/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SphereSliceAttributes.h>
#include <DataNode.h>
#include <SphereAttributes.h>

// Type map format string
const char *SphereSliceAttributes::TypeMapFormatString = "Dd";

// ****************************************************************************
// Method: SphereSliceAttributes::SphereSliceAttributes
//
// Purpose: 
//   Constructor for the SphereSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SphereSliceAttributes::SphereSliceAttributes() : 
    AttributeSubject(SphereSliceAttributes::TypeMapFormatString)
{
    origin[0] = 0;
    origin[1] = 0;
    origin[2] = 0;
    radius = 1;
}

// ****************************************************************************
// Method: SphereSliceAttributes::SphereSliceAttributes
//
// Purpose: 
//   Copy constructor for the SphereSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SphereSliceAttributes::SphereSliceAttributes(const SphereSliceAttributes &obj) : 
    AttributeSubject(SphereSliceAttributes::TypeMapFormatString)
{
    origin[0] = obj.origin[0];
    origin[1] = obj.origin[1];
    origin[2] = obj.origin[2];

    radius = obj.radius;

    SelectAll();
}

// ****************************************************************************
// Method: SphereSliceAttributes::~SphereSliceAttributes
//
// Purpose: 
//   Destructor for the SphereSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SphereSliceAttributes::~SphereSliceAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SphereSliceAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SphereSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SphereSliceAttributes& 
SphereSliceAttributes::operator = (const SphereSliceAttributes &obj)
{
    if (this == &obj) return *this;
    origin[0] = obj.origin[0];
    origin[1] = obj.origin[1];
    origin[2] = obj.origin[2];

    radius = obj.radius;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: SphereSliceAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SphereSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SphereSliceAttributes::operator == (const SphereSliceAttributes &obj) const
{
    // Compare the origin arrays.
    bool origin_equal = true;
    for(int i = 0; i < 3 && origin_equal; ++i)
        origin_equal = (origin[i] == obj.origin[i]);

    // Create the return value
    return (origin_equal &&
            (radius == obj.radius));
}

// ****************************************************************************
// Method: SphereSliceAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SphereSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SphereSliceAttributes::operator != (const SphereSliceAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SphereSliceAttributes::TypeName
//
// Purpose: 
//   Type name method for the SphereSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SphereSliceAttributes::TypeName() const
{
    return "SphereSliceAttributes";
}

// ****************************************************************************
// Method: SphereSliceAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SphereSliceAttributes class.
//
// Notes:
//   Copied from old .C file so that it will always be regenerated correctly
//   when xml2atts is run.
//
// Programmer: Kathleen Bonnell 
// Creation:   December 16, 2002 
//
// Modifications:
//
// ****************************************************************************

bool
SphereSliceAttributes::CopyAttributes(const AttributeGroup *atts)
{
    bool retval = false;

    if(TypeName() == atts->TypeName())
    {
        // Call assignment operator.
        const SphereSliceAttributes *tmp = (const SphereSliceAttributes *)atts;
        *this = *tmp;
        retval = true;
    }
    else if(atts->TypeName() == "SphereAttributes")
    {
        const SphereAttributes *tmp = (const SphereAttributes *)atts;
        SetOrigin(tmp->GetOrigin());
        SetRadius(tmp->GetRadius());
        retval = true;
    }

    return retval;
}

// ****************************************************************************
// Method: SphereSliceAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SphereSliceAttributes class.
//
// Notes:
//   Copied from old .C file so that it will always be regenerated correctly
//   when xml2atts is run.
//
// Programmer: Kathleen Bonnell 
// Creation:   December 16, 2002 
//
// Modifications:
//
// ****************************************************************************
AttributeSubject *
SphereSliceAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;

    if(TypeName() == tname)
    {
        retval = new SphereSliceAttributes(*this);
    }
    else if(tname == "SphereAttributes")
    {
        SphereAttributes *s = new SphereAttributes;
        s->SetOrigin(GetOrigin());
        s->SetRadius(GetRadius());
        retval = s;
    }

    return retval;
}

// ****************************************************************************
// Method: SphereSliceAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SphereSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SphereSliceAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SphereSliceAttributes(*this);
    else
        retval = new SphereSliceAttributes;

    return retval;
}

// ****************************************************************************
// Method: SphereSliceAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SphereSliceAttributes::SelectAll()
{
    Select(ID_origin, (void *)origin, 3);
    Select(ID_radius, (void *)&radius);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SphereSliceAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SphereSliceAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SphereSliceAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SphereSliceAttributes.
    DataNode *node = new DataNode("SphereSliceAttributes");

    if(completeSave || !FieldsEqual(ID_origin, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("origin", origin, 3));
    }

    if(completeSave || !FieldsEqual(ID_radius, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("radius", radius));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SphereSliceAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SphereSliceAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SphereSliceAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("origin")) != 0)
        SetOrigin(node->AsDoubleArray());
    if((node = searchNode->GetNode("radius")) != 0)
        SetRadius(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SphereSliceAttributes::SetOrigin(const double *origin_)
{
    origin[0] = origin_[0];
    origin[1] = origin_[1];
    origin[2] = origin_[2];
    Select(ID_origin, (void *)origin, 3);
}

void
SphereSliceAttributes::SetRadius(double radius_)
{
    radius = radius_;
    Select(ID_radius, (void *)&radius);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
SphereSliceAttributes::GetOrigin() const
{
    return origin;
}

double *
SphereSliceAttributes::GetOrigin()
{
    return origin;
}

double
SphereSliceAttributes::GetRadius() const
{
    return radius;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SphereSliceAttributes::SelectOrigin()
{
    Select(ID_origin, (void *)origin, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SphereSliceAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SphereSliceAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_origin: return "origin";
    case ID_radius: return "radius";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SphereSliceAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SphereSliceAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_origin: return FieldType_doubleArray;
    case ID_radius: return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SphereSliceAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SphereSliceAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_origin: return "doubleArray";
    case ID_radius: return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SphereSliceAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SphereSliceAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SphereSliceAttributes &obj = *((const SphereSliceAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_origin:
        {  // new scope
        // Compare the origin arrays.
        bool origin_equal = true;
        for(int i = 0; i < 3 && origin_equal; ++i)
            origin_equal = (origin[i] == obj.origin[i]);

        retval = origin_equal;
        }
        break;
    case ID_radius:
        {  // new scope
        retval = (radius == obj.radius);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

