/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtSmoothFilter.C
// ************************************************************************* //

#include <avtSmoothFilter.h>

#include <vtkPolyData.h>
#include <vtkSmoothPolyDataFilter.h>

#include <avtCallback.h>

// ****************************************************************************
//  Method: avtSmoothFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
// ****************************************************************************

avtSmoothFilter::avtSmoothFilter()
{
}


// ****************************************************************************
//  Method: avtSmoothFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
//  Modifications:
//
// ****************************************************************************

avtSmoothFilter::~avtSmoothFilter()
{
}


// ****************************************************************************
//  Method:  avtSmoothFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
// ****************************************************************************

avtFilter *
avtSmoothFilter::Create()
{
    return new avtSmoothFilter();
}


// ****************************************************************************
//  Method:      avtSmoothFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
// ****************************************************************************

void
avtSmoothFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const SmoothOperatorAttributes*)a;
}


// ****************************************************************************
//  Method: avtSmoothFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtSmoothFilter with the given
//      parameters would result in an equivalent avtSmoothFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
// ****************************************************************************

bool
avtSmoothFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(SmoothOperatorAttributes*)a);
}


// ****************************************************************************
//  Method: avtSmoothFilter::PreExecute
//
//  Purpose:
//      Called before ExecuteData, this will initialize issuedWarning.
//
//  Programmer: Hank Childs
//  Creation:   August 14, 2005
//
//  Modifications:
//    Jeremy Meredith, Thu Feb 15 11:55:03 EST 2007
//    Call inherited PreExecute before everything else.
//
// ****************************************************************************

void
avtSmoothFilter::PreExecute(void)
{
    avtPluginDataTreeIterator::PreExecute();

    issuedWarning = false;
}


// ****************************************************************************
//  Method: avtSmoothFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the Smooth filter.
//
//  Arguments:
//      in_ds      The input dataset.
//      <unused>   The domain number.
//      <unused>   The label.
//
//  Returns:       The output dataset.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
// ****************************************************************************

vtkDataSet *
avtSmoothFilter::ExecuteData(vtkDataSet *in_ds, int, std::string)
{
    if (in_ds->GetDataObjectType() != VTK_POLY_DATA)
    {
        if (!issuedWarning)
            avtCallback::IssueWarning("The Smooth operator can only be applied"
                     " to surfaces.  Please apply the ExternalSurface operator"
                     " before applying the Smooth operator.");
        issuedWarning = true;
        return in_ds;
    }

    vtkPolyData *pd = (vtkPolyData *) in_ds;
    vtkSmoothPolyDataFilter *smooth = vtkSmoothPolyDataFilter::New();
    smooth->SetInput(pd);

    smooth->SetConvergence(atts.GetConvergence());
    smooth->SetNumberOfIterations(atts.GetNumIterations());
    smooth->SetRelaxationFactor(atts.GetRelaxationFactor());
    smooth->SetFeatureEdgeSmoothing(atts.GetMaintainFeatures());
    smooth->SetFeatureAngle(atts.GetFeatureAngle());
    smooth->SetEdgeAngle(atts.GetEdgeAngle());
    smooth->SetBoundarySmoothing(atts.GetSmoothBoundaries());

    vtkPolyData *output = smooth->GetOutput();
    output->Update();

    ManageMemory(output);
    smooth->Delete();

    return output;
}
