/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisSmoothWindow.h"

#include <SmoothOperatorAttributes.h>
#include <ViewerProxy.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QSpinBox>
#include <QButtonGroup>
#include <QRadioButton>
#include <QvisColorTableButton.h>
#include <QvisOpacitySlider.h>
#include <QvisColorButton.h>
#include <QvisLineStyleWidget.h>
#include <QvisLineWidthWidget.h>
#include <QvisVariableButton.h>

#include <stdio.h>
#include <string>

using std::string;

// ****************************************************************************
// Method: QvisSmoothWindow::QvisSmoothWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisSmoothWindow::QvisSmoothWindow(const int type,
                         SmoothOperatorAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisSmoothWindow::~QvisSmoothWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisSmoothWindow::~QvisSmoothWindow()
{
}


// ****************************************************************************
// Method: QvisSmoothWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSmoothWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    numIterationsLabel = new QLabel(tr("Maximum Number of Iterations"), central);
    mainLayout->addWidget(numIterationsLabel,0,0);
    numIterations = new QLineEdit(central);
    connect(numIterations, SIGNAL(returnPressed()),
            this, SLOT(numIterationsProcessText()));
    mainLayout->addWidget(numIterations, 0,1);

    relaxationFactorLabel = new QLabel(tr("Relaxation Factor"), central);
    mainLayout->addWidget(relaxationFactorLabel,1,0);
    relaxationFactor = new QLineEdit(central);
    connect(relaxationFactor, SIGNAL(returnPressed()),
            this, SLOT(relaxationFactorProcessText()));
    mainLayout->addWidget(relaxationFactor, 1,1);

    convergenceLabel = new QLabel(tr("Convergence"), central);
    mainLayout->addWidget(convergenceLabel,2,0);
    convergence = new QLineEdit(central);
    connect(convergence, SIGNAL(returnPressed()),
            this, SLOT(convergenceProcessText()));
    mainLayout->addWidget(convergence, 2,1);

    maintainFeatures = new QCheckBox(tr("Maintain Features"), central);
    connect(maintainFeatures, SIGNAL(toggled(bool)),
            this, SLOT(maintainFeaturesChanged(bool)));
    mainLayout->addWidget(maintainFeatures, 3,0);

    featureAngleLabel = new QLabel(tr("Feature Angle"), central);
    mainLayout->addWidget(featureAngleLabel,4,0);
    featureAngle = new QLineEdit(central);
    connect(featureAngle, SIGNAL(returnPressed()),
            this, SLOT(featureAngleProcessText()));
    mainLayout->addWidget(featureAngle, 4,1);

    edgeAngleLabel = new QLabel(tr("Max Edge Angle"), central);
    mainLayout->addWidget(edgeAngleLabel,5,0);
    edgeAngle = new QLineEdit(central);
    connect(edgeAngle, SIGNAL(returnPressed()),
            this, SLOT(edgeAngleProcessText()));
    mainLayout->addWidget(edgeAngle, 5,1);

    smoothBoundaries = new QCheckBox(tr("Smooth Along Boundaries"), central);
    connect(smoothBoundaries, SIGNAL(toggled(bool)),
            this, SLOT(smoothBoundariesChanged(bool)));
    mainLayout->addWidget(smoothBoundaries, 6,0);

}


// ****************************************************************************
// Method: QvisSmoothWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSmoothWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case SmoothOperatorAttributes::ID_numIterations:
            numIterations->setText(IntToQString(atts->GetNumIterations()));
            break;
          case SmoothOperatorAttributes::ID_relaxationFactor:
            relaxationFactor->setText(DoubleToQString(atts->GetRelaxationFactor()));
            break;
          case SmoothOperatorAttributes::ID_convergence:
            convergence->setText(DoubleToQString(atts->GetConvergence()));
            break;
          case SmoothOperatorAttributes::ID_maintainFeatures:
            if (atts->GetMaintainFeatures() == true)
            {
                featureAngle->setEnabled(true);
                if(featureAngleLabel)
                    featureAngleLabel->setEnabled(true);
            }
            else
            {
                featureAngle->setEnabled(false);
                if(featureAngleLabel)
                    featureAngleLabel->setEnabled(false);
            }
            maintainFeatures->blockSignals(true);
            maintainFeatures->setChecked(atts->GetMaintainFeatures());
            maintainFeatures->blockSignals(false);
            break;
          case SmoothOperatorAttributes::ID_featureAngle:
            featureAngle->setText(DoubleToQString(atts->GetFeatureAngle()));
            break;
          case SmoothOperatorAttributes::ID_edgeAngle:
            edgeAngle->setText(DoubleToQString(atts->GetEdgeAngle()));
            break;
          case SmoothOperatorAttributes::ID_smoothBoundaries:
            smoothBoundaries->blockSignals(true);
            smoothBoundaries->setChecked(atts->GetSmoothBoundaries());
            smoothBoundaries->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisSmoothWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSmoothWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do numIterations
    if(which_widget == SmoothOperatorAttributes::ID_numIterations || doAll)
    {
        int val;
        if(LineEditGetInt(numIterations, val))
            atts->SetNumIterations(val);
        else
        {
            ResettingError(tr("Maximum Number of Iterations"),
                IntToQString(atts->GetNumIterations()));
            atts->SetNumIterations(atts->GetNumIterations());
        }
    }

    // Do relaxationFactor
    if(which_widget == SmoothOperatorAttributes::ID_relaxationFactor || doAll)
    {
        double val;
        if(LineEditGetDouble(relaxationFactor, val))
            atts->SetRelaxationFactor(val);
        else
        {
            ResettingError(tr("Relaxation Factor"),
                DoubleToQString(atts->GetRelaxationFactor()));
            atts->SetRelaxationFactor(atts->GetRelaxationFactor());
        }
    }

    // Do convergence
    if(which_widget == SmoothOperatorAttributes::ID_convergence || doAll)
    {
        double val;
        if(LineEditGetDouble(convergence, val))
            atts->SetConvergence(val);
        else
        {
            ResettingError(tr("Convergence"),
                DoubleToQString(atts->GetConvergence()));
            atts->SetConvergence(atts->GetConvergence());
        }
    }

    // Do featureAngle
    if(which_widget == SmoothOperatorAttributes::ID_featureAngle || doAll)
    {
        double val;
        if(LineEditGetDouble(featureAngle, val))
            atts->SetFeatureAngle(val);
        else
        {
            ResettingError(tr("Feature Angle"),
                DoubleToQString(atts->GetFeatureAngle()));
            atts->SetFeatureAngle(atts->GetFeatureAngle());
        }
    }

    // Do edgeAngle
    if(which_widget == SmoothOperatorAttributes::ID_edgeAngle || doAll)
    {
        double val;
        if(LineEditGetDouble(edgeAngle, val))
            atts->SetEdgeAngle(val);
        else
        {
            ResettingError(tr("Max Edge Angle"),
                DoubleToQString(atts->GetEdgeAngle()));
            atts->SetEdgeAngle(atts->GetEdgeAngle());
        }
    }

}


//
// Qt Slot functions
//


void
QvisSmoothWindow::numIterationsProcessText()
{
    GetCurrentValues(SmoothOperatorAttributes::ID_numIterations);
    Apply();
}


void
QvisSmoothWindow::relaxationFactorProcessText()
{
    GetCurrentValues(SmoothOperatorAttributes::ID_relaxationFactor);
    Apply();
}


void
QvisSmoothWindow::convergenceProcessText()
{
    GetCurrentValues(SmoothOperatorAttributes::ID_convergence);
    Apply();
}


void
QvisSmoothWindow::maintainFeaturesChanged(bool val)
{
    atts->SetMaintainFeatures(val);
    Apply();
}


void
QvisSmoothWindow::featureAngleProcessText()
{
    GetCurrentValues(SmoothOperatorAttributes::ID_featureAngle);
    Apply();
}


void
QvisSmoothWindow::edgeAngleProcessText()
{
    GetCurrentValues(SmoothOperatorAttributes::ID_edgeAngle);
    Apply();
}


void
QvisSmoothWindow::smoothBoundariesChanged(bool val)
{
    atts->SetSmoothBoundaries(val);
    SetUpdate(false);
    Apply();
}


