/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PySmoothOperatorAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PySmoothOperatorAttributes
//
// Purpose: 
//   Attributes for the Smooth Operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:41 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a SmoothOperatorAttributes.
//
struct SmoothOperatorAttributesObject
{
    PyObject_HEAD
    SmoothOperatorAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSmoothOperatorAttributes(int);

std::string
PySmoothOperatorAttributes_ToString(const SmoothOperatorAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%snumIterations = %d\n", prefix, atts->GetNumIterations());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%srelaxationFactor = %g\n", prefix, atts->GetRelaxationFactor());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sconvergence = %g\n", prefix, atts->GetConvergence());
    str += tmpStr;
    if(atts->GetMaintainFeatures())
        SNPRINTF(tmpStr, 1000, "%smaintainFeatures = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smaintainFeatures = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sfeatureAngle = %g\n", prefix, atts->GetFeatureAngle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sedgeAngle = %g\n", prefix, atts->GetEdgeAngle());
    str += tmpStr;
    if(atts->GetSmoothBoundaries())
        SNPRINTF(tmpStr, 1000, "%ssmoothBoundaries = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssmoothBoundaries = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
SmoothOperatorAttributes_Notify(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SmoothOperatorAttributes_SetNumIterations(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numIterations in the object.
    obj->data->SetNumIterations((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SmoothOperatorAttributes_GetNumIterations(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumIterations()));
    return retval;
}

/*static*/ PyObject *
SmoothOperatorAttributes_SetRelaxationFactor(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the relaxationFactor in the object.
    obj->data->SetRelaxationFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SmoothOperatorAttributes_GetRelaxationFactor(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRelaxationFactor());
    return retval;
}

/*static*/ PyObject *
SmoothOperatorAttributes_SetConvergence(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the convergence in the object.
    obj->data->SetConvergence(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SmoothOperatorAttributes_GetConvergence(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetConvergence());
    return retval;
}

/*static*/ PyObject *
SmoothOperatorAttributes_SetMaintainFeatures(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maintainFeatures in the object.
    obj->data->SetMaintainFeatures(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SmoothOperatorAttributes_GetMaintainFeatures(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaintainFeatures()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SmoothOperatorAttributes_SetFeatureAngle(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the featureAngle in the object.
    obj->data->SetFeatureAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SmoothOperatorAttributes_GetFeatureAngle(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetFeatureAngle());
    return retval;
}

/*static*/ PyObject *
SmoothOperatorAttributes_SetEdgeAngle(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the edgeAngle in the object.
    obj->data->SetEdgeAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SmoothOperatorAttributes_GetEdgeAngle(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEdgeAngle());
    return retval;
}

/*static*/ PyObject *
SmoothOperatorAttributes_SetSmoothBoundaries(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothBoundaries in the object.
    obj->data->SetSmoothBoundaries(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SmoothOperatorAttributes_GetSmoothBoundaries(PyObject *self, PyObject *args)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSmoothBoundaries()?1L:0L);
    return retval;
}



static struct PyMethodDef SmoothOperatorAttributes_methods[] = {
    {"Notify", SmoothOperatorAttributes_Notify, METH_VARARGS},
    {"SetNumIterations", SmoothOperatorAttributes_SetNumIterations, METH_VARARGS},
    {"GetNumIterations", SmoothOperatorAttributes_GetNumIterations, METH_VARARGS},
    {"SetRelaxationFactor", SmoothOperatorAttributes_SetRelaxationFactor, METH_VARARGS},
    {"GetRelaxationFactor", SmoothOperatorAttributes_GetRelaxationFactor, METH_VARARGS},
    {"SetConvergence", SmoothOperatorAttributes_SetConvergence, METH_VARARGS},
    {"GetConvergence", SmoothOperatorAttributes_GetConvergence, METH_VARARGS},
    {"SetMaintainFeatures", SmoothOperatorAttributes_SetMaintainFeatures, METH_VARARGS},
    {"GetMaintainFeatures", SmoothOperatorAttributes_GetMaintainFeatures, METH_VARARGS},
    {"SetFeatureAngle", SmoothOperatorAttributes_SetFeatureAngle, METH_VARARGS},
    {"GetFeatureAngle", SmoothOperatorAttributes_GetFeatureAngle, METH_VARARGS},
    {"SetEdgeAngle", SmoothOperatorAttributes_SetEdgeAngle, METH_VARARGS},
    {"GetEdgeAngle", SmoothOperatorAttributes_GetEdgeAngle, METH_VARARGS},
    {"SetSmoothBoundaries", SmoothOperatorAttributes_SetSmoothBoundaries, METH_VARARGS},
    {"GetSmoothBoundaries", SmoothOperatorAttributes_GetSmoothBoundaries, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SmoothOperatorAttributes_dealloc(PyObject *v)
{
   SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SmoothOperatorAttributes_compare(PyObject *v, PyObject *w)
{
    SmoothOperatorAttributes *a = ((SmoothOperatorAttributesObject *)v)->data;
    SmoothOperatorAttributes *b = ((SmoothOperatorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
SmoothOperatorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "numIterations") == 0)
        return SmoothOperatorAttributes_GetNumIterations(self, NULL);
    if(strcmp(name, "relaxationFactor") == 0)
        return SmoothOperatorAttributes_GetRelaxationFactor(self, NULL);
    if(strcmp(name, "convergence") == 0)
        return SmoothOperatorAttributes_GetConvergence(self, NULL);
    if(strcmp(name, "maintainFeatures") == 0)
        return SmoothOperatorAttributes_GetMaintainFeatures(self, NULL);
    if(strcmp(name, "featureAngle") == 0)
        return SmoothOperatorAttributes_GetFeatureAngle(self, NULL);
    if(strcmp(name, "edgeAngle") == 0)
        return SmoothOperatorAttributes_GetEdgeAngle(self, NULL);
    if(strcmp(name, "smoothBoundaries") == 0)
        return SmoothOperatorAttributes_GetSmoothBoundaries(self, NULL);

    return Py_FindMethod(SmoothOperatorAttributes_methods, self, name);
}

static int
SmoothOperatorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "numIterations") == 0)
        obj = SmoothOperatorAttributes_SetNumIterations(self, tuple);
    else if(strcmp(name, "relaxationFactor") == 0)
        obj = SmoothOperatorAttributes_SetRelaxationFactor(self, tuple);
    else if(strcmp(name, "convergence") == 0)
        obj = SmoothOperatorAttributes_SetConvergence(self, tuple);
    else if(strcmp(name, "maintainFeatures") == 0)
        obj = SmoothOperatorAttributes_SetMaintainFeatures(self, tuple);
    else if(strcmp(name, "featureAngle") == 0)
        obj = SmoothOperatorAttributes_SetFeatureAngle(self, tuple);
    else if(strcmp(name, "edgeAngle") == 0)
        obj = SmoothOperatorAttributes_SetEdgeAngle(self, tuple);
    else if(strcmp(name, "smoothBoundaries") == 0)
        obj = SmoothOperatorAttributes_SetSmoothBoundaries(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
SmoothOperatorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)v;
    fprintf(fp, "%s", PySmoothOperatorAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SmoothOperatorAttributes_str(PyObject *v)
{
    SmoothOperatorAttributesObject *obj = (SmoothOperatorAttributesObject *)v;
    return PyString_FromString(PySmoothOperatorAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SmoothOperatorAttributes_Purpose = "Attributes for the Smooth Operator";
#else
static char *SmoothOperatorAttributes_Purpose = "Attributes for the Smooth Operator";
#endif

//
// The type description structure
//
static PyTypeObject SmoothOperatorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SmoothOperatorAttributes",                    // tp_name
    sizeof(SmoothOperatorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SmoothOperatorAttributes_dealloc,  // tp_dealloc
    (printfunc)SmoothOperatorAttributes_print,     // tp_print
    (getattrfunc)SmoothOperatorAttributes_getattr, // tp_getattr
    (setattrfunc)SmoothOperatorAttributes_setattr, // tp_setattr
    (cmpfunc)SmoothOperatorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SmoothOperatorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SmoothOperatorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SmoothOperatorAttributes *defaultAtts = 0;
static SmoothOperatorAttributes *currentAtts = 0;

static PyObject *
NewSmoothOperatorAttributes(int useCurrent)
{
    SmoothOperatorAttributesObject *newObject;
    newObject = PyObject_NEW(SmoothOperatorAttributesObject, &SmoothOperatorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SmoothOperatorAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SmoothOperatorAttributes(*defaultAtts);
    else
        newObject->data = new SmoothOperatorAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSmoothOperatorAttributes(const SmoothOperatorAttributes *attr)
{
    SmoothOperatorAttributesObject *newObject;
    newObject = PyObject_NEW(SmoothOperatorAttributesObject, &SmoothOperatorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SmoothOperatorAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SmoothOperatorAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSmoothOperatorAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SmoothOperatorAttributesMethods[] = {
    {"SmoothOperatorAttributes", SmoothOperatorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SmoothOperatorAttributesObserver = 0;

std::string
PySmoothOperatorAttributes_GetLogString()
{
    std::string s("SmoothOperatorAtts = SmoothOperatorAttributes()\n");
    if(currentAtts != 0)
        s += PySmoothOperatorAttributes_ToString(currentAtts, "SmoothOperatorAtts.");
    return s;
}

static void
PySmoothOperatorAttributes_CallLogRoutine(Subject *subj, void *data)
{
    SmoothOperatorAttributes *atts = (SmoothOperatorAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SmoothOperatorAtts = SmoothOperatorAttributes()\n");
        s += PySmoothOperatorAttributes_ToString(currentAtts, "SmoothOperatorAtts.");
        cb(s);
    }
}

void
PySmoothOperatorAttributes_StartUp(SmoothOperatorAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySmoothOperatorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SmoothOperatorAttributesObserver == 0)
    {
        SmoothOperatorAttributesObserver = new ObserverToCallback(subj,
            PySmoothOperatorAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySmoothOperatorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SmoothOperatorAttributesObserver;
    SmoothOperatorAttributesObserver = 0;
}

PyMethodDef *
PySmoothOperatorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SmoothOperatorAttributesMethods;
}

bool
PySmoothOperatorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SmoothOperatorAttributesType);
}

SmoothOperatorAttributes *
PySmoothOperatorAttributes_FromPyObject(PyObject *obj)
{
    SmoothOperatorAttributesObject *obj2 = (SmoothOperatorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySmoothOperatorAttributes_New()
{
    return NewSmoothOperatorAttributes(0);
}

PyObject *
PySmoothOperatorAttributes_Wrap(const SmoothOperatorAttributes *attr)
{
    return WrapSmoothOperatorAttributes(attr);
}

void
PySmoothOperatorAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SmoothOperatorAttributesObject *obj2 = (SmoothOperatorAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySmoothOperatorAttributes_SetDefaults(const SmoothOperatorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SmoothOperatorAttributes(*atts);
}

