/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SiloDumpAttributes.h>
#include <DataNode.h>

// Type map format string
const char *SiloDumpAttributes::TypeMapFormatString = "sb";

// ****************************************************************************
// Method: SiloDumpAttributes::SiloDumpAttributes
//
// Purpose: 
//   Constructor for the SiloDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SiloDumpAttributes::SiloDumpAttributes() : 
    AttributeSubject(SiloDumpAttributes::TypeMapFormatString)
{
    filename = "dump";
    display = false;
}

// ****************************************************************************
// Method: SiloDumpAttributes::SiloDumpAttributes
//
// Purpose: 
//   Copy constructor for the SiloDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SiloDumpAttributes::SiloDumpAttributes(const SiloDumpAttributes &obj) : 
    AttributeSubject(SiloDumpAttributes::TypeMapFormatString)
{
    filename = obj.filename;
    display = obj.display;

    SelectAll();
}

// ****************************************************************************
// Method: SiloDumpAttributes::~SiloDumpAttributes
//
// Purpose: 
//   Destructor for the SiloDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SiloDumpAttributes::~SiloDumpAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SiloDumpAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SiloDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SiloDumpAttributes& 
SiloDumpAttributes::operator = (const SiloDumpAttributes &obj)
{
    if (this == &obj) return *this;
    filename = obj.filename;
    display = obj.display;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: SiloDumpAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SiloDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SiloDumpAttributes::operator == (const SiloDumpAttributes &obj) const
{
    // Create the return value
    return ((filename == obj.filename) &&
            (display == obj.display));
}

// ****************************************************************************
// Method: SiloDumpAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SiloDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SiloDumpAttributes::operator != (const SiloDumpAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SiloDumpAttributes::TypeName
//
// Purpose: 
//   Type name method for the SiloDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SiloDumpAttributes::TypeName() const
{
    return "SiloDumpAttributes";
}

// ****************************************************************************
// Method: SiloDumpAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SiloDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SiloDumpAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SiloDumpAttributes *tmp = (const SiloDumpAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SiloDumpAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SiloDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SiloDumpAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SiloDumpAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SiloDumpAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SiloDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SiloDumpAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SiloDumpAttributes(*this);
    else
        retval = new SiloDumpAttributes;

    return retval;
}

// ****************************************************************************
// Method: SiloDumpAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SiloDumpAttributes::SelectAll()
{
    Select(ID_filename, (void *)&filename);
    Select(ID_display,  (void *)&display);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SiloDumpAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SiloDumpAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SiloDumpAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SiloDumpAttributes.
    DataNode *node = new DataNode("SiloDumpAttributes");

    if(completeSave || !FieldsEqual(ID_filename, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("filename", filename));
    }

    if(completeSave || !FieldsEqual(ID_display, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("display", display));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SiloDumpAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SiloDumpAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SiloDumpAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("filename")) != 0)
        SetFilename(node->AsString());
    if((node = searchNode->GetNode("display")) != 0)
        SetDisplay(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SiloDumpAttributes::SetFilename(const std::string &filename_)
{
    filename = filename_;
    Select(ID_filename, (void *)&filename);
}

void
SiloDumpAttributes::SetDisplay(bool display_)
{
    display = display_;
    Select(ID_display, (void *)&display);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
SiloDumpAttributes::GetFilename() const
{
    return filename;
}

std::string &
SiloDumpAttributes::GetFilename()
{
    return filename;
}

bool
SiloDumpAttributes::GetDisplay() const
{
    return display;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SiloDumpAttributes::SelectFilename()
{
    Select(ID_filename, (void *)&filename);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SiloDumpAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SiloDumpAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_filename: return "filename";
    case ID_display:  return "display";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SiloDumpAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SiloDumpAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_filename: return FieldType_string;
    case ID_display:  return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SiloDumpAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SiloDumpAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_filename: return "string";
    case ID_display:  return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SiloDumpAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SiloDumpAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SiloDumpAttributes &obj = *((const SiloDumpAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_filename:
        {  // new scope
        retval = (filename == obj.filename);
        }
        break;
    case ID_display:
        {  // new scope
        retval = (display == obj.display);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

