/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PySiloDumpAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PySiloDumpAttributes
//
// Purpose: 
//   This class contains attributes for the silo dump operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:35 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a SiloDumpAttributes.
//
struct SiloDumpAttributesObject
{
    PyObject_HEAD
    SiloDumpAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSiloDumpAttributes(int);

std::string
PySiloDumpAttributes_ToString(const SiloDumpAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%sfilename = \"%s\"\n", prefix, atts->GetFilename().c_str());
    str += tmpStr;
    if(atts->GetDisplay())
        SNPRINTF(tmpStr, 1000, "%sdisplay = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdisplay = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
SiloDumpAttributes_Notify(PyObject *self, PyObject *args)
{
    SiloDumpAttributesObject *obj = (SiloDumpAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SiloDumpAttributes_SetFilename(PyObject *self, PyObject *args)
{
    SiloDumpAttributesObject *obj = (SiloDumpAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the filename in the object.
    obj->data->SetFilename(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SiloDumpAttributes_GetFilename(PyObject *self, PyObject *args)
{
    SiloDumpAttributesObject *obj = (SiloDumpAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetFilename().c_str());
    return retval;
}

/*static*/ PyObject *
SiloDumpAttributes_SetDisplay(PyObject *self, PyObject *args)
{
    SiloDumpAttributesObject *obj = (SiloDumpAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the display in the object.
    obj->data->SetDisplay(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SiloDumpAttributes_GetDisplay(PyObject *self, PyObject *args)
{
    SiloDumpAttributesObject *obj = (SiloDumpAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDisplay()?1L:0L);
    return retval;
}



static struct PyMethodDef SiloDumpAttributes_methods[] = {
    {"Notify", SiloDumpAttributes_Notify, METH_VARARGS},
    {"SetFilename", SiloDumpAttributes_SetFilename, METH_VARARGS},
    {"GetFilename", SiloDumpAttributes_GetFilename, METH_VARARGS},
    {"SetDisplay", SiloDumpAttributes_SetDisplay, METH_VARARGS},
    {"GetDisplay", SiloDumpAttributes_GetDisplay, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SiloDumpAttributes_dealloc(PyObject *v)
{
   SiloDumpAttributesObject *obj = (SiloDumpAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SiloDumpAttributes_compare(PyObject *v, PyObject *w)
{
    SiloDumpAttributes *a = ((SiloDumpAttributesObject *)v)->data;
    SiloDumpAttributes *b = ((SiloDumpAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
SiloDumpAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "filename") == 0)
        return SiloDumpAttributes_GetFilename(self, NULL);
    if(strcmp(name, "display") == 0)
        return SiloDumpAttributes_GetDisplay(self, NULL);

    return Py_FindMethod(SiloDumpAttributes_methods, self, name);
}

static int
SiloDumpAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "filename") == 0)
        obj = SiloDumpAttributes_SetFilename(self, tuple);
    else if(strcmp(name, "display") == 0)
        obj = SiloDumpAttributes_SetDisplay(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
SiloDumpAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SiloDumpAttributesObject *obj = (SiloDumpAttributesObject *)v;
    fprintf(fp, "%s", PySiloDumpAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SiloDumpAttributes_str(PyObject *v)
{
    SiloDumpAttributesObject *obj = (SiloDumpAttributesObject *)v;
    return PyString_FromString(PySiloDumpAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SiloDumpAttributes_Purpose = "This class contains attributes for the silo dump operator.";
#else
static char *SiloDumpAttributes_Purpose = "This class contains attributes for the silo dump operator.";
#endif

//
// The type description structure
//
static PyTypeObject SiloDumpAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SiloDumpAttributes",                    // tp_name
    sizeof(SiloDumpAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SiloDumpAttributes_dealloc,  // tp_dealloc
    (printfunc)SiloDumpAttributes_print,     // tp_print
    (getattrfunc)SiloDumpAttributes_getattr, // tp_getattr
    (setattrfunc)SiloDumpAttributes_setattr, // tp_setattr
    (cmpfunc)SiloDumpAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SiloDumpAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SiloDumpAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SiloDumpAttributes *defaultAtts = 0;
static SiloDumpAttributes *currentAtts = 0;

static PyObject *
NewSiloDumpAttributes(int useCurrent)
{
    SiloDumpAttributesObject *newObject;
    newObject = PyObject_NEW(SiloDumpAttributesObject, &SiloDumpAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SiloDumpAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SiloDumpAttributes(*defaultAtts);
    else
        newObject->data = new SiloDumpAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSiloDumpAttributes(const SiloDumpAttributes *attr)
{
    SiloDumpAttributesObject *newObject;
    newObject = PyObject_NEW(SiloDumpAttributesObject, &SiloDumpAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SiloDumpAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SiloDumpAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSiloDumpAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SiloDumpAttributesMethods[] = {
    {"SiloDumpAttributes", SiloDumpAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SiloDumpAttributesObserver = 0;

std::string
PySiloDumpAttributes_GetLogString()
{
    std::string s("SiloDumpAtts = SiloDumpAttributes()\n");
    if(currentAtts != 0)
        s += PySiloDumpAttributes_ToString(currentAtts, "SiloDumpAtts.");
    return s;
}

static void
PySiloDumpAttributes_CallLogRoutine(Subject *subj, void *data)
{
    SiloDumpAttributes *atts = (SiloDumpAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SiloDumpAtts = SiloDumpAttributes()\n");
        s += PySiloDumpAttributes_ToString(currentAtts, "SiloDumpAtts.");
        cb(s);
    }
}

void
PySiloDumpAttributes_StartUp(SiloDumpAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySiloDumpAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SiloDumpAttributesObserver == 0)
    {
        SiloDumpAttributesObserver = new ObserverToCallback(subj,
            PySiloDumpAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySiloDumpAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SiloDumpAttributesObserver;
    SiloDumpAttributesObserver = 0;
}

PyMethodDef *
PySiloDumpAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SiloDumpAttributesMethods;
}

bool
PySiloDumpAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SiloDumpAttributesType);
}

SiloDumpAttributes *
PySiloDumpAttributes_FromPyObject(PyObject *obj)
{
    SiloDumpAttributesObject *obj2 = (SiloDumpAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySiloDumpAttributes_New()
{
    return NewSiloDumpAttributes(0);
}

PyObject *
PySiloDumpAttributes_Wrap(const SiloDumpAttributes *attr)
{
    return WrapSiloDumpAttributes(attr);
}

void
PySiloDumpAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SiloDumpAttributesObject *obj2 = (SiloDumpAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySiloDumpAttributes_SetDefaults(const SiloDumpAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SiloDumpAttributes(*atts);
}

