/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyRevolveAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyRevolveAttributes
//
// Purpose: 
//   This class contains attributes for the revolve operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:38 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a RevolveAttributes.
//
struct RevolveAttributesObject
{
    PyObject_HEAD
    RevolveAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewRevolveAttributes(int);

std::string
PyRevolveAttributes_ToString(const RevolveAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    const char *meshType_names = "Auto, XY, RZ, ZR";
    switch (atts->GetMeshType())
    {
      case RevolveAttributes::Auto:
          SNPRINTF(tmpStr, 1000, "%smeshType = %sAuto  # %s\n", prefix, prefix, meshType_names);
          str += tmpStr;
          break;
      case RevolveAttributes::XY:
          SNPRINTF(tmpStr, 1000, "%smeshType = %sXY  # %s\n", prefix, prefix, meshType_names);
          str += tmpStr;
          break;
      case RevolveAttributes::RZ:
          SNPRINTF(tmpStr, 1000, "%smeshType = %sRZ  # %s\n", prefix, prefix, meshType_names);
          str += tmpStr;
          break;
      case RevolveAttributes::ZR:
          SNPRINTF(tmpStr, 1000, "%smeshType = %sZR  # %s\n", prefix, prefix, meshType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetAutoAxis())
        SNPRINTF(tmpStr, 1000, "%sautoAxis = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sautoAxis = 0\n", prefix);
    str += tmpStr;
    {   const double *axis = atts->GetAxis();
        SNPRINTF(tmpStr, 1000, "%saxis = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", axis[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sstartAngle = %g\n", prefix, atts->GetStartAngle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstopAngle = %g\n", prefix, atts->GetStopAngle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssteps = %d\n", prefix, atts->GetSteps());
    str += tmpStr;
    return str;
}

static PyObject *
RevolveAttributes_Notify(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RevolveAttributes_SetMeshType(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the meshType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetMeshType(RevolveAttributes::MeshType(ival));
    else
    {
        fprintf(stderr, "An invalid meshType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Auto, XY, RZ, ZR.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RevolveAttributes_GetMeshType(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMeshType()));
    return retval;
}

/*static*/ PyObject *
RevolveAttributes_SetAutoAxis(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the autoAxis in the object.
    obj->data->SetAutoAxis(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RevolveAttributes_GetAutoAxis(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAutoAxis()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RevolveAttributes_SetAxis(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;

    double *dvals = obj->data->GetAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the axis in the object as modified.
    obj->data->SelectAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RevolveAttributes_GetAxis(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the axis.
    PyObject *retval = PyTuple_New(3);
    const double *axis = obj->data->GetAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(axis[i]));
    return retval;
}

/*static*/ PyObject *
RevolveAttributes_SetStartAngle(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startAngle in the object.
    obj->data->SetStartAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RevolveAttributes_GetStartAngle(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartAngle());
    return retval;
}

/*static*/ PyObject *
RevolveAttributes_SetStopAngle(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the stopAngle in the object.
    obj->data->SetStopAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RevolveAttributes_GetStopAngle(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStopAngle());
    return retval;
}

/*static*/ PyObject *
RevolveAttributes_SetSteps(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the steps in the object.
    obj->data->SetSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RevolveAttributes_GetSteps(PyObject *self, PyObject *args)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSteps()));
    return retval;
}



static struct PyMethodDef RevolveAttributes_methods[] = {
    {"Notify", RevolveAttributes_Notify, METH_VARARGS},
    {"SetMeshType", RevolveAttributes_SetMeshType, METH_VARARGS},
    {"GetMeshType", RevolveAttributes_GetMeshType, METH_VARARGS},
    {"SetAutoAxis", RevolveAttributes_SetAutoAxis, METH_VARARGS},
    {"GetAutoAxis", RevolveAttributes_GetAutoAxis, METH_VARARGS},
    {"SetAxis", RevolveAttributes_SetAxis, METH_VARARGS},
    {"GetAxis", RevolveAttributes_GetAxis, METH_VARARGS},
    {"SetStartAngle", RevolveAttributes_SetStartAngle, METH_VARARGS},
    {"GetStartAngle", RevolveAttributes_GetStartAngle, METH_VARARGS},
    {"SetStopAngle", RevolveAttributes_SetStopAngle, METH_VARARGS},
    {"GetStopAngle", RevolveAttributes_GetStopAngle, METH_VARARGS},
    {"SetSteps", RevolveAttributes_SetSteps, METH_VARARGS},
    {"GetSteps", RevolveAttributes_GetSteps, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
RevolveAttributes_dealloc(PyObject *v)
{
   RevolveAttributesObject *obj = (RevolveAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
RevolveAttributes_compare(PyObject *v, PyObject *w)
{
    RevolveAttributes *a = ((RevolveAttributesObject *)v)->data;
    RevolveAttributes *b = ((RevolveAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
RevolveAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "meshType") == 0)
        return RevolveAttributes_GetMeshType(self, NULL);
    if(strcmp(name, "Auto") == 0)
        return PyInt_FromLong(long(RevolveAttributes::Auto));
    if(strcmp(name, "XY") == 0)
        return PyInt_FromLong(long(RevolveAttributes::XY));
    if(strcmp(name, "RZ") == 0)
        return PyInt_FromLong(long(RevolveAttributes::RZ));
    if(strcmp(name, "ZR") == 0)
        return PyInt_FromLong(long(RevolveAttributes::ZR));

    if(strcmp(name, "autoAxis") == 0)
        return RevolveAttributes_GetAutoAxis(self, NULL);
    if(strcmp(name, "axis") == 0)
        return RevolveAttributes_GetAxis(self, NULL);
    if(strcmp(name, "startAngle") == 0)
        return RevolveAttributes_GetStartAngle(self, NULL);
    if(strcmp(name, "stopAngle") == 0)
        return RevolveAttributes_GetStopAngle(self, NULL);
    if(strcmp(name, "steps") == 0)
        return RevolveAttributes_GetSteps(self, NULL);

    return Py_FindMethod(RevolveAttributes_methods, self, name);
}

static int
RevolveAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "meshType") == 0)
        obj = RevolveAttributes_SetMeshType(self, tuple);
    else if(strcmp(name, "autoAxis") == 0)
        obj = RevolveAttributes_SetAutoAxis(self, tuple);
    else if(strcmp(name, "axis") == 0)
        obj = RevolveAttributes_SetAxis(self, tuple);
    else if(strcmp(name, "startAngle") == 0)
        obj = RevolveAttributes_SetStartAngle(self, tuple);
    else if(strcmp(name, "stopAngle") == 0)
        obj = RevolveAttributes_SetStopAngle(self, tuple);
    else if(strcmp(name, "steps") == 0)
        obj = RevolveAttributes_SetSteps(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
RevolveAttributes_print(PyObject *v, FILE *fp, int flags)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)v;
    fprintf(fp, "%s", PyRevolveAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
RevolveAttributes_str(PyObject *v)
{
    RevolveAttributesObject *obj = (RevolveAttributesObject *)v;
    return PyString_FromString(PyRevolveAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *RevolveAttributes_Purpose = "This class contains attributes for the revolve operator.";
#else
static char *RevolveAttributes_Purpose = "This class contains attributes for the revolve operator.";
#endif

//
// The type description structure
//
static PyTypeObject RevolveAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "RevolveAttributes",                    // tp_name
    sizeof(RevolveAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)RevolveAttributes_dealloc,  // tp_dealloc
    (printfunc)RevolveAttributes_print,     // tp_print
    (getattrfunc)RevolveAttributes_getattr, // tp_getattr
    (setattrfunc)RevolveAttributes_setattr, // tp_setattr
    (cmpfunc)RevolveAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)RevolveAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    RevolveAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static RevolveAttributes *defaultAtts = 0;
static RevolveAttributes *currentAtts = 0;

static PyObject *
NewRevolveAttributes(int useCurrent)
{
    RevolveAttributesObject *newObject;
    newObject = PyObject_NEW(RevolveAttributesObject, &RevolveAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new RevolveAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new RevolveAttributes(*defaultAtts);
    else
        newObject->data = new RevolveAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapRevolveAttributes(const RevolveAttributes *attr)
{
    RevolveAttributesObject *newObject;
    newObject = PyObject_NEW(RevolveAttributesObject, &RevolveAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (RevolveAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
RevolveAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewRevolveAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef RevolveAttributesMethods[] = {
    {"RevolveAttributes", RevolveAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *RevolveAttributesObserver = 0;

std::string
PyRevolveAttributes_GetLogString()
{
    std::string s("RevolveAtts = RevolveAttributes()\n");
    if(currentAtts != 0)
        s += PyRevolveAttributes_ToString(currentAtts, "RevolveAtts.");
    return s;
}

static void
PyRevolveAttributes_CallLogRoutine(Subject *subj, void *data)
{
    RevolveAttributes *atts = (RevolveAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("RevolveAtts = RevolveAttributes()\n");
        s += PyRevolveAttributes_ToString(currentAtts, "RevolveAtts.");
        cb(s);
    }
}

void
PyRevolveAttributes_StartUp(RevolveAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyRevolveAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(RevolveAttributesObserver == 0)
    {
        RevolveAttributesObserver = new ObserverToCallback(subj,
            PyRevolveAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyRevolveAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete RevolveAttributesObserver;
    RevolveAttributesObserver = 0;
}

PyMethodDef *
PyRevolveAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return RevolveAttributesMethods;
}

bool
PyRevolveAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &RevolveAttributesType);
}

RevolveAttributes *
PyRevolveAttributes_FromPyObject(PyObject *obj)
{
    RevolveAttributesObject *obj2 = (RevolveAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyRevolveAttributes_New()
{
    return NewRevolveAttributes(0);
}

PyObject *
PyRevolveAttributes_Wrap(const RevolveAttributes *attr)
{
    return WrapRevolveAttributes(attr);
}

void
PyRevolveAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    RevolveAttributesObject *obj2 = (RevolveAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyRevolveAttributes_SetDefaults(const RevolveAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new RevolveAttributes(*atts);
}

