/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtResamplePluginFilter.C
// ************************************************************************* //

#include <avtResamplePluginFilter.h>
#include <avtExtents.h>

#include <avtResampleFilter.h>
#include <InternalResampleAttributes.h>

// ****************************************************************************
//  Method: avtResamplePluginFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
// ****************************************************************************

avtResamplePluginFilter::avtResamplePluginFilter()
{
    resampler = NULL;
}


// ****************************************************************************
//  Method: avtResamplePluginFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
//  Modifications:
//
// ****************************************************************************

avtResamplePluginFilter::~avtResamplePluginFilter()
{
    if (resampler != NULL)
    {
        delete resampler;
        resampler = NULL;
    }
}


// ****************************************************************************
//  Method:  avtResamplePluginFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
// ****************************************************************************

avtFilter *
avtResamplePluginFilter::Create()
{
    return new avtResamplePluginFilter();
}


// ****************************************************************************
//  Method:      avtResamplePluginFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
//  Modifications:
//
//    Hank Childs, Fri Sep 30 09:16:06 PDT 2005
//    Add support for distributed resampling.
//
//    Sean Ahern, Wed Jan  2 16:01:48 EST 2008
//    Added support for specifying that the whole extents should be used.
//
//    Hank Childs, Wed Dec 31 13:48:13 PST 2008
//    Rename ResampleAtts to InternalResampleAtts, ResamplePluginAtts to
//    just ResampleAtts.
//
// ****************************************************************************

void
avtResamplePluginFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const ResampleAttributes*)a;

    //
    // Construct a new resample filter based on these attributes.
    //
    if (resampler != NULL)
    {
        delete resampler;
    }

    InternalResampleAttributes res_atts;
    res_atts.SetDefaultVal(atts.GetDefaultValue());
    res_atts.SetUseTargetVal(false);
    res_atts.SetWidth(atts.GetSamplesX());
    res_atts.SetHeight(atts.GetSamplesY());
    if (atts.GetIs3D())
        res_atts.SetDepth(atts.GetSamplesZ());
    else
        res_atts.SetDepth(1);
    res_atts.SetUseBounds(!atts.GetUseExtents());
    res_atts.SetMinX(atts.GetStartX());
    res_atts.SetMaxX(atts.GetEndX());
    res_atts.SetMinY(atts.GetStartY());
    res_atts.SetMaxY(atts.GetEndY());
    if (atts.GetIs3D())
    {
        res_atts.SetMinZ(atts.GetStartZ());
        res_atts.SetMaxZ(atts.GetEndZ());
    }
    else
    {
        res_atts.SetMinZ(0);
        res_atts.SetMaxZ(0);
    }

    res_atts.SetUseArbitrator(atts.GetTieResolver() 
                           != ResampleAttributes::random);
    res_atts.SetArbitratorLessThan(atts.GetTieResolver() 
                                   != ResampleAttributes::smallest);
    res_atts.SetArbitratorVarName(atts.GetTieResolverVariable());
    
    res_atts.SetDistributedResample(atts.GetDistributedResample());
    resampler = new avtResampleFilter(&res_atts);
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtResamplePluginFilter with the given
//      parameters would result in an equivalent avtResamplePluginFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
// ****************************************************************************

bool
avtResamplePluginFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(ResampleAttributes*)a);
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   January 29, 2005
//
// ****************************************************************************

avtFilter *
avtResamplePluginFilter::GetFacadedFilter(void)
{
    return resampler;
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Tom Fogal
//  Creation:   June 23, 2009
//
// ****************************************************************************

const avtFilter *
avtResamplePluginFilter::GetFacadedFilter(void) const
{
    return resampler;
}
