/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ResampleAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ResampleAttributes::TieResolver
//

static const char *TieResolver_strings[] = {
"random", "largest", "smallest"
};

std::string
ResampleAttributes::TieResolver_ToString(ResampleAttributes::TieResolver t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return TieResolver_strings[index];
}

std::string
ResampleAttributes::TieResolver_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return TieResolver_strings[index];
}

bool
ResampleAttributes::TieResolver_FromString(const std::string &s, ResampleAttributes::TieResolver &val)
{
    val = ResampleAttributes::random;
    for(int i = 0; i < 3; ++i)
    {
        if(s == TieResolver_strings[i])
        {
            val = (TieResolver)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ResampleAttributes::ResampleAttributes
//
// Purpose: 
//   Init utility for the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ResampleAttributes::Init()
{
    useExtents = true;
    startX = 0;
    endX = 1;
    samplesX = 10;
    startY = 0;
    endY = 1;
    samplesY = 10;
    is3D = true;
    startZ = 0;
    endZ = 1;
    samplesZ = 10;
    tieResolver = random;
    defaultValue = 0;
    distributedResample = true;

    ResampleAttributes::SelectAll();
}

// ****************************************************************************
// Method: ResampleAttributes::ResampleAttributes
//
// Purpose: 
//   Copy utility for the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ResampleAttributes::Copy(const ResampleAttributes &obj)
{
    useExtents = obj.useExtents;
    startX = obj.startX;
    endX = obj.endX;
    samplesX = obj.samplesX;
    startY = obj.startY;
    endY = obj.endY;
    samplesY = obj.samplesY;
    is3D = obj.is3D;
    startZ = obj.startZ;
    endZ = obj.endZ;
    samplesZ = obj.samplesZ;
    tieResolver = obj.tieResolver;
    tieResolverVariable = obj.tieResolverVariable;
    defaultValue = obj.defaultValue;
    distributedResample = obj.distributedResample;

    ResampleAttributes::SelectAll();
}

// Type map format string
const char *ResampleAttributes::TypeMapFormatString = RESAMPLEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ResampleAttributes::TmfsStruct = {RESAMPLEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ResampleAttributes::ResampleAttributes
//
// Purpose: 
//   Default constructor for the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ResampleAttributes::ResampleAttributes() : 
    AttributeSubject(ResampleAttributes::TypeMapFormatString),
    tieResolverVariable("default")
{
    ResampleAttributes::Init();
}

// ****************************************************************************
// Method: ResampleAttributes::ResampleAttributes
//
// Purpose: 
//   Constructor for the derived classes of ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ResampleAttributes::ResampleAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    tieResolverVariable("default")
{
    ResampleAttributes::Init();
}

// ****************************************************************************
// Method: ResampleAttributes::ResampleAttributes
//
// Purpose: 
//   Copy constructor for the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ResampleAttributes::ResampleAttributes(const ResampleAttributes &obj) : 
    AttributeSubject(ResampleAttributes::TypeMapFormatString)
{
    ResampleAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ResampleAttributes::ResampleAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ResampleAttributes::ResampleAttributes(const ResampleAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ResampleAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ResampleAttributes::~ResampleAttributes
//
// Purpose: 
//   Destructor for the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ResampleAttributes::~ResampleAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ResampleAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ResampleAttributes& 
ResampleAttributes::operator = (const ResampleAttributes &obj)
{
    if (this == &obj) return *this;

    ResampleAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ResampleAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ResampleAttributes::operator == (const ResampleAttributes &obj) const
{
    // Create the return value
    return ((useExtents == obj.useExtents) &&
            (startX == obj.startX) &&
            (endX == obj.endX) &&
            (samplesX == obj.samplesX) &&
            (startY == obj.startY) &&
            (endY == obj.endY) &&
            (samplesY == obj.samplesY) &&
            (is3D == obj.is3D) &&
            (startZ == obj.startZ) &&
            (endZ == obj.endZ) &&
            (samplesZ == obj.samplesZ) &&
            (tieResolver == obj.tieResolver) &&
            (tieResolverVariable == obj.tieResolverVariable) &&
            (defaultValue == obj.defaultValue) &&
            (distributedResample == obj.distributedResample));
}

// ****************************************************************************
// Method: ResampleAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ResampleAttributes::operator != (const ResampleAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ResampleAttributes::TypeName
//
// Purpose: 
//   Type name method for the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ResampleAttributes::TypeName() const
{
    return "ResampleAttributes";
}

// ****************************************************************************
// Method: ResampleAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ResampleAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ResampleAttributes *tmp = (const ResampleAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ResampleAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ResampleAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ResampleAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ResampleAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ResampleAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ResampleAttributes(*this);
    else
        retval = new ResampleAttributes;

    return retval;
}

// ****************************************************************************
// Method: ResampleAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ResampleAttributes::SelectAll()
{
    Select(ID_useExtents,          (void *)&useExtents);
    Select(ID_startX,              (void *)&startX);
    Select(ID_endX,                (void *)&endX);
    Select(ID_samplesX,            (void *)&samplesX);
    Select(ID_startY,              (void *)&startY);
    Select(ID_endY,                (void *)&endY);
    Select(ID_samplesY,            (void *)&samplesY);
    Select(ID_is3D,                (void *)&is3D);
    Select(ID_startZ,              (void *)&startZ);
    Select(ID_endZ,                (void *)&endZ);
    Select(ID_samplesZ,            (void *)&samplesZ);
    Select(ID_tieResolver,         (void *)&tieResolver);
    Select(ID_tieResolverVariable, (void *)&tieResolverVariable);
    Select(ID_defaultValue,        (void *)&defaultValue);
    Select(ID_distributedResample, (void *)&distributedResample);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ResampleAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ResampleAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ResampleAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ResampleAttributes.
    DataNode *node = new DataNode("ResampleAttributes");

    if(completeSave || !FieldsEqual(ID_useExtents, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useExtents", useExtents));
    }

    if(completeSave || !FieldsEqual(ID_startX, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startX", startX));
    }

    if(completeSave || !FieldsEqual(ID_endX, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("endX", endX));
    }

    if(completeSave || !FieldsEqual(ID_samplesX, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("samplesX", samplesX));
    }

    if(completeSave || !FieldsEqual(ID_startY, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startY", startY));
    }

    if(completeSave || !FieldsEqual(ID_endY, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("endY", endY));
    }

    if(completeSave || !FieldsEqual(ID_samplesY, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("samplesY", samplesY));
    }

    if(completeSave || !FieldsEqual(ID_is3D, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("is3D", is3D));
    }

    if(completeSave || !FieldsEqual(ID_startZ, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startZ", startZ));
    }

    if(completeSave || !FieldsEqual(ID_endZ, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("endZ", endZ));
    }

    if(completeSave || !FieldsEqual(ID_samplesZ, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("samplesZ", samplesZ));
    }

    if(completeSave || !FieldsEqual(ID_tieResolver, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tieResolver", TieResolver_ToString(tieResolver)));
    }

    if(completeSave || !FieldsEqual(ID_tieResolverVariable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tieResolverVariable", tieResolverVariable));
    }

    if(completeSave || !FieldsEqual(ID_defaultValue, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("defaultValue", defaultValue));
    }

    if(completeSave || !FieldsEqual(ID_distributedResample, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("distributedResample", distributedResample));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ResampleAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ResampleAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ResampleAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("useExtents")) != 0)
        SetUseExtents(node->AsBool());
    if((node = searchNode->GetNode("startX")) != 0)
        SetStartX(node->AsDouble());
    if((node = searchNode->GetNode("endX")) != 0)
        SetEndX(node->AsDouble());
    if((node = searchNode->GetNode("samplesX")) != 0)
        SetSamplesX(node->AsInt());
    if((node = searchNode->GetNode("startY")) != 0)
        SetStartY(node->AsDouble());
    if((node = searchNode->GetNode("endY")) != 0)
        SetEndY(node->AsDouble());
    if((node = searchNode->GetNode("samplesY")) != 0)
        SetSamplesY(node->AsInt());
    if((node = searchNode->GetNode("is3D")) != 0)
        SetIs3D(node->AsBool());
    if((node = searchNode->GetNode("startZ")) != 0)
        SetStartZ(node->AsDouble());
    if((node = searchNode->GetNode("endZ")) != 0)
        SetEndZ(node->AsDouble());
    if((node = searchNode->GetNode("samplesZ")) != 0)
        SetSamplesZ(node->AsInt());
    if((node = searchNode->GetNode("tieResolver")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetTieResolver(TieResolver(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            TieResolver value;
            if(TieResolver_FromString(node->AsString(), value))
                SetTieResolver(value);
        }
    }
    if((node = searchNode->GetNode("tieResolverVariable")) != 0)
        SetTieResolverVariable(node->AsString());
    if((node = searchNode->GetNode("defaultValue")) != 0)
        SetDefaultValue(node->AsDouble());
    if((node = searchNode->GetNode("distributedResample")) != 0)
        SetDistributedResample(node->AsBool());
    // The SetStartX, etc calls trample useExtents.
    // Set to the correct value at the end.
    if((node = searchNode->GetNode("useExtents")) != 0)
        SetUseExtents(node->AsBool());

}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ResampleAttributes::SetUseExtents(bool useExtents_)
{
    useExtents = useExtents_;
    Select(ID_useExtents, (void *)&useExtents);
}

void
ResampleAttributes::SetStartX(double startX_)
{
    SetUseExtents(false);

    startX = startX_;
    Select(ID_startX, (void *)&startX);
}

void
ResampleAttributes::SetEndX(double endX_)
{
    SetUseExtents(false);

    endX = endX_;
    Select(ID_endX, (void *)&endX);
}

void
ResampleAttributes::SetSamplesX(int samplesX_)
{
    samplesX = samplesX_;
    Select(ID_samplesX, (void *)&samplesX);
}

void
ResampleAttributes::SetStartY(double startY_)
{
    SetUseExtents(false);

    startY = startY_;
    Select(ID_startY, (void *)&startY);
}

void
ResampleAttributes::SetEndY(double endY_)
{
    SetUseExtents(false);

    endY = endY_;
    Select(ID_endY, (void *)&endY);
}

void
ResampleAttributes::SetSamplesY(int samplesY_)
{
    samplesY = samplesY_;
    Select(ID_samplesY, (void *)&samplesY);
}

void
ResampleAttributes::SetIs3D(bool is3D_)
{
    is3D = is3D_;
    Select(ID_is3D, (void *)&is3D);
}

void
ResampleAttributes::SetStartZ(double startZ_)
{
    SetUseExtents(false);

    startZ = startZ_;
    Select(ID_startZ, (void *)&startZ);
}

void
ResampleAttributes::SetEndZ(double endZ_)
{
    SetUseExtents(false);

    endZ = endZ_;
    Select(ID_endZ, (void *)&endZ);
}

void
ResampleAttributes::SetSamplesZ(int samplesZ_)
{
    samplesZ = samplesZ_;
    Select(ID_samplesZ, (void *)&samplesZ);
}

void
ResampleAttributes::SetTieResolver(ResampleAttributes::TieResolver tieResolver_)
{
    tieResolver = tieResolver_;
    Select(ID_tieResolver, (void *)&tieResolver);
}

void
ResampleAttributes::SetTieResolverVariable(const std::string &tieResolverVariable_)
{
    tieResolverVariable = tieResolverVariable_;
    Select(ID_tieResolverVariable, (void *)&tieResolverVariable);
}

void
ResampleAttributes::SetDefaultValue(double defaultValue_)
{
    defaultValue = defaultValue_;
    Select(ID_defaultValue, (void *)&defaultValue);
}

void
ResampleAttributes::SetDistributedResample(bool distributedResample_)
{
    distributedResample = distributedResample_;
    Select(ID_distributedResample, (void *)&distributedResample);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
ResampleAttributes::GetUseExtents() const
{
    return useExtents;
}

double
ResampleAttributes::GetStartX() const
{
    return startX;
}

double
ResampleAttributes::GetEndX() const
{
    return endX;
}

int
ResampleAttributes::GetSamplesX() const
{
    return samplesX;
}

double
ResampleAttributes::GetStartY() const
{
    return startY;
}

double
ResampleAttributes::GetEndY() const
{
    return endY;
}

int
ResampleAttributes::GetSamplesY() const
{
    return samplesY;
}

bool
ResampleAttributes::GetIs3D() const
{
    return is3D;
}

double
ResampleAttributes::GetStartZ() const
{
    return startZ;
}

double
ResampleAttributes::GetEndZ() const
{
    return endZ;
}

int
ResampleAttributes::GetSamplesZ() const
{
    return samplesZ;
}

ResampleAttributes::TieResolver
ResampleAttributes::GetTieResolver() const
{
    return TieResolver(tieResolver);
}

const std::string &
ResampleAttributes::GetTieResolverVariable() const
{
    return tieResolverVariable;
}

std::string &
ResampleAttributes::GetTieResolverVariable()
{
    return tieResolverVariable;
}

double
ResampleAttributes::GetDefaultValue() const
{
    return defaultValue;
}

bool
ResampleAttributes::GetDistributedResample() const
{
    return distributedResample;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ResampleAttributes::SelectTieResolverVariable()
{
    Select(ID_tieResolverVariable, (void *)&tieResolverVariable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ResampleAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ResampleAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_useExtents:          return "useExtents";
    case ID_startX:              return "startX";
    case ID_endX:                return "endX";
    case ID_samplesX:            return "samplesX";
    case ID_startY:              return "startY";
    case ID_endY:                return "endY";
    case ID_samplesY:            return "samplesY";
    case ID_is3D:                return "is3D";
    case ID_startZ:              return "startZ";
    case ID_endZ:                return "endZ";
    case ID_samplesZ:            return "samplesZ";
    case ID_tieResolver:         return "tieResolver";
    case ID_tieResolverVariable: return "tieResolverVariable";
    case ID_defaultValue:        return "defaultValue";
    case ID_distributedResample: return "distributedResample";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ResampleAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ResampleAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_useExtents:          return FieldType_bool;
    case ID_startX:              return FieldType_double;
    case ID_endX:                return FieldType_double;
    case ID_samplesX:            return FieldType_int;
    case ID_startY:              return FieldType_double;
    case ID_endY:                return FieldType_double;
    case ID_samplesY:            return FieldType_int;
    case ID_is3D:                return FieldType_bool;
    case ID_startZ:              return FieldType_double;
    case ID_endZ:                return FieldType_double;
    case ID_samplesZ:            return FieldType_int;
    case ID_tieResolver:         return FieldType_enum;
    case ID_tieResolverVariable: return FieldType_variablename;
    case ID_defaultValue:        return FieldType_double;
    case ID_distributedResample: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ResampleAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ResampleAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_useExtents:          return "bool";
    case ID_startX:              return "double";
    case ID_endX:                return "double";
    case ID_samplesX:            return "int";
    case ID_startY:              return "double";
    case ID_endY:                return "double";
    case ID_samplesY:            return "int";
    case ID_is3D:                return "bool";
    case ID_startZ:              return "double";
    case ID_endZ:                return "double";
    case ID_samplesZ:            return "int";
    case ID_tieResolver:         return "enum";
    case ID_tieResolverVariable: return "variablename";
    case ID_defaultValue:        return "double";
    case ID_distributedResample: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ResampleAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ResampleAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ResampleAttributes &obj = *((const ResampleAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_useExtents:
        {  // new scope
        retval = (useExtents == obj.useExtents);
        }
        break;
    case ID_startX:
        {  // new scope
        retval = (startX == obj.startX);
        }
        break;
    case ID_endX:
        {  // new scope
        retval = (endX == obj.endX);
        }
        break;
    case ID_samplesX:
        {  // new scope
        retval = (samplesX == obj.samplesX);
        }
        break;
    case ID_startY:
        {  // new scope
        retval = (startY == obj.startY);
        }
        break;
    case ID_endY:
        {  // new scope
        retval = (endY == obj.endY);
        }
        break;
    case ID_samplesY:
        {  // new scope
        retval = (samplesY == obj.samplesY);
        }
        break;
    case ID_is3D:
        {  // new scope
        retval = (is3D == obj.is3D);
        }
        break;
    case ID_startZ:
        {  // new scope
        retval = (startZ == obj.startZ);
        }
        break;
    case ID_endZ:
        {  // new scope
        retval = (endZ == obj.endZ);
        }
        break;
    case ID_samplesZ:
        {  // new scope
        retval = (samplesZ == obj.samplesZ);
        }
        break;
    case ID_tieResolver:
        {  // new scope
        retval = (tieResolver == obj.tieResolver);
        }
        break;
    case ID_tieResolverVariable:
        {  // new scope
        retval = (tieResolverVariable == obj.tieResolverVariable);
        }
        break;
    case ID_defaultValue:
        {  // new scope
        retval = (defaultValue == obj.defaultValue);
        }
        break;
    case ID_distributedResample:
        {  // new scope
        retval = (distributedResample == obj.distributedResample);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

bool
ResampleAttributes::SetValue(const std::string &name, const double &value)
{
    int index = FieldNameToIndex(name);
    bool retval = true;
    if(index == ID_endX)
        SetEndX(value);
    else if(index == ID_endY)
        SetEndY(value);
    else if(index == ID_endZ)
        SetEndZ(value);
    else if(index == ID_startX)
        SetStartX(value);
    else if(index == ID_startY)
        SetStartY(value);
    else if(index == ID_startZ)
        SetStartZ(value);
    else
        retval = AttributeSubject::SetValue(name, value);
    return retval;
}

