/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisProjectWindow.h"

#include <ProjectAttributes.h>
#include <ViewerProxy.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QSpinBox>
#include <QButtonGroup>
#include <QRadioButton>
#include <QComboBox>
#include <QvisColorTableButton.h>
#include <QvisOpacitySlider.h>
#include <QvisColorButton.h>
#include <QvisLineStyleWidget.h>
#include <QvisLineWidthWidget.h>
#include <QvisVariableButton.h>

#include <stdio.h>
#include <string>

using std::string;

// ****************************************************************************
// Method: QvisProjectWindow::QvisProjectWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisProjectWindow::QvisProjectWindow(const int type,
                         ProjectAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisProjectWindow::~QvisProjectWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisProjectWindow::~QvisProjectWindow()
{
}


// ****************************************************************************
// Method: QvisProjectWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisProjectWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    QLabel *projectionTypeLabel = new QLabel(tr("Projection type"), central);
    mainLayout->addWidget(projectionTypeLabel,0,0);

    projectionTypeCombo = new QComboBox(central);

    projectionTypeCombo->addItem(tr("X-Axis Cartesian (x <= z, y <= y)"));
    projectionTypeCombo->addItem(tr("Y-Axis Cartesian (x <= x, y <= z)"));
    projectionTypeCombo->addItem(tr("Z-Axis Cartesian (x <= x, y <= y)"));
    projectionTypeCombo->addItem(tr("X-Axis Cylindrical (x <= x, y <= r)"));
    projectionTypeCombo->addItem(tr("Y-Axis Cylindrical (x <= y, y <= r)"));
    projectionTypeCombo->addItem(tr("Z-Axis Cylindrical (x <= z, y <= r)"));
    connect(projectionTypeCombo, SIGNAL(activated(int)),
            this, SLOT(projectionTypeChanged(int)));
    mainLayout->addWidget(projectionTypeCombo, 0,1);

    QLabel *vectorMethodLabel = new QLabel(tr("Vector transform method:"),
                                           central);
    mainLayout->addWidget(vectorMethodLabel, 1,0);
    vectorMethodCombo = new QComboBox(central);
    vectorMethodCombo->addItem(tr("No transformation"));
    vectorMethodCombo->addItem(tr("Treat as point coordinates"));
    vectorMethodCombo->addItem(tr("Treat as coordinate displacements"));
    vectorMethodCombo->addItem(tr("Treat as instantaneous directions"));
    connect(vectorMethodCombo, SIGNAL(activated(int)),
           this, SLOT(vectorMethodChanged(int)));
    mainLayout->addWidget(vectorMethodCombo, 1,1);
}


// ****************************************************************************
// Method: QvisProjectWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisProjectWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case ProjectAttributes::ID_projectionType:
            projectionTypeCombo->blockSignals(true);
            projectionTypeCombo->setCurrentIndex((int)atts->GetProjectionType());
            projectionTypeCombo->blockSignals(false);
            break;

          case ProjectAttributes::ID_vectorTransformMethod:
            vectorMethodCombo->blockSignals(true);
            vectorMethodCombo->setCurrentIndex((int)atts->GetVectorTransformMethod());
            vectorMethodCombo->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisProjectWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//help/en_US/relnotes2.0.0.html
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisProjectWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisProjectWindow::projectionTypeChanged(int val)
{
    if(val != atts->GetProjectionType())
    {
        atts->SetProjectionType(ProjectAttributes::ProjectionType(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisProjectWindow::vectorMethodChanged(int v)
{
    atts->SetVectorTransformMethod(
                                ProjectAttributes::VectorTransformMethod(v));
}
