/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyProjectAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyProjectAttributes
//
// Purpose: 
//   Project data from three to two dimensions
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ProjectAttributes.
//
struct ProjectAttributesObject
{
    PyObject_HEAD
    ProjectAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewProjectAttributes(int);

std::string
PyProjectAttributes_ToString(const ProjectAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    const char *projectionType_names = "ZYCartesian, XZCartesian, XYCartesian, XRCylindrical, YRCylindrical, "
        "ZRCylindrical";
    switch (atts->GetProjectionType())
    {
      case ProjectAttributes::ZYCartesian:
          SNPRINTF(tmpStr, 1000, "%sprojectionType = %sZYCartesian  # %s\n", prefix, prefix, projectionType_names);
          str += tmpStr;
          break;
      case ProjectAttributes::XZCartesian:
          SNPRINTF(tmpStr, 1000, "%sprojectionType = %sXZCartesian  # %s\n", prefix, prefix, projectionType_names);
          str += tmpStr;
          break;
      case ProjectAttributes::XYCartesian:
          SNPRINTF(tmpStr, 1000, "%sprojectionType = %sXYCartesian  # %s\n", prefix, prefix, projectionType_names);
          str += tmpStr;
          break;
      case ProjectAttributes::XRCylindrical:
          SNPRINTF(tmpStr, 1000, "%sprojectionType = %sXRCylindrical  # %s\n", prefix, prefix, projectionType_names);
          str += tmpStr;
          break;
      case ProjectAttributes::YRCylindrical:
          SNPRINTF(tmpStr, 1000, "%sprojectionType = %sYRCylindrical  # %s\n", prefix, prefix, projectionType_names);
          str += tmpStr;
          break;
      case ProjectAttributes::ZRCylindrical:
          SNPRINTF(tmpStr, 1000, "%sprojectionType = %sZRCylindrical  # %s\n", prefix, prefix, projectionType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *vectorTransformMethod_names = "None, AsPoint, AsDisplacement, AsDirection";
    switch (atts->GetVectorTransformMethod())
    {
      case ProjectAttributes::None:
          SNPRINTF(tmpStr, 1000, "%svectorTransformMethod = %sNone  # %s\n", prefix, prefix, vectorTransformMethod_names);
          str += tmpStr;
          break;
      case ProjectAttributes::AsPoint:
          SNPRINTF(tmpStr, 1000, "%svectorTransformMethod = %sAsPoint  # %s\n", prefix, prefix, vectorTransformMethod_names);
          str += tmpStr;
          break;
      case ProjectAttributes::AsDisplacement:
          SNPRINTF(tmpStr, 1000, "%svectorTransformMethod = %sAsDisplacement  # %s\n", prefix, prefix, vectorTransformMethod_names);
          str += tmpStr;
          break;
      case ProjectAttributes::AsDirection:
          SNPRINTF(tmpStr, 1000, "%svectorTransformMethod = %sAsDirection  # %s\n", prefix, prefix, vectorTransformMethod_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
ProjectAttributes_Notify(PyObject *self, PyObject *args)
{
    ProjectAttributesObject *obj = (ProjectAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ProjectAttributes_SetProjectionType(PyObject *self, PyObject *args)
{
    ProjectAttributesObject *obj = (ProjectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the projectionType in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetProjectionType(ProjectAttributes::ProjectionType(ival));
    else
    {
        fprintf(stderr, "An invalid projectionType value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "ZYCartesian, XZCartesian, XYCartesian, XRCylindrical, YRCylindrical, "
                        "ZRCylindrical.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ProjectAttributes_GetProjectionType(PyObject *self, PyObject *args)
{
    ProjectAttributesObject *obj = (ProjectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetProjectionType()));
    return retval;
}

/*static*/ PyObject *
ProjectAttributes_SetVectorTransformMethod(PyObject *self, PyObject *args)
{
    ProjectAttributesObject *obj = (ProjectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the vectorTransformMethod in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetVectorTransformMethod(ProjectAttributes::VectorTransformMethod(ival));
    else
    {
        fprintf(stderr, "An invalid vectorTransformMethod value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "None, AsPoint, AsDisplacement, AsDirection.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ProjectAttributes_GetVectorTransformMethod(PyObject *self, PyObject *args)
{
    ProjectAttributesObject *obj = (ProjectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVectorTransformMethod()));
    return retval;
}



PyMethodDef PyProjectAttributes_methods[PROJECTATTRIBUTES_NMETH] = {
    {"Notify", ProjectAttributes_Notify, METH_VARARGS},
    {"SetProjectionType", ProjectAttributes_SetProjectionType, METH_VARARGS},
    {"GetProjectionType", ProjectAttributes_GetProjectionType, METH_VARARGS},
    {"SetVectorTransformMethod", ProjectAttributes_SetVectorTransformMethod, METH_VARARGS},
    {"GetVectorTransformMethod", ProjectAttributes_GetVectorTransformMethod, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ProjectAttributes_dealloc(PyObject *v)
{
   ProjectAttributesObject *obj = (ProjectAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ProjectAttributes_compare(PyObject *v, PyObject *w)
{
    ProjectAttributes *a = ((ProjectAttributesObject *)v)->data;
    ProjectAttributes *b = ((ProjectAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyProjectAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "projectionType") == 0)
        return ProjectAttributes_GetProjectionType(self, NULL);
    if(strcmp(name, "ZYCartesian") == 0)
        return PyInt_FromLong(long(ProjectAttributes::ZYCartesian));
    if(strcmp(name, "XZCartesian") == 0)
        return PyInt_FromLong(long(ProjectAttributes::XZCartesian));
    if(strcmp(name, "XYCartesian") == 0)
        return PyInt_FromLong(long(ProjectAttributes::XYCartesian));
    if(strcmp(name, "XRCylindrical") == 0)
        return PyInt_FromLong(long(ProjectAttributes::XRCylindrical));
    if(strcmp(name, "YRCylindrical") == 0)
        return PyInt_FromLong(long(ProjectAttributes::YRCylindrical));
    if(strcmp(name, "ZRCylindrical") == 0)
        return PyInt_FromLong(long(ProjectAttributes::ZRCylindrical));

    if(strcmp(name, "vectorTransformMethod") == 0)
        return ProjectAttributes_GetVectorTransformMethod(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(ProjectAttributes::None));
    if(strcmp(name, "AsPoint") == 0)
        return PyInt_FromLong(long(ProjectAttributes::AsPoint));
    if(strcmp(name, "AsDisplacement") == 0)
        return PyInt_FromLong(long(ProjectAttributes::AsDisplacement));
    if(strcmp(name, "AsDirection") == 0)
        return PyInt_FromLong(long(ProjectAttributes::AsDirection));


    return Py_FindMethod(PyProjectAttributes_methods, self, name);
}

int
PyProjectAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "projectionType") == 0)
        obj = ProjectAttributes_SetProjectionType(self, tuple);
    else if(strcmp(name, "vectorTransformMethod") == 0)
        obj = ProjectAttributes_SetVectorTransformMethod(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ProjectAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ProjectAttributesObject *obj = (ProjectAttributesObject *)v;
    fprintf(fp, "%s", PyProjectAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ProjectAttributes_str(PyObject *v)
{
    ProjectAttributesObject *obj = (ProjectAttributesObject *)v;
    return PyString_FromString(PyProjectAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ProjectAttributes_Purpose = "Project data from three to two dimensions";
#else
static char *ProjectAttributes_Purpose = "Project data from three to two dimensions";
#endif

//
// The type description structure
//
static PyTypeObject ProjectAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ProjectAttributes",                    // tp_name
    sizeof(ProjectAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ProjectAttributes_dealloc,  // tp_dealloc
    (printfunc)ProjectAttributes_print,     // tp_print
    (getattrfunc)PyProjectAttributes_getattr, // tp_getattr
    (setattrfunc)PyProjectAttributes_setattr, // tp_setattr
    (cmpfunc)ProjectAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ProjectAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ProjectAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ProjectAttributes *defaultAtts = 0;
static ProjectAttributes *currentAtts = 0;

static PyObject *
NewProjectAttributes(int useCurrent)
{
    ProjectAttributesObject *newObject;
    newObject = PyObject_NEW(ProjectAttributesObject, &ProjectAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ProjectAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ProjectAttributes(*defaultAtts);
    else
        newObject->data = new ProjectAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapProjectAttributes(const ProjectAttributes *attr)
{
    ProjectAttributesObject *newObject;
    newObject = PyObject_NEW(ProjectAttributesObject, &ProjectAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ProjectAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ProjectAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewProjectAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ProjectAttributesMethods[] = {
    {"ProjectAttributes", ProjectAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ProjectAttributesObserver = 0;

std::string
PyProjectAttributes_GetLogString()
{
    std::string s("ProjectAtts = ProjectAttributes()\n");
    if(currentAtts != 0)
        s += PyProjectAttributes_ToString(currentAtts, "ProjectAtts.");
    return s;
}

static void
PyProjectAttributes_CallLogRoutine(Subject *subj, void *data)
{
    ProjectAttributes *atts = (ProjectAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ProjectAtts = ProjectAttributes()\n");
        s += PyProjectAttributes_ToString(currentAtts, "ProjectAtts.");
        cb(s);
    }
}

void
PyProjectAttributes_StartUp(ProjectAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyProjectAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ProjectAttributesObserver == 0)
    {
        ProjectAttributesObserver = new ObserverToCallback(subj,
            PyProjectAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyProjectAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ProjectAttributesObserver;
    ProjectAttributesObserver = 0;
}

PyMethodDef *
PyProjectAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ProjectAttributesMethods;
}

bool
PyProjectAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ProjectAttributesType);
}

ProjectAttributes *
PyProjectAttributes_FromPyObject(PyObject *obj)
{
    ProjectAttributesObject *obj2 = (ProjectAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyProjectAttributes_New()
{
    return NewProjectAttributes(0);
}

PyObject *
PyProjectAttributes_Wrap(const ProjectAttributes *attr)
{
    return WrapProjectAttributes(attr);
}

void
PyProjectAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ProjectAttributesObject *obj2 = (ProjectAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyProjectAttributes_SetDefaults(const ProjectAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ProjectAttributes(*atts);
}

