/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PDFAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for PDFAttributes::Scaling
//

static const char *Scaling_strings[] = {
"Linear", "Log", "Skew"
};

std::string
PDFAttributes::Scaling_ToString(PDFAttributes::Scaling t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Scaling_strings[index];
}

std::string
PDFAttributes::Scaling_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Scaling_strings[index];
}

bool
PDFAttributes::Scaling_FromString(const std::string &s, PDFAttributes::Scaling &val)
{
    val = PDFAttributes::Linear;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Scaling_strings[i])
        {
            val = (Scaling)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for PDFAttributes::NumAxes
//

static const char *NumAxes_strings[] = {
"Two", "Three"};

std::string
PDFAttributes::NumAxes_ToString(PDFAttributes::NumAxes t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return NumAxes_strings[index];
}

std::string
PDFAttributes::NumAxes_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return NumAxes_strings[index];
}

bool
PDFAttributes::NumAxes_FromString(const std::string &s, PDFAttributes::NumAxes &val)
{
    val = PDFAttributes::Two;
    for(int i = 0; i < 2; ++i)
    {
        if(s == NumAxes_strings[i])
        {
            val = (NumAxes)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for PDFAttributes::DensityType
//

static const char *DensityType_strings[] = {
"Probability", "ZoneCount"};

std::string
PDFAttributes::DensityType_ToString(PDFAttributes::DensityType t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return DensityType_strings[index];
}

std::string
PDFAttributes::DensityType_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return DensityType_strings[index];
}

bool
PDFAttributes::DensityType_FromString(const std::string &s, PDFAttributes::DensityType &val)
{
    val = PDFAttributes::Probability;
    for(int i = 0; i < 2; ++i)
    {
        if(s == DensityType_strings[i])
        {
            val = (DensityType)i;
            return true;
        }
    }
    return false;
}

// Type map format string
const char *PDFAttributes::TypeMapFormatString = "sbbddidisbbddidiisbbddidibi";

// ****************************************************************************
// Method: PDFAttributes::PDFAttributes
//
// Purpose: 
//   Constructor for the PDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PDFAttributes::PDFAttributes() : 
    AttributeSubject(PDFAttributes::TypeMapFormatString)
{
    var1 = "default";
    var1MinFlag = false;
    var1MaxFlag = false;
    var1Min = 0;
    var1Max = 1;
    var1Scaling = Linear;
    var1SkewFactor = 1;
    var1NumSamples = 100;
    var2 = "default";
    var2MinFlag = false;
    var2MaxFlag = false;
    var2Min = 0;
    var2Max = 1;
    var2Scaling = Linear;
    var2SkewFactor = 1;
    var2NumSamples = 100;
    numAxes = Two;
    var3 = "default";
    var3MinFlag = false;
    var3MaxFlag = false;
    var3Min = 0;
    var3Max = 1;
    var3Scaling = Linear;
    var3SkewFactor = 1;
    var3NumSamples = 100;
    scaleCube = true;
    densityType = Probability;
}

// ****************************************************************************
// Method: PDFAttributes::PDFAttributes
//
// Purpose: 
//   Copy constructor for the PDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PDFAttributes::PDFAttributes(const PDFAttributes &obj) : 
    AttributeSubject(PDFAttributes::TypeMapFormatString)
{
    var1 = obj.var1;
    var1MinFlag = obj.var1MinFlag;
    var1MaxFlag = obj.var1MaxFlag;
    var1Min = obj.var1Min;
    var1Max = obj.var1Max;
    var1Scaling = obj.var1Scaling;
    var1SkewFactor = obj.var1SkewFactor;
    var1NumSamples = obj.var1NumSamples;
    var2 = obj.var2;
    var2MinFlag = obj.var2MinFlag;
    var2MaxFlag = obj.var2MaxFlag;
    var2Min = obj.var2Min;
    var2Max = obj.var2Max;
    var2Scaling = obj.var2Scaling;
    var2SkewFactor = obj.var2SkewFactor;
    var2NumSamples = obj.var2NumSamples;
    numAxes = obj.numAxes;
    var3 = obj.var3;
    var3MinFlag = obj.var3MinFlag;
    var3MaxFlag = obj.var3MaxFlag;
    var3Min = obj.var3Min;
    var3Max = obj.var3Max;
    var3Scaling = obj.var3Scaling;
    var3SkewFactor = obj.var3SkewFactor;
    var3NumSamples = obj.var3NumSamples;
    scaleCube = obj.scaleCube;
    densityType = obj.densityType;

    SelectAll();
}

// ****************************************************************************
// Method: PDFAttributes::~PDFAttributes
//
// Purpose: 
//   Destructor for the PDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PDFAttributes::~PDFAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: PDFAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the PDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PDFAttributes& 
PDFAttributes::operator = (const PDFAttributes &obj)
{
    if (this == &obj) return *this;
    var1 = obj.var1;
    var1MinFlag = obj.var1MinFlag;
    var1MaxFlag = obj.var1MaxFlag;
    var1Min = obj.var1Min;
    var1Max = obj.var1Max;
    var1Scaling = obj.var1Scaling;
    var1SkewFactor = obj.var1SkewFactor;
    var1NumSamples = obj.var1NumSamples;
    var2 = obj.var2;
    var2MinFlag = obj.var2MinFlag;
    var2MaxFlag = obj.var2MaxFlag;
    var2Min = obj.var2Min;
    var2Max = obj.var2Max;
    var2Scaling = obj.var2Scaling;
    var2SkewFactor = obj.var2SkewFactor;
    var2NumSamples = obj.var2NumSamples;
    numAxes = obj.numAxes;
    var3 = obj.var3;
    var3MinFlag = obj.var3MinFlag;
    var3MaxFlag = obj.var3MaxFlag;
    var3Min = obj.var3Min;
    var3Max = obj.var3Max;
    var3Scaling = obj.var3Scaling;
    var3SkewFactor = obj.var3SkewFactor;
    var3NumSamples = obj.var3NumSamples;
    scaleCube = obj.scaleCube;
    densityType = obj.densityType;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: PDFAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the PDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PDFAttributes::operator == (const PDFAttributes &obj) const
{
    // Create the return value
    return ((var1 == obj.var1) &&
            (var1MinFlag == obj.var1MinFlag) &&
            (var1MaxFlag == obj.var1MaxFlag) &&
            (var1Min == obj.var1Min) &&
            (var1Max == obj.var1Max) &&
            (var1Scaling == obj.var1Scaling) &&
            (var1SkewFactor == obj.var1SkewFactor) &&
            (var1NumSamples == obj.var1NumSamples) &&
            (var2 == obj.var2) &&
            (var2MinFlag == obj.var2MinFlag) &&
            (var2MaxFlag == obj.var2MaxFlag) &&
            (var2Min == obj.var2Min) &&
            (var2Max == obj.var2Max) &&
            (var2Scaling == obj.var2Scaling) &&
            (var2SkewFactor == obj.var2SkewFactor) &&
            (var2NumSamples == obj.var2NumSamples) &&
            (numAxes == obj.numAxes) &&
            (var3 == obj.var3) &&
            (var3MinFlag == obj.var3MinFlag) &&
            (var3MaxFlag == obj.var3MaxFlag) &&
            (var3Min == obj.var3Min) &&
            (var3Max == obj.var3Max) &&
            (var3Scaling == obj.var3Scaling) &&
            (var3SkewFactor == obj.var3SkewFactor) &&
            (var3NumSamples == obj.var3NumSamples) &&
            (scaleCube == obj.scaleCube) &&
            (densityType == obj.densityType));
}

// ****************************************************************************
// Method: PDFAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the PDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PDFAttributes::operator != (const PDFAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: PDFAttributes::TypeName
//
// Purpose: 
//   Type name method for the PDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
PDFAttributes::TypeName() const
{
    return "PDFAttributes";
}

// ****************************************************************************
// Method: PDFAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the PDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PDFAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const PDFAttributes *tmp = (const PDFAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: PDFAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the PDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PDFAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new PDFAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: PDFAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the PDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PDFAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new PDFAttributes(*this);
    else
        retval = new PDFAttributes;

    return retval;
}

// ****************************************************************************
// Method: PDFAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PDFAttributes::SelectAll()
{
    Select(ID_var1,           (void *)&var1);
    Select(ID_var1MinFlag,    (void *)&var1MinFlag);
    Select(ID_var1MaxFlag,    (void *)&var1MaxFlag);
    Select(ID_var1Min,        (void *)&var1Min);
    Select(ID_var1Max,        (void *)&var1Max);
    Select(ID_var1Scaling,    (void *)&var1Scaling);
    Select(ID_var1SkewFactor, (void *)&var1SkewFactor);
    Select(ID_var1NumSamples, (void *)&var1NumSamples);
    Select(ID_var2,           (void *)&var2);
    Select(ID_var2MinFlag,    (void *)&var2MinFlag);
    Select(ID_var2MaxFlag,    (void *)&var2MaxFlag);
    Select(ID_var2Min,        (void *)&var2Min);
    Select(ID_var2Max,        (void *)&var2Max);
    Select(ID_var2Scaling,    (void *)&var2Scaling);
    Select(ID_var2SkewFactor, (void *)&var2SkewFactor);
    Select(ID_var2NumSamples, (void *)&var2NumSamples);
    Select(ID_numAxes,        (void *)&numAxes);
    Select(ID_var3,           (void *)&var3);
    Select(ID_var3MinFlag,    (void *)&var3MinFlag);
    Select(ID_var3MaxFlag,    (void *)&var3MaxFlag);
    Select(ID_var3Min,        (void *)&var3Min);
    Select(ID_var3Max,        (void *)&var3Max);
    Select(ID_var3Scaling,    (void *)&var3Scaling);
    Select(ID_var3SkewFactor, (void *)&var3SkewFactor);
    Select(ID_var3NumSamples, (void *)&var3NumSamples);
    Select(ID_scaleCube,      (void *)&scaleCube);
    Select(ID_densityType,    (void *)&densityType);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PDFAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PDFAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    PDFAttributes defaultObject;
    bool addToParent = false;
    // Create a node for PDFAttributes.
    DataNode *node = new DataNode("PDFAttributes");

    if(completeSave || !FieldsEqual(ID_var1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1", var1));
    }

    if(completeSave || !FieldsEqual(ID_var1MinFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1MinFlag", var1MinFlag));
    }

    if(completeSave || !FieldsEqual(ID_var1MaxFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1MaxFlag", var1MaxFlag));
    }

    if(completeSave || !FieldsEqual(ID_var1Min, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1Min", var1Min));
    }

    if(completeSave || !FieldsEqual(ID_var1Max, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1Max", var1Max));
    }

    if(completeSave || !FieldsEqual(ID_var1Scaling, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1Scaling", Scaling_ToString(var1Scaling)));
    }

    if(completeSave || !FieldsEqual(ID_var1SkewFactor, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1SkewFactor", var1SkewFactor));
    }

    if(completeSave || !FieldsEqual(ID_var1NumSamples, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1NumSamples", var1NumSamples));
    }

    if(completeSave || !FieldsEqual(ID_var2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2", var2));
    }

    if(completeSave || !FieldsEqual(ID_var2MinFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2MinFlag", var2MinFlag));
    }

    if(completeSave || !FieldsEqual(ID_var2MaxFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2MaxFlag", var2MaxFlag));
    }

    if(completeSave || !FieldsEqual(ID_var2Min, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2Min", var2Min));
    }

    if(completeSave || !FieldsEqual(ID_var2Max, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2Max", var2Max));
    }

    if(completeSave || !FieldsEqual(ID_var2Scaling, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2Scaling", Scaling_ToString(var2Scaling)));
    }

    if(completeSave || !FieldsEqual(ID_var2SkewFactor, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2SkewFactor", var2SkewFactor));
    }

    if(completeSave || !FieldsEqual(ID_var2NumSamples, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2NumSamples", var2NumSamples));
    }

    if(completeSave || !FieldsEqual(ID_numAxes, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numAxes", NumAxes_ToString(numAxes)));
    }

    if(completeSave || !FieldsEqual(ID_var3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3", var3));
    }

    if(completeSave || !FieldsEqual(ID_var3MinFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3MinFlag", var3MinFlag));
    }

    if(completeSave || !FieldsEqual(ID_var3MaxFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3MaxFlag", var3MaxFlag));
    }

    if(completeSave || !FieldsEqual(ID_var3Min, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3Min", var3Min));
    }

    if(completeSave || !FieldsEqual(ID_var3Max, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3Max", var3Max));
    }

    if(completeSave || !FieldsEqual(ID_var3Scaling, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3Scaling", Scaling_ToString(var3Scaling)));
    }

    if(completeSave || !FieldsEqual(ID_var3SkewFactor, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3SkewFactor", var3SkewFactor));
    }

    if(completeSave || !FieldsEqual(ID_var3NumSamples, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3NumSamples", var3NumSamples));
    }

    if(completeSave || !FieldsEqual(ID_scaleCube, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaleCube", scaleCube));
    }

    if(completeSave || !FieldsEqual(ID_densityType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("densityType", DensityType_ToString(densityType)));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: PDFAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PDFAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("PDFAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("var1")) != 0)
        SetVar1(node->AsString());
    if((node = searchNode->GetNode("var1MinFlag")) != 0)
        SetVar1MinFlag(node->AsBool());
    if((node = searchNode->GetNode("var1MaxFlag")) != 0)
        SetVar1MaxFlag(node->AsBool());
    if((node = searchNode->GetNode("var1Min")) != 0)
        SetVar1Min(node->AsDouble());
    if((node = searchNode->GetNode("var1Max")) != 0)
        SetVar1Max(node->AsDouble());
    if((node = searchNode->GetNode("var1Scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetVar1Scaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetVar1Scaling(value);
        }
    }
    if((node = searchNode->GetNode("var1SkewFactor")) != 0)
        SetVar1SkewFactor(node->AsDouble());
    if((node = searchNode->GetNode("var1NumSamples")) != 0)
        SetVar1NumSamples(node->AsInt());
    if((node = searchNode->GetNode("var2")) != 0)
        SetVar2(node->AsString());
    if((node = searchNode->GetNode("var2MinFlag")) != 0)
        SetVar2MinFlag(node->AsBool());
    if((node = searchNode->GetNode("var2MaxFlag")) != 0)
        SetVar2MaxFlag(node->AsBool());
    if((node = searchNode->GetNode("var2Min")) != 0)
        SetVar2Min(node->AsDouble());
    if((node = searchNode->GetNode("var2Max")) != 0)
        SetVar2Max(node->AsDouble());
    if((node = searchNode->GetNode("var2Scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetVar2Scaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetVar2Scaling(value);
        }
    }
    if((node = searchNode->GetNode("var2SkewFactor")) != 0)
        SetVar2SkewFactor(node->AsDouble());
    if((node = searchNode->GetNode("var2NumSamples")) != 0)
        SetVar2NumSamples(node->AsInt());
    if((node = searchNode->GetNode("numAxes")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetNumAxes(NumAxes(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            NumAxes value;
            if(NumAxes_FromString(node->AsString(), value))
                SetNumAxes(value);
        }
    }
    if((node = searchNode->GetNode("var3")) != 0)
        SetVar3(node->AsString());
    if((node = searchNode->GetNode("var3MinFlag")) != 0)
        SetVar3MinFlag(node->AsBool());
    if((node = searchNode->GetNode("var3MaxFlag")) != 0)
        SetVar3MaxFlag(node->AsBool());
    if((node = searchNode->GetNode("var3Min")) != 0)
        SetVar3Min(node->AsDouble());
    if((node = searchNode->GetNode("var3Max")) != 0)
        SetVar3Max(node->AsDouble());
    if((node = searchNode->GetNode("var3Scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetVar3Scaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetVar3Scaling(value);
        }
    }
    if((node = searchNode->GetNode("var3SkewFactor")) != 0)
        SetVar3SkewFactor(node->AsDouble());
    if((node = searchNode->GetNode("var3NumSamples")) != 0)
        SetVar3NumSamples(node->AsInt());
    if((node = searchNode->GetNode("scaleCube")) != 0)
        SetScaleCube(node->AsBool());
    if((node = searchNode->GetNode("densityType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetDensityType(DensityType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            DensityType value;
            if(DensityType_FromString(node->AsString(), value))
                SetDensityType(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
PDFAttributes::SetVar1(const std::string &var1_)
{
    var1 = var1_;
    Select(ID_var1, (void *)&var1);
}

void
PDFAttributes::SetVar1MinFlag(bool var1MinFlag_)
{
    var1MinFlag = var1MinFlag_;
    Select(ID_var1MinFlag, (void *)&var1MinFlag);
}

void
PDFAttributes::SetVar1MaxFlag(bool var1MaxFlag_)
{
    var1MaxFlag = var1MaxFlag_;
    Select(ID_var1MaxFlag, (void *)&var1MaxFlag);
}

void
PDFAttributes::SetVar1Min(double var1Min_)
{
    var1Min = var1Min_;
    Select(ID_var1Min, (void *)&var1Min);
}

void
PDFAttributes::SetVar1Max(double var1Max_)
{
    var1Max = var1Max_;
    Select(ID_var1Max, (void *)&var1Max);
}

void
PDFAttributes::SetVar1Scaling(PDFAttributes::Scaling var1Scaling_)
{
    var1Scaling = var1Scaling_;
    Select(ID_var1Scaling, (void *)&var1Scaling);
}

void
PDFAttributes::SetVar1SkewFactor(double var1SkewFactor_)
{
    var1SkewFactor = var1SkewFactor_;
    Select(ID_var1SkewFactor, (void *)&var1SkewFactor);
}

void
PDFAttributes::SetVar1NumSamples(int var1NumSamples_)
{
    var1NumSamples = var1NumSamples_;
    Select(ID_var1NumSamples, (void *)&var1NumSamples);
}

void
PDFAttributes::SetVar2(const std::string &var2_)
{
    var2 = var2_;
    Select(ID_var2, (void *)&var2);
}

void
PDFAttributes::SetVar2MinFlag(bool var2MinFlag_)
{
    var2MinFlag = var2MinFlag_;
    Select(ID_var2MinFlag, (void *)&var2MinFlag);
}

void
PDFAttributes::SetVar2MaxFlag(bool var2MaxFlag_)
{
    var2MaxFlag = var2MaxFlag_;
    Select(ID_var2MaxFlag, (void *)&var2MaxFlag);
}

void
PDFAttributes::SetVar2Min(double var2Min_)
{
    var2Min = var2Min_;
    Select(ID_var2Min, (void *)&var2Min);
}

void
PDFAttributes::SetVar2Max(double var2Max_)
{
    var2Max = var2Max_;
    Select(ID_var2Max, (void *)&var2Max);
}

void
PDFAttributes::SetVar2Scaling(PDFAttributes::Scaling var2Scaling_)
{
    var2Scaling = var2Scaling_;
    Select(ID_var2Scaling, (void *)&var2Scaling);
}

void
PDFAttributes::SetVar2SkewFactor(double var2SkewFactor_)
{
    var2SkewFactor = var2SkewFactor_;
    Select(ID_var2SkewFactor, (void *)&var2SkewFactor);
}

void
PDFAttributes::SetVar2NumSamples(int var2NumSamples_)
{
    var2NumSamples = var2NumSamples_;
    Select(ID_var2NumSamples, (void *)&var2NumSamples);
}

void
PDFAttributes::SetNumAxes(PDFAttributes::NumAxes numAxes_)
{
    numAxes = numAxes_;
    Select(ID_numAxes, (void *)&numAxes);
}

void
PDFAttributes::SetVar3(const std::string &var3_)
{
    var3 = var3_;
    Select(ID_var3, (void *)&var3);
}

void
PDFAttributes::SetVar3MinFlag(bool var3MinFlag_)
{
    var3MinFlag = var3MinFlag_;
    Select(ID_var3MinFlag, (void *)&var3MinFlag);
}

void
PDFAttributes::SetVar3MaxFlag(bool var3MaxFlag_)
{
    var3MaxFlag = var3MaxFlag_;
    Select(ID_var3MaxFlag, (void *)&var3MaxFlag);
}

void
PDFAttributes::SetVar3Min(double var3Min_)
{
    var3Min = var3Min_;
    Select(ID_var3Min, (void *)&var3Min);
}

void
PDFAttributes::SetVar3Max(double var3Max_)
{
    var3Max = var3Max_;
    Select(ID_var3Max, (void *)&var3Max);
}

void
PDFAttributes::SetVar3Scaling(PDFAttributes::Scaling var3Scaling_)
{
    var3Scaling = var3Scaling_;
    Select(ID_var3Scaling, (void *)&var3Scaling);
}

void
PDFAttributes::SetVar3SkewFactor(double var3SkewFactor_)
{
    var3SkewFactor = var3SkewFactor_;
    Select(ID_var3SkewFactor, (void *)&var3SkewFactor);
}

void
PDFAttributes::SetVar3NumSamples(int var3NumSamples_)
{
    var3NumSamples = var3NumSamples_;
    Select(ID_var3NumSamples, (void *)&var3NumSamples);
}

void
PDFAttributes::SetScaleCube(bool scaleCube_)
{
    scaleCube = scaleCube_;
    Select(ID_scaleCube, (void *)&scaleCube);
}

void
PDFAttributes::SetDensityType(PDFAttributes::DensityType densityType_)
{
    densityType = densityType_;
    Select(ID_densityType, (void *)&densityType);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
PDFAttributes::GetVar1() const
{
    return var1;
}

std::string &
PDFAttributes::GetVar1()
{
    return var1;
}

bool
PDFAttributes::GetVar1MinFlag() const
{
    return var1MinFlag;
}

bool
PDFAttributes::GetVar1MaxFlag() const
{
    return var1MaxFlag;
}

double
PDFAttributes::GetVar1Min() const
{
    return var1Min;
}

double
PDFAttributes::GetVar1Max() const
{
    return var1Max;
}

PDFAttributes::Scaling
PDFAttributes::GetVar1Scaling() const
{
    return Scaling(var1Scaling);
}

double
PDFAttributes::GetVar1SkewFactor() const
{
    return var1SkewFactor;
}

int
PDFAttributes::GetVar1NumSamples() const
{
    return var1NumSamples;
}

const std::string &
PDFAttributes::GetVar2() const
{
    return var2;
}

std::string &
PDFAttributes::GetVar2()
{
    return var2;
}

bool
PDFAttributes::GetVar2MinFlag() const
{
    return var2MinFlag;
}

bool
PDFAttributes::GetVar2MaxFlag() const
{
    return var2MaxFlag;
}

double
PDFAttributes::GetVar2Min() const
{
    return var2Min;
}

double
PDFAttributes::GetVar2Max() const
{
    return var2Max;
}

PDFAttributes::Scaling
PDFAttributes::GetVar2Scaling() const
{
    return Scaling(var2Scaling);
}

double
PDFAttributes::GetVar2SkewFactor() const
{
    return var2SkewFactor;
}

int
PDFAttributes::GetVar2NumSamples() const
{
    return var2NumSamples;
}

PDFAttributes::NumAxes
PDFAttributes::GetNumAxes() const
{
    return NumAxes(numAxes);
}

const std::string &
PDFAttributes::GetVar3() const
{
    return var3;
}

std::string &
PDFAttributes::GetVar3()
{
    return var3;
}

bool
PDFAttributes::GetVar3MinFlag() const
{
    return var3MinFlag;
}

bool
PDFAttributes::GetVar3MaxFlag() const
{
    return var3MaxFlag;
}

double
PDFAttributes::GetVar3Min() const
{
    return var3Min;
}

double
PDFAttributes::GetVar3Max() const
{
    return var3Max;
}

PDFAttributes::Scaling
PDFAttributes::GetVar3Scaling() const
{
    return Scaling(var3Scaling);
}

double
PDFAttributes::GetVar3SkewFactor() const
{
    return var3SkewFactor;
}

int
PDFAttributes::GetVar3NumSamples() const
{
    return var3NumSamples;
}

bool
PDFAttributes::GetScaleCube() const
{
    return scaleCube;
}

PDFAttributes::DensityType
PDFAttributes::GetDensityType() const
{
    return DensityType(densityType);
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
PDFAttributes::SelectVar1()
{
    Select(ID_var1, (void *)&var1);
}

void
PDFAttributes::SelectVar2()
{
    Select(ID_var2, (void *)&var2);
}

void
PDFAttributes::SelectVar3()
{
    Select(ID_var3, (void *)&var3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PDFAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PDFAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_var1:           return "var1";
    case ID_var1MinFlag:    return "var1MinFlag";
    case ID_var1MaxFlag:    return "var1MaxFlag";
    case ID_var1Min:        return "var1Min";
    case ID_var1Max:        return "var1Max";
    case ID_var1Scaling:    return "var1Scaling";
    case ID_var1SkewFactor: return "var1SkewFactor";
    case ID_var1NumSamples: return "var1NumSamples";
    case ID_var2:           return "var2";
    case ID_var2MinFlag:    return "var2MinFlag";
    case ID_var2MaxFlag:    return "var2MaxFlag";
    case ID_var2Min:        return "var2Min";
    case ID_var2Max:        return "var2Max";
    case ID_var2Scaling:    return "var2Scaling";
    case ID_var2SkewFactor: return "var2SkewFactor";
    case ID_var2NumSamples: return "var2NumSamples";
    case ID_numAxes:        return "numAxes";
    case ID_var3:           return "var3";
    case ID_var3MinFlag:    return "var3MinFlag";
    case ID_var3MaxFlag:    return "var3MaxFlag";
    case ID_var3Min:        return "var3Min";
    case ID_var3Max:        return "var3Max";
    case ID_var3Scaling:    return "var3Scaling";
    case ID_var3SkewFactor: return "var3SkewFactor";
    case ID_var3NumSamples: return "var3NumSamples";
    case ID_scaleCube:      return "scaleCube";
    case ID_densityType:    return "densityType";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PDFAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
PDFAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_var1:           return FieldType_string;
    case ID_var1MinFlag:    return FieldType_bool;
    case ID_var1MaxFlag:    return FieldType_bool;
    case ID_var1Min:        return FieldType_double;
    case ID_var1Max:        return FieldType_double;
    case ID_var1Scaling:    return FieldType_enum;
    case ID_var1SkewFactor: return FieldType_double;
    case ID_var1NumSamples: return FieldType_int;
    case ID_var2:           return FieldType_string;
    case ID_var2MinFlag:    return FieldType_bool;
    case ID_var2MaxFlag:    return FieldType_bool;
    case ID_var2Min:        return FieldType_double;
    case ID_var2Max:        return FieldType_double;
    case ID_var2Scaling:    return FieldType_enum;
    case ID_var2SkewFactor: return FieldType_double;
    case ID_var2NumSamples: return FieldType_int;
    case ID_numAxes:        return FieldType_enum;
    case ID_var3:           return FieldType_string;
    case ID_var3MinFlag:    return FieldType_bool;
    case ID_var3MaxFlag:    return FieldType_bool;
    case ID_var3Min:        return FieldType_double;
    case ID_var3Max:        return FieldType_double;
    case ID_var3Scaling:    return FieldType_enum;
    case ID_var3SkewFactor: return FieldType_double;
    case ID_var3NumSamples: return FieldType_int;
    case ID_scaleCube:      return FieldType_bool;
    case ID_densityType:    return FieldType_enum;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: PDFAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PDFAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_var1:           return "string";
    case ID_var1MinFlag:    return "bool";
    case ID_var1MaxFlag:    return "bool";
    case ID_var1Min:        return "double";
    case ID_var1Max:        return "double";
    case ID_var1Scaling:    return "enum";
    case ID_var1SkewFactor: return "double";
    case ID_var1NumSamples: return "int";
    case ID_var2:           return "string";
    case ID_var2MinFlag:    return "bool";
    case ID_var2MaxFlag:    return "bool";
    case ID_var2Min:        return "double";
    case ID_var2Max:        return "double";
    case ID_var2Scaling:    return "enum";
    case ID_var2SkewFactor: return "double";
    case ID_var2NumSamples: return "int";
    case ID_numAxes:        return "enum";
    case ID_var3:           return "string";
    case ID_var3MinFlag:    return "bool";
    case ID_var3MaxFlag:    return "bool";
    case ID_var3Min:        return "double";
    case ID_var3Max:        return "double";
    case ID_var3Scaling:    return "enum";
    case ID_var3SkewFactor: return "double";
    case ID_var3NumSamples: return "int";
    case ID_scaleCube:      return "bool";
    case ID_densityType:    return "enum";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PDFAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PDFAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const PDFAttributes &obj = *((const PDFAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_var1:
        {  // new scope
        retval = (var1 == obj.var1);
        }
        break;
    case ID_var1MinFlag:
        {  // new scope
        retval = (var1MinFlag == obj.var1MinFlag);
        }
        break;
    case ID_var1MaxFlag:
        {  // new scope
        retval = (var1MaxFlag == obj.var1MaxFlag);
        }
        break;
    case ID_var1Min:
        {  // new scope
        retval = (var1Min == obj.var1Min);
        }
        break;
    case ID_var1Max:
        {  // new scope
        retval = (var1Max == obj.var1Max);
        }
        break;
    case ID_var1Scaling:
        {  // new scope
        retval = (var1Scaling == obj.var1Scaling);
        }
        break;
    case ID_var1SkewFactor:
        {  // new scope
        retval = (var1SkewFactor == obj.var1SkewFactor);
        }
        break;
    case ID_var1NumSamples:
        {  // new scope
        retval = (var1NumSamples == obj.var1NumSamples);
        }
        break;
    case ID_var2:
        {  // new scope
        retval = (var2 == obj.var2);
        }
        break;
    case ID_var2MinFlag:
        {  // new scope
        retval = (var2MinFlag == obj.var2MinFlag);
        }
        break;
    case ID_var2MaxFlag:
        {  // new scope
        retval = (var2MaxFlag == obj.var2MaxFlag);
        }
        break;
    case ID_var2Min:
        {  // new scope
        retval = (var2Min == obj.var2Min);
        }
        break;
    case ID_var2Max:
        {  // new scope
        retval = (var2Max == obj.var2Max);
        }
        break;
    case ID_var2Scaling:
        {  // new scope
        retval = (var2Scaling == obj.var2Scaling);
        }
        break;
    case ID_var2SkewFactor:
        {  // new scope
        retval = (var2SkewFactor == obj.var2SkewFactor);
        }
        break;
    case ID_var2NumSamples:
        {  // new scope
        retval = (var2NumSamples == obj.var2NumSamples);
        }
        break;
    case ID_numAxes:
        {  // new scope
        retval = (numAxes == obj.numAxes);
        }
        break;
    case ID_var3:
        {  // new scope
        retval = (var3 == obj.var3);
        }
        break;
    case ID_var3MinFlag:
        {  // new scope
        retval = (var3MinFlag == obj.var3MinFlag);
        }
        break;
    case ID_var3MaxFlag:
        {  // new scope
        retval = (var3MaxFlag == obj.var3MaxFlag);
        }
        break;
    case ID_var3Min:
        {  // new scope
        retval = (var3Min == obj.var3Min);
        }
        break;
    case ID_var3Max:
        {  // new scope
        retval = (var3Max == obj.var3Max);
        }
        break;
    case ID_var3Scaling:
        {  // new scope
        retval = (var3Scaling == obj.var3Scaling);
        }
        break;
    case ID_var3SkewFactor:
        {  // new scope
        retval = (var3SkewFactor == obj.var3SkewFactor);
        }
        break;
    case ID_var3NumSamples:
        {  // new scope
        retval = (var3NumSamples == obj.var3NumSamples);
        }
        break;
    case ID_scaleCube:
        {  // new scope
        retval = (scaleCube == obj.scaleCube);
        }
        break;
    case ID_densityType:
        {  // new scope
        retval = (densityType == obj.densityType);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

