/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyMetricThresholdAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyMetricThresholdAttributes
//
// Purpose: 
//   This class contains attributes for the MetricThreshold operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 13:23:36 PST 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a MetricThresholdAttributes.
//
struct MetricThresholdAttributesObject
{
    PyObject_HEAD
    MetricThresholdAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewMetricThresholdAttributes(int);

std::string
PyMetricThresholdAttributes_ToString(const MetricThresholdAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    const char *preset_names = "None, Aspect_Ratio, Aspect_Gamma, Skew, Taper, "
        "Volume, Stretch, Diagonal, Dimension, "
        "Oddy, Condition, Jacobian, Scaled_Jacobian, "
        "Shear, Shape, Relative_Size, Shape_and_Size, "
        "Area, Warpage, Smallest_Angle, Largest_Angle";
    switch (atts->GetPreset())
    {
      case MetricThresholdAttributes::None:
          SNPRINTF(tmpStr, 1000, "%spreset = %sNone  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Aspect_Ratio:
          SNPRINTF(tmpStr, 1000, "%spreset = %sAspect_Ratio  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Aspect_Gamma:
          SNPRINTF(tmpStr, 1000, "%spreset = %sAspect_Gamma  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Skew:
          SNPRINTF(tmpStr, 1000, "%spreset = %sSkew  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Taper:
          SNPRINTF(tmpStr, 1000, "%spreset = %sTaper  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Volume:
          SNPRINTF(tmpStr, 1000, "%spreset = %sVolume  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Stretch:
          SNPRINTF(tmpStr, 1000, "%spreset = %sStretch  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Diagonal:
          SNPRINTF(tmpStr, 1000, "%spreset = %sDiagonal  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Dimension:
          SNPRINTF(tmpStr, 1000, "%spreset = %sDimension  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Oddy:
          SNPRINTF(tmpStr, 1000, "%spreset = %sOddy  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Condition:
          SNPRINTF(tmpStr, 1000, "%spreset = %sCondition  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Jacobian:
          SNPRINTF(tmpStr, 1000, "%spreset = %sJacobian  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Scaled_Jacobian:
          SNPRINTF(tmpStr, 1000, "%spreset = %sScaled_Jacobian  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Shear:
          SNPRINTF(tmpStr, 1000, "%spreset = %sShear  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Shape:
          SNPRINTF(tmpStr, 1000, "%spreset = %sShape  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Relative_Size:
          SNPRINTF(tmpStr, 1000, "%spreset = %sRelative_Size  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Shape_and_Size:
          SNPRINTF(tmpStr, 1000, "%spreset = %sShape_and_Size  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Area:
          SNPRINTF(tmpStr, 1000, "%spreset = %sArea  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Warpage:
          SNPRINTF(tmpStr, 1000, "%spreset = %sWarpage  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Smallest_Angle:
          SNPRINTF(tmpStr, 1000, "%spreset = %sSmallest_Angle  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      case MetricThresholdAttributes::Largest_Angle:
          SNPRINTF(tmpStr, 1000, "%spreset = %sLargest_Angle  # %s\n", prefix, prefix, preset_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetHexahedron())
        SNPRINTF(tmpStr, 1000, "%sHexahedron = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sHexahedron = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%shex_lower = %g\n", prefix, atts->GetHex_lower());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%shex_upper = %g\n", prefix, atts->GetHex_upper());
    str += tmpStr;
    if(atts->GetTetrahedron())
        SNPRINTF(tmpStr, 1000, "%sTetrahedron = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sTetrahedron = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stet_lower = %g\n", prefix, atts->GetTet_lower());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stet_upper = %g\n", prefix, atts->GetTet_upper());
    str += tmpStr;
    if(atts->GetWedge())
        SNPRINTF(tmpStr, 1000, "%sWedge = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sWedge = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%swed_lower = %g\n", prefix, atts->GetWed_lower());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%swed_upper = %g\n", prefix, atts->GetWed_upper());
    str += tmpStr;
    if(atts->GetPyramid())
        SNPRINTF(tmpStr, 1000, "%sPyramid = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sPyramid = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spyr_lower = %g\n", prefix, atts->GetPyr_lower());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spyr_upper = %g\n", prefix, atts->GetPyr_upper());
    str += tmpStr;
    if(atts->GetTriangle())
        SNPRINTF(tmpStr, 1000, "%sTriangle = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sTriangle = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stri_lower = %g\n", prefix, atts->GetTri_lower());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stri_upper = %g\n", prefix, atts->GetTri_upper());
    str += tmpStr;
    if(atts->GetQuad())
        SNPRINTF(tmpStr, 1000, "%sQuad = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sQuad = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%squad_lower = %g\n", prefix, atts->GetQuad_lower());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%squad_upper = %g\n", prefix, atts->GetQuad_upper());
    str += tmpStr;
    return str;
}

static PyObject *
MetricThresholdAttributes_Notify(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetPreset(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the preset in the object.
    if(ival >= 0 && ival < 21)
        obj->data->SetPreset(MetricThresholdAttributes::Preset(ival));
    else
    {
        fprintf(stderr, "An invalid preset value was given. "
                        "Valid values are in the range of [0,20]. "
                        "You can also use the following names: "
                        "None, Aspect_Ratio, Aspect_Gamma, Skew, Taper, "
                        "Volume, Stretch, Diagonal, Dimension, "
                        "Oddy, Condition, Jacobian, Scaled_Jacobian, "
                        "Shear, Shape, Relative_Size, Shape_and_Size, "
                        "Area, Warpage, Smallest_Angle, Largest_Angle"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetPreset(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPreset()));
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetHexahedron(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Hexahedron in the object.
    obj->data->SetHexahedron(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetHexahedron(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetHexahedron()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetHex_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the hex_lower in the object.
    obj->data->SetHex_lower(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetHex_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHex_lower());
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetHex_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the hex_upper in the object.
    obj->data->SetHex_upper(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetHex_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHex_upper());
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetTetrahedron(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Tetrahedron in the object.
    obj->data->SetTetrahedron(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetTetrahedron(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTetrahedron()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetTet_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tet_lower in the object.
    obj->data->SetTet_lower(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetTet_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTet_lower());
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetTet_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tet_upper in the object.
    obj->data->SetTet_upper(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetTet_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTet_upper());
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetWedge(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Wedge in the object.
    obj->data->SetWedge(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetWedge(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWedge()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetWed_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the wed_lower in the object.
    obj->data->SetWed_lower(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetWed_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetWed_lower());
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetWed_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the wed_upper in the object.
    obj->data->SetWed_upper(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetWed_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetWed_upper());
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetPyramid(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Pyramid in the object.
    obj->data->SetPyramid(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetPyramid(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPyramid()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetPyr_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pyr_lower in the object.
    obj->data->SetPyr_lower(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetPyr_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPyr_lower());
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetPyr_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pyr_upper in the object.
    obj->data->SetPyr_upper(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetPyr_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPyr_upper());
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetTriangle(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Triangle in the object.
    obj->data->SetTriangle(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetTriangle(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTriangle()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetTri_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tri_lower in the object.
    obj->data->SetTri_lower(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetTri_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTri_lower());
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetTri_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tri_upper in the object.
    obj->data->SetTri_upper(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetTri_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTri_upper());
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetQuad(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Quad in the object.
    obj->data->SetQuad(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetQuad(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetQuad()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetQuad_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the quad_lower in the object.
    obj->data->SetQuad_lower(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetQuad_lower(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetQuad_lower());
    return retval;
}

/*static*/ PyObject *
MetricThresholdAttributes_SetQuad_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the quad_upper in the object.
    obj->data->SetQuad_upper(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MetricThresholdAttributes_GetQuad_upper(PyObject *self, PyObject *args)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetQuad_upper());
    return retval;
}



static struct PyMethodDef MetricThresholdAttributes_methods[] = {
    {"Notify", MetricThresholdAttributes_Notify, METH_VARARGS},
    {"SetPreset", MetricThresholdAttributes_SetPreset, METH_VARARGS},
    {"GetPreset", MetricThresholdAttributes_GetPreset, METH_VARARGS},
    {"SetHexahedron", MetricThresholdAttributes_SetHexahedron, METH_VARARGS},
    {"GetHexahedron", MetricThresholdAttributes_GetHexahedron, METH_VARARGS},
    {"SetHex_lower", MetricThresholdAttributes_SetHex_lower, METH_VARARGS},
    {"GetHex_lower", MetricThresholdAttributes_GetHex_lower, METH_VARARGS},
    {"SetHex_upper", MetricThresholdAttributes_SetHex_upper, METH_VARARGS},
    {"GetHex_upper", MetricThresholdAttributes_GetHex_upper, METH_VARARGS},
    {"SetTetrahedron", MetricThresholdAttributes_SetTetrahedron, METH_VARARGS},
    {"GetTetrahedron", MetricThresholdAttributes_GetTetrahedron, METH_VARARGS},
    {"SetTet_lower", MetricThresholdAttributes_SetTet_lower, METH_VARARGS},
    {"GetTet_lower", MetricThresholdAttributes_GetTet_lower, METH_VARARGS},
    {"SetTet_upper", MetricThresholdAttributes_SetTet_upper, METH_VARARGS},
    {"GetTet_upper", MetricThresholdAttributes_GetTet_upper, METH_VARARGS},
    {"SetWedge", MetricThresholdAttributes_SetWedge, METH_VARARGS},
    {"GetWedge", MetricThresholdAttributes_GetWedge, METH_VARARGS},
    {"SetWed_lower", MetricThresholdAttributes_SetWed_lower, METH_VARARGS},
    {"GetWed_lower", MetricThresholdAttributes_GetWed_lower, METH_VARARGS},
    {"SetWed_upper", MetricThresholdAttributes_SetWed_upper, METH_VARARGS},
    {"GetWed_upper", MetricThresholdAttributes_GetWed_upper, METH_VARARGS},
    {"SetPyramid", MetricThresholdAttributes_SetPyramid, METH_VARARGS},
    {"GetPyramid", MetricThresholdAttributes_GetPyramid, METH_VARARGS},
    {"SetPyr_lower", MetricThresholdAttributes_SetPyr_lower, METH_VARARGS},
    {"GetPyr_lower", MetricThresholdAttributes_GetPyr_lower, METH_VARARGS},
    {"SetPyr_upper", MetricThresholdAttributes_SetPyr_upper, METH_VARARGS},
    {"GetPyr_upper", MetricThresholdAttributes_GetPyr_upper, METH_VARARGS},
    {"SetTriangle", MetricThresholdAttributes_SetTriangle, METH_VARARGS},
    {"GetTriangle", MetricThresholdAttributes_GetTriangle, METH_VARARGS},
    {"SetTri_lower", MetricThresholdAttributes_SetTri_lower, METH_VARARGS},
    {"GetTri_lower", MetricThresholdAttributes_GetTri_lower, METH_VARARGS},
    {"SetTri_upper", MetricThresholdAttributes_SetTri_upper, METH_VARARGS},
    {"GetTri_upper", MetricThresholdAttributes_GetTri_upper, METH_VARARGS},
    {"SetQuad", MetricThresholdAttributes_SetQuad, METH_VARARGS},
    {"GetQuad", MetricThresholdAttributes_GetQuad, METH_VARARGS},
    {"SetQuad_lower", MetricThresholdAttributes_SetQuad_lower, METH_VARARGS},
    {"GetQuad_lower", MetricThresholdAttributes_GetQuad_lower, METH_VARARGS},
    {"SetQuad_upper", MetricThresholdAttributes_SetQuad_upper, METH_VARARGS},
    {"GetQuad_upper", MetricThresholdAttributes_GetQuad_upper, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
MetricThresholdAttributes_dealloc(PyObject *v)
{
   MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
MetricThresholdAttributes_compare(PyObject *v, PyObject *w)
{
    MetricThresholdAttributes *a = ((MetricThresholdAttributesObject *)v)->data;
    MetricThresholdAttributes *b = ((MetricThresholdAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
MetricThresholdAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "preset") == 0)
        return MetricThresholdAttributes_GetPreset(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::None));
    if(strcmp(name, "Aspect_Ratio") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Aspect_Ratio));
    if(strcmp(name, "Aspect_Gamma") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Aspect_Gamma));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Skew));
    if(strcmp(name, "Taper") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Taper));
    if(strcmp(name, "Volume") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Volume));
    if(strcmp(name, "Stretch") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Stretch));
    if(strcmp(name, "Diagonal") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Diagonal));
    if(strcmp(name, "Dimension") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Dimension));
    if(strcmp(name, "Oddy") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Oddy));
    if(strcmp(name, "Condition") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Condition));
    if(strcmp(name, "Jacobian") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Jacobian));
    if(strcmp(name, "Scaled_Jacobian") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Scaled_Jacobian));
    if(strcmp(name, "Shear") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Shear));
    if(strcmp(name, "Shape") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Shape));
    if(strcmp(name, "Relative_Size") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Relative_Size));
    if(strcmp(name, "Shape_and_Size") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Shape_and_Size));
    if(strcmp(name, "Area") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Area));
    if(strcmp(name, "Warpage") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Warpage));
    if(strcmp(name, "Smallest_Angle") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Smallest_Angle));
    if(strcmp(name, "Largest_Angle") == 0)
        return PyInt_FromLong(long(MetricThresholdAttributes::Largest_Angle));

    if(strcmp(name, "Hexahedron") == 0)
        return MetricThresholdAttributes_GetHexahedron(self, NULL);
    if(strcmp(name, "hex_lower") == 0)
        return MetricThresholdAttributes_GetHex_lower(self, NULL);
    if(strcmp(name, "hex_upper") == 0)
        return MetricThresholdAttributes_GetHex_upper(self, NULL);
    if(strcmp(name, "Tetrahedron") == 0)
        return MetricThresholdAttributes_GetTetrahedron(self, NULL);
    if(strcmp(name, "tet_lower") == 0)
        return MetricThresholdAttributes_GetTet_lower(self, NULL);
    if(strcmp(name, "tet_upper") == 0)
        return MetricThresholdAttributes_GetTet_upper(self, NULL);
    if(strcmp(name, "Wedge") == 0)
        return MetricThresholdAttributes_GetWedge(self, NULL);
    if(strcmp(name, "wed_lower") == 0)
        return MetricThresholdAttributes_GetWed_lower(self, NULL);
    if(strcmp(name, "wed_upper") == 0)
        return MetricThresholdAttributes_GetWed_upper(self, NULL);
    if(strcmp(name, "Pyramid") == 0)
        return MetricThresholdAttributes_GetPyramid(self, NULL);
    if(strcmp(name, "pyr_lower") == 0)
        return MetricThresholdAttributes_GetPyr_lower(self, NULL);
    if(strcmp(name, "pyr_upper") == 0)
        return MetricThresholdAttributes_GetPyr_upper(self, NULL);
    if(strcmp(name, "Triangle") == 0)
        return MetricThresholdAttributes_GetTriangle(self, NULL);
    if(strcmp(name, "tri_lower") == 0)
        return MetricThresholdAttributes_GetTri_lower(self, NULL);
    if(strcmp(name, "tri_upper") == 0)
        return MetricThresholdAttributes_GetTri_upper(self, NULL);
    if(strcmp(name, "Quad") == 0)
        return MetricThresholdAttributes_GetQuad(self, NULL);
    if(strcmp(name, "quad_lower") == 0)
        return MetricThresholdAttributes_GetQuad_lower(self, NULL);
    if(strcmp(name, "quad_upper") == 0)
        return MetricThresholdAttributes_GetQuad_upper(self, NULL);

    return Py_FindMethod(MetricThresholdAttributes_methods, self, name);
}

static int
MetricThresholdAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "preset") == 0)
        obj = MetricThresholdAttributes_SetPreset(self, tuple);
    else if(strcmp(name, "Hexahedron") == 0)
        obj = MetricThresholdAttributes_SetHexahedron(self, tuple);
    else if(strcmp(name, "hex_lower") == 0)
        obj = MetricThresholdAttributes_SetHex_lower(self, tuple);
    else if(strcmp(name, "hex_upper") == 0)
        obj = MetricThresholdAttributes_SetHex_upper(self, tuple);
    else if(strcmp(name, "Tetrahedron") == 0)
        obj = MetricThresholdAttributes_SetTetrahedron(self, tuple);
    else if(strcmp(name, "tet_lower") == 0)
        obj = MetricThresholdAttributes_SetTet_lower(self, tuple);
    else if(strcmp(name, "tet_upper") == 0)
        obj = MetricThresholdAttributes_SetTet_upper(self, tuple);
    else if(strcmp(name, "Wedge") == 0)
        obj = MetricThresholdAttributes_SetWedge(self, tuple);
    else if(strcmp(name, "wed_lower") == 0)
        obj = MetricThresholdAttributes_SetWed_lower(self, tuple);
    else if(strcmp(name, "wed_upper") == 0)
        obj = MetricThresholdAttributes_SetWed_upper(self, tuple);
    else if(strcmp(name, "Pyramid") == 0)
        obj = MetricThresholdAttributes_SetPyramid(self, tuple);
    else if(strcmp(name, "pyr_lower") == 0)
        obj = MetricThresholdAttributes_SetPyr_lower(self, tuple);
    else if(strcmp(name, "pyr_upper") == 0)
        obj = MetricThresholdAttributes_SetPyr_upper(self, tuple);
    else if(strcmp(name, "Triangle") == 0)
        obj = MetricThresholdAttributes_SetTriangle(self, tuple);
    else if(strcmp(name, "tri_lower") == 0)
        obj = MetricThresholdAttributes_SetTri_lower(self, tuple);
    else if(strcmp(name, "tri_upper") == 0)
        obj = MetricThresholdAttributes_SetTri_upper(self, tuple);
    else if(strcmp(name, "Quad") == 0)
        obj = MetricThresholdAttributes_SetQuad(self, tuple);
    else if(strcmp(name, "quad_lower") == 0)
        obj = MetricThresholdAttributes_SetQuad_lower(self, tuple);
    else if(strcmp(name, "quad_upper") == 0)
        obj = MetricThresholdAttributes_SetQuad_upper(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
MetricThresholdAttributes_print(PyObject *v, FILE *fp, int flags)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)v;
    fprintf(fp, "%s", PyMetricThresholdAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
MetricThresholdAttributes_str(PyObject *v)
{
    MetricThresholdAttributesObject *obj = (MetricThresholdAttributesObject *)v;
    return PyString_FromString(PyMetricThresholdAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *MetricThresholdAttributes_Purpose = "This class contains attributes for the MetricThreshold operator.";
#else
static char *MetricThresholdAttributes_Purpose = "This class contains attributes for the MetricThreshold operator.";
#endif

//
// The type description structure
//
static PyTypeObject MetricThresholdAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "MetricThresholdAttributes",                    // tp_name
    sizeof(MetricThresholdAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)MetricThresholdAttributes_dealloc,  // tp_dealloc
    (printfunc)MetricThresholdAttributes_print,     // tp_print
    (getattrfunc)MetricThresholdAttributes_getattr, // tp_getattr
    (setattrfunc)MetricThresholdAttributes_setattr, // tp_setattr
    (cmpfunc)MetricThresholdAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)MetricThresholdAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    MetricThresholdAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static MetricThresholdAttributes *defaultAtts = 0;
static MetricThresholdAttributes *currentAtts = 0;

static PyObject *
NewMetricThresholdAttributes(int useCurrent)
{
    MetricThresholdAttributesObject *newObject;
    newObject = PyObject_NEW(MetricThresholdAttributesObject, &MetricThresholdAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new MetricThresholdAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new MetricThresholdAttributes(*defaultAtts);
    else
        newObject->data = new MetricThresholdAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapMetricThresholdAttributes(const MetricThresholdAttributes *attr)
{
    MetricThresholdAttributesObject *newObject;
    newObject = PyObject_NEW(MetricThresholdAttributesObject, &MetricThresholdAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (MetricThresholdAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
MetricThresholdAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewMetricThresholdAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef MetricThresholdAttributesMethods[] = {
    {"MetricThresholdAttributes", MetricThresholdAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *MetricThresholdAttributesObserver = 0;

std::string
PyMetricThresholdAttributes_GetLogString()
{
    std::string s("MetricThresholdAtts = MetricThresholdAttributes()\n");
    if(currentAtts != 0)
        s += PyMetricThresholdAttributes_ToString(currentAtts, "MetricThresholdAtts.");
    return s;
}

static void
PyMetricThresholdAttributes_CallLogRoutine(Subject *subj, void *data)
{
    MetricThresholdAttributes *atts = (MetricThresholdAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("MetricThresholdAtts = MetricThresholdAttributes()\n");
        s += PyMetricThresholdAttributes_ToString(currentAtts, "MetricThresholdAtts.");
        cb(s);
    }
}

void
PyMetricThresholdAttributes_StartUp(MetricThresholdAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyMetricThresholdAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(MetricThresholdAttributesObserver == 0)
    {
        MetricThresholdAttributesObserver = new ObserverToCallback(subj,
            PyMetricThresholdAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyMetricThresholdAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete MetricThresholdAttributesObserver;
    MetricThresholdAttributesObserver = 0;
}

PyMethodDef *
PyMetricThresholdAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return MetricThresholdAttributesMethods;
}

bool
PyMetricThresholdAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &MetricThresholdAttributesType);
}

MetricThresholdAttributes *
PyMetricThresholdAttributes_FromPyObject(PyObject *obj)
{
    MetricThresholdAttributesObject *obj2 = (MetricThresholdAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyMetricThresholdAttributes_New()
{
    return NewMetricThresholdAttributes(0);
}

PyObject *
PyMetricThresholdAttributes_Wrap(const MetricThresholdAttributes *attr)
{
    return WrapMetricThresholdAttributes(attr);
}

void
PyMetricThresholdAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    MetricThresholdAttributesObject *obj2 = (MetricThresholdAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyMetricThresholdAttributes_SetDefaults(const MetricThresholdAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new MetricThresholdAttributes(*atts);
}

