/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <MergeOperatorAttributes.h>
#include <DataNode.h>

// Type map format string
const char *MergeOperatorAttributes::TypeMapFormatString = "bd";

// ****************************************************************************
// Method: MergeOperatorAttributes::MergeOperatorAttributes
//
// Purpose: 
//   Constructor for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MergeOperatorAttributes::MergeOperatorAttributes() : 
    AttributeSubject(MergeOperatorAttributes::TypeMapFormatString)
{
    parallelMerge = false;
    tolerance = 0;
}

// ****************************************************************************
// Method: MergeOperatorAttributes::MergeOperatorAttributes
//
// Purpose: 
//   Copy constructor for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MergeOperatorAttributes::MergeOperatorAttributes(const MergeOperatorAttributes &obj) : 
    AttributeSubject(MergeOperatorAttributes::TypeMapFormatString)
{
    parallelMerge = obj.parallelMerge;
    tolerance = obj.tolerance;

    SelectAll();
}

// ****************************************************************************
// Method: MergeOperatorAttributes::~MergeOperatorAttributes
//
// Purpose: 
//   Destructor for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MergeOperatorAttributes::~MergeOperatorAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: MergeOperatorAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MergeOperatorAttributes& 
MergeOperatorAttributes::operator = (const MergeOperatorAttributes &obj)
{
    if (this == &obj) return *this;
    parallelMerge = obj.parallelMerge;
    tolerance = obj.tolerance;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: MergeOperatorAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MergeOperatorAttributes::operator == (const MergeOperatorAttributes &obj) const
{
    // Create the return value
    return ((parallelMerge == obj.parallelMerge) &&
            (tolerance == obj.tolerance));
}

// ****************************************************************************
// Method: MergeOperatorAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MergeOperatorAttributes::operator != (const MergeOperatorAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: MergeOperatorAttributes::TypeName
//
// Purpose: 
//   Type name method for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
MergeOperatorAttributes::TypeName() const
{
    return "MergeOperatorAttributes";
}

// ****************************************************************************
// Method: MergeOperatorAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MergeOperatorAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const MergeOperatorAttributes *tmp = (const MergeOperatorAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: MergeOperatorAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MergeOperatorAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new MergeOperatorAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: MergeOperatorAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the MergeOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MergeOperatorAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new MergeOperatorAttributes(*this);
    else
        retval = new MergeOperatorAttributes;

    return retval;
}

// ****************************************************************************
// Method: MergeOperatorAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
MergeOperatorAttributes::SelectAll()
{
    Select(ID_parallelMerge, (void *)&parallelMerge);
    Select(ID_tolerance,     (void *)&tolerance);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MergeOperatorAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MergeOperatorAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    MergeOperatorAttributes defaultObject;
    bool addToParent = false;
    // Create a node for MergeOperatorAttributes.
    DataNode *node = new DataNode("MergeOperatorAttributes");

    if(completeSave || !FieldsEqual(ID_parallelMerge, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("parallelMerge", parallelMerge));
    }

    if(completeSave || !FieldsEqual(ID_tolerance, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tolerance", tolerance));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: MergeOperatorAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
MergeOperatorAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("MergeOperatorAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("parallelMerge")) != 0)
        SetParallelMerge(node->AsBool());
    if((node = searchNode->GetNode("tolerance")) != 0)
        SetTolerance(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
MergeOperatorAttributes::SetParallelMerge(bool parallelMerge_)
{
    parallelMerge = parallelMerge_;
    Select(ID_parallelMerge, (void *)&parallelMerge);
}

void
MergeOperatorAttributes::SetTolerance(double tolerance_)
{
    tolerance = tolerance_;
    Select(ID_tolerance, (void *)&tolerance);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
MergeOperatorAttributes::GetParallelMerge() const
{
    return parallelMerge;
}

double
MergeOperatorAttributes::GetTolerance() const
{
    return tolerance;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MergeOperatorAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
MergeOperatorAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_parallelMerge: return "parallelMerge";
    case ID_tolerance:     return "tolerance";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MergeOperatorAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
MergeOperatorAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_parallelMerge: return FieldType_bool;
    case ID_tolerance:     return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: MergeOperatorAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
MergeOperatorAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_parallelMerge: return "bool";
    case ID_tolerance:     return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MergeOperatorAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MergeOperatorAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const MergeOperatorAttributes &obj = *((const MergeOperatorAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_parallelMerge:
        {  // new scope
        retval = (parallelMerge == obj.parallelMerge);
        }
        break;
    case ID_tolerance:
        {  // new scope
        retval = (tolerance == obj.tolerance);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

