/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyLineSurfaceAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyLineSurfaceAttributes
//
// Purpose: 
//   Attributes for the LineSurface operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 13:23:37 PST 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a LineSurfaceAttributes.
//
struct LineSurfaceAttributesObject
{
    PyObject_HEAD
    LineSurfaceAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewLineSurfaceAttributes(int);

std::string
PyLineSurfaceAttributes_ToString(const LineSurfaceAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%sstartTime = %d\n", prefix, atts->GetStartTime());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendTime = %d\n", prefix, atts->GetEndTime());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstride = %d\n", prefix, atts->GetStride());
    str += tmpStr;
    {   const double *point1 = atts->GetPoint1();
        SNPRINTF(tmpStr, 1000, "%spoint1 = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", point1[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *point2 = atts->GetPoint2();
        SNPRINTF(tmpStr, 1000, "%spoint2 = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", point2[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
LineSurfaceAttributes_Notify(PyObject *self, PyObject *args)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSurfaceAttributes_SetStartTime(PyObject *self, PyObject *args)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the startTime in the object.
    obj->data->SetStartTime((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSurfaceAttributes_GetStartTime(PyObject *self, PyObject *args)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStartTime()));
    return retval;
}

/*static*/ PyObject *
LineSurfaceAttributes_SetEndTime(PyObject *self, PyObject *args)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the endTime in the object.
    obj->data->SetEndTime((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSurfaceAttributes_GetEndTime(PyObject *self, PyObject *args)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEndTime()));
    return retval;
}

/*static*/ PyObject *
LineSurfaceAttributes_SetStride(PyObject *self, PyObject *args)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stride in the object.
    obj->data->SetStride((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSurfaceAttributes_GetStride(PyObject *self, PyObject *args)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStride()));
    return retval;
}

/*static*/ PyObject *
LineSurfaceAttributes_SetPoint1(PyObject *self, PyObject *args)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)self;

    double *dvals = obj->data->GetPoint1();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the point1 in the object as modified.
    obj->data->SelectPoint1();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSurfaceAttributes_GetPoint1(PyObject *self, PyObject *args)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the point1.
    PyObject *retval = PyTuple_New(3);
    const double *point1 = obj->data->GetPoint1();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(point1[i]));
    return retval;
}

/*static*/ PyObject *
LineSurfaceAttributes_SetPoint2(PyObject *self, PyObject *args)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)self;

    double *dvals = obj->data->GetPoint2();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the point2 in the object as modified.
    obj->data->SelectPoint2();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSurfaceAttributes_GetPoint2(PyObject *self, PyObject *args)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the point2.
    PyObject *retval = PyTuple_New(3);
    const double *point2 = obj->data->GetPoint2();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(point2[i]));
    return retval;
}



static struct PyMethodDef LineSurfaceAttributes_methods[] = {
    {"Notify", LineSurfaceAttributes_Notify, METH_VARARGS},
    {"SetStartTime", LineSurfaceAttributes_SetStartTime, METH_VARARGS},
    {"GetStartTime", LineSurfaceAttributes_GetStartTime, METH_VARARGS},
    {"SetEndTime", LineSurfaceAttributes_SetEndTime, METH_VARARGS},
    {"GetEndTime", LineSurfaceAttributes_GetEndTime, METH_VARARGS},
    {"SetStride", LineSurfaceAttributes_SetStride, METH_VARARGS},
    {"GetStride", LineSurfaceAttributes_GetStride, METH_VARARGS},
    {"SetPoint1", LineSurfaceAttributes_SetPoint1, METH_VARARGS},
    {"GetPoint1", LineSurfaceAttributes_GetPoint1, METH_VARARGS},
    {"SetPoint2", LineSurfaceAttributes_SetPoint2, METH_VARARGS},
    {"GetPoint2", LineSurfaceAttributes_GetPoint2, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LineSurfaceAttributes_dealloc(PyObject *v)
{
   LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
LineSurfaceAttributes_compare(PyObject *v, PyObject *w)
{
    LineSurfaceAttributes *a = ((LineSurfaceAttributesObject *)v)->data;
    LineSurfaceAttributes *b = ((LineSurfaceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
LineSurfaceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "startTime") == 0)
        return LineSurfaceAttributes_GetStartTime(self, NULL);
    if(strcmp(name, "endTime") == 0)
        return LineSurfaceAttributes_GetEndTime(self, NULL);
    if(strcmp(name, "stride") == 0)
        return LineSurfaceAttributes_GetStride(self, NULL);
    if(strcmp(name, "point1") == 0)
        return LineSurfaceAttributes_GetPoint1(self, NULL);
    if(strcmp(name, "point2") == 0)
        return LineSurfaceAttributes_GetPoint2(self, NULL);

    return Py_FindMethod(LineSurfaceAttributes_methods, self, name);
}

static int
LineSurfaceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "startTime") == 0)
        obj = LineSurfaceAttributes_SetStartTime(self, tuple);
    else if(strcmp(name, "endTime") == 0)
        obj = LineSurfaceAttributes_SetEndTime(self, tuple);
    else if(strcmp(name, "stride") == 0)
        obj = LineSurfaceAttributes_SetStride(self, tuple);
    else if(strcmp(name, "point1") == 0)
        obj = LineSurfaceAttributes_SetPoint1(self, tuple);
    else if(strcmp(name, "point2") == 0)
        obj = LineSurfaceAttributes_SetPoint2(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
LineSurfaceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)v;
    fprintf(fp, "%s", PyLineSurfaceAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
LineSurfaceAttributes_str(PyObject *v)
{
    LineSurfaceAttributesObject *obj = (LineSurfaceAttributesObject *)v;
    return PyString_FromString(PyLineSurfaceAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *LineSurfaceAttributes_Purpose = "Attributes for the LineSurface operator";
#else
static char *LineSurfaceAttributes_Purpose = "Attributes for the LineSurface operator";
#endif

//
// The type description structure
//
static PyTypeObject LineSurfaceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LineSurfaceAttributes",                    // tp_name
    sizeof(LineSurfaceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LineSurfaceAttributes_dealloc,  // tp_dealloc
    (printfunc)LineSurfaceAttributes_print,     // tp_print
    (getattrfunc)LineSurfaceAttributes_getattr, // tp_getattr
    (setattrfunc)LineSurfaceAttributes_setattr, // tp_setattr
    (cmpfunc)LineSurfaceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LineSurfaceAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LineSurfaceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static LineSurfaceAttributes *defaultAtts = 0;
static LineSurfaceAttributes *currentAtts = 0;

static PyObject *
NewLineSurfaceAttributes(int useCurrent)
{
    LineSurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(LineSurfaceAttributesObject, &LineSurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new LineSurfaceAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new LineSurfaceAttributes(*defaultAtts);
    else
        newObject->data = new LineSurfaceAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapLineSurfaceAttributes(const LineSurfaceAttributes *attr)
{
    LineSurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(LineSurfaceAttributesObject, &LineSurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (LineSurfaceAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
LineSurfaceAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewLineSurfaceAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef LineSurfaceAttributesMethods[] = {
    {"LineSurfaceAttributes", LineSurfaceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *LineSurfaceAttributesObserver = 0;

std::string
PyLineSurfaceAttributes_GetLogString()
{
    std::string s("LineSurfaceAtts = LineSurfaceAttributes()\n");
    if(currentAtts != 0)
        s += PyLineSurfaceAttributes_ToString(currentAtts, "LineSurfaceAtts.");
    return s;
}

static void
PyLineSurfaceAttributes_CallLogRoutine(Subject *subj, void *data)
{
    LineSurfaceAttributes *atts = (LineSurfaceAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("LineSurfaceAtts = LineSurfaceAttributes()\n");
        s += PyLineSurfaceAttributes_ToString(currentAtts, "LineSurfaceAtts.");
        cb(s);
    }
}

void
PyLineSurfaceAttributes_StartUp(LineSurfaceAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyLineSurfaceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(LineSurfaceAttributesObserver == 0)
    {
        LineSurfaceAttributesObserver = new ObserverToCallback(subj,
            PyLineSurfaceAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyLineSurfaceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete LineSurfaceAttributesObserver;
    LineSurfaceAttributesObserver = 0;
}

PyMethodDef *
PyLineSurfaceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return LineSurfaceAttributesMethods;
}

bool
PyLineSurfaceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &LineSurfaceAttributesType);
}

LineSurfaceAttributes *
PyLineSurfaceAttributes_FromPyObject(PyObject *obj)
{
    LineSurfaceAttributesObject *obj2 = (LineSurfaceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyLineSurfaceAttributes_New()
{
    return NewLineSurfaceAttributes(0);
}

PyObject *
PyLineSurfaceAttributes_Wrap(const LineSurfaceAttributes *attr)
{
    return WrapLineSurfaceAttributes(attr);
}

void
PyLineSurfaceAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    LineSurfaceAttributesObject *obj2 = (LineSurfaceAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyLineSurfaceAttributes_SetDefaults(const LineSurfaceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new LineSurfaceAttributes(*atts);
}

