/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtInverseGhostZoneFilter.C
// ************************************************************************* //

#include <avtInverseGhostZoneFilter.h>

#include <vtkCellData.h>
#include <vtkDataSet.h>
#include <vtkUnsignedCharArray.h>


// ****************************************************************************
//  Method: avtInverseGhostZoneFilter constructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:27:11 PDT 2004
//
// ****************************************************************************

avtInverseGhostZoneFilter::avtInverseGhostZoneFilter()
{
}


// ****************************************************************************
//  Method: avtInverseGhostZoneFilter destructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:27:11 PDT 2004
//
//  Modifications:
//
// ****************************************************************************

avtInverseGhostZoneFilter::~avtInverseGhostZoneFilter()
{
}


// ****************************************************************************
//  Method:  avtInverseGhostZoneFilter::Create
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:27:11 PDT 2004
//
// ****************************************************************************

avtFilter *
avtInverseGhostZoneFilter::Create()
{
    return new avtInverseGhostZoneFilter();
}


// ****************************************************************************
//  Method:      avtInverseGhostZoneFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:27:11 PDT 2004
//
// ****************************************************************************

void
avtInverseGhostZoneFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const InverseGhostZoneAttributes*)a;
}


// ****************************************************************************
//  Method: avtInverseGhostZoneFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtInverseGhostZoneFilter with the given
//      parameters would result in an equivalent avtInverseGhostZoneFilter.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:27:11 PDT 2004
//
// ****************************************************************************

bool
avtInverseGhostZoneFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(InverseGhostZoneAttributes*)a);
}


// ****************************************************************************
//  Method: avtInverseGhostZoneFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the InverseGhostZone filter.
//
//  Arguments:
//      in_ds      The input dataset.
//      <unused>   The domain number.
//      <unused>   The label.
//
//  Returns:       The output dataset.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jan 8 09:27:11 PDT 2004
//
//  Modifications:
//
//    Hank Childs, Fri Aug 27 15:25:22 PDT 2004
//    Rename ghost data array.
//
//    Hank Childs, Thu Mar  2 11:08:43 PST 2006
//    Remove avtRealDims ['6724].
//
//    Hank Childs, Wed Jun 14 13:44:49 PDT 2006
//    Fix memory leak.
//
//    Sean Ahern, Thu Aug 21 14:25:51 EDT 2008
//    When there are no ghost zones, the inverse is a NULL mesh.
//
// ****************************************************************************

vtkDataSet *
avtInverseGhostZoneFilter::ExecuteData(vtkDataSet *in_ds, int, std::string)
{
    vtkDataArray *gz = in_ds->GetCellData()->GetArray("avtGhostZones");
    if (gz == NULL)
    {
        return NULL;
    }

    //
    // Make an output that is identical to the input.
    //
    vtkDataSet *out_ds = (vtkDataSet *) in_ds->NewInstance();
    out_ds->ShallowCopy(in_ds);

    if (atts.GetShowType() == InverseGhostZoneAttributes::GhostZonesOnly)
    {
        int nCells = in_ds->GetNumberOfCells();
        unsigned char *gza = ((vtkUnsignedCharArray*)gz)->GetPointer(0);
        vtkUnsignedCharArray *ghostZones = vtkUnsignedCharArray::New();
        ghostZones->SetName("avtGhostZones");
        ghostZones->Allocate(nCells);
        for (int i = 0 ; i < nCells ; i++)
        {
            unsigned char ghost = (gza[i] == 0 ? 1 : 0);
            ghostZones->InsertNextValue(ghost);
        }
        out_ds->GetCellData()->RemoveArray("avtGhostZones");
        if (out_ds->GetFieldData()->GetArray("avtRealDims") != NULL)
            out_ds->GetFieldData()->RemoveArray("avtRealDims");
        out_ds->GetCellData()->AddArray(ghostZones);
        ghostZones->Delete();
    }
    else
    {
        out_ds->GetCellData()->RemoveArray("avtGhostZones");
    }

    ManageMemory(out_ds);
    out_ds->Delete();
    return out_ds;
}


// ****************************************************************************
//  Method: avtInverseGhostZoneFilter::UpdateDataObjectInfo
//
//  Purpose:
//      Indicates the zones no longer correspond to the original problem.
//      (They of course do, but information about the zones, like facelists,
//       no longer apply).
//
//  Programmer: Hank Childs
//  Creation:   January 8, 2004
//
// ****************************************************************************

void
avtInverseGhostZoneFilter::UpdateDataObjectInfo(void)
{
    GetOutput()->GetInfo().GetValidity().InvalidateZones();
}


