/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisInverseGhostZoneWindow.h"

#include <InverseGhostZoneAttributes.h>
#include <ViewerProxy.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QSpinBox>
#include <QButtonGroup>
#include <QRadioButton>
#include <QvisColorTableButton.h>
#include <QvisOpacitySlider.h>
#include <QvisColorButton.h>
#include <QvisLineStyleWidget.h>
#include <QvisLineWidthWidget.h>
#include <QvisVariableButton.h>

#include <stdio.h>
#include <string>

using std::string;

// ****************************************************************************
// Method: QvisInverseGhostZoneWindow::QvisInverseGhostZoneWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisInverseGhostZoneWindow::QvisInverseGhostZoneWindow(const int type,
                         InverseGhostZoneAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisInverseGhostZoneWindow::~QvisInverseGhostZoneWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisInverseGhostZoneWindow::~QvisInverseGhostZoneWindow()
{
}


// ****************************************************************************
// Method: QvisInverseGhostZoneWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, Mon Aug 18 20:03:17 PDT 2008
//   Qt4 Port - Autogen and changed radio button labels.
//
// ****************************************************************************

void
QvisInverseGhostZoneWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    showTypeLabel = new QLabel(tr("Zones to Display:"), central);
    mainLayout->addWidget(showTypeLabel,0,0);
    showType = new QButtonGroup(central);
    QWidget *showTypeWidget = new QWidget(central);
    QHBoxLayout *showTypeLayout = new QHBoxLayout(showTypeWidget);
    showTypeLayout->setMargin(0);
    showTypeLayout->setSpacing(10);
    QRadioButton *showTypeShowTypeGhostZonesOnly = new QRadioButton(tr("Ghost zones only"), showTypeWidget);
    showType->addButton(showTypeShowTypeGhostZonesOnly,0);
    showTypeLayout->addWidget(showTypeShowTypeGhostZonesOnly);
    QRadioButton *showTypeShowTypeGhostZonesAndRealZones = new QRadioButton(tr("Ghost zones and real zones"), showTypeWidget);
    showType->addButton(showTypeShowTypeGhostZonesAndRealZones,1);
    showTypeLayout->addWidget(showTypeShowTypeGhostZonesAndRealZones);
    connect(showType, SIGNAL(buttonClicked(int)),
            this, SLOT(showTypeChanged(int)));
    mainLayout->addWidget(showTypeWidget, 0,1);

}


// ****************************************************************************
// Method: QvisInverseGhostZoneWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisInverseGhostZoneWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case InverseGhostZoneAttributes::ID_showType:
            showType->blockSignals(true);
            if(showType->button((int)atts->GetShowType()) != 0)
                showType->button((int)atts->GetShowType())->setChecked(true);
            showType->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisInverseGhostZoneWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisInverseGhostZoneWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisInverseGhostZoneWindow::showTypeChanged(int val)
{
    if(val != atts->GetShowType())
    {
        atts->SetShowType(InverseGhostZoneAttributes::ShowType(val));
        SetUpdate(false);
        Apply();
    }
}


