/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyIndexSelectAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyIndexSelectAttributes
//
// Purpose: 
//   This class contains attributes for the index select operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a IndexSelectAttributes.
//
struct IndexSelectAttributesObject
{
    PyObject_HEAD
    IndexSelectAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewIndexSelectAttributes(int);

std::string
PyIndexSelectAttributes_ToString(const IndexSelectAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    const char *dim_names = "OneD, TwoD, ThreeD";
    switch (atts->GetDim())
    {
      case IndexSelectAttributes::OneD:
          SNPRINTF(tmpStr, 1000, "%sdim = %sOneD  # %s\n", prefix, prefix, dim_names);
          str += tmpStr;
          break;
      case IndexSelectAttributes::TwoD:
          SNPRINTF(tmpStr, 1000, "%sdim = %sTwoD  # %s\n", prefix, prefix, dim_names);
          str += tmpStr;
          break;
      case IndexSelectAttributes::ThreeD:
          SNPRINTF(tmpStr, 1000, "%sdim = %sThreeD  # %s\n", prefix, prefix, dim_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sxMin = %d\n", prefix, atts->GetXMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sxMax = %d\n", prefix, atts->GetXMax());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sxIncr = %d\n", prefix, atts->GetXIncr());
    str += tmpStr;
    if(atts->GetXWrap())
        SNPRINTF(tmpStr, 1000, "%sxWrap = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sxWrap = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%syMin = %d\n", prefix, atts->GetYMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%syMax = %d\n", prefix, atts->GetYMax());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%syIncr = %d\n", prefix, atts->GetYIncr());
    str += tmpStr;
    if(atts->GetYWrap())
        SNPRINTF(tmpStr, 1000, "%syWrap = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%syWrap = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%szMin = %d\n", prefix, atts->GetZMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%szMax = %d\n", prefix, atts->GetZMax());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%szIncr = %d\n", prefix, atts->GetZIncr());
    str += tmpStr;
    if(atts->GetZWrap())
        SNPRINTF(tmpStr, 1000, "%szWrap = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%szWrap = 0\n", prefix);
    str += tmpStr;
    if(atts->GetUseWholeCollection())
        SNPRINTF(tmpStr, 1000, "%suseWholeCollection = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseWholeCollection = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scategoryName = \"%s\"\n", prefix, atts->GetCategoryName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssubsetName = \"%s\"\n", prefix, atts->GetSubsetName().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
IndexSelectAttributes_Notify(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_SetDim(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dim in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDim(IndexSelectAttributes::Dimension(ival));
    else
    {
        fprintf(stderr, "An invalid dim value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "OneD, TwoD, ThreeD.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetDim(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDim()));
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetXMin(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xMin in the object.
    obj->data->SetXMin((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetXMin(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXMin()));
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetXMax(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xMax in the object.
    obj->data->SetXMax((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetXMax(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXMax()));
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetXIncr(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xIncr in the object.
    obj->data->SetXIncr((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetXIncr(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXIncr()));
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetXWrap(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xWrap in the object.
    obj->data->SetXWrap(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetXWrap(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetXWrap()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetYMin(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yMin in the object.
    obj->data->SetYMin((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetYMin(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYMin()));
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetYMax(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yMax in the object.
    obj->data->SetYMax((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetYMax(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYMax()));
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetYIncr(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yIncr in the object.
    obj->data->SetYIncr((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetYIncr(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYIncr()));
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetYWrap(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yWrap in the object.
    obj->data->SetYWrap(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetYWrap(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetYWrap()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetZMin(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zMin in the object.
    obj->data->SetZMin((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetZMin(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetZMin()));
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetZMax(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zMax in the object.
    obj->data->SetZMax((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetZMax(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetZMax()));
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetZIncr(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zIncr in the object.
    obj->data->SetZIncr((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetZIncr(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetZIncr()));
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetZWrap(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zWrap in the object.
    obj->data->SetZWrap(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetZWrap(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetZWrap()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetUseWholeCollection(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useWholeCollection in the object.
    obj->data->SetUseWholeCollection(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetUseWholeCollection(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseWholeCollection()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetCategoryName(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the categoryName in the object.
    obj->data->SetCategoryName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetCategoryName(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCategoryName().c_str());
    return retval;
}

/*static*/ PyObject *
IndexSelectAttributes_SetSubsetName(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the subsetName in the object.
    obj->data->SetSubsetName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IndexSelectAttributes_GetSubsetName(PyObject *self, PyObject *args)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSubsetName().c_str());
    return retval;
}



PyMethodDef PyIndexSelectAttributes_methods[INDEXSELECTATTRIBUTES_NMETH] = {
    {"Notify", IndexSelectAttributes_Notify, METH_VARARGS},
    {"SetDim", IndexSelectAttributes_SetDim, METH_VARARGS},
    {"GetDim", IndexSelectAttributes_GetDim, METH_VARARGS},
    {"SetXMin", IndexSelectAttributes_SetXMin, METH_VARARGS},
    {"GetXMin", IndexSelectAttributes_GetXMin, METH_VARARGS},
    {"SetXMax", IndexSelectAttributes_SetXMax, METH_VARARGS},
    {"GetXMax", IndexSelectAttributes_GetXMax, METH_VARARGS},
    {"SetXIncr", IndexSelectAttributes_SetXIncr, METH_VARARGS},
    {"GetXIncr", IndexSelectAttributes_GetXIncr, METH_VARARGS},
    {"SetXWrap", IndexSelectAttributes_SetXWrap, METH_VARARGS},
    {"GetXWrap", IndexSelectAttributes_GetXWrap, METH_VARARGS},
    {"SetYMin", IndexSelectAttributes_SetYMin, METH_VARARGS},
    {"GetYMin", IndexSelectAttributes_GetYMin, METH_VARARGS},
    {"SetYMax", IndexSelectAttributes_SetYMax, METH_VARARGS},
    {"GetYMax", IndexSelectAttributes_GetYMax, METH_VARARGS},
    {"SetYIncr", IndexSelectAttributes_SetYIncr, METH_VARARGS},
    {"GetYIncr", IndexSelectAttributes_GetYIncr, METH_VARARGS},
    {"SetYWrap", IndexSelectAttributes_SetYWrap, METH_VARARGS},
    {"GetYWrap", IndexSelectAttributes_GetYWrap, METH_VARARGS},
    {"SetZMin", IndexSelectAttributes_SetZMin, METH_VARARGS},
    {"GetZMin", IndexSelectAttributes_GetZMin, METH_VARARGS},
    {"SetZMax", IndexSelectAttributes_SetZMax, METH_VARARGS},
    {"GetZMax", IndexSelectAttributes_GetZMax, METH_VARARGS},
    {"SetZIncr", IndexSelectAttributes_SetZIncr, METH_VARARGS},
    {"GetZIncr", IndexSelectAttributes_GetZIncr, METH_VARARGS},
    {"SetZWrap", IndexSelectAttributes_SetZWrap, METH_VARARGS},
    {"GetZWrap", IndexSelectAttributes_GetZWrap, METH_VARARGS},
    {"SetUseWholeCollection", IndexSelectAttributes_SetUseWholeCollection, METH_VARARGS},
    {"GetUseWholeCollection", IndexSelectAttributes_GetUseWholeCollection, METH_VARARGS},
    {"SetCategoryName", IndexSelectAttributes_SetCategoryName, METH_VARARGS},
    {"GetCategoryName", IndexSelectAttributes_GetCategoryName, METH_VARARGS},
    {"SetSubsetName", IndexSelectAttributes_SetSubsetName, METH_VARARGS},
    {"GetSubsetName", IndexSelectAttributes_GetSubsetName, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
IndexSelectAttributes_dealloc(PyObject *v)
{
   IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
IndexSelectAttributes_compare(PyObject *v, PyObject *w)
{
    IndexSelectAttributes *a = ((IndexSelectAttributesObject *)v)->data;
    IndexSelectAttributes *b = ((IndexSelectAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyIndexSelectAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "dim") == 0)
        return IndexSelectAttributes_GetDim(self, NULL);
    if(strcmp(name, "OneD") == 0)
        return PyInt_FromLong(long(IndexSelectAttributes::OneD));
    if(strcmp(name, "TwoD") == 0)
        return PyInt_FromLong(long(IndexSelectAttributes::TwoD));
    if(strcmp(name, "ThreeD") == 0)
        return PyInt_FromLong(long(IndexSelectAttributes::ThreeD));

    if(strcmp(name, "xMin") == 0)
        return IndexSelectAttributes_GetXMin(self, NULL);
    if(strcmp(name, "xMax") == 0)
        return IndexSelectAttributes_GetXMax(self, NULL);
    if(strcmp(name, "xIncr") == 0)
        return IndexSelectAttributes_GetXIncr(self, NULL);
    if(strcmp(name, "xWrap") == 0)
        return IndexSelectAttributes_GetXWrap(self, NULL);
    if(strcmp(name, "yMin") == 0)
        return IndexSelectAttributes_GetYMin(self, NULL);
    if(strcmp(name, "yMax") == 0)
        return IndexSelectAttributes_GetYMax(self, NULL);
    if(strcmp(name, "yIncr") == 0)
        return IndexSelectAttributes_GetYIncr(self, NULL);
    if(strcmp(name, "yWrap") == 0)
        return IndexSelectAttributes_GetYWrap(self, NULL);
    if(strcmp(name, "zMin") == 0)
        return IndexSelectAttributes_GetZMin(self, NULL);
    if(strcmp(name, "zMax") == 0)
        return IndexSelectAttributes_GetZMax(self, NULL);
    if(strcmp(name, "zIncr") == 0)
        return IndexSelectAttributes_GetZIncr(self, NULL);
    if(strcmp(name, "zWrap") == 0)
        return IndexSelectAttributes_GetZWrap(self, NULL);
    if(strcmp(name, "useWholeCollection") == 0)
        return IndexSelectAttributes_GetUseWholeCollection(self, NULL);
    if(strcmp(name, "categoryName") == 0)
        return IndexSelectAttributes_GetCategoryName(self, NULL);
    if(strcmp(name, "subsetName") == 0)
        return IndexSelectAttributes_GetSubsetName(self, NULL);

    return Py_FindMethod(PyIndexSelectAttributes_methods, self, name);
}

int
PyIndexSelectAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "dim") == 0)
        obj = IndexSelectAttributes_SetDim(self, tuple);
    else if(strcmp(name, "xMin") == 0)
        obj = IndexSelectAttributes_SetXMin(self, tuple);
    else if(strcmp(name, "xMax") == 0)
        obj = IndexSelectAttributes_SetXMax(self, tuple);
    else if(strcmp(name, "xIncr") == 0)
        obj = IndexSelectAttributes_SetXIncr(self, tuple);
    else if(strcmp(name, "xWrap") == 0)
        obj = IndexSelectAttributes_SetXWrap(self, tuple);
    else if(strcmp(name, "yMin") == 0)
        obj = IndexSelectAttributes_SetYMin(self, tuple);
    else if(strcmp(name, "yMax") == 0)
        obj = IndexSelectAttributes_SetYMax(self, tuple);
    else if(strcmp(name, "yIncr") == 0)
        obj = IndexSelectAttributes_SetYIncr(self, tuple);
    else if(strcmp(name, "yWrap") == 0)
        obj = IndexSelectAttributes_SetYWrap(self, tuple);
    else if(strcmp(name, "zMin") == 0)
        obj = IndexSelectAttributes_SetZMin(self, tuple);
    else if(strcmp(name, "zMax") == 0)
        obj = IndexSelectAttributes_SetZMax(self, tuple);
    else if(strcmp(name, "zIncr") == 0)
        obj = IndexSelectAttributes_SetZIncr(self, tuple);
    else if(strcmp(name, "zWrap") == 0)
        obj = IndexSelectAttributes_SetZWrap(self, tuple);
    else if(strcmp(name, "useWholeCollection") == 0)
        obj = IndexSelectAttributes_SetUseWholeCollection(self, tuple);
    else if(strcmp(name, "categoryName") == 0)
        obj = IndexSelectAttributes_SetCategoryName(self, tuple);
    else if(strcmp(name, "subsetName") == 0)
        obj = IndexSelectAttributes_SetSubsetName(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
IndexSelectAttributes_print(PyObject *v, FILE *fp, int flags)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)v;
    fprintf(fp, "%s", PyIndexSelectAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
IndexSelectAttributes_str(PyObject *v)
{
    IndexSelectAttributesObject *obj = (IndexSelectAttributesObject *)v;
    return PyString_FromString(PyIndexSelectAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *IndexSelectAttributes_Purpose = "This class contains attributes for the index select operator.";
#else
static char *IndexSelectAttributes_Purpose = "This class contains attributes for the index select operator.";
#endif

//
// The type description structure
//
static PyTypeObject IndexSelectAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "IndexSelectAttributes",                    // tp_name
    sizeof(IndexSelectAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)IndexSelectAttributes_dealloc,  // tp_dealloc
    (printfunc)IndexSelectAttributes_print,     // tp_print
    (getattrfunc)PyIndexSelectAttributes_getattr, // tp_getattr
    (setattrfunc)PyIndexSelectAttributes_setattr, // tp_setattr
    (cmpfunc)IndexSelectAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)IndexSelectAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    IndexSelectAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static IndexSelectAttributes *defaultAtts = 0;
static IndexSelectAttributes *currentAtts = 0;

static PyObject *
NewIndexSelectAttributes(int useCurrent)
{
    IndexSelectAttributesObject *newObject;
    newObject = PyObject_NEW(IndexSelectAttributesObject, &IndexSelectAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new IndexSelectAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new IndexSelectAttributes(*defaultAtts);
    else
        newObject->data = new IndexSelectAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapIndexSelectAttributes(const IndexSelectAttributes *attr)
{
    IndexSelectAttributesObject *newObject;
    newObject = PyObject_NEW(IndexSelectAttributesObject, &IndexSelectAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (IndexSelectAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
IndexSelectAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewIndexSelectAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef IndexSelectAttributesMethods[] = {
    {"IndexSelectAttributes", IndexSelectAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *IndexSelectAttributesObserver = 0;

std::string
PyIndexSelectAttributes_GetLogString()
{
    std::string s("IndexSelectAtts = IndexSelectAttributes()\n");
    if(currentAtts != 0)
        s += PyIndexSelectAttributes_ToString(currentAtts, "IndexSelectAtts.");
    return s;
}

static void
PyIndexSelectAttributes_CallLogRoutine(Subject *subj, void *data)
{
    IndexSelectAttributes *atts = (IndexSelectAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("IndexSelectAtts = IndexSelectAttributes()\n");
        s += PyIndexSelectAttributes_ToString(currentAtts, "IndexSelectAtts.");
        cb(s);
    }
}

void
PyIndexSelectAttributes_StartUp(IndexSelectAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyIndexSelectAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(IndexSelectAttributesObserver == 0)
    {
        IndexSelectAttributesObserver = new ObserverToCallback(subj,
            PyIndexSelectAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyIndexSelectAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete IndexSelectAttributesObserver;
    IndexSelectAttributesObserver = 0;
}

PyMethodDef *
PyIndexSelectAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return IndexSelectAttributesMethods;
}

bool
PyIndexSelectAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &IndexSelectAttributesType);
}

IndexSelectAttributes *
PyIndexSelectAttributes_FromPyObject(PyObject *obj)
{
    IndexSelectAttributesObject *obj2 = (IndexSelectAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyIndexSelectAttributes_New()
{
    return NewIndexSelectAttributes(0);
}

PyObject *
PyIndexSelectAttributes_Wrap(const IndexSelectAttributes *attr)
{
    return WrapIndexSelectAttributes(attr);
}

void
PyIndexSelectAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    IndexSelectAttributesObject *obj2 = (IndexSelectAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyIndexSelectAttributes_SetDefaults(const IndexSelectAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new IndexSelectAttributes(*atts);
}

