/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyExternalSurfaceAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyExternalSurfaceAttributes
//
// Purpose: 
//   This class contains attributes for the external surface operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 13:23:37 PST 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a ExternalSurfaceAttributes.
//
struct ExternalSurfaceAttributesObject
{
    PyObject_HEAD
    ExternalSurfaceAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewExternalSurfaceAttributes(int);

std::string
PyExternalSurfaceAttributes_ToString(const ExternalSurfaceAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    if(atts->GetRemoveGhosts())
        SNPRINTF(tmpStr, 1000, "%sremoveGhosts = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sremoveGhosts = 0\n", prefix);
    str += tmpStr;
    if(atts->GetEdgesIn2D())
        SNPRINTF(tmpStr, 1000, "%sedgesIn2D = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sedgesIn2D = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
ExternalSurfaceAttributes_Notify(PyObject *self, PyObject *args)
{
    ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExternalSurfaceAttributes_SetRemoveGhosts(PyObject *self, PyObject *args)
{
    ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the removeGhosts in the object.
    obj->data->SetRemoveGhosts(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExternalSurfaceAttributes_GetRemoveGhosts(PyObject *self, PyObject *args)
{
    ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetRemoveGhosts()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ExternalSurfaceAttributes_SetEdgesIn2D(PyObject *self, PyObject *args)
{
    ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the edgesIn2D in the object.
    obj->data->SetEdgesIn2D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExternalSurfaceAttributes_GetEdgesIn2D(PyObject *self, PyObject *args)
{
    ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetEdgesIn2D()?1L:0L);
    return retval;
}



static struct PyMethodDef ExternalSurfaceAttributes_methods[] = {
    {"Notify", ExternalSurfaceAttributes_Notify, METH_VARARGS},
    {"SetRemoveGhosts", ExternalSurfaceAttributes_SetRemoveGhosts, METH_VARARGS},
    {"GetRemoveGhosts", ExternalSurfaceAttributes_GetRemoveGhosts, METH_VARARGS},
    {"SetEdgesIn2D", ExternalSurfaceAttributes_SetEdgesIn2D, METH_VARARGS},
    {"GetEdgesIn2D", ExternalSurfaceAttributes_GetEdgesIn2D, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ExternalSurfaceAttributes_dealloc(PyObject *v)
{
   ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ExternalSurfaceAttributes_compare(PyObject *v, PyObject *w)
{
    ExternalSurfaceAttributes *a = ((ExternalSurfaceAttributesObject *)v)->data;
    ExternalSurfaceAttributes *b = ((ExternalSurfaceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
ExternalSurfaceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "removeGhosts") == 0)
        return ExternalSurfaceAttributes_GetRemoveGhosts(self, NULL);
    if(strcmp(name, "edgesIn2D") == 0)
        return ExternalSurfaceAttributes_GetEdgesIn2D(self, NULL);

    return Py_FindMethod(ExternalSurfaceAttributes_methods, self, name);
}

static int
ExternalSurfaceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "removeGhosts") == 0)
        obj = ExternalSurfaceAttributes_SetRemoveGhosts(self, tuple);
    else if(strcmp(name, "edgesIn2D") == 0)
        obj = ExternalSurfaceAttributes_SetEdgesIn2D(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
ExternalSurfaceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)v;
    fprintf(fp, "%s", PyExternalSurfaceAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ExternalSurfaceAttributes_str(PyObject *v)
{
    ExternalSurfaceAttributesObject *obj = (ExternalSurfaceAttributesObject *)v;
    return PyString_FromString(PyExternalSurfaceAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ExternalSurfaceAttributes_Purpose = "This class contains attributes for the external surface operator.";
#else
static char *ExternalSurfaceAttributes_Purpose = "This class contains attributes for the external surface operator.";
#endif

//
// The type description structure
//
static PyTypeObject ExternalSurfaceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ExternalSurfaceAttributes",                    // tp_name
    sizeof(ExternalSurfaceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ExternalSurfaceAttributes_dealloc,  // tp_dealloc
    (printfunc)ExternalSurfaceAttributes_print,     // tp_print
    (getattrfunc)ExternalSurfaceAttributes_getattr, // tp_getattr
    (setattrfunc)ExternalSurfaceAttributes_setattr, // tp_setattr
    (cmpfunc)ExternalSurfaceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ExternalSurfaceAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ExternalSurfaceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ExternalSurfaceAttributes *defaultAtts = 0;
static ExternalSurfaceAttributes *currentAtts = 0;

static PyObject *
NewExternalSurfaceAttributes(int useCurrent)
{
    ExternalSurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(ExternalSurfaceAttributesObject, &ExternalSurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ExternalSurfaceAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ExternalSurfaceAttributes(*defaultAtts);
    else
        newObject->data = new ExternalSurfaceAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapExternalSurfaceAttributes(const ExternalSurfaceAttributes *attr)
{
    ExternalSurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(ExternalSurfaceAttributesObject, &ExternalSurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ExternalSurfaceAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ExternalSurfaceAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewExternalSurfaceAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ExternalSurfaceAttributesMethods[] = {
    {"ExternalSurfaceAttributes", ExternalSurfaceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ExternalSurfaceAttributesObserver = 0;

std::string
PyExternalSurfaceAttributes_GetLogString()
{
    std::string s("ExternalSurfaceAtts = ExternalSurfaceAttributes()\n");
    if(currentAtts != 0)
        s += PyExternalSurfaceAttributes_ToString(currentAtts, "ExternalSurfaceAtts.");
    return s;
}

static void
PyExternalSurfaceAttributes_CallLogRoutine(Subject *subj, void *data)
{
    ExternalSurfaceAttributes *atts = (ExternalSurfaceAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ExternalSurfaceAtts = ExternalSurfaceAttributes()\n");
        s += PyExternalSurfaceAttributes_ToString(currentAtts, "ExternalSurfaceAtts.");
        cb(s);
    }
}

void
PyExternalSurfaceAttributes_StartUp(ExternalSurfaceAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyExternalSurfaceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ExternalSurfaceAttributesObserver == 0)
    {
        ExternalSurfaceAttributesObserver = new ObserverToCallback(subj,
            PyExternalSurfaceAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyExternalSurfaceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ExternalSurfaceAttributesObserver;
    ExternalSurfaceAttributesObserver = 0;
}

PyMethodDef *
PyExternalSurfaceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ExternalSurfaceAttributesMethods;
}

bool
PyExternalSurfaceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ExternalSurfaceAttributesType);
}

ExternalSurfaceAttributes *
PyExternalSurfaceAttributes_FromPyObject(PyObject *obj)
{
    ExternalSurfaceAttributesObject *obj2 = (ExternalSurfaceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyExternalSurfaceAttributes_New()
{
    return NewExternalSurfaceAttributes(0);
}

PyObject *
PyExternalSurfaceAttributes_Wrap(const ExternalSurfaceAttributes *attr)
{
    return WrapExternalSurfaceAttributes(attr);
}

void
PyExternalSurfaceAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ExternalSurfaceAttributesObject *obj2 = (ExternalSurfaceAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyExternalSurfaceAttributes_SetDefaults(const ExternalSurfaceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ExternalSurfaceAttributes(*atts);
}

