/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtElevateFilter.C
// ************************************************************************* //

#include <avtElevateFilter.h>

#include <avtSurfaceFilter.h>
#include <SurfaceFilterAttributes.h>

// ****************************************************************************
//  Method: avtElevateFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
// ****************************************************************************

avtElevateFilter::avtElevateFilter()
{
    surface_filter = NULL;
}


// ****************************************************************************
//  Method: avtElevateFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
//  Modifications:
//
// ****************************************************************************

avtElevateFilter::~avtElevateFilter()
{
    if (surface_filter != NULL)
    {
        delete surface_filter;
        surface_filter = NULL;
    }
}


// ****************************************************************************
//  Method:  avtElevateFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
// ****************************************************************************

avtFilter *
avtElevateFilter::Create()
{
    return new avtElevateFilter();
}


// ****************************************************************************
//  Method:      avtElevateFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
//  Modifications:
//      Sean Ahern, Tue Aug 14 11:47:14 EDT 2007
//      Added the "zero" flag.
//
// ****************************************************************************

void
avtElevateFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const ElevateAttributes*)a;
 
    if (surface_filter != NULL)
    {
        delete surface_filter;
    }

    SurfaceFilterAttributes sf_atts;
    sf_atts.SetLimitsMode(
                   (SurfaceFilterAttributes::LimitsMode) atts.GetLimitsMode());
    sf_atts.SetMinFlag(atts.GetMinFlag());
    sf_atts.SetMaxFlag(atts.GetMaxFlag());
    sf_atts.SetZeroFlag(atts.GetZeroFlag());
    sf_atts.SetScaling((SurfaceFilterAttributes::Scaling) atts.GetScaling());
    sf_atts.SetSkewFactor(atts.GetSkewFactor());
    sf_atts.SetMin(atts.GetMin());
    sf_atts.SetMax(atts.GetMax());
    sf_atts.SetVariable(atts.GetVariable());
    sf_atts.SetUseXYLimits(atts.GetUseXYLimits());
    sf_atts.SetGenerateNodalOutput(false);

    surface_filter = new avtSurfaceFilter(&sf_atts);
}


// ****************************************************************************
//  Method: avtElevateFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtElevateFilter with the given
//      parameters would result in an equivalent avtElevateFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
// ****************************************************************************

bool
avtElevateFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(ElevateAttributes*)a);
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   January 29, 2005
//
// ****************************************************************************

avtFilter *
avtElevateFilter::GetFacadedFilter(void)
{
    return surface_filter;
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Tom Fogal
//  Creation:   June 23, 2009
//
// ****************************************************************************

const avtFilter *
avtElevateFilter::GetFacadedFilter(void) const
{
    return surface_filter;
}
