/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisElevateWindow.h"

#include <ElevateAttributes.h>
#include <ViewerProxy.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QSpinBox>
#include <QButtonGroup>
#include <QRadioButton>
#include <QvisColorTableButton.h>
#include <QvisOpacitySlider.h>
#include <QvisColorButton.h>
#include <QvisLineStyleWidget.h>
#include <QvisLineWidthWidget.h>
#include <QvisVariableButton.h>

#include <stdio.h>
#include <string>

using std::string;

// ****************************************************************************
// Method: QvisElevateWindow::QvisElevateWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisElevateWindow::QvisElevateWindow(const int type,
                         ElevateAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisElevateWindow::~QvisElevateWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, Tue Aug 19 10:58:31 PDT 2008
//   Qt4 Port.
//
// ****************************************************************************

QvisElevateWindow::~QvisElevateWindow()
{
}


// ****************************************************************************
// Method: QvisElevateWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, Tue Aug 19 10:58:31 PDT 2008
//   Qt4 Port.
//
// ****************************************************************************

void
QvisElevateWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    useXYLimits = new QCheckBox(tr("Elevation height relative to XY limits?"), central);
    connect(useXYLimits, SIGNAL(toggled(bool)),
            this, SLOT(useXYLimitsChanged(bool)));
    mainLayout->addWidget(useXYLimits, 0,0,1,2);

    limitsModeLabel = new QLabel(tr("Limits Mode"), central);
    mainLayout->addWidget(limitsModeLabel,1,0);
    limitsModeWidget = new QWidget(central);
    limitsMode = new QButtonGroup(limitsModeWidget);
    QHBoxLayout *limitsModeLayout = new QHBoxLayout(limitsModeWidget);
    limitsModeLayout->setMargin(0);
    limitsModeLayout->setSpacing(10);
    QRadioButton *limitsModeLimitsModeOriginalData = new QRadioButton(tr("Original Data"), limitsModeWidget);
    limitsMode->addButton(limitsModeLimitsModeOriginalData,0);
    limitsModeLayout->addWidget(limitsModeLimitsModeOriginalData);
    QRadioButton *limitsModeLimitsModeCurrentPlot = new QRadioButton(tr("Current Plot"), limitsModeWidget);
    limitsMode->addButton(limitsModeLimitsModeCurrentPlot,1);
    limitsModeLayout->addWidget(limitsModeLimitsModeCurrentPlot);
    connect(limitsMode, SIGNAL(buttonClicked(int)),
            this, SLOT(limitsModeChanged(int)));
    mainLayout->addWidget(limitsModeWidget, 1,1);

    scalingLabel = new QLabel(tr("Scale"), central);
    mainLayout->addWidget(scalingLabel,2,0);
    scalingWidget = new QWidget(central);
    scaling = new QButtonGroup(scalingWidget);
    QHBoxLayout *scalingLayout = new QHBoxLayout(scalingWidget);
    scalingLayout->setMargin(0);
    scalingLayout->setSpacing(10);
    QRadioButton *scalingScalingLinear = new QRadioButton(tr("Linear"), scalingWidget);
    scaling->addButton(scalingScalingLinear,0);
    scalingLayout->addWidget(scalingScalingLinear);
    QRadioButton *scalingScalingLog = new QRadioButton(tr("Log"), scalingWidget);
    scaling->addButton(scalingScalingLog,1);
    scalingLayout->addWidget(scalingScalingLog);
    QRadioButton *scalingScalingSkew = new QRadioButton(tr("Skew"), scalingWidget);
    scaling->addButton(scalingScalingSkew,2);
    scalingLayout->addWidget(scalingScalingSkew);
    connect(scaling, SIGNAL(buttonClicked(int)),
            this, SLOT(scalingChanged(int)));
    mainLayout->addWidget(scalingWidget, 2,1);

    skewFactorLabel = new QLabel(tr("Skew factor"), central);
    mainLayout->addWidget(skewFactorLabel,3,0);
    skewFactor = new QLineEdit(central);
    connect(skewFactor, SIGNAL(returnPressed()),
            this, SLOT(skewFactorProcessText()));
    mainLayout->addWidget(skewFactor, 3,1);

    minFlag = new QCheckBox(tr("Use min"), central);
    connect(minFlag, SIGNAL(toggled(bool)),
            this, SLOT(minFlagChanged(bool)));
    mainLayout->addWidget(minFlag, 4,0);

    minLabel = new QLabel(tr("Min"), central);
    mainLayout->addWidget(minLabel,5,0);
    min = new QLineEdit(central);
    connect(min, SIGNAL(returnPressed()),
            this, SLOT(minProcessText()));
    mainLayout->addWidget(min, 5,1);

    maxFlag = new QCheckBox(tr("Use max"), central);
    connect(maxFlag, SIGNAL(toggled(bool)),
            this, SLOT(maxFlagChanged(bool)));
    mainLayout->addWidget(maxFlag, 6,0);

    maxLabel = new QLabel(tr("Max"), central);
    mainLayout->addWidget(maxLabel,7,0);
    max = new QLineEdit(central);
    connect(max, SIGNAL(returnPressed()),
            this, SLOT(maxProcessText()));
    mainLayout->addWidget(max, 7,1);

    zeroFlag = new QCheckBox(tr("Elevate with zero height?"), central);
    connect(zeroFlag, SIGNAL(toggled(bool)),
            this, SLOT(zeroFlagChanged(bool)));
    mainLayout->addWidget(zeroFlag, 8,0,1,2);

    variableLabel = new QLabel(tr("Elevate by Variable"), central);
    mainLayout->addWidget(variableLabel,9,0);
    int variableMask = QvisVariableButton::Scalars;
    variable = new QvisVariableButton(true, true, true, variableMask, central);
    variable->setDefaultVariable("default");
    connect(variable, SIGNAL(activated(const QString&)),
            this, SLOT(variableChanged(const QString&)));
    mainLayout->addWidget(variable, 9,1);

}


// ****************************************************************************
// Method: QvisElevateWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, Tue Aug 19 10:58:31 PDT 2008
//   Qt4 Port.
//
// ****************************************************************************

void
QvisElevateWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case ElevateAttributes::ID_useXYLimits:
            if (atts->GetUseXYLimits() == true)
            {
                limitsModeWidget->setEnabled(true);
                if(limitsModeLabel)
                    limitsModeLabel->setEnabled(true);
            }
            else
            {
                limitsModeWidget->setEnabled(false);
                if(limitsModeLabel)
                    limitsModeLabel->setEnabled(false);
            }
            if (atts->GetUseXYLimits() == true)
            {
                scalingWidget->setEnabled(true);
                if(scalingLabel)
                    scalingLabel->setEnabled(true);
            }
            else
            {
                scalingWidget->setEnabled(false);
                if(scalingLabel)
                    scalingLabel->setEnabled(false);
            }
            if (atts->GetUseXYLimits() == true)
            {
                minFlag->setEnabled(true);
            }
            else
            {
                minFlag->setEnabled(false);
            }
            if (atts->GetUseXYLimits() == true)
            {
                maxFlag->setEnabled(true);
            }
            else
            {
                maxFlag->setEnabled(false);
            }
            useXYLimits->blockSignals(true);
            useXYLimits->setChecked(atts->GetUseXYLimits());
            useXYLimits->blockSignals(false);
            break;
          case ElevateAttributes::ID_limitsMode:
            limitsMode->blockSignals(true);
            if(limitsMode->button((int)atts->GetLimitsMode()) != 0)
                limitsMode->button((int)atts->GetLimitsMode())->setChecked(true);
            limitsMode->blockSignals(false);
            break;
          case ElevateAttributes::ID_scaling:
            if (atts->GetScaling() == ElevateAttributes::Skew)
            {
                skewFactor->setEnabled(true);
                if(skewFactorLabel)
                    skewFactorLabel->setEnabled(true);
            }
            else
            {
                skewFactor->setEnabled(false);
                if(skewFactorLabel)
                    skewFactorLabel->setEnabled(false);
            }
            scaling->blockSignals(true);
            if(scaling->button((int)atts->GetScaling()) != 0)
                scaling->button((int)atts->GetScaling())->setChecked(true);
            scaling->blockSignals(false);
            break;
          case ElevateAttributes::ID_skewFactor:
            skewFactor->setText(DoubleToQString(atts->GetSkewFactor()));
            break;
          case ElevateAttributes::ID_minFlag:
            if (atts->GetMinFlag() == true)
            {
                min->setEnabled(true);
                if(minLabel)
                    minLabel->setEnabled(true);
            }
            else
            {
                min->setEnabled(false);
                if(minLabel)
                    minLabel->setEnabled(false);
            }
            minFlag->blockSignals(true);
            minFlag->setChecked(atts->GetMinFlag());
            minFlag->blockSignals(false);
            break;
          case ElevateAttributes::ID_min:
            min->setText(DoubleToQString(atts->GetMin()));
            break;
          case ElevateAttributes::ID_maxFlag:
            if (atts->GetMaxFlag() == true)
            {
                max->setEnabled(true);
                if(maxLabel)
                    maxLabel->setEnabled(true);
            }
            else
            {
                max->setEnabled(false);
                if(maxLabel)
                    maxLabel->setEnabled(false);
            }
            maxFlag->blockSignals(true);
            maxFlag->setChecked(atts->GetMaxFlag());
            maxFlag->blockSignals(false);
            break;
          case ElevateAttributes::ID_max:
            max->setText(DoubleToQString(atts->GetMax()));
            break;
          case ElevateAttributes::ID_zeroFlag:
            if (atts->GetZeroFlag() == false)
            {
                variable->setEnabled(true);
                if(variableLabel)
                    variableLabel->setEnabled(true);
            }
            else
            {
                variable->setEnabled(false);
                if(variableLabel)
                    variableLabel->setEnabled(false);
            }
            zeroFlag->blockSignals(true);
            zeroFlag->setChecked(atts->GetZeroFlag());
            zeroFlag->blockSignals(false);
            break;
          case ElevateAttributes::ID_variable:
            variable->blockSignals(true);
            variable->setText(QString(atts->GetVariable().c_str()));
            variable->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisElevateWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisElevateWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do skewFactor
    if(which_widget == ElevateAttributes::ID_skewFactor || doAll)
    {
        double val;
        if(LineEditGetDouble(skewFactor, val))
            atts->SetSkewFactor(val);
        else
        {
            ResettingError(tr("Skew factor"),
                DoubleToQString(atts->GetSkewFactor()));
            atts->SetSkewFactor(atts->GetSkewFactor());
        }
    }

    // Do min
    if(which_widget == ElevateAttributes::ID_min || doAll)
    {
        double val;
        if(LineEditGetDouble(min, val))
            atts->SetMin(val);
        else
        {
            ResettingError(tr("Min"),
                DoubleToQString(atts->GetMin()));
            atts->SetMin(atts->GetMin());
        }
    }

    // Do max
    if(which_widget == ElevateAttributes::ID_max || doAll)
    {
        double val;
        if(LineEditGetDouble(max, val))
            atts->SetMax(val);
        else
        {
            ResettingError(tr("Max"),
                DoubleToQString(atts->GetMax()));
            atts->SetMax(atts->GetMax());
        }
    }

}


//
// Qt Slot functions
//


void
QvisElevateWindow::useXYLimitsChanged(bool val)
{
    atts->SetUseXYLimits(val);
    Apply();
}


void
QvisElevateWindow::limitsModeChanged(int val)
{
    if(val != atts->GetLimitsMode())
    {
        atts->SetLimitsMode(ElevateAttributes::LimitsMode(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisElevateWindow::scalingChanged(int val)
{
    if(val != atts->GetScaling())
    {
        atts->SetScaling(ElevateAttributes::Scaling(val));
        Apply();
    }
}


void
QvisElevateWindow::skewFactorProcessText()
{
    GetCurrentValues(ElevateAttributes::ID_skewFactor);
    Apply();
}


void
QvisElevateWindow::minFlagChanged(bool val)
{
    atts->SetMinFlag(val);
    Apply();
}


void
QvisElevateWindow::minProcessText()
{
    GetCurrentValues(ElevateAttributes::ID_min);
    Apply();
}


void
QvisElevateWindow::maxFlagChanged(bool val)
{
    atts->SetMaxFlag(val);
    Apply();
}


void
QvisElevateWindow::maxProcessText()
{
    GetCurrentValues(ElevateAttributes::ID_max);
    Apply();
}


void
QvisElevateWindow::zeroFlagChanged(bool val)
{
    atts->SetZeroFlag(val);
    Apply();
}


void
QvisElevateWindow::variableChanged(const QString &varName)
{
    atts->SetVariable(varName.toStdString());
    SetUpdate(false);
    Apply();
}


