/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ElevateAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ElevateAttributes::Scaling
//

static const char *Scaling_strings[] = {
"Linear", "Log", "Skew"
};

std::string
ElevateAttributes::Scaling_ToString(ElevateAttributes::Scaling t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Scaling_strings[index];
}

std::string
ElevateAttributes::Scaling_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Scaling_strings[index];
}

bool
ElevateAttributes::Scaling_FromString(const std::string &s, ElevateAttributes::Scaling &val)
{
    val = ElevateAttributes::Linear;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Scaling_strings[i])
        {
            val = (Scaling)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for ElevateAttributes::LimitsMode
//

static const char *LimitsMode_strings[] = {
"OriginalData", "CurrentPlot"};

std::string
ElevateAttributes::LimitsMode_ToString(ElevateAttributes::LimitsMode t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return LimitsMode_strings[index];
}

std::string
ElevateAttributes::LimitsMode_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return LimitsMode_strings[index];
}

bool
ElevateAttributes::LimitsMode_FromString(const std::string &s, ElevateAttributes::LimitsMode &val)
{
    val = ElevateAttributes::OriginalData;
    for(int i = 0; i < 2; ++i)
    {
        if(s == LimitsMode_strings[i])
        {
            val = (LimitsMode)i;
            return true;
        }
    }
    return false;
}

// Type map format string
const char *ElevateAttributes::TypeMapFormatString = "biidbdbdbs";

// ****************************************************************************
// Method: ElevateAttributes::ElevateAttributes
//
// Purpose: 
//   Constructor for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ElevateAttributes::ElevateAttributes() : 
    AttributeSubject(ElevateAttributes::TypeMapFormatString),
    variable("default")
{
    useXYLimits = false;
    limitsMode = OriginalData;
    scaling = Linear;
    skewFactor = 1;
    minFlag = false;
    min = 0;
    maxFlag = false;
    max = 1;
    zeroFlag = false;
}

// ****************************************************************************
// Method: ElevateAttributes::ElevateAttributes
//
// Purpose: 
//   Copy constructor for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ElevateAttributes::ElevateAttributes(const ElevateAttributes &obj) : 
    AttributeSubject(ElevateAttributes::TypeMapFormatString)
{
    useXYLimits = obj.useXYLimits;
    limitsMode = obj.limitsMode;
    scaling = obj.scaling;
    skewFactor = obj.skewFactor;
    minFlag = obj.minFlag;
    min = obj.min;
    maxFlag = obj.maxFlag;
    max = obj.max;
    zeroFlag = obj.zeroFlag;
    variable = obj.variable;

    SelectAll();
}

// ****************************************************************************
// Method: ElevateAttributes::~ElevateAttributes
//
// Purpose: 
//   Destructor for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ElevateAttributes::~ElevateAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ElevateAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ElevateAttributes& 
ElevateAttributes::operator = (const ElevateAttributes &obj)
{
    if (this == &obj) return *this;
    useXYLimits = obj.useXYLimits;
    limitsMode = obj.limitsMode;
    scaling = obj.scaling;
    skewFactor = obj.skewFactor;
    minFlag = obj.minFlag;
    min = obj.min;
    maxFlag = obj.maxFlag;
    max = obj.max;
    zeroFlag = obj.zeroFlag;
    variable = obj.variable;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: ElevateAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ElevateAttributes::operator == (const ElevateAttributes &obj) const
{
    // Create the return value
    return ((useXYLimits == obj.useXYLimits) &&
            (limitsMode == obj.limitsMode) &&
            (scaling == obj.scaling) &&
            (skewFactor == obj.skewFactor) &&
            (minFlag == obj.minFlag) &&
            (min == obj.min) &&
            (maxFlag == obj.maxFlag) &&
            (max == obj.max) &&
            (zeroFlag == obj.zeroFlag) &&
            (variable == obj.variable));
}

// ****************************************************************************
// Method: ElevateAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ElevateAttributes::operator != (const ElevateAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ElevateAttributes::TypeName
//
// Purpose: 
//   Type name method for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ElevateAttributes::TypeName() const
{
    return "ElevateAttributes";
}

// ****************************************************************************
// Method: ElevateAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ElevateAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ElevateAttributes *tmp = (const ElevateAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ElevateAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ElevateAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ElevateAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ElevateAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ElevateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ElevateAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ElevateAttributes(*this);
    else
        retval = new ElevateAttributes;

    return retval;
}

// ****************************************************************************
// Method: ElevateAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ElevateAttributes::SelectAll()
{
    Select(ID_useXYLimits, (void *)&useXYLimits);
    Select(ID_limitsMode,  (void *)&limitsMode);
    Select(ID_scaling,     (void *)&scaling);
    Select(ID_skewFactor,  (void *)&skewFactor);
    Select(ID_minFlag,     (void *)&minFlag);
    Select(ID_min,         (void *)&min);
    Select(ID_maxFlag,     (void *)&maxFlag);
    Select(ID_max,         (void *)&max);
    Select(ID_zeroFlag,    (void *)&zeroFlag);
    Select(ID_variable,    (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ElevateAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ElevateAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ElevateAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ElevateAttributes.
    DataNode *node = new DataNode("ElevateAttributes");

    if(completeSave || !FieldsEqual(ID_useXYLimits, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useXYLimits", useXYLimits));
    }

    if(completeSave || !FieldsEqual(ID_limitsMode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("limitsMode", LimitsMode_ToString(limitsMode)));
    }

    if(completeSave || !FieldsEqual(ID_scaling, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaling", Scaling_ToString(scaling)));
    }

    if(completeSave || !FieldsEqual(ID_skewFactor, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("skewFactor", skewFactor));
    }

    if(completeSave || !FieldsEqual(ID_minFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minFlag", minFlag));
    }

    if(completeSave || !FieldsEqual(ID_min, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("min", min));
    }

    if(completeSave || !FieldsEqual(ID_maxFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxFlag", maxFlag));
    }

    if(completeSave || !FieldsEqual(ID_max, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("max", max));
    }

    if(completeSave || !FieldsEqual(ID_zeroFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zeroFlag", zeroFlag));
    }

    if(completeSave || !FieldsEqual(ID_variable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variable", variable));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ElevateAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ElevateAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ElevateAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("useXYLimits")) != 0)
        SetUseXYLimits(node->AsBool());
    if((node = searchNode->GetNode("limitsMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetLimitsMode(LimitsMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LimitsMode value;
            if(LimitsMode_FromString(node->AsString(), value))
                SetLimitsMode(value);
        }
    }
    if((node = searchNode->GetNode("scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetScaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetScaling(value);
        }
    }
    if((node = searchNode->GetNode("skewFactor")) != 0)
        SetSkewFactor(node->AsDouble());
    if((node = searchNode->GetNode("minFlag")) != 0)
        SetMinFlag(node->AsBool());
    if((node = searchNode->GetNode("min")) != 0)
        SetMin(node->AsDouble());
    if((node = searchNode->GetNode("maxFlag")) != 0)
        SetMaxFlag(node->AsBool());
    if((node = searchNode->GetNode("max")) != 0)
        SetMax(node->AsDouble());
    if((node = searchNode->GetNode("zeroFlag")) != 0)
        SetZeroFlag(node->AsBool());
    if((node = searchNode->GetNode("variable")) != 0)
        SetVariable(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ElevateAttributes::SetUseXYLimits(bool useXYLimits_)
{
    useXYLimits = useXYLimits_;
    Select(ID_useXYLimits, (void *)&useXYLimits);
}

void
ElevateAttributes::SetLimitsMode(ElevateAttributes::LimitsMode limitsMode_)
{
    limitsMode = limitsMode_;
    Select(ID_limitsMode, (void *)&limitsMode);
}

void
ElevateAttributes::SetScaling(ElevateAttributes::Scaling scaling_)
{
    scaling = scaling_;
    Select(ID_scaling, (void *)&scaling);
}

void
ElevateAttributes::SetSkewFactor(double skewFactor_)
{
    skewFactor = skewFactor_;
    Select(ID_skewFactor, (void *)&skewFactor);
}

void
ElevateAttributes::SetMinFlag(bool minFlag_)
{
    minFlag = minFlag_;
    Select(ID_minFlag, (void *)&minFlag);
}

void
ElevateAttributes::SetMin(double min_)
{
    min = min_;
    Select(ID_min, (void *)&min);
}

void
ElevateAttributes::SetMaxFlag(bool maxFlag_)
{
    maxFlag = maxFlag_;
    Select(ID_maxFlag, (void *)&maxFlag);
}

void
ElevateAttributes::SetMax(double max_)
{
    max = max_;
    Select(ID_max, (void *)&max);
}

void
ElevateAttributes::SetZeroFlag(bool zeroFlag_)
{
    zeroFlag = zeroFlag_;
    Select(ID_zeroFlag, (void *)&zeroFlag);
}

void
ElevateAttributes::SetVariable(const std::string &variable_)
{
    variable = variable_;
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
ElevateAttributes::GetUseXYLimits() const
{
    return useXYLimits;
}

ElevateAttributes::LimitsMode
ElevateAttributes::GetLimitsMode() const
{
    return LimitsMode(limitsMode);
}

ElevateAttributes::Scaling
ElevateAttributes::GetScaling() const
{
    return Scaling(scaling);
}

double
ElevateAttributes::GetSkewFactor() const
{
    return skewFactor;
}

bool
ElevateAttributes::GetMinFlag() const
{
    return minFlag;
}

double
ElevateAttributes::GetMin() const
{
    return min;
}

bool
ElevateAttributes::GetMaxFlag() const
{
    return maxFlag;
}

double
ElevateAttributes::GetMax() const
{
    return max;
}

bool
ElevateAttributes::GetZeroFlag() const
{
    return zeroFlag;
}

const std::string &
ElevateAttributes::GetVariable() const
{
    return variable;
}

std::string &
ElevateAttributes::GetVariable()
{
    return variable;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ElevateAttributes::SelectVariable()
{
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ElevateAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ElevateAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_useXYLimits: return "useXYLimits";
    case ID_limitsMode:  return "limitsMode";
    case ID_scaling:     return "scaling";
    case ID_skewFactor:  return "skewFactor";
    case ID_minFlag:     return "minFlag";
    case ID_min:         return "min";
    case ID_maxFlag:     return "maxFlag";
    case ID_max:         return "max";
    case ID_zeroFlag:    return "zeroFlag";
    case ID_variable:    return "variable";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ElevateAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ElevateAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_useXYLimits: return FieldType_bool;
    case ID_limitsMode:  return FieldType_enum;
    case ID_scaling:     return FieldType_enum;
    case ID_skewFactor:  return FieldType_double;
    case ID_minFlag:     return FieldType_bool;
    case ID_min:         return FieldType_double;
    case ID_maxFlag:     return FieldType_bool;
    case ID_max:         return FieldType_double;
    case ID_zeroFlag:    return FieldType_bool;
    case ID_variable:    return FieldType_variablename;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ElevateAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ElevateAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_useXYLimits: return "bool";
    case ID_limitsMode:  return "enum";
    case ID_scaling:     return "enum";
    case ID_skewFactor:  return "double";
    case ID_minFlag:     return "bool";
    case ID_min:         return "double";
    case ID_maxFlag:     return "bool";
    case ID_max:         return "double";
    case ID_zeroFlag:    return "bool";
    case ID_variable:    return "variablename";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ElevateAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ElevateAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ElevateAttributes &obj = *((const ElevateAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_useXYLimits:
        {  // new scope
        retval = (useXYLimits == obj.useXYLimits);
        }
        break;
    case ID_limitsMode:
        {  // new scope
        retval = (limitsMode == obj.limitsMode);
        }
        break;
    case ID_scaling:
        {  // new scope
        retval = (scaling == obj.scaling);
        }
        break;
    case ID_skewFactor:
        {  // new scope
        retval = (skewFactor == obj.skewFactor);
        }
        break;
    case ID_minFlag:
        {  // new scope
        retval = (minFlag == obj.minFlag);
        }
        break;
    case ID_min:
        {  // new scope
        retval = (min == obj.min);
        }
        break;
    case ID_maxFlag:
        {  // new scope
        retval = (maxFlag == obj.maxFlag);
        }
        break;
    case ID_max:
        {  // new scope
        retval = (max == obj.max);
        }
        break;
    case ID_zeroFlag:
        {  // new scope
        retval = (zeroFlag == obj.zeroFlag);
        }
        break;
    case ID_variable:
        {  // new scope
        retval = (variable == obj.variable);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

