/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtEdgeFilter.C
// ************************************************************************* //

#include <avtEdgeFilter.h>
#include <vtkExtractEdges.h>
#include <vtkGeometryFilter.h>

// ****************************************************************************
//  Method: avtEdgeFilter constructor
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
// ****************************************************************************

avtEdgeFilter::avtEdgeFilter()
{
}


// ****************************************************************************
//  Method: avtEdgeFilter destructor
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
//  Modifications:
//
// ****************************************************************************

avtEdgeFilter::~avtEdgeFilter()
{
}


// ****************************************************************************
//  Method:  avtEdgeFilter::Create
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
// ****************************************************************************

avtFilter *
avtEdgeFilter::Create()
{
    return new avtEdgeFilter();
}


// ****************************************************************************
//  Method:      avtEdgeFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
// ****************************************************************************

void
avtEdgeFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const EdgeAttributes*)a;
}


// ****************************************************************************
//  Method: avtEdgeFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtEdgeFilter with the given
//      parameters would result in an equivalent avtEdgeFilter.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
// ****************************************************************************

bool
avtEdgeFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(EdgeAttributes*)a);
}


// ****************************************************************************
//  Method: avtEdgeFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the Edge filter.
//
//  Arguments:
//      in_ds      The input dataset.
//      <unused>   The domain number.
//      <unused>   The label.
//
//  Returns:       The output dataset.
//
//  Programmer: Jeremy Meredith
//  Creation:   February 23, 2009
//
// ****************************************************************************

vtkDataSet *
avtEdgeFilter::ExecuteData(vtkDataSet *inDS, int, std::string)
{
    vtkGeometryFilter *geom = NULL;
    if (inDS->GetDataObjectType() != VTK_POLY_DATA)
    {
        geom = vtkGeometryFilter::New();
        geom->SetInput(inDS);
        inDS = geom->GetOutput();
    }

    vtkExtractEdges *ee = vtkExtractEdges::New();
    ee->SetInput(inDS);
    vtkPolyData *outDS = vtkPolyData::New();
    ee->SetOutput(outDS);

    outDS->Update();
    ManageMemory(outDS);

    ee->Delete();
    if (geom)
        geom->Delete();

    return outDS;
}


// ****************************************************************************
//  Method:  avtEdgeFilter::UpdateDataObjectInfo
//
//  Purpose:
//    Set the topological dimension to 1.
//
//  Arguments:
//    none
//
//  Programmer:  Jeremy Meredith
//  Creation:    February 23, 2009
//
// ****************************************************************************
void
avtEdgeFilter::UpdateDataObjectInfo(void)
{
    if (GetInput()->GetInfo().GetAttributes().GetTopologicalDimension() != 0)
        GetOutput()->GetInfo().GetAttributes().SetTopologicalDimension(1);
}
