/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <EdgeAttributes.h>
#include <DataNode.h>

// Type map format string
const char *EdgeAttributes::TypeMapFormatString = "b";

// ****************************************************************************
// Method: EdgeAttributes::EdgeAttributes
//
// Purpose: 
//   Constructor for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EdgeAttributes::EdgeAttributes() : 
    AttributeSubject(EdgeAttributes::TypeMapFormatString)
{
    dummy = true;
}

// ****************************************************************************
// Method: EdgeAttributes::EdgeAttributes
//
// Purpose: 
//   Copy constructor for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EdgeAttributes::EdgeAttributes(const EdgeAttributes &obj) : 
    AttributeSubject(EdgeAttributes::TypeMapFormatString)
{
    dummy = obj.dummy;

    SelectAll();
}

// ****************************************************************************
// Method: EdgeAttributes::~EdgeAttributes
//
// Purpose: 
//   Destructor for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EdgeAttributes::~EdgeAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: EdgeAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EdgeAttributes& 
EdgeAttributes::operator = (const EdgeAttributes &obj)
{
    if (this == &obj) return *this;
    dummy = obj.dummy;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: EdgeAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EdgeAttributes::operator == (const EdgeAttributes &obj) const
{
    // Create the return value
    return ((dummy == obj.dummy));
}

// ****************************************************************************
// Method: EdgeAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EdgeAttributes::operator != (const EdgeAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: EdgeAttributes::TypeName
//
// Purpose: 
//   Type name method for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
EdgeAttributes::TypeName() const
{
    return "EdgeAttributes";
}

// ****************************************************************************
// Method: EdgeAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EdgeAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const EdgeAttributes *tmp = (const EdgeAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: EdgeAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
EdgeAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new EdgeAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: EdgeAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the EdgeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
EdgeAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new EdgeAttributes(*this);
    else
        retval = new EdgeAttributes;

    return retval;
}

// ****************************************************************************
// Method: EdgeAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
EdgeAttributes::SelectAll()
{
    Select(ID_dummy, (void *)&dummy);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
EdgeAttributes::SetDummy(bool dummy_)
{
    dummy = dummy_;
    Select(ID_dummy, (void *)&dummy);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
EdgeAttributes::GetDummy() const
{
    return dummy;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: EdgeAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
EdgeAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_dummy: return "dummy";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: EdgeAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
EdgeAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_dummy: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: EdgeAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
EdgeAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_dummy: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: EdgeAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EdgeAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const EdgeAttributes &obj = *((const EdgeAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_dummy:
        {  // new scope
        retval = (dummy == obj.dummy);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

