/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtDelaunayFilter.C
// ************************************************************************* //

#include <avtDelaunayFilter.h>

#include <vtkDelaunay2D.h>
#include <vtkDelaunay3D.h>
#include <vtkUnstructuredGrid.h>
#include <vtkPolyData.h>

// ****************************************************************************
//  Method: avtDelaunayFilter constructor
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Wed Feb 25 11:01:51 PDT 2009
//
// ****************************************************************************

avtDelaunayFilter::avtDelaunayFilter()
{
}


// ****************************************************************************
//  Method: avtDelaunayFilter destructor
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Wed Feb 25 11:01:51 PDT 2009
//
//  Modifications:
//
// ****************************************************************************

avtDelaunayFilter::~avtDelaunayFilter()
{
}


// ****************************************************************************
//  Method:  avtDelaunayFilter::Create
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Wed Feb 25 11:01:51 PDT 2009
//
// ****************************************************************************

avtFilter *
avtDelaunayFilter::Create()
{
    return new avtDelaunayFilter();
}


// ****************************************************************************
//  Method:      avtDelaunayFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Wed Feb 25 11:01:51 PDT 2009
//
// ****************************************************************************

void
avtDelaunayFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const DelaunayAttributes*)a;
}


// ****************************************************************************
//  Method: avtDelaunayFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtDelaunayFilter with the given
//      parameters would result in an equivalent avtDelaunayFilter.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Wed Feb 25 11:01:51 PDT 2009
//
// ****************************************************************************

bool
avtDelaunayFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(DelaunayAttributes*)a);
}


// ****************************************************************************
//  Method: avtDelaunayFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the Delaunay filter.
//
//  Arguments:
//      in_ds      The input dataset.
//      <unused>   The domain number.
//      <unused>   The label.
//
//  Returns:       The output dataset.
//
//  Programmer: Jeremy Meredith
//  Creation:   February 25, 2009
//
// ****************************************************************************

vtkDataSet *
avtDelaunayFilter::ExecuteData(vtkDataSet *inDS, int, std::string)
{
    vtkDelaunay2D     *d2   = NULL;
    vtkDelaunay3D     *d3   = NULL;

    vtkDataSet *outDS = NULL;
    int dimension = -1;
    switch (atts.GetDimension())
    {
      case DelaunayAttributes::Tetrahedralization:
        dimension = 3;
        break;
      case DelaunayAttributes::Triangulation:
        dimension = 2;
        break;
      case DelaunayAttributes::Automatic:
        dimension = GetInput()->GetInfo().GetAttributes().GetSpatialDimension();
        break;
    }

    if (dimension == 2)
    {
        d2 = vtkDelaunay2D::New();
        d2->SetInput(inDS);
        outDS = d2->GetOutput();
    }
    else if (dimension == 3)
    {
        d3 = vtkDelaunay3D::New();
        d3->SetInput(inDS);
        outDS = vtkUnstructuredGrid::New();
        d3->SetOutput(outDS);
    }
    else
    {
        EXCEPTION1(ImproperUseException, "Only supports 2- and 3-spatial "
                   "dimension data");
    }

    outDS->Update();
    ManageMemory(outDS);

    if (d2)
        d2->Delete();
    if (d3)
        d3->Delete();

    return outDS;
}

// ****************************************************************************
//  Method:  avtEdgeFilter::UpdateDataObjectInfo
//
//  Purpose:
//    Set the topological dimension appropriately.
//
//  Arguments:
//    none
//
//  Programmer:  Jeremy Meredith
//  Creation:    February 23, 2009
//
// ****************************************************************************
void
avtDelaunayFilter::UpdateDataObjectInfo(void)
{
    int dimension = -1;
    switch (atts.GetDimension())
    {
      case DelaunayAttributes::Tetrahedralization:
        dimension = 3;
        break;
      case DelaunayAttributes::Triangulation:
        dimension = 2;
        break;
      case DelaunayAttributes::Automatic:
        dimension = GetInput()->GetInfo().GetAttributes().GetSpatialDimension();
        break;
    }

    GetOutput()->GetInfo().GetAttributes().SetTopologicalDimension(dimension);
}
