/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <DelaunayAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for DelaunayAttributes::Dimension
//

static const char *Dimension_strings[] = {
"Automatic", "Triangulation", "Tetrahedralization"
};

std::string
DelaunayAttributes::Dimension_ToString(DelaunayAttributes::Dimension t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Dimension_strings[index];
}

std::string
DelaunayAttributes::Dimension_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Dimension_strings[index];
}

bool
DelaunayAttributes::Dimension_FromString(const std::string &s, DelaunayAttributes::Dimension &val)
{
    val = DelaunayAttributes::Automatic;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Dimension_strings[i])
        {
            val = (Dimension)i;
            return true;
        }
    }
    return false;
}

// Type map format string
const char *DelaunayAttributes::TypeMapFormatString = "i";

// ****************************************************************************
// Method: DelaunayAttributes::DelaunayAttributes
//
// Purpose: 
//   Constructor for the DelaunayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DelaunayAttributes::DelaunayAttributes() : 
    AttributeSubject(DelaunayAttributes::TypeMapFormatString)
{
    dimension = Automatic;
}

// ****************************************************************************
// Method: DelaunayAttributes::DelaunayAttributes
//
// Purpose: 
//   Copy constructor for the DelaunayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DelaunayAttributes::DelaunayAttributes(const DelaunayAttributes &obj) : 
    AttributeSubject(DelaunayAttributes::TypeMapFormatString)
{
    dimension = obj.dimension;

    SelectAll();
}

// ****************************************************************************
// Method: DelaunayAttributes::~DelaunayAttributes
//
// Purpose: 
//   Destructor for the DelaunayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DelaunayAttributes::~DelaunayAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: DelaunayAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the DelaunayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DelaunayAttributes& 
DelaunayAttributes::operator = (const DelaunayAttributes &obj)
{
    if (this == &obj) return *this;
    dimension = obj.dimension;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: DelaunayAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the DelaunayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DelaunayAttributes::operator == (const DelaunayAttributes &obj) const
{
    // Create the return value
    return ((dimension == obj.dimension));
}

// ****************************************************************************
// Method: DelaunayAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the DelaunayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DelaunayAttributes::operator != (const DelaunayAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: DelaunayAttributes::TypeName
//
// Purpose: 
//   Type name method for the DelaunayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
DelaunayAttributes::TypeName() const
{
    return "DelaunayAttributes";
}

// ****************************************************************************
// Method: DelaunayAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the DelaunayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DelaunayAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const DelaunayAttributes *tmp = (const DelaunayAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: DelaunayAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the DelaunayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DelaunayAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new DelaunayAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: DelaunayAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the DelaunayAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DelaunayAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new DelaunayAttributes(*this);
    else
        retval = new DelaunayAttributes;

    return retval;
}

// ****************************************************************************
// Method: DelaunayAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DelaunayAttributes::SelectAll()
{
    Select(ID_dimension, (void *)&dimension);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
DelaunayAttributes::SetDimension(DelaunayAttributes::Dimension dimension_)
{
    dimension = dimension_;
    Select(ID_dimension, (void *)&dimension);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

DelaunayAttributes::Dimension
DelaunayAttributes::GetDimension() const
{
    return Dimension(dimension);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DelaunayAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
DelaunayAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_dimension: return "dimension";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DelaunayAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
DelaunayAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_dimension: return FieldType_enum;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: DelaunayAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
DelaunayAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_dimension: return "enum";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DelaunayAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DelaunayAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const DelaunayAttributes &obj = *((const DelaunayAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_dimension:
        {  // new scope
        retval = (dimension == obj.dimension);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

