/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisDeformSphereGlyphWindow.h"

#include <DeformSphereGlyphAttributes.h>
#include <ViewerProxy.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QSpinBox>
#include <QButtonGroup>
#include <QRadioButton>
#include <QvisColorTableButton.h>
#include <QvisOpacitySlider.h>
#include <QvisColorButton.h>
#include <QvisLineStyleWidget.h>
#include <QvisLineWidthWidget.h>
#include <QvisVariableButton.h>

#include <stdio.h>
#include <string>

using std::string;

// ****************************************************************************
// Method: QvisDeformSphereGlyphWindow::QvisDeformSphereGlyphWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisDeformSphereGlyphWindow::QvisDeformSphereGlyphWindow(const int type,
                         DeformSphereGlyphAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisDeformSphereGlyphWindow::~QvisDeformSphereGlyphWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisDeformSphereGlyphWindow::~QvisDeformSphereGlyphWindow()
{
}


// ****************************************************************************
// Method: QvisDeformSphereGlyphWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDeformSphereGlyphWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    varLabel = new QLabel(tr("var"), central);
    mainLayout->addWidget(varLabel,0,0);
    int varMask = QvisVariableButton::Arrays;
    var = new QvisVariableButton(true, true, true, varMask, central);
    var->setDefaultVariable("Default");
    connect(var, SIGNAL(activated(const QString&)),
            this, SLOT(varChanged(const QString&)));
    mainLayout->addWidget(var, 0,1);

    scaleLabel = new QLabel(tr("Scale Factor"), central);
    mainLayout->addWidget(scaleLabel,1,0);
    scale = new QLineEdit(central);
    connect(scale, SIGNAL(returnPressed()),
            this, SLOT(scaleProcessText()));
    mainLayout->addWidget(scale, 1,1);

    minSizeLabel = new QLabel(tr("Minimum Size"), central);
    mainLayout->addWidget(minSizeLabel,2,0);
    minSize = new QLineEdit(central);
    connect(minSize, SIGNAL(returnPressed()),
            this, SLOT(minSizeProcessText()));
    mainLayout->addWidget(minSize, 2,1);

}


// ****************************************************************************
// Method: QvisDeformSphereGlyphWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDeformSphereGlyphWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case DeformSphereGlyphAttributes::ID_var:
            var->blockSignals(true);
            var->setText(QString(atts->GetVar().c_str()));
            var->blockSignals(false);
            break;
          case DeformSphereGlyphAttributes::ID_scale:
            scale->setText(DoubleToQString(atts->GetScale()));
            break;
          case DeformSphereGlyphAttributes::ID_minSize:
            minSize->setText(DoubleToQString(atts->GetMinSize()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisDeformSphereGlyphWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDeformSphereGlyphWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do scale
    if(which_widget == DeformSphereGlyphAttributes::ID_scale || doAll)
    {
        double val;
        if(LineEditGetDouble(scale, val))
            atts->SetScale(val);
        else
        {
            ResettingError(tr("Scale Factor"),
                DoubleToQString(atts->GetScale()));
            atts->SetScale(atts->GetScale());
        }
    }

    // Do minSize
    if(which_widget == DeformSphereGlyphAttributes::ID_minSize || doAll)
    {
        double val;
        if(LineEditGetDouble(minSize, val))
            atts->SetMinSize(val);
        else
        {
            ResettingError(tr("Minimum Size"),
                DoubleToQString(atts->GetMinSize()));
            atts->SetMinSize(atts->GetMinSize());
        }
    }

}


//
// Qt Slot functions
//


void
QvisDeformSphereGlyphWindow::varChanged(const QString &varName)
{
    atts->SetVar(varName.toStdString());
    SetUpdate(false);
    Apply();
}


void
QvisDeformSphereGlyphWindow::scaleProcessText()
{
    GetCurrentValues(DeformSphereGlyphAttributes::ID_scale);
    Apply();
}


void
QvisDeformSphereGlyphWindow::minSizeProcessText()
{
    GetCurrentValues(DeformSphereGlyphAttributes::ID_minSize);
    Apply();
}


