/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyDeformSphereGlyphAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyDeformSphereGlyphAttributes
//
// Purpose: 
//   Attributes for the DeformSphereGlyph
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Mar 19 13:55:32 PST 2009
//
// ****************************************************************************

//
// This struct contains the Python type information and a DeformSphereGlyphAttributes.
//
struct DeformSphereGlyphAttributesObject
{
    PyObject_HEAD
    DeformSphereGlyphAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewDeformSphereGlyphAttributes(int);

std::string
PyDeformSphereGlyphAttributes_ToString(const DeformSphereGlyphAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%svar = \"%s\"\n", prefix, atts->GetVar().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sscale = %g\n", prefix, atts->GetScale());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sminSize = %g\n", prefix, atts->GetMinSize());
    str += tmpStr;
    return str;
}

static PyObject *
DeformSphereGlyphAttributes_Notify(PyObject *self, PyObject *args)
{
    DeformSphereGlyphAttributesObject *obj = (DeformSphereGlyphAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DeformSphereGlyphAttributes_SetVar(PyObject *self, PyObject *args)
{
    DeformSphereGlyphAttributesObject *obj = (DeformSphereGlyphAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the var in the object.
    obj->data->SetVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DeformSphereGlyphAttributes_GetVar(PyObject *self, PyObject *args)
{
    DeformSphereGlyphAttributesObject *obj = (DeformSphereGlyphAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVar().c_str());
    return retval;
}

/*static*/ PyObject *
DeformSphereGlyphAttributes_SetScale(PyObject *self, PyObject *args)
{
    DeformSphereGlyphAttributesObject *obj = (DeformSphereGlyphAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the scale in the object.
    obj->data->SetScale(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DeformSphereGlyphAttributes_GetScale(PyObject *self, PyObject *args)
{
    DeformSphereGlyphAttributesObject *obj = (DeformSphereGlyphAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetScale());
    return retval;
}

/*static*/ PyObject *
DeformSphereGlyphAttributes_SetMinSize(PyObject *self, PyObject *args)
{
    DeformSphereGlyphAttributesObject *obj = (DeformSphereGlyphAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the minSize in the object.
    obj->data->SetMinSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DeformSphereGlyphAttributes_GetMinSize(PyObject *self, PyObject *args)
{
    DeformSphereGlyphAttributesObject *obj = (DeformSphereGlyphAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMinSize());
    return retval;
}



static struct PyMethodDef DeformSphereGlyphAttributes_methods[] = {
    {"Notify", DeformSphereGlyphAttributes_Notify, METH_VARARGS},
    {"SetVar", DeformSphereGlyphAttributes_SetVar, METH_VARARGS},
    {"GetVar", DeformSphereGlyphAttributes_GetVar, METH_VARARGS},
    {"SetScale", DeformSphereGlyphAttributes_SetScale, METH_VARARGS},
    {"GetScale", DeformSphereGlyphAttributes_GetScale, METH_VARARGS},
    {"SetMinSize", DeformSphereGlyphAttributes_SetMinSize, METH_VARARGS},
    {"GetMinSize", DeformSphereGlyphAttributes_GetMinSize, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
DeformSphereGlyphAttributes_dealloc(PyObject *v)
{
   DeformSphereGlyphAttributesObject *obj = (DeformSphereGlyphAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
DeformSphereGlyphAttributes_compare(PyObject *v, PyObject *w)
{
    DeformSphereGlyphAttributes *a = ((DeformSphereGlyphAttributesObject *)v)->data;
    DeformSphereGlyphAttributes *b = ((DeformSphereGlyphAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
DeformSphereGlyphAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "var") == 0)
        return DeformSphereGlyphAttributes_GetVar(self, NULL);
    if(strcmp(name, "scale") == 0)
        return DeformSphereGlyphAttributes_GetScale(self, NULL);
    if(strcmp(name, "minSize") == 0)
        return DeformSphereGlyphAttributes_GetMinSize(self, NULL);

    return Py_FindMethod(DeformSphereGlyphAttributes_methods, self, name);
}

static int
DeformSphereGlyphAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "var") == 0)
        obj = DeformSphereGlyphAttributes_SetVar(self, tuple);
    else if(strcmp(name, "scale") == 0)
        obj = DeformSphereGlyphAttributes_SetScale(self, tuple);
    else if(strcmp(name, "minSize") == 0)
        obj = DeformSphereGlyphAttributes_SetMinSize(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
DeformSphereGlyphAttributes_print(PyObject *v, FILE *fp, int flags)
{
    DeformSphereGlyphAttributesObject *obj = (DeformSphereGlyphAttributesObject *)v;
    fprintf(fp, "%s", PyDeformSphereGlyphAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
DeformSphereGlyphAttributes_str(PyObject *v)
{
    DeformSphereGlyphAttributesObject *obj = (DeformSphereGlyphAttributesObject *)v;
    return PyString_FromString(PyDeformSphereGlyphAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *DeformSphereGlyphAttributes_Purpose = "Attributes for the DeformSphereGlyph";
#else
static char *DeformSphereGlyphAttributes_Purpose = "Attributes for the DeformSphereGlyph";
#endif

//
// The type description structure
//
static PyTypeObject DeformSphereGlyphAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "DeformSphereGlyphAttributes",                    // tp_name
    sizeof(DeformSphereGlyphAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)DeformSphereGlyphAttributes_dealloc,  // tp_dealloc
    (printfunc)DeformSphereGlyphAttributes_print,     // tp_print
    (getattrfunc)DeformSphereGlyphAttributes_getattr, // tp_getattr
    (setattrfunc)DeformSphereGlyphAttributes_setattr, // tp_setattr
    (cmpfunc)DeformSphereGlyphAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)DeformSphereGlyphAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    DeformSphereGlyphAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static DeformSphereGlyphAttributes *defaultAtts = 0;
static DeformSphereGlyphAttributes *currentAtts = 0;

static PyObject *
NewDeformSphereGlyphAttributes(int useCurrent)
{
    DeformSphereGlyphAttributesObject *newObject;
    newObject = PyObject_NEW(DeformSphereGlyphAttributesObject, &DeformSphereGlyphAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new DeformSphereGlyphAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new DeformSphereGlyphAttributes(*defaultAtts);
    else
        newObject->data = new DeformSphereGlyphAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapDeformSphereGlyphAttributes(const DeformSphereGlyphAttributes *attr)
{
    DeformSphereGlyphAttributesObject *newObject;
    newObject = PyObject_NEW(DeformSphereGlyphAttributesObject, &DeformSphereGlyphAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (DeformSphereGlyphAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
DeformSphereGlyphAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewDeformSphereGlyphAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef DeformSphereGlyphAttributesMethods[] = {
    {"DeformSphereGlyphAttributes", DeformSphereGlyphAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *DeformSphereGlyphAttributesObserver = 0;

std::string
PyDeformSphereGlyphAttributes_GetLogString()
{
    std::string s("DeformSphereGlyphAtts = DeformSphereGlyphAttributes()\n");
    if(currentAtts != 0)
        s += PyDeformSphereGlyphAttributes_ToString(currentAtts, "DeformSphereGlyphAtts.");
    return s;
}

static void
PyDeformSphereGlyphAttributes_CallLogRoutine(Subject *subj, void *data)
{
    DeformSphereGlyphAttributes *atts = (DeformSphereGlyphAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("DeformSphereGlyphAtts = DeformSphereGlyphAttributes()\n");
        s += PyDeformSphereGlyphAttributes_ToString(currentAtts, "DeformSphereGlyphAtts.");
        cb(s);
    }
}

void
PyDeformSphereGlyphAttributes_StartUp(DeformSphereGlyphAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyDeformSphereGlyphAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(DeformSphereGlyphAttributesObserver == 0)
    {
        DeformSphereGlyphAttributesObserver = new ObserverToCallback(subj,
            PyDeformSphereGlyphAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyDeformSphereGlyphAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete DeformSphereGlyphAttributesObserver;
    DeformSphereGlyphAttributesObserver = 0;
}

PyMethodDef *
PyDeformSphereGlyphAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return DeformSphereGlyphAttributesMethods;
}

bool
PyDeformSphereGlyphAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &DeformSphereGlyphAttributesType);
}

DeformSphereGlyphAttributes *
PyDeformSphereGlyphAttributes_FromPyObject(PyObject *obj)
{
    DeformSphereGlyphAttributesObject *obj2 = (DeformSphereGlyphAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyDeformSphereGlyphAttributes_New()
{
    return NewDeformSphereGlyphAttributes(0);
}

PyObject *
PyDeformSphereGlyphAttributes_Wrap(const DeformSphereGlyphAttributes *attr)
{
    return WrapDeformSphereGlyphAttributes(attr);
}

void
PyDeformSphereGlyphAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    DeformSphereGlyphAttributesObject *obj2 = (DeformSphereGlyphAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyDeformSphereGlyphAttributes_SetDefaults(const DeformSphereGlyphAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new DeformSphereGlyphAttributes(*atts);
}

