/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <DeformSphereGlyphAttributes.h>
#include <DataNode.h>

// Type map format string
const char *DeformSphereGlyphAttributes::TypeMapFormatString = "sdd";

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::DeformSphereGlyphAttributes
//
// Purpose: 
//   Constructor for the DeformSphereGlyphAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DeformSphereGlyphAttributes::DeformSphereGlyphAttributes() : 
    AttributeSubject(DeformSphereGlyphAttributes::TypeMapFormatString),
    var("Default")
{
    scale = 1;
    minSize = 1;
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::DeformSphereGlyphAttributes
//
// Purpose: 
//   Copy constructor for the DeformSphereGlyphAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DeformSphereGlyphAttributes::DeformSphereGlyphAttributes(const DeformSphereGlyphAttributes &obj) : 
    AttributeSubject(DeformSphereGlyphAttributes::TypeMapFormatString)
{
    var = obj.var;
    scale = obj.scale;
    minSize = obj.minSize;

    SelectAll();
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::~DeformSphereGlyphAttributes
//
// Purpose: 
//   Destructor for the DeformSphereGlyphAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DeformSphereGlyphAttributes::~DeformSphereGlyphAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the DeformSphereGlyphAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DeformSphereGlyphAttributes& 
DeformSphereGlyphAttributes::operator = (const DeformSphereGlyphAttributes &obj)
{
    if (this == &obj) return *this;
    var = obj.var;
    scale = obj.scale;
    minSize = obj.minSize;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the DeformSphereGlyphAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DeformSphereGlyphAttributes::operator == (const DeformSphereGlyphAttributes &obj) const
{
    // Create the return value
    return ((var == obj.var) &&
            (scale == obj.scale) &&
            (minSize == obj.minSize));
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the DeformSphereGlyphAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DeformSphereGlyphAttributes::operator != (const DeformSphereGlyphAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::TypeName
//
// Purpose: 
//   Type name method for the DeformSphereGlyphAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
DeformSphereGlyphAttributes::TypeName() const
{
    return "DeformSphereGlyphAttributes";
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the DeformSphereGlyphAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DeformSphereGlyphAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const DeformSphereGlyphAttributes *tmp = (const DeformSphereGlyphAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the DeformSphereGlyphAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DeformSphereGlyphAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new DeformSphereGlyphAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the DeformSphereGlyphAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DeformSphereGlyphAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new DeformSphereGlyphAttributes(*this);
    else
        retval = new DeformSphereGlyphAttributes;

    return retval;
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DeformSphereGlyphAttributes::SelectAll()
{
    Select(ID_var,     (void *)&var);
    Select(ID_scale,   (void *)&scale);
    Select(ID_minSize, (void *)&minSize);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
DeformSphereGlyphAttributes::SetVar(const std::string &var_)
{
    var = var_;
    Select(ID_var, (void *)&var);
}

void
DeformSphereGlyphAttributes::SetScale(double scale_)
{
    scale = scale_;
    Select(ID_scale, (void *)&scale);
}

void
DeformSphereGlyphAttributes::SetMinSize(double minSize_)
{
    minSize = minSize_;
    Select(ID_minSize, (void *)&minSize);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
DeformSphereGlyphAttributes::GetVar() const
{
    return var;
}

std::string &
DeformSphereGlyphAttributes::GetVar()
{
    return var;
}

double
DeformSphereGlyphAttributes::GetScale() const
{
    return scale;
}

double
DeformSphereGlyphAttributes::GetMinSize() const
{
    return minSize;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
DeformSphereGlyphAttributes::SelectVar()
{
    Select(ID_var, (void *)&var);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
DeformSphereGlyphAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_var:     return "var";
    case ID_scale:   return "scale";
    case ID_minSize: return "minSize";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
DeformSphereGlyphAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_var:     return FieldType_variablename;
    case ID_scale:   return FieldType_double;
    case ID_minSize: return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
DeformSphereGlyphAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_var:     return "variablename";
    case ID_scale:   return "double";
    case ID_minSize: return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DeformSphereGlyphAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DeformSphereGlyphAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const DeformSphereGlyphAttributes &obj = *((const DeformSphereGlyphAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_var:
        {  // new scope
        retval = (var == obj.var);
        }
        break;
    case ID_scale:
        {  // new scope
        retval = (scale == obj.scale);
        }
        break;
    case ID_minSize:
        {  // new scope
        retval = (minSize == obj.minSize);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

