/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <DeferExpressionAttributes.h>
#include <DataNode.h>

// Type map format string
const char *DeferExpressionAttributes::TypeMapFormatString = "s*";

// ****************************************************************************
// Method: DeferExpressionAttributes::DeferExpressionAttributes
//
// Purpose: 
//   Constructor for the DeferExpressionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DeferExpressionAttributes::DeferExpressionAttributes() : 
    AttributeSubject(DeferExpressionAttributes::TypeMapFormatString)
{
}

// ****************************************************************************
// Method: DeferExpressionAttributes::DeferExpressionAttributes
//
// Purpose: 
//   Copy constructor for the DeferExpressionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DeferExpressionAttributes::DeferExpressionAttributes(const DeferExpressionAttributes &obj) : 
    AttributeSubject(DeferExpressionAttributes::TypeMapFormatString)
{
    exprs = obj.exprs;

    SelectAll();
}

// ****************************************************************************
// Method: DeferExpressionAttributes::~DeferExpressionAttributes
//
// Purpose: 
//   Destructor for the DeferExpressionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DeferExpressionAttributes::~DeferExpressionAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: DeferExpressionAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the DeferExpressionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DeferExpressionAttributes& 
DeferExpressionAttributes::operator = (const DeferExpressionAttributes &obj)
{
    if (this == &obj) return *this;
    exprs = obj.exprs;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: DeferExpressionAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the DeferExpressionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DeferExpressionAttributes::operator == (const DeferExpressionAttributes &obj) const
{
    // Create the return value
    return ((exprs == obj.exprs));
}

// ****************************************************************************
// Method: DeferExpressionAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the DeferExpressionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DeferExpressionAttributes::operator != (const DeferExpressionAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: DeferExpressionAttributes::TypeName
//
// Purpose: 
//   Type name method for the DeferExpressionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
DeferExpressionAttributes::TypeName() const
{
    return "DeferExpressionAttributes";
}

// ****************************************************************************
// Method: DeferExpressionAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the DeferExpressionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DeferExpressionAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const DeferExpressionAttributes *tmp = (const DeferExpressionAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: DeferExpressionAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the DeferExpressionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DeferExpressionAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new DeferExpressionAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: DeferExpressionAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the DeferExpressionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DeferExpressionAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new DeferExpressionAttributes(*this);
    else
        retval = new DeferExpressionAttributes;

    return retval;
}

// ****************************************************************************
// Method: DeferExpressionAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DeferExpressionAttributes::SelectAll()
{
    Select(ID_exprs, (void *)&exprs);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DeferExpressionAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DeferExpressionAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    DeferExpressionAttributes defaultObject;
    bool addToParent = false;
    // Create a node for DeferExpressionAttributes.
    DataNode *node = new DataNode("DeferExpressionAttributes");

    if(completeSave || !FieldsEqual(ID_exprs, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("exprs", exprs));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: DeferExpressionAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DeferExpressionAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("DeferExpressionAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("exprs")) != 0)
        SetExprs(node->AsStringVector());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
DeferExpressionAttributes::SetExprs(const stringVector &exprs_)
{
    exprs = exprs_;
    Select(ID_exprs, (void *)&exprs);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const stringVector &
DeferExpressionAttributes::GetExprs() const
{
    return exprs;
}

stringVector &
DeferExpressionAttributes::GetExprs()
{
    return exprs;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
DeferExpressionAttributes::SelectExprs()
{
    Select(ID_exprs, (void *)&exprs);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DeferExpressionAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
DeferExpressionAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_exprs: return "exprs";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DeferExpressionAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
DeferExpressionAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_exprs: return FieldType_stringVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: DeferExpressionAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
DeferExpressionAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_exprs: return "stringVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DeferExpressionAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DeferExpressionAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const DeferExpressionAttributes &obj = *((const DeferExpressionAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_exprs:
        {  // new scope
        retval = (exprs == obj.exprs);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

