/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyCylinderAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyCylinderAttributes
//
// Purpose: 
//   Contain the attributes for a cylinder
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:42 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a CylinderAttributes.
//
struct CylinderAttributesObject
{
    PyObject_HEAD
    CylinderAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewCylinderAttributes(int);

std::string
PyCylinderAttributes_ToString(const CylinderAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    {   const double *point1 = atts->GetPoint1();
        SNPRINTF(tmpStr, 1000, "%spoint1 = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", point1[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *point2 = atts->GetPoint2();
        SNPRINTF(tmpStr, 1000, "%spoint2 = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", point2[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sradius = %g\n", prefix, atts->GetRadius());
    str += tmpStr;
    return str;
}

static PyObject *
CylinderAttributes_Notify(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CylinderAttributes_SetPoint1(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;

    double *dvals = obj->data->GetPoint1();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the point1 in the object as modified.
    obj->data->SelectPoint1();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CylinderAttributes_GetPoint1(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the point1.
    PyObject *retval = PyTuple_New(3);
    const double *point1 = obj->data->GetPoint1();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(point1[i]));
    return retval;
}

/*static*/ PyObject *
CylinderAttributes_SetPoint2(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;

    double *dvals = obj->data->GetPoint2();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the point2 in the object as modified.
    obj->data->SelectPoint2();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CylinderAttributes_GetPoint2(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the point2.
    PyObject *retval = PyTuple_New(3);
    const double *point2 = obj->data->GetPoint2();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(point2[i]));
    return retval;
}

/*static*/ PyObject *
CylinderAttributes_SetRadius(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the radius in the object.
    obj->data->SetRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CylinderAttributes_GetRadius(PyObject *self, PyObject *args)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRadius());
    return retval;
}



static struct PyMethodDef CylinderAttributes_methods[] = {
    {"Notify", CylinderAttributes_Notify, METH_VARARGS},
    {"SetPoint1", CylinderAttributes_SetPoint1, METH_VARARGS},
    {"GetPoint1", CylinderAttributes_GetPoint1, METH_VARARGS},
    {"SetPoint2", CylinderAttributes_SetPoint2, METH_VARARGS},
    {"GetPoint2", CylinderAttributes_GetPoint2, METH_VARARGS},
    {"SetRadius", CylinderAttributes_SetRadius, METH_VARARGS},
    {"GetRadius", CylinderAttributes_GetRadius, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
CylinderAttributes_dealloc(PyObject *v)
{
   CylinderAttributesObject *obj = (CylinderAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
CylinderAttributes_compare(PyObject *v, PyObject *w)
{
    CylinderAttributes *a = ((CylinderAttributesObject *)v)->data;
    CylinderAttributes *b = ((CylinderAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
CylinderAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "point1") == 0)
        return CylinderAttributes_GetPoint1(self, NULL);
    if(strcmp(name, "point2") == 0)
        return CylinderAttributes_GetPoint2(self, NULL);
    if(strcmp(name, "radius") == 0)
        return CylinderAttributes_GetRadius(self, NULL);

    return Py_FindMethod(CylinderAttributes_methods, self, name);
}

static int
CylinderAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "point1") == 0)
        obj = CylinderAttributes_SetPoint1(self, tuple);
    else if(strcmp(name, "point2") == 0)
        obj = CylinderAttributes_SetPoint2(self, tuple);
    else if(strcmp(name, "radius") == 0)
        obj = CylinderAttributes_SetRadius(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
CylinderAttributes_print(PyObject *v, FILE *fp, int flags)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)v;
    fprintf(fp, "%s", PyCylinderAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
CylinderAttributes_str(PyObject *v)
{
    CylinderAttributesObject *obj = (CylinderAttributesObject *)v;
    return PyString_FromString(PyCylinderAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *CylinderAttributes_Purpose = "Contain the attributes for a cylinder";
#else
static char *CylinderAttributes_Purpose = "Contain the attributes for a cylinder";
#endif

//
// The type description structure
//
static PyTypeObject CylinderAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "CylinderAttributes",                    // tp_name
    sizeof(CylinderAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)CylinderAttributes_dealloc,  // tp_dealloc
    (printfunc)CylinderAttributes_print,     // tp_print
    (getattrfunc)CylinderAttributes_getattr, // tp_getattr
    (setattrfunc)CylinderAttributes_setattr, // tp_setattr
    (cmpfunc)CylinderAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)CylinderAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    CylinderAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static CylinderAttributes *defaultAtts = 0;
static CylinderAttributes *currentAtts = 0;

static PyObject *
NewCylinderAttributes(int useCurrent)
{
    CylinderAttributesObject *newObject;
    newObject = PyObject_NEW(CylinderAttributesObject, &CylinderAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new CylinderAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new CylinderAttributes(*defaultAtts);
    else
        newObject->data = new CylinderAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapCylinderAttributes(const CylinderAttributes *attr)
{
    CylinderAttributesObject *newObject;
    newObject = PyObject_NEW(CylinderAttributesObject, &CylinderAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (CylinderAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
CylinderAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewCylinderAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef CylinderAttributesMethods[] = {
    {"CylinderAttributes", CylinderAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *CylinderAttributesObserver = 0;

std::string
PyCylinderAttributes_GetLogString()
{
    std::string s("CylinderAtts = CylinderAttributes()\n");
    if(currentAtts != 0)
        s += PyCylinderAttributes_ToString(currentAtts, "CylinderAtts.");
    return s;
}

static void
PyCylinderAttributes_CallLogRoutine(Subject *subj, void *data)
{
    CylinderAttributes *atts = (CylinderAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("CylinderAtts = CylinderAttributes()\n");
        s += PyCylinderAttributes_ToString(currentAtts, "CylinderAtts.");
        cb(s);
    }
}

void
PyCylinderAttributes_StartUp(CylinderAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyCylinderAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(CylinderAttributesObserver == 0)
    {
        CylinderAttributesObserver = new ObserverToCallback(subj,
            PyCylinderAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyCylinderAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete CylinderAttributesObserver;
    CylinderAttributesObserver = 0;
}

PyMethodDef *
PyCylinderAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return CylinderAttributesMethods;
}

bool
PyCylinderAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &CylinderAttributesType);
}

CylinderAttributes *
PyCylinderAttributes_FromPyObject(PyObject *obj)
{
    CylinderAttributesObject *obj2 = (CylinderAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyCylinderAttributes_New()
{
    return NewCylinderAttributes(0);
}

PyObject *
PyCylinderAttributes_Wrap(const CylinderAttributes *attr)
{
    return WrapCylinderAttributes(attr);
}

void
PyCylinderAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    CylinderAttributesObject *obj2 = (CylinderAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyCylinderAttributes_SetDefaults(const CylinderAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new CylinderAttributes(*atts);
}

