/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtCracksDensityFilter.C
// ************************************************************************* //

#include <avtCracksDensityFilter.h>

#include <vtkCellData.h>
#include <vtkDataSet.h>
#include <vtkFloatArray.h>
#include <vtkIntArray.h>

#include <DebugStream.h>
#include <avtCallback.h>


// ****************************************************************************
//  Method: avtCracksDensityFilter constructor
//
//  Programmer: kbonnell -- generated by xml2avt
//  Creation:   Mon Apr 30 11:40:50 PDT 2007
//
// ****************************************************************************

avtCracksDensityFilter::avtCracksDensityFilter()
{
}


// ****************************************************************************
//  Method: avtCracksDensityFilter destructor
//
//  Programmer: kbonnell -- generated by xml2avt
//  Creation:   Mon Apr 30 11:40:50 PDT 2007
//
//  Modifications:
//
// ****************************************************************************

avtCracksDensityFilter::~avtCracksDensityFilter()
{
}


// ****************************************************************************
//  Method:  avtCracksDensityFilter::Create
//
//  Programmer: kbonnell -- generated by xml2avt
//  Creation:   Mon Apr 30 11:40:50 PDT 2007
//
// ****************************************************************************

avtFilter *
avtCracksDensityFilter::Create()
{
    return new avtCracksDensityFilter();
}


// ****************************************************************************
//  Method:      avtCracksDensityFilter::SetAtts
//
//  Purpose:
//    Sets the state of the filter based on the attribute object.
//
//  Arguments:
//    a         The attributes to use.
//
//  Programmer: kbonnell -- generated by xml2avt
//  Creation:   Mon Apr 30 11:40:50 PDT 2007
//
// ****************************************************************************

void
avtCracksDensityFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const CracksClipperAttributes*)a;
}


// ****************************************************************************
//  Method: avtCracksDensityFilter::Equivalent
//
//  Purpose:
//    Returns true if creating a new avtCracksDensityFilter with the given
//    parameters would result in an equivalent avtCracksDensityFilter.
//
//  Programmer: kbonnell -- generated by xml2avt
//  Creation:   Mon Apr 30 11:40:50 PDT 2007
//
// ****************************************************************************

bool
avtCracksDensityFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(CracksClipperAttributes*)a);
}


// ****************************************************************************
//  Method: avtCracksDensityFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the CracksDensity filter.
//
//  Arguments:
//      in_ds      The input dataset.
//      <unused>   The domain number.
//      <unused>   The label.
//
//  Returns:       The output dataset.
//
//  Programmer: kbonnell -- generated by xml2avt
//  Creation:   Mon Apr 30 11:40:50 PDT 2007
//
// ****************************************************************************

vtkDataSet *
avtCracksDensityFilter::ExecuteData(vtkDataSet *in_ds, int, std::string)
{
    vtkFloatArray *vol = (vtkFloatArray*)(in_ds->GetCellData()->GetArray("ccvol"));
    if (vol == NULL)
    {
        avtCallback::IssueWarning("Could not find necessary volume data," 
            " cannot calculate density. This filter must be used in"
            " conjunction with avtCracksClipper");
        return in_ds; 
    } 

    vtkIntArray *coz = (vtkIntArray*)(in_ds->GetCellData()->GetArray("cracksOriginalZones"));
    if (coz == NULL)
    {
        avtCallback::IssueWarning("Could not find necessary original zones"
            " data, cannot calculate density.  This filter must be used in"
            " conjunction with avtCracksClipper");
        return in_ds; 
    }

    string massVar = atts.GetInMassVar();
    vtkFloatArray *ems = (vtkFloatArray*)(in_ds->GetCellData()->GetArray(massVar.c_str()));
    if (ems == NULL)
    {
        string msg = "Could not find mass varaible: " + massVar;
        msg += ".  Cannot calculate density.";
        avtCallback::IssueWarning(msg.c_str());
        return in_ds; 
    } 

    vtkIntArray *noc = (vtkIntArray*)(in_ds->GetFieldData()->GetArray("originalNumCells"));
    if (noc == NULL)
    {
        avtCallback::IssueWarning("Could not find necessary number of zones"
            " data, cannot calculate density.  This filter must be used in"
            " conjunction with avtCracksClipper");
        return in_ds; 
    }

    float *volp = (float*)vol->GetVoidPointer(0);
    float *emsp = (float*)ems->GetVoidPointer(0);
    int *cozp   = (int*)coz->GetVoidPointer(0);
    int numOriginalCells = noc->GetValue(0);
    int numNewCells = in_ds->GetNumberOfCells();


    // find the new volume of the original cells
    float *newVol = new float[numOriginalCells];
    int i;
    for (i = 0; i < numOriginalCells; i++)
    {
        newVol[i] = 0.f;
    }
    for (i = 0; i < numNewCells; i++)
    {
        newVol[cozp[i]] += volp[i];
    }

    vtkFloatArray *den = vtkFloatArray::New();
    den->SetNumberOfComponents(1);
    den->SetNumberOfTuples(numNewCells);
    den->SetName(atts.GetOutDenVar().c_str());

    float *volSum = new float[numNewCells];
    for (i = 0; i < numNewCells; i++)
    { 
        volSum[i] = newVol[cozp[i]]; 
    } 

    for (i = 0; i < numNewCells; i++)
    { 
        if (volSum[i] != 0.f)
            den->SetValue(i, emsp[i]/volSum[i]);
        else 
            den->SetValue(i, emsp[i]);
    } 

    delete [] newVol;
    delete [] volSum;

    vtkDataSet *rv = in_ds;
    rv->GetCellData()->AddArray(den);
    den->Delete();

    return rv;
}
