/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyCracksClipperAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyCracksClipperAttributes
//
// Purpose: 
//   Attributes for the cracks clipper operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 13:17:00 PST 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a CracksClipperAttributes.
//
struct CracksClipperAttributesObject
{
    PyObject_HEAD
    CracksClipperAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewCracksClipperAttributes(int);

std::string
PyCracksClipperAttributes_ToString(const CracksClipperAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%scrack1Var = \"%s\"\n", prefix, atts->GetCrack1Var().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scrack2Var = \"%s\"\n", prefix, atts->GetCrack2Var().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scrack3Var = \"%s\"\n", prefix, atts->GetCrack3Var().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstrainVar = \"%s\"\n", prefix, atts->GetStrainVar().c_str());
    str += tmpStr;
    if(atts->GetShowCrack1())
        SNPRINTF(tmpStr, 1000, "%sshowCrack1 = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowCrack1 = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowCrack2())
        SNPRINTF(tmpStr, 1000, "%sshowCrack2 = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowCrack2 = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowCrack3())
        SNPRINTF(tmpStr, 1000, "%sshowCrack3 = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowCrack3 = 0\n", prefix);
    str += tmpStr;
    if(atts->GetCalculateDensity())
        SNPRINTF(tmpStr, 1000, "%scalculateDensity = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scalculateDensity = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sinMassVar = \"%s\"\n", prefix, atts->GetInMassVar().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soutDenVar = \"%s\"\n", prefix, atts->GetOutDenVar().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
CracksClipperAttributes_Notify(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CracksClipperAttributes_SetCrack1Var(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the crack1Var in the object.
    obj->data->SetCrack1Var(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CracksClipperAttributes_GetCrack1Var(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCrack1Var().c_str());
    return retval;
}

/*static*/ PyObject *
CracksClipperAttributes_SetCrack2Var(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the crack2Var in the object.
    obj->data->SetCrack2Var(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CracksClipperAttributes_GetCrack2Var(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCrack2Var().c_str());
    return retval;
}

/*static*/ PyObject *
CracksClipperAttributes_SetCrack3Var(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the crack3Var in the object.
    obj->data->SetCrack3Var(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CracksClipperAttributes_GetCrack3Var(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCrack3Var().c_str());
    return retval;
}

/*static*/ PyObject *
CracksClipperAttributes_SetStrainVar(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the strainVar in the object.
    obj->data->SetStrainVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CracksClipperAttributes_GetStrainVar(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetStrainVar().c_str());
    return retval;
}

/*static*/ PyObject *
CracksClipperAttributes_SetShowCrack1(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showCrack1 in the object.
    obj->data->SetShowCrack1(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CracksClipperAttributes_GetShowCrack1(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowCrack1()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CracksClipperAttributes_SetShowCrack2(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showCrack2 in the object.
    obj->data->SetShowCrack2(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CracksClipperAttributes_GetShowCrack2(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowCrack2()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CracksClipperAttributes_SetShowCrack3(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showCrack3 in the object.
    obj->data->SetShowCrack3(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CracksClipperAttributes_GetShowCrack3(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowCrack3()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CracksClipperAttributes_SetCalculateDensity(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the calculateDensity in the object.
    obj->data->SetCalculateDensity(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CracksClipperAttributes_GetCalculateDensity(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCalculateDensity()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CracksClipperAttributes_SetInMassVar(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the inMassVar in the object.
    obj->data->SetInMassVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CracksClipperAttributes_GetInMassVar(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetInMassVar().c_str());
    return retval;
}

/*static*/ PyObject *
CracksClipperAttributes_SetOutDenVar(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the outDenVar in the object.
    obj->data->SetOutDenVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CracksClipperAttributes_GetOutDenVar(PyObject *self, PyObject *args)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOutDenVar().c_str());
    return retval;
}



static struct PyMethodDef CracksClipperAttributes_methods[] = {
    {"Notify", CracksClipperAttributes_Notify, METH_VARARGS},
    {"SetCrack1Var", CracksClipperAttributes_SetCrack1Var, METH_VARARGS},
    {"GetCrack1Var", CracksClipperAttributes_GetCrack1Var, METH_VARARGS},
    {"SetCrack2Var", CracksClipperAttributes_SetCrack2Var, METH_VARARGS},
    {"GetCrack2Var", CracksClipperAttributes_GetCrack2Var, METH_VARARGS},
    {"SetCrack3Var", CracksClipperAttributes_SetCrack3Var, METH_VARARGS},
    {"GetCrack3Var", CracksClipperAttributes_GetCrack3Var, METH_VARARGS},
    {"SetStrainVar", CracksClipperAttributes_SetStrainVar, METH_VARARGS},
    {"GetStrainVar", CracksClipperAttributes_GetStrainVar, METH_VARARGS},
    {"SetShowCrack1", CracksClipperAttributes_SetShowCrack1, METH_VARARGS},
    {"GetShowCrack1", CracksClipperAttributes_GetShowCrack1, METH_VARARGS},
    {"SetShowCrack2", CracksClipperAttributes_SetShowCrack2, METH_VARARGS},
    {"GetShowCrack2", CracksClipperAttributes_GetShowCrack2, METH_VARARGS},
    {"SetShowCrack3", CracksClipperAttributes_SetShowCrack3, METH_VARARGS},
    {"GetShowCrack3", CracksClipperAttributes_GetShowCrack3, METH_VARARGS},
    {"SetCalculateDensity", CracksClipperAttributes_SetCalculateDensity, METH_VARARGS},
    {"GetCalculateDensity", CracksClipperAttributes_GetCalculateDensity, METH_VARARGS},
    {"SetInMassVar", CracksClipperAttributes_SetInMassVar, METH_VARARGS},
    {"GetInMassVar", CracksClipperAttributes_GetInMassVar, METH_VARARGS},
    {"SetOutDenVar", CracksClipperAttributes_SetOutDenVar, METH_VARARGS},
    {"GetOutDenVar", CracksClipperAttributes_GetOutDenVar, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
CracksClipperAttributes_dealloc(PyObject *v)
{
   CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
CracksClipperAttributes_compare(PyObject *v, PyObject *w)
{
    CracksClipperAttributes *a = ((CracksClipperAttributesObject *)v)->data;
    CracksClipperAttributes *b = ((CracksClipperAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
CracksClipperAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "crack1Var") == 0)
        return CracksClipperAttributes_GetCrack1Var(self, NULL);
    if(strcmp(name, "crack2Var") == 0)
        return CracksClipperAttributes_GetCrack2Var(self, NULL);
    if(strcmp(name, "crack3Var") == 0)
        return CracksClipperAttributes_GetCrack3Var(self, NULL);
    if(strcmp(name, "strainVar") == 0)
        return CracksClipperAttributes_GetStrainVar(self, NULL);
    if(strcmp(name, "showCrack1") == 0)
        return CracksClipperAttributes_GetShowCrack1(self, NULL);
    if(strcmp(name, "showCrack2") == 0)
        return CracksClipperAttributes_GetShowCrack2(self, NULL);
    if(strcmp(name, "showCrack3") == 0)
        return CracksClipperAttributes_GetShowCrack3(self, NULL);
    if(strcmp(name, "calculateDensity") == 0)
        return CracksClipperAttributes_GetCalculateDensity(self, NULL);
    if(strcmp(name, "inMassVar") == 0)
        return CracksClipperAttributes_GetInMassVar(self, NULL);
    if(strcmp(name, "outDenVar") == 0)
        return CracksClipperAttributes_GetOutDenVar(self, NULL);

    return Py_FindMethod(CracksClipperAttributes_methods, self, name);
}

static int
CracksClipperAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "crack1Var") == 0)
        obj = CracksClipperAttributes_SetCrack1Var(self, tuple);
    else if(strcmp(name, "crack2Var") == 0)
        obj = CracksClipperAttributes_SetCrack2Var(self, tuple);
    else if(strcmp(name, "crack3Var") == 0)
        obj = CracksClipperAttributes_SetCrack3Var(self, tuple);
    else if(strcmp(name, "strainVar") == 0)
        obj = CracksClipperAttributes_SetStrainVar(self, tuple);
    else if(strcmp(name, "showCrack1") == 0)
        obj = CracksClipperAttributes_SetShowCrack1(self, tuple);
    else if(strcmp(name, "showCrack2") == 0)
        obj = CracksClipperAttributes_SetShowCrack2(self, tuple);
    else if(strcmp(name, "showCrack3") == 0)
        obj = CracksClipperAttributes_SetShowCrack3(self, tuple);
    else if(strcmp(name, "calculateDensity") == 0)
        obj = CracksClipperAttributes_SetCalculateDensity(self, tuple);
    else if(strcmp(name, "inMassVar") == 0)
        obj = CracksClipperAttributes_SetInMassVar(self, tuple);
    else if(strcmp(name, "outDenVar") == 0)
        obj = CracksClipperAttributes_SetOutDenVar(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
CracksClipperAttributes_print(PyObject *v, FILE *fp, int flags)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)v;
    fprintf(fp, "%s", PyCracksClipperAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
CracksClipperAttributes_str(PyObject *v)
{
    CracksClipperAttributesObject *obj = (CracksClipperAttributesObject *)v;
    return PyString_FromString(PyCracksClipperAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *CracksClipperAttributes_Purpose = "Attributes for the cracks clipper operator";
#else
static char *CracksClipperAttributes_Purpose = "Attributes for the cracks clipper operator";
#endif

//
// The type description structure
//
static PyTypeObject CracksClipperAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "CracksClipperAttributes",                    // tp_name
    sizeof(CracksClipperAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)CracksClipperAttributes_dealloc,  // tp_dealloc
    (printfunc)CracksClipperAttributes_print,     // tp_print
    (getattrfunc)CracksClipperAttributes_getattr, // tp_getattr
    (setattrfunc)CracksClipperAttributes_setattr, // tp_setattr
    (cmpfunc)CracksClipperAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)CracksClipperAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    CracksClipperAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static CracksClipperAttributes *defaultAtts = 0;
static CracksClipperAttributes *currentAtts = 0;

static PyObject *
NewCracksClipperAttributes(int useCurrent)
{
    CracksClipperAttributesObject *newObject;
    newObject = PyObject_NEW(CracksClipperAttributesObject, &CracksClipperAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new CracksClipperAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new CracksClipperAttributes(*defaultAtts);
    else
        newObject->data = new CracksClipperAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapCracksClipperAttributes(const CracksClipperAttributes *attr)
{
    CracksClipperAttributesObject *newObject;
    newObject = PyObject_NEW(CracksClipperAttributesObject, &CracksClipperAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (CracksClipperAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
CracksClipperAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewCracksClipperAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef CracksClipperAttributesMethods[] = {
    {"CracksClipperAttributes", CracksClipperAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *CracksClipperAttributesObserver = 0;

std::string
PyCracksClipperAttributes_GetLogString()
{
    std::string s("CracksClipperAtts = CracksClipperAttributes()\n");
    if(currentAtts != 0)
        s += PyCracksClipperAttributes_ToString(currentAtts, "CracksClipperAtts.");
    return s;
}

static void
PyCracksClipperAttributes_CallLogRoutine(Subject *subj, void *data)
{
    CracksClipperAttributes *atts = (CracksClipperAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("CracksClipperAtts = CracksClipperAttributes()\n");
        s += PyCracksClipperAttributes_ToString(currentAtts, "CracksClipperAtts.");
        cb(s);
    }
}

void
PyCracksClipperAttributes_StartUp(CracksClipperAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyCracksClipperAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(CracksClipperAttributesObserver == 0)
    {
        CracksClipperAttributesObserver = new ObserverToCallback(subj,
            PyCracksClipperAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyCracksClipperAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete CracksClipperAttributesObserver;
    CracksClipperAttributesObserver = 0;
}

PyMethodDef *
PyCracksClipperAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return CracksClipperAttributesMethods;
}

bool
PyCracksClipperAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &CracksClipperAttributesType);
}

CracksClipperAttributes *
PyCracksClipperAttributes_FromPyObject(PyObject *obj)
{
    CracksClipperAttributesObject *obj2 = (CracksClipperAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyCracksClipperAttributes_New()
{
    return NewCracksClipperAttributes(0);
}

PyObject *
PyCracksClipperAttributes_Wrap(const CracksClipperAttributes *attr)
{
    return WrapCracksClipperAttributes(attr);
}

void
PyCracksClipperAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    CracksClipperAttributesObject *obj2 = (CracksClipperAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyCracksClipperAttributes_SetDefaults(const CracksClipperAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new CracksClipperAttributes(*atts);
}

