/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyCoordSwap.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyCoordSwap
//
// Purpose: 
//   This class contains attributes for the coord swap operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Feb 2 15:47:40 PST 2005
//
// ****************************************************************************

//
// This struct contains the Python type information and a CoordSwap.
//
struct CoordSwapObject
{
    PyObject_HEAD
    CoordSwap *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewCoordSwap();

static PyObject *
CoordSwap_Notify(PyObject *self, PyObject *args)
{
    CoordSwapObject *obj = (CoordSwapObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CoordSwap_SetNewCoord1(PyObject *self, PyObject *args)
{
    CoordSwapObject *obj = (CoordSwapObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the newCoord1 in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetNewCoord1(CoordSwap::Coord(ival));
    else
    {
        fprintf(stderr, "An invalid newCoord1 value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Coord1, Coord2, Coord3.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CoordSwap_GetNewCoord1(PyObject *self, PyObject *args)
{
    CoordSwapObject *obj = (CoordSwapObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNewCoord1()));
    return retval;
}

static PyObject *
CoordSwap_SetNewCoord2(PyObject *self, PyObject *args)
{
    CoordSwapObject *obj = (CoordSwapObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the newCoord2 in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetNewCoord2(CoordSwap::Coord(ival));
    else
    {
        fprintf(stderr, "An invalid newCoord2 value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Coord1, Coord2, Coord3.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CoordSwap_GetNewCoord2(PyObject *self, PyObject *args)
{
    CoordSwapObject *obj = (CoordSwapObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNewCoord2()));
    return retval;
}

static PyObject *
CoordSwap_SetNewCoord3(PyObject *self, PyObject *args)
{
    CoordSwapObject *obj = (CoordSwapObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the newCoord3 in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetNewCoord3(CoordSwap::Coord(ival));
    else
    {
        fprintf(stderr, "An invalid newCoord3 value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Coord1, Coord2, Coord3.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CoordSwap_GetNewCoord3(PyObject *self, PyObject *args)
{
    CoordSwapObject *obj = (CoordSwapObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNewCoord3()));
    return retval;
}



static struct PyMethodDef CoordSwap_methods[] = {
    {"Notify", CoordSwap_Notify, METH_VARARGS},
    {"SetNewCoord1", CoordSwap_SetNewCoord1, METH_VARARGS},
    {"GetNewCoord1", CoordSwap_GetNewCoord1, METH_VARARGS},
    {"SetNewCoord2", CoordSwap_SetNewCoord2, METH_VARARGS},
    {"GetNewCoord2", CoordSwap_GetNewCoord2, METH_VARARGS},
    {"SetNewCoord3", CoordSwap_SetNewCoord3, METH_VARARGS},
    {"GetNewCoord3", CoordSwap_GetNewCoord3, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
CoordSwap_dealloc(PyObject *v)
{
   CoordSwapObject *obj = (CoordSwapObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
CoordSwap_compare(PyObject *v, PyObject *w)
{
    CoordSwap *a = ((CoordSwapObject *)v)->data;
    CoordSwap *b = ((CoordSwapObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
CoordSwap_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "newCoord1") == 0)
        return CoordSwap_GetNewCoord1(self, NULL);
    if(strcmp(name, "Coord1") == 0)
        return PyInt_FromLong(long(CoordSwap::Coord1));
    else if(strcmp(name, "Coord2") == 0)
        return PyInt_FromLong(long(CoordSwap::Coord2));
    else if(strcmp(name, "Coord3") == 0)
        return PyInt_FromLong(long(CoordSwap::Coord3));

    if(strcmp(name, "newCoord2") == 0)
        return CoordSwap_GetNewCoord2(self, NULL);
    if(strcmp(name, "Coord1") == 0)
        return PyInt_FromLong(long(CoordSwap::Coord1));
    else if(strcmp(name, "Coord2") == 0)
        return PyInt_FromLong(long(CoordSwap::Coord2));
    else if(strcmp(name, "Coord3") == 0)
        return PyInt_FromLong(long(CoordSwap::Coord3));

    if(strcmp(name, "newCoord3") == 0)
        return CoordSwap_GetNewCoord3(self, NULL);
    if(strcmp(name, "Coord1") == 0)
        return PyInt_FromLong(long(CoordSwap::Coord1));
    else if(strcmp(name, "Coord2") == 0)
        return PyInt_FromLong(long(CoordSwap::Coord2));
    else if(strcmp(name, "Coord3") == 0)
        return PyInt_FromLong(long(CoordSwap::Coord3));


    return Py_FindMethod(CoordSwap_methods, self, name);
}

static int
CoordSwap_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "newCoord1") == 0)
        retval = (CoordSwap_SetNewCoord1(self, tuple) != NULL);
    else if(strcmp(name, "newCoord2") == 0)
        retval = (CoordSwap_SetNewCoord2(self, tuple) != NULL);
    else if(strcmp(name, "newCoord3") == 0)
        retval = (CoordSwap_SetNewCoord3(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
CoordSwap_print(PyObject *v, FILE *fp, int flags)
{
    CoordSwapObject *obj = (CoordSwapObject *)v;

    const char *newCoord1_names = "Coord1, Coord2, Coord3";
    if(obj->data->GetNewCoord1() == CoordSwap::Coord1)
        fprintf(fp, "newCoord1 = Coord1  # %s\n", newCoord1_names);
    else if(obj->data->GetNewCoord1() == CoordSwap::Coord2)
        fprintf(fp, "newCoord1 = Coord2  # %s\n", newCoord1_names);
    else
        fprintf(fp, "newCoord1 = Coord3  # %s\n", newCoord1_names);

    const char *newCoord2_names = "Coord1, Coord2, Coord3";
    if(obj->data->GetNewCoord2() == CoordSwap::Coord1)
        fprintf(fp, "newCoord2 = Coord1  # %s\n", newCoord2_names);
    else if(obj->data->GetNewCoord2() == CoordSwap::Coord2)
        fprintf(fp, "newCoord2 = Coord2  # %s\n", newCoord2_names);
    else
        fprintf(fp, "newCoord2 = Coord3  # %s\n", newCoord2_names);

    const char *newCoord3_names = "Coord1, Coord2, Coord3";
    if(obj->data->GetNewCoord3() == CoordSwap::Coord1)
        fprintf(fp, "newCoord3 = Coord1  # %s\n", newCoord3_names);
    else if(obj->data->GetNewCoord3() == CoordSwap::Coord2)
        fprintf(fp, "newCoord3 = Coord2  # %s\n", newCoord3_names);
    else
        fprintf(fp, "newCoord3 = Coord3  # %s\n", newCoord3_names);


    return 0;
}

#include <snprintf.h>
PyObject *
PyCoordSwap_StringRepresentation(const CoordSwap *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    const char *newCoord1_names = "Coord1, Coord2, Coord3";
    if(atts->GetNewCoord1() == CoordSwap::Coord1)
        {
             SNPRINTF(tmpStr, 1000, "newCoord1 = Coord1  # %s\n", newCoord1_names);
             str += tmpStr;
        }
    else if(atts->GetNewCoord1() == CoordSwap::Coord2)
        {
             SNPRINTF(tmpStr, 1000, "newCoord1 = Coord2  # %s\n", newCoord1_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "newCoord1 = Coord3  # %s\n", newCoord1_names);
             str += tmpStr;
        }

    const char *newCoord2_names = "Coord1, Coord2, Coord3";
    if(atts->GetNewCoord2() == CoordSwap::Coord1)
        {
             SNPRINTF(tmpStr, 1000, "newCoord2 = Coord1  # %s\n", newCoord2_names);
             str += tmpStr;
        }
    else if(atts->GetNewCoord2() == CoordSwap::Coord2)
        {
             SNPRINTF(tmpStr, 1000, "newCoord2 = Coord2  # %s\n", newCoord2_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "newCoord2 = Coord3  # %s\n", newCoord2_names);
             str += tmpStr;
        }

    const char *newCoord3_names = "Coord1, Coord2, Coord3";
    if(atts->GetNewCoord3() == CoordSwap::Coord1)
        {
             SNPRINTF(tmpStr, 1000, "newCoord3 = Coord1  # %s\n", newCoord3_names);
             str += tmpStr;
        }
    else if(atts->GetNewCoord3() == CoordSwap::Coord2)
        {
             SNPRINTF(tmpStr, 1000, "newCoord3 = Coord2  # %s\n", newCoord3_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "newCoord3 = Coord3  # %s\n", newCoord3_names);
             str += tmpStr;
        }

    return PyString_FromString(str.c_str());
}

static PyObject *
CoordSwap_str(PyObject *v)
{
    CoordSwapObject *obj = (CoordSwapObject *)v;
    return PyCoordSwap_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *CoordSwap_Purpose = "This class contains attributes for the coord swap operator.";

//
// The type description structure
//
static PyTypeObject CoordSwapType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "CoordSwap",                    // tp_name
    sizeof(CoordSwapObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)CoordSwap_dealloc,  // tp_dealloc
    (printfunc)CoordSwap_print,     // tp_print
    (getattrfunc)CoordSwap_getattr, // tp_getattr
    (setattrfunc)CoordSwap_setattr, // tp_setattr
    (cmpfunc)CoordSwap_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)CoordSwap_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    CoordSwap_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static CoordSwap *defaultAtts = 0;

static PyObject *
NewCoordSwap()
{
    CoordSwapObject *newObject;
    newObject = PyObject_NEW(CoordSwapObject, &CoordSwapType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new CoordSwap(*defaultAtts);
    else
        newObject->data = new CoordSwap;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapCoordSwap(const CoordSwap *attr)
{
    CoordSwapObject *newObject;
    newObject = PyObject_NEW(CoordSwapObject, &CoordSwapType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (CoordSwap *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
CoordSwap_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewCoordSwap();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef CoordSwapMethods[] = {
    {"CoordSwap", CoordSwap_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *CoordSwapObserver = 0;
static bool CoordSwapEnableLogging = true;

static void
PyCoordSwap_WriteLog(Subject *subj, void *data)
{
    CoordSwap *atts = (CoordSwap *)subj;
    FILE *logFile = (FILE *)data;

    if(!CoordSwapEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# CoordSwap_WriteLog()\n");
}

void
PyCoordSwap_StartUp(CoordSwap *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyCoordSwap_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(CoordSwapObserver == 0)
    {
        CoordSwapObserver = new ObserverToCallback(subj,
            PyCoordSwap_WriteLog, (void *)logFile);
    }

    CoordSwapEnableLogging = true;
}

void
PyCoordSwap_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete CoordSwapObserver;
    CoordSwapObserver = 0;
}

PyMethodDef *
PyCoordSwap_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return CoordSwapMethods;
}

bool
PyCoordSwap_Check(PyObject *obj)
{
    return (obj->ob_type == &CoordSwapType);
}

CoordSwap *
PyCoordSwap_FromPyObject(PyObject *obj)
{
    CoordSwapObject *obj2 = (CoordSwapObject *)obj;
    return obj2->data;
}

PyObject *
PyCoordSwap_NewPyObject()
{
    return NewCoordSwap();
}

PyObject *
PyCoordSwap_WrapPyObject(const CoordSwap *attr)
{
    return WrapCoordSwap(attr);
}

void
PyCoordSwap_SetLogging(bool val)
{
    CoordSwapEnableLogging = val;
}

void
PyCoordSwap_SetDefaults(const CoordSwap *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new CoordSwap(*atts);
}

