/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtContextFilter.C
// ************************************************************************* //

#include <avtContextFilter.h>

#include <vtkCellData.h>
#include <vtkDataSet.h>
#include <vtkFloatArray.h>
#include <vtkPointData.h>

#include <NoInputException.h>


// ****************************************************************************
//  Method: avtContextFilter constructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
// ****************************************************************************

avtContextFilter::avtContextFilter()
{
}


// ****************************************************************************
//  Method: avtContextFilter destructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
//  Modifications:
//
// ****************************************************************************

avtContextFilter::~avtContextFilter()
{
}


// ****************************************************************************
//  Method:  avtContextFilter::Create
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
// ****************************************************************************

avtFilter *
avtContextFilter::Create()
{
    return new avtContextFilter();
}


// ****************************************************************************
//  Method:      avtContextFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
// ****************************************************************************

void
avtContextFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const ContextAttributes*)a;
}


// ****************************************************************************
//  Method: avtContextFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtContextFilter with the given
//      parameters would result in an equivalent avtContextFilter.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
// ****************************************************************************

bool
avtContextFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(ContextAttributes*)a);
}


// ****************************************************************************
//  Method: avtContextFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the Context filter.
//
//  Arguments:
//      in_ds      The input dataset.
//      <unused>   The domain number.
//      <unused>   The label.
//
//  Returns:       The output dataset.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Dec 21 14:23:41 PST 2001
//
//  Modifications:
//    Kathleen Bonnell, Fri Feb  8 11:03:49 PST 2002
//    vtkScalars has been deprecated in VTK 4.0, use vtkDataArray 
//    and vtkFloatArray instead.
//
//    Kathleen Bonnell, Fri Dec 13 16:41:12 PST 2002   
//    Use NewInstance instead of MakeObject in order to match vtk's new api. 
//    
// ****************************************************************************

vtkDataSet *
avtContextFilter::ExecuteData(vtkDataSet *in_ds, int, std::string)
{
    bool pointvar = false;
    vtkDataArray *primaryVar = in_ds->GetPointData()->GetScalars();
    if (primaryVar == NULL)
    {
        primaryVar = in_ds->GetCellData()->GetScalars();
    }
    else
    {
        pointvar = true;
    }

    if (primaryVar == NULL)
    {
        EXCEPTION0(NoInputException);
    }

    const char *contextVarName = atts.GetContext().c_str();
    vtkDataArray *contextVar = in_ds->GetPointData()->GetArray(contextVarName);
    bool contextPointVar = false;
    if (contextVar == NULL)
    {
        contextVar = in_ds->GetCellData()->GetArray(contextVarName);
    }
    else
    {
        contextPointVar = true;
    } 

    if (contextVar == NULL)
    {
        EXCEPTION0(NoInputException);
    }

    if (pointvar != contextPointVar)
    {
        cerr << "Currently unhandled case" << endl;
        return NULL;
    }

    int numVals;
    if (pointvar)
    {
        numVals = in_ds->GetNumberOfPoints();
    }
    else
    {
        numVals = in_ds->GetNumberOfCells();
    }

    vtkFloatArray *outVar = vtkFloatArray::New();
    outVar->SetNumberOfTuples(numVals);
    outVar->SetName(primaryVar->GetName());
    for (int i = 0 ; i < numVals ; i++)
    {
        float val = primaryVar->GetTuple1(i);
        if (val >= atts.GetLow() && val <= atts.GetHi())
        {
            outVar->SetTuple1(i, val + atts.GetOffset());
        }
        else
        {
            float cVal = contextVar->GetTuple1(i);
            if (cVal < atts.GetCutoff())
            {
                outVar->SetTuple1(i, atts.GetBelow());
            }
            else
            {
                outVar->SetTuple1(i, atts.GetAbove());
            }
        }
    }

    vtkDataSet *out_ds = (vtkDataSet *) in_ds->NewInstance();
    out_ds->ShallowCopy(in_ds);
    if (pointvar)
    {
        out_ds->GetPointData()->SetScalars(outVar);
    }
    else
    {
        out_ds->GetCellData()->SetScalars(outVar);
    }

    outVar->Delete();

    return out_ds;
}


// ****************************************************************************
//  Method: avtContextFilter::ModifyContract
//
//  Purpose:
//      Adds the secondary variable we are interested in to the pipeline.
//
//  Programmer: Hank Childs
//  Creation:   December 21, 2001
//
// **************************************************************************** 

avtContract_p
avtContextFilter::ModifyContract(avtContract_p spec)
{
    avtDataRequest_p ds = spec->GetDataRequest();
    ds->AddSecondaryVariable(atts.GetContext().c_str());
    return spec;
}


