/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ConnCompReduceAttributes.h>
#include <DataNode.h>

// Type map format string
const char *ConnCompReduceAttributes::TypeMapFormatString = "d";

// ****************************************************************************
// Method: ConnCompReduceAttributes::ConnCompReduceAttributes
//
// Purpose: 
//   Constructor for the ConnCompReduceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ConnCompReduceAttributes::ConnCompReduceAttributes() : 
    AttributeSubject(ConnCompReduceAttributes::TypeMapFormatString)
{
    target = 0.1;
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::ConnCompReduceAttributes
//
// Purpose: 
//   Copy constructor for the ConnCompReduceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ConnCompReduceAttributes::ConnCompReduceAttributes(const ConnCompReduceAttributes &obj) : 
    AttributeSubject(ConnCompReduceAttributes::TypeMapFormatString)
{
    target = obj.target;

    SelectAll();
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::~ConnCompReduceAttributes
//
// Purpose: 
//   Destructor for the ConnCompReduceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ConnCompReduceAttributes::~ConnCompReduceAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ConnCompReduceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ConnCompReduceAttributes& 
ConnCompReduceAttributes::operator = (const ConnCompReduceAttributes &obj)
{
    if (this == &obj) return *this;
    target = obj.target;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ConnCompReduceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ConnCompReduceAttributes::operator == (const ConnCompReduceAttributes &obj) const
{
    // Create the return value
    return ((target == obj.target));
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ConnCompReduceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ConnCompReduceAttributes::operator != (const ConnCompReduceAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::TypeName
//
// Purpose: 
//   Type name method for the ConnCompReduceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ConnCompReduceAttributes::TypeName() const
{
    return "ConnCompReduceAttributes";
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ConnCompReduceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ConnCompReduceAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ConnCompReduceAttributes *tmp = (const ConnCompReduceAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ConnCompReduceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ConnCompReduceAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ConnCompReduceAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ConnCompReduceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ConnCompReduceAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ConnCompReduceAttributes(*this);
    else
        retval = new ConnCompReduceAttributes;

    return retval;
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ConnCompReduceAttributes::SelectAll()
{
    Select(ID_target, (void *)&target);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ConnCompReduceAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ConnCompReduceAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ConnCompReduceAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ConnCompReduceAttributes.
    DataNode *node = new DataNode("ConnCompReduceAttributes");

    if(completeSave || !FieldsEqual(ID_target, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("target", target));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ConnCompReduceAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ConnCompReduceAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("target")) != 0)
        SetTarget(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ConnCompReduceAttributes::SetTarget(double target_)
{
    target = target_;
    Select(ID_target, (void *)&target);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

double
ConnCompReduceAttributes::GetTarget() const
{
    return target;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ConnCompReduceAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ConnCompReduceAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_target: return "target";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ConnCompReduceAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_target: return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ConnCompReduceAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_target: return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ConnCompReduceAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ConnCompReduceAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ConnCompReduceAttributes &obj = *((const ConnCompReduceAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_target:
        {  // new scope
        retval = (target == obj.target);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

