/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#ifndef CONEATTRIBUTES_H
#define CONEATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: ConeAttributes
//
// Purpose:
//    This class contains attributes for the cone operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class ConeAttributes : public AttributeSubject
{
public:
    enum Representation
    {
        ThreeD,
        Flattened,
        R_Theta
    };

    ConeAttributes();
    ConeAttributes(const ConeAttributes &obj);
    virtual ~ConeAttributes();

    virtual ConeAttributes& operator = (const ConeAttributes &obj);
    virtual bool operator == (const ConeAttributes &obj) const;
    virtual bool operator != (const ConeAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectOrigin();
    void SelectNormal();
    void SelectUpAxis();

    // Property setting methods
    void SetAngle(double angle_);
    void SetOrigin(const double *origin_);
    void SetNormal(const double *normal_);
    void SetRepresentation(Representation representation_);
    void SetUpAxis(const double *upAxis_);
    void SetCutByLength(bool cutByLength_);
    void SetLength(double length_);

    // Property getting methods
    double       GetAngle() const;
    const double *GetOrigin() const;
          double *GetOrigin();
    const double *GetNormal() const;
          double *GetNormal();
    Representation GetRepresentation() const;
    const double *GetUpAxis() const;
          double *GetUpAxis();
    bool         GetCutByLength() const;
    double       GetLength() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Representation_ToString(Representation);
    static bool Representation_FromString(const std::string &, Representation &);
protected:
    static std::string Representation_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_angle = 0,
        ID_origin,
        ID_normal,
        ID_representation,
        ID_upAxis,
        ID_cutByLength,
        ID_length
    };

private:
    double angle;
    double origin[3];
    double normal[3];
    int    representation;
    double upAxis[3];
    bool   cutByLength;
    double length;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
};

#endif
