/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisBoxWindow.h"

#include <BoxAttributes.h>
#include <ViewerProxy.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QSpinBox>
#include <QButtonGroup>
#include <QRadioButton>
#include <QvisColorTableButton.h>
#include <QvisOpacitySlider.h>
#include <QvisColorButton.h>
#include <QvisLineStyleWidget.h>
#include <QvisLineWidthWidget.h>
#include <QvisVariableButton.h>

#include <stdio.h>
#include <string>

using std::string;

// ****************************************************************************
// Method: QvisBoxWindow::QvisBoxWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisBoxWindow::QvisBoxWindow(const int type,
                         BoxAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisBoxWindow::~QvisBoxWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisBoxWindow::~QvisBoxWindow()
{
}


// ****************************************************************************
// Method: QvisBoxWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisBoxWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    amountLabel = new QLabel(tr("Amount of cell in the range"), central);
    mainLayout->addWidget(amountLabel,0,0);
    amount = new QWidget(central);
    amountButtonGroup= new QButtonGroup(amount);
    QHBoxLayout *amountLayout = new QHBoxLayout(amount);
    amountLayout->setMargin(0);
    amountLayout->setSpacing(10);
    QRadioButton *amountAmountSome = new QRadioButton(tr("Some"), amount);
    amountButtonGroup->addButton(amountAmountSome,0);
    amountLayout->addWidget(amountAmountSome);
    QRadioButton *amountAmountAll = new QRadioButton(tr("All"), amount);
    amountButtonGroup->addButton(amountAmountAll,1);
    amountLayout->addWidget(amountAmountAll);
    connect(amountButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(amountChanged(int)));
    mainLayout->addWidget(amount, 0,1);

    minxLabel = new QLabel(tr("X-Minimum"), central);
    mainLayout->addWidget(minxLabel,1,0);
    minx = new QLineEdit(central);
    connect(minx, SIGNAL(returnPressed()),
            this, SLOT(minxProcessText()));
    mainLayout->addWidget(minx, 1,1);

    maxxLabel = new QLabel(tr("X-Maximum"), central);
    mainLayout->addWidget(maxxLabel,2,0);
    maxx = new QLineEdit(central);
    connect(maxx, SIGNAL(returnPressed()),
            this, SLOT(maxxProcessText()));
    mainLayout->addWidget(maxx, 2,1);

    minyLabel = new QLabel(tr("Y-Minimum"), central);
    mainLayout->addWidget(minyLabel,3,0);
    miny = new QLineEdit(central);
    connect(miny, SIGNAL(returnPressed()),
            this, SLOT(minyProcessText()));
    mainLayout->addWidget(miny, 3,1);

    maxyLabel = new QLabel(tr("Y-Maximum"), central);
    mainLayout->addWidget(maxyLabel,4,0);
    maxy = new QLineEdit(central);
    connect(maxy, SIGNAL(returnPressed()),
            this, SLOT(maxyProcessText()));
    mainLayout->addWidget(maxy, 4,1);

    minzLabel = new QLabel(tr("Z-Minimum"), central);
    mainLayout->addWidget(minzLabel,5,0);
    minz = new QLineEdit(central);
    connect(minz, SIGNAL(returnPressed()),
            this, SLOT(minzProcessText()));
    mainLayout->addWidget(minz, 5,1);

    maxzLabel = new QLabel(tr("Z-Maximum"), central);
    mainLayout->addWidget(maxzLabel,6,0);
    maxz = new QLineEdit(central);
    connect(maxz, SIGNAL(returnPressed()),
            this, SLOT(maxzProcessText()));
    mainLayout->addWidget(maxz, 6,1);

}


// ****************************************************************************
// Method: QvisBoxWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisBoxWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case BoxAttributes::ID_amount:
            amountButtonGroup->blockSignals(true);
            if(amountButtonGroup->button((int)atts->GetAmount()) != 0)
                amountButtonGroup->button((int)atts->GetAmount())->setChecked(true);
            amountButtonGroup->blockSignals(false);
            break;
          case BoxAttributes::ID_minx:
            minx->setText(DoubleToQString(atts->GetMinx()));
            break;
          case BoxAttributes::ID_maxx:
            maxx->setText(DoubleToQString(atts->GetMaxx()));
            break;
          case BoxAttributes::ID_miny:
            miny->setText(DoubleToQString(atts->GetMiny()));
            break;
          case BoxAttributes::ID_maxy:
            maxy->setText(DoubleToQString(atts->GetMaxy()));
            break;
          case BoxAttributes::ID_minz:
            minz->setText(DoubleToQString(atts->GetMinz()));
            break;
          case BoxAttributes::ID_maxz:
            maxz->setText(DoubleToQString(atts->GetMaxz()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisBoxWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisBoxWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do minx
    if(which_widget == BoxAttributes::ID_minx || doAll)
    {
        double val;
        if(LineEditGetDouble(minx, val))
            atts->SetMinx(val);
        else
        {
            ResettingError(tr("X-Minimum"),
                DoubleToQString(atts->GetMinx()));
            atts->SetMinx(atts->GetMinx());
        }
    }

    // Do maxx
    if(which_widget == BoxAttributes::ID_maxx || doAll)
    {
        double val;
        if(LineEditGetDouble(maxx, val))
            atts->SetMaxx(val);
        else
        {
            ResettingError(tr("X-Maximum"),
                DoubleToQString(atts->GetMaxx()));
            atts->SetMaxx(atts->GetMaxx());
        }
    }

    // Do miny
    if(which_widget == BoxAttributes::ID_miny || doAll)
    {
        double val;
        if(LineEditGetDouble(miny, val))
            atts->SetMiny(val);
        else
        {
            ResettingError(tr("Y-Minimum"),
                DoubleToQString(atts->GetMiny()));
            atts->SetMiny(atts->GetMiny());
        }
    }

    // Do maxy
    if(which_widget == BoxAttributes::ID_maxy || doAll)
    {
        double val;
        if(LineEditGetDouble(maxy, val))
            atts->SetMaxy(val);
        else
        {
            ResettingError(tr("Y-Maximum"),
                DoubleToQString(atts->GetMaxy()));
            atts->SetMaxy(atts->GetMaxy());
        }
    }

    // Do minz
    if(which_widget == BoxAttributes::ID_minz || doAll)
    {
        double val;
        if(LineEditGetDouble(minz, val))
            atts->SetMinz(val);
        else
        {
            ResettingError(tr("Z-Minimum"),
                DoubleToQString(atts->GetMinz()));
            atts->SetMinz(atts->GetMinz());
        }
    }

    // Do maxz
    if(which_widget == BoxAttributes::ID_maxz || doAll)
    {
        double val;
        if(LineEditGetDouble(maxz, val))
            atts->SetMaxz(val);
        else
        {
            ResettingError(tr("Z-Maximum"),
                DoubleToQString(atts->GetMaxz()));
            atts->SetMaxz(atts->GetMaxz());
        }
    }

}


//
// Qt Slot functions
//


void
QvisBoxWindow::amountChanged(int val)
{
    if(val != atts->GetAmount())
    {
        atts->SetAmount(BoxAttributes::Amount(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisBoxWindow::minxProcessText()
{
    GetCurrentValues(BoxAttributes::ID_minx);
    Apply();
}


void
QvisBoxWindow::maxxProcessText()
{
    GetCurrentValues(BoxAttributes::ID_maxx);
    Apply();
}


void
QvisBoxWindow::minyProcessText()
{
    GetCurrentValues(BoxAttributes::ID_miny);
    Apply();
}


void
QvisBoxWindow::maxyProcessText()
{
    GetCurrentValues(BoxAttributes::ID_maxy);
    Apply();
}


void
QvisBoxWindow::minzProcessText()
{
    GetCurrentValues(BoxAttributes::ID_minz);
    Apply();
}


void
QvisBoxWindow::maxzProcessText()
{
    GetCurrentValues(BoxAttributes::ID_maxz);
    Apply();
}


