/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtBoundaryOpFilter.C
// ************************************************************************* //

#include <avtBoundaryOpFilter.h>


// ****************************************************************************
//  Method: avtBoundaryOpFilter constructor
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
// ****************************************************************************

avtBoundaryOpFilter::avtBoundaryOpFilter()
{
}


// ****************************************************************************
//  Method: avtBoundaryOpFilter destructor
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
//  Modifications:
//
// ****************************************************************************

avtBoundaryOpFilter::~avtBoundaryOpFilter()
{
}


// ****************************************************************************
//  Method:  avtBoundaryOpFilter::Create
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
// ****************************************************************************

avtFilter *
avtBoundaryOpFilter::Create()
{
    return new avtBoundaryOpFilter();
}


// ****************************************************************************
//  Method:      avtBoundaryOpFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
// ****************************************************************************

void
avtBoundaryOpFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const BoundaryOpAttributes*)a;
}


// ****************************************************************************
//  Method: avtBoundaryOpFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtBoundaryOpFilter with the given
//      parameters would result in an equivalent avtBoundaryOpFilter.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
// ****************************************************************************

bool
avtBoundaryOpFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(BoundaryOpAttributes*)a);
}


// ****************************************************************************
//  Method: avtBoundaryOpFilter::ExecuteData
//
//  Purpose:
//      Return input data set, which due to contract modifications alreay
//      corresponds to the material interface, performing additional
//      smoothing if necessary.
//
//  Arguments:
//      in_ds      The input dataset.
//      domain_no  The domain number.
//      label      The label.
//
//  Returns:       The output dataset.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
// ****************************************************************************

vtkDataSet *
avtBoundaryOpFilter::ExecuteData(vtkDataSet *in_ds, int domain_no, std::string label)
{
    if (atts.GetSmoothingLevel() > 0)
    {
        SetSmoothingLevel(atts.GetSmoothingLevel());
        return avtSmoothPolyDataFilter::ExecuteData(in_ds, domain_no, label);
    }
    else
    {
        return in_ds;
    }
}


// ****************************************************************************
//  Method: avtBoundaryOpFilter::PerformRestricition
//
//  Purpose:
//      Modify contract to request material interface reconstruction.
//
//  Arguments:
//      in_contract  Original contract
//
//  Returns:         Modified contract.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
// ****************************************************************************

avtContract_p
avtBoundaryOpFilter::ModifyContract(avtContract_p in_contract)
{
    avtContract_p out_contract =
       new avtContract(in_contract);

    out_contract->GetDataRequest()->ForceMaterialInterfaceReconstructionOn();
    out_contract->GetDataRequest()->TurnBoundarySurfaceRepresentationOn();

    return out_contract;
}
