/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <BoundaryOpAttributes.h>
#include <DataNode.h>

// Type map format string
const char *BoundaryOpAttributes::TypeMapFormatString = "i";

// ****************************************************************************
// Method: BoundaryOpAttributes::BoundaryOpAttributes
//
// Purpose: 
//   Constructor for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

BoundaryOpAttributes::BoundaryOpAttributes() : 
    AttributeSubject(BoundaryOpAttributes::TypeMapFormatString)
{
    smoothingLevel = 0;
}

// ****************************************************************************
// Method: BoundaryOpAttributes::BoundaryOpAttributes
//
// Purpose: 
//   Copy constructor for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

BoundaryOpAttributes::BoundaryOpAttributes(const BoundaryOpAttributes &obj) : 
    AttributeSubject(BoundaryOpAttributes::TypeMapFormatString)
{
    smoothingLevel = obj.smoothingLevel;

    SelectAll();
}

// ****************************************************************************
// Method: BoundaryOpAttributes::~BoundaryOpAttributes
//
// Purpose: 
//   Destructor for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

BoundaryOpAttributes::~BoundaryOpAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: BoundaryOpAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

BoundaryOpAttributes& 
BoundaryOpAttributes::operator = (const BoundaryOpAttributes &obj)
{
    if (this == &obj) return *this;
    smoothingLevel = obj.smoothingLevel;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: BoundaryOpAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
BoundaryOpAttributes::operator == (const BoundaryOpAttributes &obj) const
{
    // Create the return value
    return ((smoothingLevel == obj.smoothingLevel));
}

// ****************************************************************************
// Method: BoundaryOpAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
BoundaryOpAttributes::operator != (const BoundaryOpAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: BoundaryOpAttributes::TypeName
//
// Purpose: 
//   Type name method for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
BoundaryOpAttributes::TypeName() const
{
    return "BoundaryOpAttributes";
}

// ****************************************************************************
// Method: BoundaryOpAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
BoundaryOpAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const BoundaryOpAttributes *tmp = (const BoundaryOpAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: BoundaryOpAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
BoundaryOpAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new BoundaryOpAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: BoundaryOpAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
BoundaryOpAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new BoundaryOpAttributes(*this);
    else
        retval = new BoundaryOpAttributes;

    return retval;
}

// ****************************************************************************
// Method: BoundaryOpAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
BoundaryOpAttributes::SelectAll()
{
    Select(ID_smoothingLevel, (void *)&smoothingLevel);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: BoundaryOpAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
BoundaryOpAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    BoundaryOpAttributes defaultObject;
    bool addToParent = false;
    // Create a node for BoundaryOpAttributes.
    DataNode *node = new DataNode("BoundaryOpAttributes");

    if(completeSave || !FieldsEqual(ID_smoothingLevel, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("smoothingLevel", smoothingLevel));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: BoundaryOpAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
BoundaryOpAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("BoundaryOpAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("smoothingLevel")) != 0)
        SetSmoothingLevel(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
BoundaryOpAttributes::SetSmoothingLevel(int smoothingLevel_)
{
    smoothingLevel = smoothingLevel_;
    Select(ID_smoothingLevel, (void *)&smoothingLevel);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
BoundaryOpAttributes::GetSmoothingLevel() const
{
    return smoothingLevel;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: BoundaryOpAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
BoundaryOpAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_smoothingLevel: return "smoothingLevel";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: BoundaryOpAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
BoundaryOpAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_smoothingLevel: return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: BoundaryOpAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
BoundaryOpAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_smoothingLevel: return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: BoundaryOpAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
BoundaryOpAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const BoundaryOpAttributes &obj = *((const BoundaryOpAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_smoothingLevel:
        {  // new scope
        retval = (smoothingLevel == obj.smoothingLevel);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

