/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <stdio.h>
#include <string>

// ****************************************************************************
// Function: main
//
// Purpose:
//   Writes out a Java class that contains VisIt's version number. The class
//   is autogenerated so we don't have to keep doing it by hand.
//
// Notes:      
//
// Programmer: Brad Whitlock
// Creation:   Wed Aug 21 12:24:23 PDT 2002
//
// Modifications:
//   Brad Whitlock, Thu Nov 19 16:44:51 PST 2009
//   Get the input and output file from the command line.
//
// ****************************************************************************

int
main(int argc, char *argv[])
{
    FILE *fp = NULL;
    int i, reached_end = 0, retval = 1;

    if(argc != 3)
    {
        fprintf(stderr, "Usage: %s versionfile outputfile\n", argv[0]);
        return -1;
    }

    std::string ver("2.0");
    if((fp = fopen(argv[1], "rt")) != NULL)
    {
        char s[2] = {'\0', '\0'};
        ver = "";
        while(!feof(fp))
        {
            s[0] = (char)fgetc(fp);
            if(s[0] != '\n')
                ver += s;
            else
                break;
        }
        fclose(fp);
    }
        
    // Open the file and write the Java class.
    if((fp = fopen(argv[2], "wt")) != NULL)
    {
        printf("Writing Version.java\n");
        fprintf(fp, "package llnl.visit;\n");
        fprintf(fp, "\n");
        fprintf(fp, "// ****************************************************************************\n");
        fprintf(fp, "// Class: Version\n");
        fprintf(fp, "//\n");
        fprintf(fp, "// Purpose:\n");
        fprintf(fp, "//   This automatically generated class contains VisIt's version.\n");
        fprintf(fp, "//\n");
        fprintf(fp, "// ****************************************************************************\n");
        fprintf(fp, "\n");
        fprintf(fp, "public class Version\n");
        fprintf(fp, "{\n");
        fprintf(fp, "    public final static byte[] version = {");

        // Print the characters of the version string.
        for(i = 0; i < 10; ++i)
        {
            if(reached_end)
                fprintf(fp, "'\\0'");
            else if(ver[i] == '\0')
            {
                reached_end = 1;
                fprintf(fp, "'\\0'");
            }
            else
                fprintf(fp, "'%c'", ver[i]);

            if(i < 9)
                fprintf(fp, ", ");
        }

        fprintf(fp, "};\n");
        fprintf(fp, "}\n");
        fprintf(fp, "\n");
        fclose(fp);
        retval = 0;
    }

    return retval;
}
