/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                           avtITAPS_COptions.C                             //
// ************************************************************************* //

#include <avtITAPS_COptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>

using std::string;
using std::vector;


// ****************************************************************************
//  Function: GetITAPS_CReadOptions
//
//  Purpose:
//      Creates the options for ITAPS_C readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   Thu Nov 29 14:10:56 PST 2007
//
// ****************************************************************************

DBOptionsAttributes *
GetITAPS_CReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}


// ****************************************************************************
//  Function: GetITAPS_CWriteOptions
//
//  Purpose:
//      Creates the options for ITAPS_C writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   Thu Nov 29 14:10:56 PST 2007
//
//  Modifications:
//    Mark C. Miller, Wed Jan 14 17:57:10 PST 2009
//    Added various bools to control output behavior.
//
//    Mark C. Miller, Tue Apr 21 16:04:38 PDT 2009
//    Ensure all options are available, even to GRUMMP, but set their default
//    values appropriately for GRUMMP.
// ****************************************************************************

DBOptionsAttributes *
GetITAPS_CWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

#if defined(ITAPS_MOAB)
    rv->SetEnum("Format", 0);
    vector<string> formats;
    formats.push_back("MOAB");   // 0
    formats.push_back("EXODUS"); // 1
    formats.push_back("VTK");    // 2
    formats.push_back("SLAC");   // 3
    formats.push_back("GMV");    // 4
    formats.push_back("ANSYS");  // 5
    formats.push_back("GMSH");   // 6
    formats.push_back("STL");    // 7
    rv->SetEnumStrings("Format", formats);
#endif

    // GRUMMP requires some extra stuff so we turn that on
    // by default here. 
#if defined(ITAPS_GRUMMP)
    rv->SetBool("Simplexify", true);
    rv->SetBool("Add faces for 3Dents", true);
#else
    rv->SetBool("Simplexify", false);
    rv->SetBool("Add faces for 3Dents", false);
#endif

    rv->SetBool("Prevent duplicates to iMesh", false);

    return rv;
}
