; Script generated by the HM NIS Edit Script Wizard.

##############################################################################
#
# File: binaryinstallation.nsi
#
# Purpose: This file contains the instructions that the NSIS installer needs
#          in order to create an installation program for VisIt.
#
# Programmer: Brad Whitlock
# Date:       Wed Aug 18 15:46:47 PST 2004
#
# Modifications:
#  Brad Whitlock, Thu Sep 23 09:39:53 PDT 2004
#  Updated for 1.3.5.
#
#  Brad Whitlock, Wed Nov 3 14:07:03 PST 2004
#  Updated for 1.4.
#
#  Brad Whitlock, Wed Jan 5 17:24:18 PST 2005
#  Updated for 1.4.1.
#
##############################################################################

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "VisIt"
!define PRODUCT_VERSION "1.4.1"
!define PRODUCT_PUBLISHER "LLNL"
!define PRODUCT_WEB_SITE "http://www.llnl.gov/visit"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\visit${PRODUCT_VERSION}.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME} ${PRODUCT_VERSION}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

# Define macros for Qt.
!define QTPATH "C:\Qt\3.0.2"
!define QTDLL  "qt-mt302.dll"

SetCompressor bzip2

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "..\resources\visit.ico"
!define MUI_UNICON "..\resources\visit.ico"
#!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

ReserveFile "NetworkConfig.ini"
; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "copyright.txt"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Custom
page custom ChooseNetworkConfig

; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\visit.exe"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"


; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "..\installation\visit${PRODUCT_VERSION}.exe"
InstallDir "$PROGRAMFILES\LLNL\VisIt ${PRODUCT_VERSION}"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Var CreatedPythonLinks

Function .onInit
  ;Extract InstallOptions INI files
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "NetworkConfig.ini"
FunctionEnd

Function ChooseNetworkConfig
#  !insertmacro MUI_HEADER_TEXT "Choose Network Configuration"
  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "NetworkConfig.ini"
FunctionEnd

Section "Executable Components" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "..\bin\MSVC7.Net\Release\*.dll"
  File "..\bin\MSVC7.Net\Release\*.exe"
  File "..\bin\MSVC7.Net\Release\visit-config-closed.ini"
  File "..\bin\MSVC7.Net\Release\visit-config-open.ini"
  File "..\bin\MSVC7.Net\Release\xml2plugin.bat"
  File "..\bin\MSVC7.Net\Release\makemovie.py"
        
  CreateDirectory "$SMPROGRAMS\VisIt ${PRODUCT_VERSION}"
  CreateShortCut "$SMPROGRAMS\VisIt ${PRODUCT_VERSION}\VisIt ${PRODUCT_VERSION}.lnk"     "$INSTDIR\visit.exe" ""     "" 0 SW_SHOWMINIMIZED "" "VisIt allows you to visualize simulation data."
  CreateShortCut "$DESKTOP\VisIt ${PRODUCT_VERSION}.lnk"                                 "$INSTDIR\visit.exe" ""     "" 0 SW_SHOWMINIMIZED "" "VisIt allows you to visualize simulation data."
  CreateShortCut "$SMPROGRAMS\VisIt ${PRODUCT_VERSION}\VisIt Command Line Interface.lnk" "$INSTDIR\visit.exe" "-cli" "" 0 SW_SHOWNORMAL    "" "VisIt's command line interface allows you to visualize simulation data via Python scripting."
  CreateShortCut "$SMPROGRAMS\VisIt ${PRODUCT_VERSION}\Silex.lnk"                        "$INSTDIR\silex.exe" ""     "" 0 SW_SHOWNORMAL    "" "Silex allows you to browse the contents of Silo files."
  # Icon files
  File "..\resources\*.ico"
  # Qt DLL
  File "${QTPATH}\lib\${QTDLL}"
  # MSVC 7 .NET runtime libraries
  File "C:\Program files\Microsoft Visual Studio .NET 2003\SDK\v1.1\Bin\msvcr71.dll"
  File "C:\Program files\Microsoft Visual Studio .NET 2003\SDK\v1.1\Bin\msvcp71.dll"
SectionEnd

Section "Database plugins" SEC02
  SetOutPath "$INSTDIR\databases"
  File "..\bin\MSVC7.Net\Release\databases\libI*.dll"
  File "..\bin\MSVC7.Net\Release\databases\libE*.dll"
  File "..\bin\MSVC7.Net\Release\databases\libM*.dll"
SectionEnd

Section "Plot plugins" SEC03
  SetOutPath "$INSTDIR\plots"
  File "..\bin\MSVC7.Net\Release\plots\libI*.dll"
  File "..\bin\MSVC7.Net\Release\plots\libE*.dll"
  File "..\bin\MSVC7.Net\Release\plots\libG*.dll"
  File "..\bin\MSVC7.Net\Release\plots\libS*.dll"
  File "..\bin\MSVC7.Net\Release\plots\libV*.dll"
SectionEnd

Section "Operator plugins" SEC04
  SetOutPath "$INSTDIR\operators"
  File "..\bin\MSVC7.Net\Release\operators\libI*.dll"
  File "..\bin\MSVC7.Net\Release\operators\libE*.dll"
  File "..\bin\MSVC7.Net\Release\operators\libG*.dll"
  File "..\bin\MSVC7.Net\Release\operators\libS*.dll"
  File "..\bin\MSVC7.Net\Release\operators\libV*.dll"
SectionEnd

Section "Python modules" SEC05
  SetOutPath "$INSTDIR"
  File /r "..\bin\MSVC7.Net\Release\Python"
SectionEnd

Section HelpFiles
  SetOutPath "$INSTDIR\help"
  File "..\bin\MSVC7.Net\Release\help\*.html"
  File "..\bin\MSVC7.Net\Release\help\visit.helpml"
  SetOutPath "$INSTDIR"
SectionEnd

Section DataFiles
  SetOutPath "$INSTDIR\data"
  #
  # This references Files that are on my local C:\ drive since I don't want to have to
  # make the source distribution have projects to build the test data programs.
  #
  File "..\..\VisItData\*.silo"
  File "..\..\VisItData\wave.visit"
  File "..\..\VisItData\PDB\db*.pdb"
  File "..\..\VisItData\ANALYZE_test_data\*.hdr"
  File "..\..\VisItData\ANALYZE_test_data\*.img"
  File "..\..\VisItData\ANALYZE_test_data\*.visit"
SectionEnd

Section MyImageDirectory
  # This will hopefully create an image storage directory that VisIt can use.
  SetOutPath "$INSTDIR\My images"

  # Make sure that we're in the VisIt data directory by default when the
  # application runs for the first time.
  SetOutPath "$INSTDIR\data"
SectionEnd

Section AddVisItRegKeys
#
# This section installs the VISIT<version> key, which tells visit.exe where
# to find the rest of the VisIt components. Note that we put keys in 
# HKEY_LOCAL_MACHINE and in HKEY_CURRENT_USER.
#
  WriteRegStr HKCR "VISIT${PRODUCT_VERSION}" "" ""
  WriteRegStr HKCU "VISIT${PRODUCT_VERSION}" "" ""
  WriteRegStr HKCR "VISIT${PRODUCT_VERSION}" "VISITHOME" "$INSTDIR"
  WriteRegStr HKCU "VISIT${PRODUCT_VERSION}" "VISITHOME" "$INSTDIR"

  # Write the system config that the user chose.
  !insertmacro MUI_INSTALLOPTIONS_READ $0 "NetworkConfig.ini" "Field 1" "State"
  # If $0=="" then we're going to have a networkconfig
  Strcmp $0 "0" HaveNetworkConfig SkipNetworkConfig
HaveNetworkConfig:
    !insertmacro MUI_INSTALLOPTIONS_READ $0 "NetworkConfig.ini" "Field 2" "State"
    # If $0=="" then we're going to use the closed config
    Strcmp $0 "1" OpenNetworkConfig ClosedNetworkConfig
OpenNetworkConfig:
         WriteRegStr HKCR "VISIT${PRODUCT_VERSION}" "VISITSYSTEMCONFIG" "visit-config-open"
         WriteRegStr HKCU "VISIT${PRODUCT_VERSION}" "VISITSYSTEMCONFIG" "visit-config-open"
         Goto SkipNetworkConfig
ClosedNetworkConfig:
         WriteRegStr HKCR "VISIT${PRODUCT_VERSION}" "VISITSYSTEMCONFIG" "visit-config-closed"
         WriteRegStr HKCU "VISIT${PRODUCT_VERSION}" "VISITSYSTEMCONFIG" "visit-config-closed"
SkipNetworkConfig:

  # If the Python installation path for Python 2.3 does not exist then create it.
#  ReadRegStr $CreatedPythonLinks HKCU "Software\Python\PythonCore\2.3\InstallPath"
#  Strcmp $CreatedPythonLinks "" CreatePythonLinks SkipAddingVisItKeys
#CreatePythonLinks:
  WriteRegStr HKCU "Software\Python\PythonCore\2.3\InstallPath" "" "$INSTDIR"
  WriteRegStr HKCU "Software\Python\PythonCore\2.3\PythonPath"  "" "$INSTDIR\Python\Lib;$INSTDIR\Python\DLLs;$INSTDIR\Python\Lib\lib-tk"
#  WriteRegStr HKCR "VISIT${PRODUCT_VERSION}" "CreatedPythonLinks"  "yes"
#SkipAddingVisItKeys:
SectionEnd

Section AddFileAssociations
  # Associate the Silo file format with VisIt and Silex.
  WriteRegStr HKCR ".silo" "" "siloFile"
  WriteRegStr HKCR "siloFile" "" "Silo File"
  WriteRegStr HKCR "siloFile\DefaultIcon" "" "$INSTDIR\silo.ico"
  WriteRegStr HKCR "siloFile\shell\Explore\command" "" '$INSTDIR\silex.exe "%1"'
  WriteRegStr HKCR "siloFile\shell\open\command" "" '$INSTDIR\visit.exe -o "%1"'

  # Associate the VisIt file format with VisIt.
  WriteRegStr HKCR ".visit" "" "visitFile"
  WriteRegStr HKCR "visitFile" "" "VisIt File"
  WriteRegStr HKCR "visitFile\DefaultIcon" "" "$INSTDIR\visitfile.ico"
  WriteRegStr HKCR "visitFile\shell\open\command" "" '$INSTDIR\visit.exe -o "%1"'

  # Associate the VisIt session file format with VisIt.
  WriteRegStr HKCR ".vses" "" "visitSessionFile"
  WriteRegStr HKCR "visitSessionFile" "" "VisIt Session File"
  WriteRegStr HKCR "visitSessionFile\DefaultIcon" "" "$INSTDIR\visitsessionfile.ico"
  WriteRegStr HKCR "visitSessionFile\shell\Make 480x480 movie\command"  "" '$INSTDIR\visit.exe -movie -format tiff -geometry 480x480 -sessionfile "%1"'
  WriteRegStr HKCR "visitSessionFile\shell\Make 640x480 movie\command"  "" '$INSTDIR\visit.exe -movie -format tiff -geometry 640x480 -sessionfile "%1"'
  WriteRegStr HKCR "visitSessionFile\shell\Make 800x600 movie\command"  "" '$INSTDIR\visit.exe -movie -format tiff -geometry 800x600 -sessionfile "%1\'
  WriteRegStr HKCR "visitSessionFile\shell\Make 1024x768 movie\command" "" '$INSTDIR\visit.exe -movie -format tiff -geometry 1024x768 -sessionfile "%1"'
  WriteRegStr HKCR "visitSessionFile\shell\Edit\command" "" 'notepad.exe "%1"'
  WriteRegStr HKCR "visitSessionFile\shell\open\command" "" '$INSTDIR\visit.exe -sessionfile "%1"'
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\VisIt ${PRODUCT_VERSION}\VisIt Home Page.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\VisIt ${PRODUCT_VERSION}\Uninstall VisIt ${PRODUCT_VERSION}.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\visit.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\visit.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$SMPROGRAMS\VisIt ${PRODUCT_VERSION}\Uninstall VisIt ${PRODUCT_VERSION}.lnk"
  Delete "$SMPROGRAMS\VisIt ${PRODUCT_VERSION}\VisIt Home Page.lnk"
  Delete "$SMPROGRAMS\VisIt ${PRODUCT_VERSION}\Silex.lnk"
  Delete "$SMPROGRAMS\VisIt ${PRODUCT_VERSION}\VisIt Command Line Interface.lnk"
  Delete "$DESKTOP\VisIt ${PRODUCT_VERSION}.lnk"
  Delete "$SMPROGRAMS\VisIt ${PRODUCT_VERSION}\VisIt ${PRODUCT_VERSION}.lnk"

  RMDir "$SMPROGRAMS\VisIt ${PRODUCT_VERSION}"

  # Remove all of the VisIt software components
  RMDir /r "$INSTDIR"

  # Delete the Silo file type from the registry.
  DeleteRegKey HKCR ".silo"
  DeleteRegKey HKCR "siloFile"
  # Delete the VisIt session file type from the registry.
  DeleteRegKey HKCR ".vses"
  DeleteRegKey HKCR "visitSessionFile"
  # Delete the VisIt file type from the registry.
  DeleteRegKey HKCR ".visit"
  DeleteRegKey HKCR "visitFile"

  # If we created links for Python, remove them when we remove VisIt.
#  ReadRegStr $CreatedPythonLinks HKCR "VISIT${PRODUCT_VERSION}" "CreatedPythonLinks"
#  Strcmp $CreatedPythonLinks "yes" RemovePythonLinks SkipRemovingPythonLinks
#RemovePythonLinks:
#  DeleteRegKey HKCU "Software\Python\PythonCore\2.3\InstallPath"
#  DeleteRegKey HKCU "Software\Python\PythonCore\2.3\PythonPath"
#SkipRemovingPythonLinks:

  # Delete the VisIt <version> key registry.
  DeleteRegKey HKCR "VISIT${PRODUCT_VERSION}"
  DeleteRegKey HKCU "VISIT${PRODUCT_VERSION}"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
