#include <PyWindowInformation.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyWindowInformation
//
// Purpose: 
//   This class contains the attributes that tell the state of a viewer window.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Mar 18 16:14:43 PST 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a WindowInformation.
//
struct WindowInformationObject
{
    PyObject_HEAD
    WindowInformation *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewWindowInformation();

static PyObject *
WindowInformation_Notify(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_SetActiveSource(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the activeSource in the object.
    obj->data->SetActiveSource(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetActiveSource(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetActiveSource().c_str());
    return retval;
}

static PyObject *
WindowInformation_SetActiveTimeSlider(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the activeTimeSlider in the object.
    obj->data->SetActiveTimeSlider(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetActiveTimeSlider(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetActiveTimeSlider()));
    return retval;
}

static PyObject *
WindowInformation_SetTimeSliders(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    stringVector  &vec = obj->data->GetTimeSliders();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the timeSliders in the object as modified.
    obj->data->SelectTimeSliders();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetTimeSliders(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    // Allocate a tuple the with enough entries to hold the timeSliders.
    const stringVector &timeSliders = obj->data->GetTimeSliders();
    PyObject *retval = PyTuple_New(timeSliders.size());
    for(int i = 0; i < timeSliders.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(timeSliders[i].c_str()));
    return retval;
}

static PyObject *
WindowInformation_SetTimeSliderCurrentStates(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    intVector  &vec = obj->data->GetTimeSliderCurrentStates();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the timeSliderCurrentStates in the object as modified.
    obj->data->SelectTimeSliderCurrentStates();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetTimeSliderCurrentStates(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    // Allocate a tuple the with enough entries to hold the timeSliderCurrentStates.
    const intVector &timeSliderCurrentStates = obj->data->GetTimeSliderCurrentStates();
    PyObject *retval = PyTuple_New(timeSliderCurrentStates.size());
    for(int i = 0; i < timeSliderCurrentStates.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(timeSliderCurrentStates[i])));
    return retval;
}

static PyObject *
WindowInformation_SetAnimationMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the animationMode in the object.
    obj->data->SetAnimationMode(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetAnimationMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAnimationMode()));
    return retval;
}

static PyObject *
WindowInformation_SetWindowMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the windowMode in the object.
    obj->data->SetWindowMode(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetWindowMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWindowMode()));
    return retval;
}

static PyObject *
WindowInformation_SetBoundingBoxNavigate(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the boundingBoxNavigate in the object.
    obj->data->SetBoundingBoxNavigate(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetBoundingBoxNavigate(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetBoundingBoxNavigate()?1L:0L);
    return retval;
}

static PyObject *
WindowInformation_SetSpin(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the spin in the object.
    obj->data->SetSpin(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetSpin(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSpin()?1L:0L);
    return retval;
}

static PyObject *
WindowInformation_SetFullFrame(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fullFrame in the object.
    obj->data->SetFullFrame(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetFullFrame(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFullFrame()?1L:0L);
    return retval;
}

static PyObject *
WindowInformation_SetPerspective(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the perspective in the object.
    obj->data->SetPerspective(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetPerspective(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPerspective()?1L:0L);
    return retval;
}

static PyObject *
WindowInformation_SetLockView(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lockView in the object.
    obj->data->SetLockView(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetLockView(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLockView()?1L:0L);
    return retval;
}

static PyObject *
WindowInformation_SetLockTools(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lockTools in the object.
    obj->data->SetLockTools(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetLockTools(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLockTools()?1L:0L);
    return retval;
}

static PyObject *
WindowInformation_SetLockTime(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lockTime in the object.
    obj->data->SetLockTime(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetLockTime(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLockTime()?1L:0L);
    return retval;
}

static PyObject *
WindowInformation_SetViewExtentsType(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the viewExtentsType in the object.
    obj->data->SetViewExtentsType(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetViewExtentsType(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetViewExtentsType()));
    return retval;
}

static PyObject *
WindowInformation_SetViewDimension(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the viewDimension in the object.
    obj->data->SetViewDimension(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetViewDimension(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetViewDimension()));
    return retval;
}

static PyObject *
WindowInformation_SetViewKeyframes(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    intVector  &vec = obj->data->GetViewKeyframes();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the viewKeyframes in the object as modified.
    obj->data->SelectViewKeyframes();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetViewKeyframes(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    // Allocate a tuple the with enough entries to hold the viewKeyframes.
    const intVector &viewKeyframes = obj->data->GetViewKeyframes();
    PyObject *retval = PyTuple_New(viewKeyframes.size());
    for(int i = 0; i < viewKeyframes.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(viewKeyframes[i])));
    return retval;
}

static PyObject *
WindowInformation_SetCameraViewMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cameraViewMode in the object.
    obj->data->SetCameraViewMode(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetCameraViewMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCameraViewMode()?1L:0L);
    return retval;
}

static PyObject *
WindowInformation_SetUsingScalableRendering(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the usingScalableRendering in the object.
    obj->data->SetUsingScalableRendering(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetUsingScalableRendering(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUsingScalableRendering()?1L:0L);
    return retval;
}

static PyObject *
WindowInformation_SetLastRenderMin(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the lastRenderMin in the object.
    obj->data->SetLastRenderMin(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetLastRenderMin(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetLastRenderMin()));
    return retval;
}

static PyObject *
WindowInformation_SetLastRenderAvg(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the lastRenderAvg in the object.
    obj->data->SetLastRenderAvg(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetLastRenderAvg(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetLastRenderAvg()));
    return retval;
}

static PyObject *
WindowInformation_SetLastRenderMax(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the lastRenderMax in the object.
    obj->data->SetLastRenderMax(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetLastRenderMax(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetLastRenderMax()));
    return retval;
}

static PyObject *
WindowInformation_SetNumTriangles(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numTriangles in the object.
    obj->data->SetNumTriangles(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetNumTriangles(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumTriangles()));
    return retval;
}

static PyObject *
WindowInformation_SetExtents(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    double *dvals = obj->data->GetExtents();
    if(!PyArg_ParseTuple(args, "dddddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3], &dvals[4], &dvals[5]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 6)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the extents in the object as modified.
    obj->data->SelectExtents();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
WindowInformation_GetExtents(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    // Allocate a tuple the with enough entries to hold the extents.
    PyObject *retval = PyTuple_New(6);
    const double *extents = obj->data->GetExtents();
    for(int i = 0; i < 6; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(extents[i]));
    return retval;
}



static struct PyMethodDef WindowInformation_methods[] = {
    {"Notify", WindowInformation_Notify, METH_VARARGS},
    {"SetActiveSource", WindowInformation_SetActiveSource, METH_VARARGS},
    {"GetActiveSource", WindowInformation_GetActiveSource, METH_VARARGS},
    {"SetActiveTimeSlider", WindowInformation_SetActiveTimeSlider, METH_VARARGS},
    {"GetActiveTimeSlider", WindowInformation_GetActiveTimeSlider, METH_VARARGS},
    {"SetTimeSliders", WindowInformation_SetTimeSliders, METH_VARARGS},
    {"GetTimeSliders", WindowInformation_GetTimeSliders, METH_VARARGS},
    {"SetTimeSliderCurrentStates", WindowInformation_SetTimeSliderCurrentStates, METH_VARARGS},
    {"GetTimeSliderCurrentStates", WindowInformation_GetTimeSliderCurrentStates, METH_VARARGS},
    {"SetAnimationMode", WindowInformation_SetAnimationMode, METH_VARARGS},
    {"GetAnimationMode", WindowInformation_GetAnimationMode, METH_VARARGS},
    {"SetWindowMode", WindowInformation_SetWindowMode, METH_VARARGS},
    {"GetWindowMode", WindowInformation_GetWindowMode, METH_VARARGS},
    {"SetBoundingBoxNavigate", WindowInformation_SetBoundingBoxNavigate, METH_VARARGS},
    {"GetBoundingBoxNavigate", WindowInformation_GetBoundingBoxNavigate, METH_VARARGS},
    {"SetSpin", WindowInformation_SetSpin, METH_VARARGS},
    {"GetSpin", WindowInformation_GetSpin, METH_VARARGS},
    {"SetFullFrame", WindowInformation_SetFullFrame, METH_VARARGS},
    {"GetFullFrame", WindowInformation_GetFullFrame, METH_VARARGS},
    {"SetPerspective", WindowInformation_SetPerspective, METH_VARARGS},
    {"GetPerspective", WindowInformation_GetPerspective, METH_VARARGS},
    {"SetLockView", WindowInformation_SetLockView, METH_VARARGS},
    {"GetLockView", WindowInformation_GetLockView, METH_VARARGS},
    {"SetLockTools", WindowInformation_SetLockTools, METH_VARARGS},
    {"GetLockTools", WindowInformation_GetLockTools, METH_VARARGS},
    {"SetLockTime", WindowInformation_SetLockTime, METH_VARARGS},
    {"GetLockTime", WindowInformation_GetLockTime, METH_VARARGS},
    {"SetViewExtentsType", WindowInformation_SetViewExtentsType, METH_VARARGS},
    {"GetViewExtentsType", WindowInformation_GetViewExtentsType, METH_VARARGS},
    {"SetViewDimension", WindowInformation_SetViewDimension, METH_VARARGS},
    {"GetViewDimension", WindowInformation_GetViewDimension, METH_VARARGS},
    {"SetViewKeyframes", WindowInformation_SetViewKeyframes, METH_VARARGS},
    {"GetViewKeyframes", WindowInformation_GetViewKeyframes, METH_VARARGS},
    {"SetCameraViewMode", WindowInformation_SetCameraViewMode, METH_VARARGS},
    {"GetCameraViewMode", WindowInformation_GetCameraViewMode, METH_VARARGS},
    {"SetUsingScalableRendering", WindowInformation_SetUsingScalableRendering, METH_VARARGS},
    {"GetUsingScalableRendering", WindowInformation_GetUsingScalableRendering, METH_VARARGS},
    {"SetLastRenderMin", WindowInformation_SetLastRenderMin, METH_VARARGS},
    {"GetLastRenderMin", WindowInformation_GetLastRenderMin, METH_VARARGS},
    {"SetLastRenderAvg", WindowInformation_SetLastRenderAvg, METH_VARARGS},
    {"GetLastRenderAvg", WindowInformation_GetLastRenderAvg, METH_VARARGS},
    {"SetLastRenderMax", WindowInformation_SetLastRenderMax, METH_VARARGS},
    {"GetLastRenderMax", WindowInformation_GetLastRenderMax, METH_VARARGS},
    {"SetNumTriangles", WindowInformation_SetNumTriangles, METH_VARARGS},
    {"GetNumTriangles", WindowInformation_GetNumTriangles, METH_VARARGS},
    {"SetExtents", WindowInformation_SetExtents, METH_VARARGS},
    {"GetExtents", WindowInformation_GetExtents, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
WindowInformation_dealloc(PyObject *v)
{
   WindowInformationObject *obj = (WindowInformationObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
WindowInformation_compare(PyObject *v, PyObject *w)
{
    WindowInformation *a = ((WindowInformationObject *)v)->data;
    WindowInformation *b = ((WindowInformationObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
WindowInformation_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "activeSource") == 0)
        return WindowInformation_GetActiveSource(self, NULL);
    if(strcmp(name, "activeTimeSlider") == 0)
        return WindowInformation_GetActiveTimeSlider(self, NULL);
    if(strcmp(name, "timeSliders") == 0)
        return WindowInformation_GetTimeSliders(self, NULL);
    if(strcmp(name, "timeSliderCurrentStates") == 0)
        return WindowInformation_GetTimeSliderCurrentStates(self, NULL);
    if(strcmp(name, "animationMode") == 0)
        return WindowInformation_GetAnimationMode(self, NULL);
    if(strcmp(name, "windowMode") == 0)
        return WindowInformation_GetWindowMode(self, NULL);
    if(strcmp(name, "boundingBoxNavigate") == 0)
        return WindowInformation_GetBoundingBoxNavigate(self, NULL);
    if(strcmp(name, "spin") == 0)
        return WindowInformation_GetSpin(self, NULL);
    if(strcmp(name, "fullFrame") == 0)
        return WindowInformation_GetFullFrame(self, NULL);
    if(strcmp(name, "perspective") == 0)
        return WindowInformation_GetPerspective(self, NULL);
    if(strcmp(name, "lockView") == 0)
        return WindowInformation_GetLockView(self, NULL);
    if(strcmp(name, "lockTools") == 0)
        return WindowInformation_GetLockTools(self, NULL);
    if(strcmp(name, "lockTime") == 0)
        return WindowInformation_GetLockTime(self, NULL);
    if(strcmp(name, "viewExtentsType") == 0)
        return WindowInformation_GetViewExtentsType(self, NULL);
    if(strcmp(name, "viewDimension") == 0)
        return WindowInformation_GetViewDimension(self, NULL);
    if(strcmp(name, "viewKeyframes") == 0)
        return WindowInformation_GetViewKeyframes(self, NULL);
    if(strcmp(name, "cameraViewMode") == 0)
        return WindowInformation_GetCameraViewMode(self, NULL);
    if(strcmp(name, "usingScalableRendering") == 0)
        return WindowInformation_GetUsingScalableRendering(self, NULL);
    if(strcmp(name, "lastRenderMin") == 0)
        return WindowInformation_GetLastRenderMin(self, NULL);
    if(strcmp(name, "lastRenderAvg") == 0)
        return WindowInformation_GetLastRenderAvg(self, NULL);
    if(strcmp(name, "lastRenderMax") == 0)
        return WindowInformation_GetLastRenderMax(self, NULL);
    if(strcmp(name, "numTriangles") == 0)
        return WindowInformation_GetNumTriangles(self, NULL);
    if(strcmp(name, "extents") == 0)
        return WindowInformation_GetExtents(self, NULL);

    return Py_FindMethod(WindowInformation_methods, self, name);
}

static int
WindowInformation_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "activeSource") == 0)
        retval = (WindowInformation_SetActiveSource(self, tuple) != NULL);
    else if(strcmp(name, "activeTimeSlider") == 0)
        retval = (WindowInformation_SetActiveTimeSlider(self, tuple) != NULL);
    else if(strcmp(name, "timeSliders") == 0)
        retval = (WindowInformation_SetTimeSliders(self, tuple) != NULL);
    else if(strcmp(name, "timeSliderCurrentStates") == 0)
        retval = (WindowInformation_SetTimeSliderCurrentStates(self, tuple) != NULL);
    else if(strcmp(name, "animationMode") == 0)
        retval = (WindowInformation_SetAnimationMode(self, tuple) != NULL);
    else if(strcmp(name, "windowMode") == 0)
        retval = (WindowInformation_SetWindowMode(self, tuple) != NULL);
    else if(strcmp(name, "boundingBoxNavigate") == 0)
        retval = (WindowInformation_SetBoundingBoxNavigate(self, tuple) != NULL);
    else if(strcmp(name, "spin") == 0)
        retval = (WindowInformation_SetSpin(self, tuple) != NULL);
    else if(strcmp(name, "fullFrame") == 0)
        retval = (WindowInformation_SetFullFrame(self, tuple) != NULL);
    else if(strcmp(name, "perspective") == 0)
        retval = (WindowInformation_SetPerspective(self, tuple) != NULL);
    else if(strcmp(name, "lockView") == 0)
        retval = (WindowInformation_SetLockView(self, tuple) != NULL);
    else if(strcmp(name, "lockTools") == 0)
        retval = (WindowInformation_SetLockTools(self, tuple) != NULL);
    else if(strcmp(name, "lockTime") == 0)
        retval = (WindowInformation_SetLockTime(self, tuple) != NULL);
    else if(strcmp(name, "viewExtentsType") == 0)
        retval = (WindowInformation_SetViewExtentsType(self, tuple) != NULL);
    else if(strcmp(name, "viewDimension") == 0)
        retval = (WindowInformation_SetViewDimension(self, tuple) != NULL);
    else if(strcmp(name, "viewKeyframes") == 0)
        retval = (WindowInformation_SetViewKeyframes(self, tuple) != NULL);
    else if(strcmp(name, "cameraViewMode") == 0)
        retval = (WindowInformation_SetCameraViewMode(self, tuple) != NULL);
    else if(strcmp(name, "usingScalableRendering") == 0)
        retval = (WindowInformation_SetUsingScalableRendering(self, tuple) != NULL);
    else if(strcmp(name, "lastRenderMin") == 0)
        retval = (WindowInformation_SetLastRenderMin(self, tuple) != NULL);
    else if(strcmp(name, "lastRenderAvg") == 0)
        retval = (WindowInformation_SetLastRenderAvg(self, tuple) != NULL);
    else if(strcmp(name, "lastRenderMax") == 0)
        retval = (WindowInformation_SetLastRenderMax(self, tuple) != NULL);
    else if(strcmp(name, "numTriangles") == 0)
        retval = (WindowInformation_SetNumTriangles(self, tuple) != NULL);
    else if(strcmp(name, "extents") == 0)
        retval = (WindowInformation_SetExtents(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
WindowInformation_print(PyObject *v, FILE *fp, int flags)
{
    WindowInformationObject *obj = (WindowInformationObject *)v;

    fprintf(fp, "activeSource = \"%s\"\n", obj->data->GetActiveSource().c_str());
    fprintf(fp, "activeTimeSlider = %d\n", obj->data->GetActiveTimeSlider());
    {   const stringVector &timeSliders = obj->data->GetTimeSliders();
        fprintf(fp, "timeSliders = (");
        for(int i = 0; i < timeSliders.size(); ++i)
        {
            fprintf(fp, "\"%s\"", timeSliders[i].c_str());
            if(i < timeSliders.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const intVector &timeSliderCurrentStates = obj->data->GetTimeSliderCurrentStates();
        fprintf(fp, "timeSliderCurrentStates = (");
        for(int i = 0; i < timeSliderCurrentStates.size(); ++i)
        {
            fprintf(fp, "%d", timeSliderCurrentStates[i]);
            if(i < timeSliderCurrentStates.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "animationMode = %d\n", obj->data->GetAnimationMode());
    fprintf(fp, "windowMode = %d\n", obj->data->GetWindowMode());
    if(obj->data->GetBoundingBoxNavigate())
        fprintf(fp, "boundingBoxNavigate = 1\n");
    else
        fprintf(fp, "boundingBoxNavigate = 0\n");
    if(obj->data->GetSpin())
        fprintf(fp, "spin = 1\n");
    else
        fprintf(fp, "spin = 0\n");
    if(obj->data->GetFullFrame())
        fprintf(fp, "fullFrame = 1\n");
    else
        fprintf(fp, "fullFrame = 0\n");
    if(obj->data->GetPerspective())
        fprintf(fp, "perspective = 1\n");
    else
        fprintf(fp, "perspective = 0\n");
    if(obj->data->GetLockView())
        fprintf(fp, "lockView = 1\n");
    else
        fprintf(fp, "lockView = 0\n");
    if(obj->data->GetLockTools())
        fprintf(fp, "lockTools = 1\n");
    else
        fprintf(fp, "lockTools = 0\n");
    if(obj->data->GetLockTime())
        fprintf(fp, "lockTime = 1\n");
    else
        fprintf(fp, "lockTime = 0\n");
    fprintf(fp, "viewExtentsType = %d\n", obj->data->GetViewExtentsType());
    fprintf(fp, "viewDimension = %d\n", obj->data->GetViewDimension());
    {   const intVector &viewKeyframes = obj->data->GetViewKeyframes();
        fprintf(fp, "viewKeyframes = (");
        for(int i = 0; i < viewKeyframes.size(); ++i)
        {
            fprintf(fp, "%d", viewKeyframes[i]);
            if(i < viewKeyframes.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    if(obj->data->GetCameraViewMode())
        fprintf(fp, "cameraViewMode = 1\n");
    else
        fprintf(fp, "cameraViewMode = 0\n");
    if(obj->data->GetUsingScalableRendering())
        fprintf(fp, "usingScalableRendering = 1\n");
    else
        fprintf(fp, "usingScalableRendering = 0\n");
    fprintf(fp, "lastRenderMin = %g\n", obj->data->GetLastRenderMin());
    fprintf(fp, "lastRenderAvg = %g\n", obj->data->GetLastRenderAvg());
    fprintf(fp, "lastRenderMax = %g\n", obj->data->GetLastRenderMax());
    fprintf(fp, "numTriangles = %d\n", obj->data->GetNumTriangles());
    {   const double *extents = obj->data->GetExtents();
        fprintf(fp, "extents = (");
        for(int i = 0; i < 6; ++i)
        {
            fprintf(fp, "%g", extents[i]);
            if(i < 5)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }

    return 0;
}

#include <snprintf.h>
PyObject *
PyWindowInformation_StringRepresentation(const WindowInformation *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "activeSource = \"%s\"\n", atts->GetActiveSource().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "activeTimeSlider = %d\n", atts->GetActiveTimeSlider());
    str += tmpStr;
    {   const stringVector &timeSliders = atts->GetTimeSliders();
        SNPRINTF(tmpStr, 1000, "timeSliders = (");
        str += tmpStr;
        for(int i = 0; i < timeSliders.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", timeSliders[i].c_str());
            str += tmpStr;
            if(i < timeSliders.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &timeSliderCurrentStates = atts->GetTimeSliderCurrentStates();
        SNPRINTF(tmpStr, 1000, "timeSliderCurrentStates = (");
        str += tmpStr;
        for(int i = 0; i < timeSliderCurrentStates.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", timeSliderCurrentStates[i]);
            str += tmpStr;
            if(i < timeSliderCurrentStates.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "animationMode = %d\n", atts->GetAnimationMode());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "windowMode = %d\n", atts->GetWindowMode());
    str += tmpStr;
    if(atts->GetBoundingBoxNavigate())
        SNPRINTF(tmpStr, 1000, "boundingBoxNavigate = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "boundingBoxNavigate = 0\n");
    str += tmpStr;
    if(atts->GetSpin())
        SNPRINTF(tmpStr, 1000, "spin = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "spin = 0\n");
    str += tmpStr;
    if(atts->GetFullFrame())
        SNPRINTF(tmpStr, 1000, "fullFrame = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "fullFrame = 0\n");
    str += tmpStr;
    if(atts->GetPerspective())
        SNPRINTF(tmpStr, 1000, "perspective = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "perspective = 0\n");
    str += tmpStr;
    if(atts->GetLockView())
        SNPRINTF(tmpStr, 1000, "lockView = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "lockView = 0\n");
    str += tmpStr;
    if(atts->GetLockTools())
        SNPRINTF(tmpStr, 1000, "lockTools = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "lockTools = 0\n");
    str += tmpStr;
    if(atts->GetLockTime())
        SNPRINTF(tmpStr, 1000, "lockTime = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "lockTime = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "viewExtentsType = %d\n", atts->GetViewExtentsType());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "viewDimension = %d\n", atts->GetViewDimension());
    str += tmpStr;
    {   const intVector &viewKeyframes = atts->GetViewKeyframes();
        SNPRINTF(tmpStr, 1000, "viewKeyframes = (");
        str += tmpStr;
        for(int i = 0; i < viewKeyframes.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", viewKeyframes[i]);
            str += tmpStr;
            if(i < viewKeyframes.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetCameraViewMode())
        SNPRINTF(tmpStr, 1000, "cameraViewMode = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "cameraViewMode = 0\n");
    str += tmpStr;
    if(atts->GetUsingScalableRendering())
        SNPRINTF(tmpStr, 1000, "usingScalableRendering = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "usingScalableRendering = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lastRenderMin = %g\n", atts->GetLastRenderMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lastRenderAvg = %g\n", atts->GetLastRenderAvg());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lastRenderMax = %g\n", atts->GetLastRenderMax());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "numTriangles = %d\n", atts->GetNumTriangles());
    str += tmpStr;
    {   const double *extents = atts->GetExtents();
        SNPRINTF(tmpStr, 1000, "extents = (");
        str += tmpStr;
        for(int i = 0; i < 6; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", extents[i]);
            str += tmpStr;
            if(i < 5)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return PyString_FromString(str.c_str());
}

static PyObject *
WindowInformation_str(PyObject *v)
{
    WindowInformationObject *obj = (WindowInformationObject *)v;
    return PyWindowInformation_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *WindowInformation_Purpose = "This class contains the attributes that tell the state of a viewer window.";

//
// The type description structure
//
static PyTypeObject WindowInformationType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "WindowInformation",                    // tp_name
    sizeof(WindowInformationObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)WindowInformation_dealloc,  // tp_dealloc
    (printfunc)WindowInformation_print,     // tp_print
    (getattrfunc)WindowInformation_getattr, // tp_getattr
    (setattrfunc)WindowInformation_setattr, // tp_setattr
    (cmpfunc)WindowInformation_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)WindowInformation_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    WindowInformation_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static WindowInformation *defaultAtts = 0;

static PyObject *
NewWindowInformation()
{
    WindowInformationObject *newObject;
    newObject = PyObject_NEW(WindowInformationObject, &WindowInformationType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new WindowInformation(*defaultAtts);
    else
        newObject->data = new WindowInformation;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapWindowInformation(const WindowInformation *attr)
{
    WindowInformationObject *newObject;
    newObject = PyObject_NEW(WindowInformationObject, &WindowInformationType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (WindowInformation *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
WindowInformation_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewWindowInformation();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef WindowInformationMethods[] = {
    {"WindowInformation", WindowInformation_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *WindowInformationObserver = 0;
static bool WindowInformationEnableLogging = true;

static void
PyWindowInformation_WriteLog(Subject *subj, void *data)
{
    WindowInformation *atts = (WindowInformation *)subj;
    FILE *logFile = (FILE *)data;

    if(!WindowInformationEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# WindowInformation_WriteLog()\n");
}

void
PyWindowInformation_StartUp(WindowInformation *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyWindowInformation_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(WindowInformationObserver == 0)
    {
        WindowInformationObserver = new ObserverToCallback(subj,
            PyWindowInformation_WriteLog, (void *)logFile);
    }

    WindowInformationEnableLogging = true;
}

void
PyWindowInformation_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete WindowInformationObserver;
    WindowInformationObserver = 0;
}

PyMethodDef *
PyWindowInformation_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return WindowInformationMethods;
}

bool
PyWindowInformation_Check(PyObject *obj)
{
    return (obj->ob_type == &WindowInformationType);
}

WindowInformation *
PyWindowInformation_FromPyObject(PyObject *obj)
{
    WindowInformationObject *obj2 = (WindowInformationObject *)obj;
    return obj2->data;
}

PyObject *
PyWindowInformation_NewPyObject()
{
    return NewWindowInformation();
}

PyObject *
PyWindowInformation_WrapPyObject(const WindowInformation *attr)
{
    return WrapWindowInformation(attr);
}

void
PyWindowInformation_SetLogging(bool val)
{
    WindowInformationEnableLogging = val;
}

void
PyWindowInformation_SetDefaults(const WindowInformation *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new WindowInformation(*atts);
}

