#include <PyViewCurveAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyViewCurveAttributes
//
// Purpose: 
//   This class contains the curve view attributes.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 15 14:10:12 PST 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a ViewCurveAttributes.
//
struct ViewCurveAttributesObject
{
    PyObject_HEAD
    ViewCurveAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewViewCurveAttributes();

static PyObject *
ViewCurveAttributes_Notify(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewCurveAttributes_SetDomainCoords(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;

    double *dvals = obj->data->GetDomainCoords();
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the domainCoords in the object as modified.
    obj->data->SelectDomainCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewCurveAttributes_GetDomainCoords(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the domainCoords.
    PyObject *retval = PyTuple_New(2);
    const double *domainCoords = obj->data->GetDomainCoords();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(domainCoords[i]));
    return retval;
}

static PyObject *
ViewCurveAttributes_SetRangeCoords(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;

    double *dvals = obj->data->GetRangeCoords();
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the rangeCoords in the object as modified.
    obj->data->SelectRangeCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewCurveAttributes_GetRangeCoords(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the rangeCoords.
    PyObject *retval = PyTuple_New(2);
    const double *rangeCoords = obj->data->GetRangeCoords();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(rangeCoords[i]));
    return retval;
}

static PyObject *
ViewCurveAttributes_SetViewportCoords(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;

    double *dvals = obj->data->GetViewportCoords();
    if(!PyArg_ParseTuple(args, "dddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 4)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the viewportCoords in the object as modified.
    obj->data->SelectViewportCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewCurveAttributes_GetViewportCoords(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the viewportCoords.
    PyObject *retval = PyTuple_New(4);
    const double *viewportCoords = obj->data->GetViewportCoords();
    for(int i = 0; i < 4; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(viewportCoords[i]));
    return retval;
}



static struct PyMethodDef ViewCurveAttributes_methods[] = {
    {"Notify", ViewCurveAttributes_Notify, METH_VARARGS},
    {"SetDomainCoords", ViewCurveAttributes_SetDomainCoords, METH_VARARGS},
    {"GetDomainCoords", ViewCurveAttributes_GetDomainCoords, METH_VARARGS},
    {"SetRangeCoords", ViewCurveAttributes_SetRangeCoords, METH_VARARGS},
    {"GetRangeCoords", ViewCurveAttributes_GetRangeCoords, METH_VARARGS},
    {"SetViewportCoords", ViewCurveAttributes_SetViewportCoords, METH_VARARGS},
    {"GetViewportCoords", ViewCurveAttributes_GetViewportCoords, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ViewCurveAttributes_dealloc(PyObject *v)
{
   ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ViewCurveAttributes_compare(PyObject *v, PyObject *w)
{
    ViewCurveAttributes *a = ((ViewCurveAttributesObject *)v)->data;
    ViewCurveAttributes *b = ((ViewCurveAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ViewCurveAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "domainCoords") == 0)
        return ViewCurveAttributes_GetDomainCoords(self, NULL);
    if(strcmp(name, "rangeCoords") == 0)
        return ViewCurveAttributes_GetRangeCoords(self, NULL);
    if(strcmp(name, "viewportCoords") == 0)
        return ViewCurveAttributes_GetViewportCoords(self, NULL);

    return Py_FindMethod(ViewCurveAttributes_methods, self, name);
}

static int
ViewCurveAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "domainCoords") == 0)
        retval = (ViewCurveAttributes_SetDomainCoords(self, tuple) != NULL);
    else if(strcmp(name, "rangeCoords") == 0)
        retval = (ViewCurveAttributes_SetRangeCoords(self, tuple) != NULL);
    else if(strcmp(name, "viewportCoords") == 0)
        retval = (ViewCurveAttributes_SetViewportCoords(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ViewCurveAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)v;

    {   const double *domainCoords = obj->data->GetDomainCoords();
        fprintf(fp, "domainCoords = (");
        for(int i = 0; i < 2; ++i)
        {
            fprintf(fp, "%g", domainCoords[i]);
            if(i < 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *rangeCoords = obj->data->GetRangeCoords();
        fprintf(fp, "rangeCoords = (");
        for(int i = 0; i < 2; ++i)
        {
            fprintf(fp, "%g", rangeCoords[i]);
            if(i < 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *viewportCoords = obj->data->GetViewportCoords();
        fprintf(fp, "viewportCoords = (");
        for(int i = 0; i < 4; ++i)
        {
            fprintf(fp, "%g", viewportCoords[i]);
            if(i < 3)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }

    return 0;
}

static PyObject *
ViewCurveAttributes_add(PyObject *v, PyObject *w)
{
    bool arg1isObject = PyViewCurveAttributes_Check(v);
    bool arg2isObject = PyViewCurveAttributes_Check(w);
    if(!arg1isObject || !arg2isObject)
    {
        cerr << "ViewCurveAttributes_add: One or more arguments are not ViewCurveAttributes!" << endl;
        return NULL;
    }

    PyObject *retval = NewViewCurveAttributes();
    ViewCurveAttributes *c = PyViewCurveAttributes_FromPyObject(retval);
    ViewCurveAttributes *a = ((ViewCurveAttributesObject *)v)->data;
    ViewCurveAttributes *b = ((ViewCurveAttributesObject *)w)->data;

    c->GetDomainCoords()[0] = a->GetDomainCoords()[0] + b->GetDomainCoords()[0];
    c->GetDomainCoords()[1] = a->GetDomainCoords()[1] + b->GetDomainCoords()[1];

    c->GetRangeCoords()[0] = a->GetRangeCoords()[0] + b->GetRangeCoords()[0];
    c->GetRangeCoords()[1] = a->GetRangeCoords()[1] + b->GetRangeCoords()[1];

    c->GetViewportCoords()[0] = a->GetViewportCoords()[0] + b->GetViewportCoords()[0];
    c->GetViewportCoords()[1] = a->GetViewportCoords()[1] + b->GetViewportCoords()[1];
    c->GetViewportCoords()[2] = a->GetViewportCoords()[2] + b->GetViewportCoords()[2];
    c->GetViewportCoords()[3] = a->GetViewportCoords()[3] + b->GetViewportCoords()[3];

    return retval;
}

static PyObject *
ViewCurveAttributes_mul(PyObject *v, PyObject *w)
{
    PyObject *retval = NewViewCurveAttributes();
    ViewCurveAttributes *c = PyViewCurveAttributes_FromPyObject(retval);

    ViewCurveAttributes *a;
    double val = 1.;
    bool arg1isObject = PyViewCurveAttributes_Check(v);
    bool arg2isObject = PyViewCurveAttributes_Check(w);

    if(arg1isObject && arg2isObject)
    {
        return NULL;
    }
    else
    {
        PyObject *num;

        if(arg1isObject)
        {
            a = ((ViewCurveAttributesObject *)v)->data;
            num = w;
        }
        else
        {
            a = ((ViewCurveAttributesObject *)w)->data;
            num = v;
        }

        if(PyFloat_Check(num))
            val = PyFloat_AS_DOUBLE(num);
        else if(PyInt_Check(num))
            val = double(PyInt_AS_LONG(num));
        else if(PyLong_Check(num))
            val = PyLong_AsDouble(num);
        else
        {
            cerr << "MUL: Expected numeric argument is not a number!" << endl;
        }

        c->GetDomainCoords()[0] = a->GetDomainCoords()[0] * val;
        c->GetDomainCoords()[1] = a->GetDomainCoords()[1] * val;

        c->GetRangeCoords()[0] = a->GetRangeCoords()[0] * val;
        c->GetRangeCoords()[1] = a->GetRangeCoords()[1] * val;

        c->GetViewportCoords()[0] = a->GetViewportCoords()[0] * val;
        c->GetViewportCoords()[1] = a->GetViewportCoords()[1] * val;
        c->GetViewportCoords()[2] = a->GetViewportCoords()[2] * val;
        c->GetViewportCoords()[3] = a->GetViewportCoords()[3] * val;
    }

    return retval;
}

//
// The type description structure
//
static PyNumberMethods ViewCurveAttributes_as_number = {
    (binaryfunc)ViewCurveAttributes_add, /*nb_add*/
    (binaryfunc)0, /*nb_subtract*/
    (binaryfunc)ViewCurveAttributes_mul, /*nb_multiply*/
    (binaryfunc)0, /*nb_divide*/
    (binaryfunc)0,    /*nb_remainder*/
    (binaryfunc)0,    /*nb_divmod*/
    (ternaryfunc)0,    /*nb_power*/
    (unaryfunc)0,    /*nb_negative*/
    (unaryfunc)0,    /*nb_positive*/
    (unaryfunc)0,    /*nb_absolute*/
    (inquiry)0,    /*nb_nonzero*/
    (unaryfunc)0,    /*nb_invert*/
    (binaryfunc)0,    /*nb_lshift*/
    (binaryfunc)0,    /*nb_rshift*/
    (binaryfunc)0,    /*nb_and*/
    (binaryfunc)0,    /*nb_xor*/
    (binaryfunc)0,    /*nb_or*/
    0,            /*nb_coerce*/
    (unaryfunc)0,    /*nb_int*/
    (unaryfunc)0,    /*nb_long*/
    (unaryfunc)0,    /*nb_float*/
    (unaryfunc)0,    /*nb_oct*/
    (unaryfunc)0,     /*nb_hex*/
    0,            /*nb_inplace_add*/
    0,            /*nb_inplace_subtract*/
    0,            /*nb_inplace_multiply*/
    0,            /*nb_inplace_divide*/
    0,            /*nb_inplace_remainder*/
    0,            /*nb_inplace_power*/
    0,            /*nb_inplace_lshift*/
    0,            /*nb_inplace_rshift*/
    0,            /*nb_inplace_and*/
    0,            /*nb_inplace_xor*/
    0,            /*nb_inplace_or*/
};

//
// The doc string for the class.
//
static char *ViewCurveAttributes_Purpose = "This class contains the curve view attributes.";

//
// The type description structure
//
static PyTypeObject ViewCurveAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ViewCurveAttributes",                    // tp_name
    sizeof(ViewCurveAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ViewCurveAttributes_dealloc,  // tp_dealloc
    (printfunc)ViewCurveAttributes_print,     // tp_print
    (getattrfunc)ViewCurveAttributes_getattr, // tp_getattr
    (setattrfunc)ViewCurveAttributes_setattr, // tp_setattr
    (cmpfunc)ViewCurveAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    &ViewCurveAttributes_as_number,      // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ViewCurveAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ViewCurveAttributes *defaultAtts = 0;

static PyObject *
NewViewCurveAttributes()
{
    ViewCurveAttributesObject *newObject;
    newObject = PyObject_NEW(ViewCurveAttributesObject, &ViewCurveAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ViewCurveAttributes(*defaultAtts);
    else
        newObject->data = new ViewCurveAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapViewCurveAttributes(const ViewCurveAttributes *attr)
{
    ViewCurveAttributesObject *newObject;
    newObject = PyObject_NEW(ViewCurveAttributesObject, &ViewCurveAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ViewCurveAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ViewCurveAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewViewCurveAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ViewCurveAttributesMethods[] = {
    {"ViewCurveAttributes", ViewCurveAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ViewCurveAttributesObserver = 0;
static bool ViewCurveAttributesEnableLogging = true;

static void
PyViewCurveAttributes_WriteLog(Subject *subj, void *data)
{
    ViewCurveAttributes *atts = (ViewCurveAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ViewCurveAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ViewCurveAttributes_WriteLog()\n");
}

void
PyViewCurveAttributes_StartUp(ViewCurveAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyViewCurveAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ViewCurveAttributesObserver == 0)
    {
        ViewCurveAttributesObserver = new ObserverToCallback(subj,
            PyViewCurveAttributes_WriteLog, (void *)logFile);
    }

    ViewCurveAttributesEnableLogging = true;
}

void
PyViewCurveAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ViewCurveAttributesObserver;
    ViewCurveAttributesObserver = 0;
}

PyMethodDef *
PyViewCurveAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ViewCurveAttributesMethods;
}

bool
PyViewCurveAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ViewCurveAttributesType);
}

ViewCurveAttributes *
PyViewCurveAttributes_FromPyObject(PyObject *obj)
{
    ViewCurveAttributesObject *obj2 = (ViewCurveAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyViewCurveAttributes_NewPyObject()
{
    return NewViewCurveAttributes();
}

PyObject *
PyViewCurveAttributes_WrapPyObject(const ViewCurveAttributes *attr)
{
    return WrapViewCurveAttributes(attr);
}

void
PyViewCurveAttributes_SetLogging(bool val)
{
    ViewCurveAttributesEnableLogging = val;
}

void
PyViewCurveAttributes_SetDefaults(const ViewCurveAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ViewCurveAttributes(*atts);
}

