#include <PyViewAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyViewAttributes
//
// Purpose: 
//   This class contains the view attributes.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Oct 15 14:41:08 PST 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a ViewAttributes.
//
struct ViewAttributesObject
{
    PyObject_HEAD
    ViewAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewViewAttributes();

static PyObject *
ViewAttributes_Notify(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_SetViewNormal(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    double *dvals = obj->data->GetViewNormal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the viewNormal in the object as modified.
    obj->data->SelectViewNormal();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetViewNormal(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the viewNormal.
    PyObject *retval = PyTuple_New(3);
    const double *viewNormal = obj->data->GetViewNormal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(viewNormal[i]));
    return retval;
}

static PyObject *
ViewAttributes_SetFocus(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    double *dvals = obj->data->GetFocus();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the focus in the object as modified.
    obj->data->SelectFocus();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetFocus(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the focus.
    PyObject *retval = PyTuple_New(3);
    const double *focus = obj->data->GetFocus();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(focus[i]));
    return retval;
}

static PyObject *
ViewAttributes_SetViewUp(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    double *dvals = obj->data->GetViewUp();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the viewUp in the object as modified.
    obj->data->SelectViewUp();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetViewUp(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the viewUp.
    PyObject *retval = PyTuple_New(3);
    const double *viewUp = obj->data->GetViewUp();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(viewUp[i]));
    return retval;
}

static PyObject *
ViewAttributes_SetViewAngle(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the viewAngle in the object.
    obj->data->SetViewAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetViewAngle(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetViewAngle());
    return retval;
}

static PyObject *
ViewAttributes_SetSetScale(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the setScale in the object.
    obj->data->SetSetScale(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetSetScale(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSetScale()?1L:0L);
    return retval;
}

static PyObject *
ViewAttributes_SetParallelScale(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the parallelScale in the object.
    obj->data->SetParallelScale(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetParallelScale(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetParallelScale());
    return retval;
}

static PyObject *
ViewAttributes_SetNearPlane(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the nearPlane in the object.
    obj->data->SetNearPlane(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetNearPlane(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetNearPlane());
    return retval;
}

static PyObject *
ViewAttributes_SetFarPlane(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the farPlane in the object.
    obj->data->SetFarPlane(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetFarPlane(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetFarPlane());
    return retval;
}

static PyObject *
ViewAttributes_SetImagePan(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    double *dvals = obj->data->GetImagePan();
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the imagePan in the object as modified.
    obj->data->SelectImagePan();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetImagePan(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the imagePan.
    PyObject *retval = PyTuple_New(2);
    const double *imagePan = obj->data->GetImagePan();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(imagePan[i]));
    return retval;
}

static PyObject *
ViewAttributes_SetImageZoom(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the imageZoom in the object.
    obj->data->SetImageZoom(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetImageZoom(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetImageZoom());
    return retval;
}

static PyObject *
ViewAttributes_SetPerspective(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the perspective in the object.
    obj->data->SetPerspective(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetPerspective(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPerspective()?1L:0L);
    return retval;
}

static PyObject *
ViewAttributes_SetWindowCoords(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    double *dvals = obj->data->GetWindowCoords();
    if(!PyArg_ParseTuple(args, "dddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 4)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the windowCoords in the object as modified.
    obj->data->SelectWindowCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetWindowCoords(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the windowCoords.
    PyObject *retval = PyTuple_New(4);
    const double *windowCoords = obj->data->GetWindowCoords();
    for(int i = 0; i < 4; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(windowCoords[i]));
    return retval;
}

static PyObject *
ViewAttributes_SetViewportCoords(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    double *dvals = obj->data->GetViewportCoords();
    if(!PyArg_ParseTuple(args, "dddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 4)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the viewportCoords in the object as modified.
    obj->data->SelectViewportCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetViewportCoords(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the viewportCoords.
    PyObject *retval = PyTuple_New(4);
    const double *viewportCoords = obj->data->GetViewportCoords();
    for(int i = 0; i < 4; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(viewportCoords[i]));
    return retval;
}

static PyObject *
ViewAttributes_SetEyeAngle(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the eyeAngle in the object.
    obj->data->SetEyeAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ViewAttributes_GetEyeAngle(PyObject *self, PyObject *args)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEyeAngle());
    return retval;
}



static struct PyMethodDef ViewAttributes_methods[] = {
    {"Notify", ViewAttributes_Notify, METH_VARARGS},
    {"SetViewNormal", ViewAttributes_SetViewNormal, METH_VARARGS},
    {"GetViewNormal", ViewAttributes_GetViewNormal, METH_VARARGS},
    {"SetFocus", ViewAttributes_SetFocus, METH_VARARGS},
    {"GetFocus", ViewAttributes_GetFocus, METH_VARARGS},
    {"SetViewUp", ViewAttributes_SetViewUp, METH_VARARGS},
    {"GetViewUp", ViewAttributes_GetViewUp, METH_VARARGS},
    {"SetViewAngle", ViewAttributes_SetViewAngle, METH_VARARGS},
    {"GetViewAngle", ViewAttributes_GetViewAngle, METH_VARARGS},
    {"SetSetScale", ViewAttributes_SetSetScale, METH_VARARGS},
    {"GetSetScale", ViewAttributes_GetSetScale, METH_VARARGS},
    {"SetParallelScale", ViewAttributes_SetParallelScale, METH_VARARGS},
    {"GetParallelScale", ViewAttributes_GetParallelScale, METH_VARARGS},
    {"SetNearPlane", ViewAttributes_SetNearPlane, METH_VARARGS},
    {"GetNearPlane", ViewAttributes_GetNearPlane, METH_VARARGS},
    {"SetFarPlane", ViewAttributes_SetFarPlane, METH_VARARGS},
    {"GetFarPlane", ViewAttributes_GetFarPlane, METH_VARARGS},
    {"SetImagePan", ViewAttributes_SetImagePan, METH_VARARGS},
    {"GetImagePan", ViewAttributes_GetImagePan, METH_VARARGS},
    {"SetImageZoom", ViewAttributes_SetImageZoom, METH_VARARGS},
    {"GetImageZoom", ViewAttributes_GetImageZoom, METH_VARARGS},
    {"SetPerspective", ViewAttributes_SetPerspective, METH_VARARGS},
    {"GetPerspective", ViewAttributes_GetPerspective, METH_VARARGS},
    {"SetWindowCoords", ViewAttributes_SetWindowCoords, METH_VARARGS},
    {"GetWindowCoords", ViewAttributes_GetWindowCoords, METH_VARARGS},
    {"SetViewportCoords", ViewAttributes_SetViewportCoords, METH_VARARGS},
    {"GetViewportCoords", ViewAttributes_GetViewportCoords, METH_VARARGS},
    {"SetEyeAngle", ViewAttributes_SetEyeAngle, METH_VARARGS},
    {"GetEyeAngle", ViewAttributes_GetEyeAngle, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ViewAttributes_dealloc(PyObject *v)
{
   ViewAttributesObject *obj = (ViewAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ViewAttributes_compare(PyObject *v, PyObject *w)
{
    ViewAttributes *a = ((ViewAttributesObject *)v)->data;
    ViewAttributes *b = ((ViewAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ViewAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "viewNormal") == 0)
        return ViewAttributes_GetViewNormal(self, NULL);
    if(strcmp(name, "focus") == 0)
        return ViewAttributes_GetFocus(self, NULL);
    if(strcmp(name, "viewUp") == 0)
        return ViewAttributes_GetViewUp(self, NULL);
    if(strcmp(name, "viewAngle") == 0)
        return ViewAttributes_GetViewAngle(self, NULL);
    if(strcmp(name, "setScale") == 0)
        return ViewAttributes_GetSetScale(self, NULL);
    if(strcmp(name, "parallelScale") == 0)
        return ViewAttributes_GetParallelScale(self, NULL);
    if(strcmp(name, "nearPlane") == 0)
        return ViewAttributes_GetNearPlane(self, NULL);
    if(strcmp(name, "farPlane") == 0)
        return ViewAttributes_GetFarPlane(self, NULL);
    if(strcmp(name, "imagePan") == 0)
        return ViewAttributes_GetImagePan(self, NULL);
    if(strcmp(name, "imageZoom") == 0)
        return ViewAttributes_GetImageZoom(self, NULL);
    if(strcmp(name, "perspective") == 0)
        return ViewAttributes_GetPerspective(self, NULL);
    if(strcmp(name, "windowCoords") == 0)
        return ViewAttributes_GetWindowCoords(self, NULL);
    if(strcmp(name, "viewportCoords") == 0)
        return ViewAttributes_GetViewportCoords(self, NULL);
    if(strcmp(name, "eyeAngle") == 0)
        return ViewAttributes_GetEyeAngle(self, NULL);

    return Py_FindMethod(ViewAttributes_methods, self, name);
}

static int
ViewAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "viewNormal") == 0)
        retval = (ViewAttributes_SetViewNormal(self, tuple) != NULL);
    else if(strcmp(name, "focus") == 0)
        retval = (ViewAttributes_SetFocus(self, tuple) != NULL);
    else if(strcmp(name, "viewUp") == 0)
        retval = (ViewAttributes_SetViewUp(self, tuple) != NULL);
    else if(strcmp(name, "viewAngle") == 0)
        retval = (ViewAttributes_SetViewAngle(self, tuple) != NULL);
    else if(strcmp(name, "setScale") == 0)
        retval = (ViewAttributes_SetSetScale(self, tuple) != NULL);
    else if(strcmp(name, "parallelScale") == 0)
        retval = (ViewAttributes_SetParallelScale(self, tuple) != NULL);
    else if(strcmp(name, "nearPlane") == 0)
        retval = (ViewAttributes_SetNearPlane(self, tuple) != NULL);
    else if(strcmp(name, "farPlane") == 0)
        retval = (ViewAttributes_SetFarPlane(self, tuple) != NULL);
    else if(strcmp(name, "imagePan") == 0)
        retval = (ViewAttributes_SetImagePan(self, tuple) != NULL);
    else if(strcmp(name, "imageZoom") == 0)
        retval = (ViewAttributes_SetImageZoom(self, tuple) != NULL);
    else if(strcmp(name, "perspective") == 0)
        retval = (ViewAttributes_SetPerspective(self, tuple) != NULL);
    else if(strcmp(name, "windowCoords") == 0)
        retval = (ViewAttributes_SetWindowCoords(self, tuple) != NULL);
    else if(strcmp(name, "viewportCoords") == 0)
        retval = (ViewAttributes_SetViewportCoords(self, tuple) != NULL);
    else if(strcmp(name, "eyeAngle") == 0)
        retval = (ViewAttributes_SetEyeAngle(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ViewAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ViewAttributesObject *obj = (ViewAttributesObject *)v;

    {   const double *viewNormal = obj->data->GetViewNormal();
        fprintf(fp, "viewNormal = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", viewNormal[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *focus = obj->data->GetFocus();
        fprintf(fp, "focus = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", focus[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *viewUp = obj->data->GetViewUp();
        fprintf(fp, "viewUp = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", viewUp[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "viewAngle = %g\n", obj->data->GetViewAngle());
    if(obj->data->GetSetScale())
        fprintf(fp, "setScale = 1\n");
    else
        fprintf(fp, "setScale = 0\n");
    fprintf(fp, "parallelScale = %g\n", obj->data->GetParallelScale());
    fprintf(fp, "nearPlane = %g\n", obj->data->GetNearPlane());
    fprintf(fp, "farPlane = %g\n", obj->data->GetFarPlane());
    {   const double *imagePan = obj->data->GetImagePan();
        fprintf(fp, "imagePan = (");
        for(int i = 0; i < 2; ++i)
        {
            fprintf(fp, "%g", imagePan[i]);
            if(i < 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "imageZoom = %g\n", obj->data->GetImageZoom());
    if(obj->data->GetPerspective())
        fprintf(fp, "perspective = 1\n");
    else
        fprintf(fp, "perspective = 0\n");
    {   const double *windowCoords = obj->data->GetWindowCoords();
        fprintf(fp, "windowCoords = (");
        for(int i = 0; i < 4; ++i)
        {
            fprintf(fp, "%g", windowCoords[i]);
            if(i < 3)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *viewportCoords = obj->data->GetViewportCoords();
        fprintf(fp, "viewportCoords = (");
        for(int i = 0; i < 4; ++i)
        {
            fprintf(fp, "%g", viewportCoords[i]);
            if(i < 3)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "eyeAngle = %g\n", obj->data->GetEyeAngle());

    return 0;
}

static PyObject *
ViewAttributes_add(PyObject *v, PyObject *w)
{
    bool arg1isObject = PyViewAttributes_Check(v);
    bool arg2isObject = PyViewAttributes_Check(w);
    if(!arg1isObject || !arg2isObject)
    {
        cerr << "ViewAttributes_add: One or more arguments are not ViewAttributes!" << endl;
        return NULL;
    }

    PyObject *retval = NewViewAttributes();
    ViewAttributes *c = PyViewAttributes_FromPyObject(retval);
    ViewAttributes *a = ((ViewAttributesObject *)v)->data;
    ViewAttributes *b = ((ViewAttributesObject *)w)->data;

    c->GetViewNormal()[0] = a->GetViewNormal()[0] + b->GetViewNormal()[0];
    c->GetViewNormal()[1] = a->GetViewNormal()[1] + b->GetViewNormal()[1];
    c->GetViewNormal()[2] = a->GetViewNormal()[2] + b->GetViewNormal()[2];

    c->GetFocus()[0] = a->GetFocus()[0] + b->GetFocus()[0];
    c->GetFocus()[1] = a->GetFocus()[1] + b->GetFocus()[1];
    c->GetFocus()[2] = a->GetFocus()[2] + b->GetFocus()[2];

    c->GetViewUp()[0] = a->GetViewUp()[0] + b->GetViewUp()[0];
    c->GetViewUp()[1] = a->GetViewUp()[1] + b->GetViewUp()[1];
    c->GetViewUp()[2] = a->GetViewUp()[2] + b->GetViewUp()[2];

    c->SetViewAngle(a->GetViewAngle() + b->GetViewAngle());
    c->SetSetScale(a->GetSetScale() | b->GetSetScale());
    c->SetParallelScale(a->GetParallelScale() + b->GetParallelScale());
    c->SetNearPlane(a->GetNearPlane() + b->GetNearPlane());
    c->SetFarPlane(a->GetFarPlane() + b->GetFarPlane());
    c->SetPerspective(a->GetPerspective() + b->GetPerspective());

    c->GetImagePan()[0] = a->GetImagePan()[0] + b->GetImagePan()[0];
    c->GetImagePan()[1] = a->GetImagePan()[1] + b->GetImagePan()[1];
    c->SetImageZoom(a->GetImageZoom() + b->GetImageZoom());

    c->GetWindowCoords()[0] = a->GetWindowCoords()[0] + b->GetWindowCoords()[0];
    c->GetWindowCoords()[1] = a->GetWindowCoords()[1] + b->GetWindowCoords()[1];
    c->GetWindowCoords()[2] = a->GetWindowCoords()[2] + b->GetWindowCoords()[2];
    c->GetWindowCoords()[3] = a->GetWindowCoords()[3] + b->GetWindowCoords()[3];

    c->GetViewportCoords()[0] = a->GetViewportCoords()[0] + b->GetViewportCoords()[0];
    c->GetViewportCoords()[1] = a->GetViewportCoords()[1] + b->GetViewportCoords()[1];
    c->GetViewportCoords()[2] = a->GetViewportCoords()[2] + b->GetViewportCoords()[2];
    c->GetViewportCoords()[3] = a->GetViewportCoords()[3] + b->GetViewportCoords()[3];

    return retval;
}

static PyObject *
ViewAttributes_mul(PyObject *v, PyObject *w)
{
    PyObject *retval = NewViewAttributes();
    ViewAttributes *c = PyViewAttributes_FromPyObject(retval);

    ViewAttributes *a;
    double val = 1.;
    bool arg1isObject = PyViewAttributes_Check(v);
    bool arg2isObject = PyViewAttributes_Check(w);

    if(arg1isObject && arg2isObject)
    {
        return NULL;
    }
    else
    {
        PyObject *num;

        if(arg1isObject)
        {
            a = ((ViewAttributesObject *)v)->data;
            num = w;
        }
        else
        {
            a = ((ViewAttributesObject *)w)->data;
            num = v;
        }

        if(PyFloat_Check(num))
            val = PyFloat_AS_DOUBLE(num);
        else if(PyInt_Check(num))
            val = double(PyInt_AS_LONG(num));
        else if(PyLong_Check(num))
            val = PyLong_AsDouble(num);
        else
        {
            cerr << "MUL: Expected numeric argument is not a number!" << endl;
        }

        c->GetViewNormal()[0] = a->GetViewNormal()[0] * val;
        c->GetViewNormal()[1] = a->GetViewNormal()[1] * val;
        c->GetViewNormal()[2] = a->GetViewNormal()[2] * val;

        c->GetFocus()[0] = a->GetFocus()[0] * val;
        c->GetFocus()[1] = a->GetFocus()[1] * val;
        c->GetFocus()[2] = a->GetFocus()[2] * val;

        c->GetViewUp()[0] = a->GetViewUp()[0] * val;
        c->GetViewUp()[1] = a->GetViewUp()[1] * val;
        c->GetViewUp()[2] = a->GetViewUp()[2] * val;

        c->SetViewAngle(a->GetViewAngle() * val);
        c->SetSetScale(a->GetSetScale());
        c->SetParallelScale(a->GetParallelScale() * val);
        c->SetNearPlane(a->GetNearPlane() * val);
        c->SetFarPlane(a->GetFarPlane() * val);
        c->SetPerspective(a->GetPerspective() * val);

        c->GetImagePan()[0] = a->GetImagePan()[0] * val;
        c->GetImagePan()[1] = a->GetImagePan()[1] * val;
        c->SetImageZoom(a->GetImageZoom() * val);

        c->GetWindowCoords()[0] = a->GetWindowCoords()[0] * val;
        c->GetWindowCoords()[1] = a->GetWindowCoords()[1] * val;
        c->GetWindowCoords()[2] = a->GetWindowCoords()[2] * val;
        c->GetWindowCoords()[3] = a->GetWindowCoords()[3] * val;

        c->GetViewportCoords()[0] = a->GetViewportCoords()[0] * val;
        c->GetViewportCoords()[1] = a->GetViewportCoords()[1] * val;
        c->GetViewportCoords()[2] = a->GetViewportCoords()[2] * val;
        c->GetViewportCoords()[3] = a->GetViewportCoords()[3] * val;
    }

    return retval;
}

//
// The type description structure
//
static PyNumberMethods ViewAttributes_as_number = {
    (binaryfunc)ViewAttributes_add, /*nb_add*/
    (binaryfunc)0, /*nb_subtract*/
    (binaryfunc)ViewAttributes_mul, /*nb_multiply*/
    (binaryfunc)0, /*nb_divide*/
    (binaryfunc)0,    /*nb_remainder*/
    (binaryfunc)0,    /*nb_divmod*/
    (ternaryfunc)0,    /*nb_power*/
    (unaryfunc)0,    /*nb_negative*/
    (unaryfunc)0,    /*nb_positive*/
    (unaryfunc)0,    /*nb_absolute*/
    (inquiry)0,    /*nb_nonzero*/
    (unaryfunc)0,    /*nb_invert*/
    (binaryfunc)0,    /*nb_lshift*/
    (binaryfunc)0,    /*nb_rshift*/
    (binaryfunc)0,    /*nb_and*/
    (binaryfunc)0,    /*nb_xor*/
    (binaryfunc)0,    /*nb_or*/
    0,            /*nb_coerce*/
    (unaryfunc)0,    /*nb_int*/
    (unaryfunc)0,    /*nb_long*/
    (unaryfunc)0,    /*nb_float*/
    (unaryfunc)0,    /*nb_oct*/
    (unaryfunc)0,     /*nb_hex*/
    0,            /*nb_inplace_add*/
    0,            /*nb_inplace_subtract*/
    0,            /*nb_inplace_multiply*/
    0,            /*nb_inplace_divide*/
    0,            /*nb_inplace_remainder*/
    0,            /*nb_inplace_power*/
    0,            /*nb_inplace_lshift*/
    0,            /*nb_inplace_rshift*/
    0,            /*nb_inplace_and*/
    0,            /*nb_inplace_xor*/
    0,            /*nb_inplace_or*/
};

//
// The doc string for the class.
//
static char *ViewAttributes_Purpose = "This class contains the view attributes.";

//
// The type description structure
//
static PyTypeObject ViewAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ViewAttributes",                    // tp_name
    sizeof(ViewAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ViewAttributes_dealloc,  // tp_dealloc
    (printfunc)ViewAttributes_print,     // tp_print
    (getattrfunc)ViewAttributes_getattr, // tp_getattr
    (setattrfunc)ViewAttributes_setattr, // tp_setattr
    (cmpfunc)ViewAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    &ViewAttributes_as_number,           // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ViewAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ViewAttributes *defaultAtts = 0;

static PyObject *
NewViewAttributes()
{
    ViewAttributesObject *newObject;
    newObject = PyObject_NEW(ViewAttributesObject, &ViewAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ViewAttributes(*defaultAtts);
    else
        newObject->data = new ViewAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapViewAttributes(const ViewAttributes *attr)
{
    ViewAttributesObject *newObject;
    newObject = PyObject_NEW(ViewAttributesObject, &ViewAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ViewAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ViewAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewViewAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ViewAttributesMethods[] = {
    {"ViewAttributes", ViewAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ViewAttributesObserver = 0;
static bool ViewAttributesEnableLogging = true;

static void
PyViewAttributes_WriteLog(Subject *subj, void *data)
{
    ViewAttributes *atts = (ViewAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ViewAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ViewAttributes_WriteLog()\n");
}

void
PyViewAttributes_StartUp(ViewAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyViewAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ViewAttributesObserver == 0)
    {
        ViewAttributesObserver = new ObserverToCallback(subj,
            PyViewAttributes_WriteLog, (void *)logFile);
    }

    ViewAttributesEnableLogging = true;
}

void
PyViewAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ViewAttributesObserver;
    ViewAttributesObserver = 0;
}

PyMethodDef *
PyViewAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ViewAttributesMethods;
}

bool
PyViewAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ViewAttributesType);
}

ViewAttributes *
PyViewAttributes_FromPyObject(PyObject *obj)
{
    ViewAttributesObject *obj2 = (ViewAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyViewAttributes_NewPyObject()
{
    return NewViewAttributes();
}

PyObject *
PyViewAttributes_WrapPyObject(const ViewAttributes *attr)
{
    return WrapViewAttributes(attr);
}

void
PyViewAttributes_SetLogging(bool val)
{
    ViewAttributesEnableLogging = val;
}

void
PyViewAttributes_SetDefaults(const ViewAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ViewAttributes(*atts);
}

