#include <PyView3DAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyView3DAttributes
//
// Purpose: 
//   This class contains the 3d view attributes.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon Feb 9 14:51:08 PST 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a View3DAttributes.
//
struct View3DAttributesObject
{
    PyObject_HEAD
    View3DAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewView3DAttributes();

static PyObject *
View3DAttributes_Notify(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_SetViewNormal(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double *dvals = obj->data->GetViewNormal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the viewNormal in the object as modified.
    obj->data->SelectViewNormal();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetViewNormal(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the viewNormal.
    PyObject *retval = PyTuple_New(3);
    const double *viewNormal = obj->data->GetViewNormal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(viewNormal[i]));
    return retval;
}

static PyObject *
View3DAttributes_SetFocus(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double *dvals = obj->data->GetFocus();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the focus in the object as modified.
    obj->data->SelectFocus();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetFocus(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the focus.
    PyObject *retval = PyTuple_New(3);
    const double *focus = obj->data->GetFocus();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(focus[i]));
    return retval;
}

static PyObject *
View3DAttributes_SetViewUp(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double *dvals = obj->data->GetViewUp();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the viewUp in the object as modified.
    obj->data->SelectViewUp();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetViewUp(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the viewUp.
    PyObject *retval = PyTuple_New(3);
    const double *viewUp = obj->data->GetViewUp();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(viewUp[i]));
    return retval;
}

static PyObject *
View3DAttributes_SetViewAngle(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the viewAngle in the object.
    obj->data->SetViewAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetViewAngle(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetViewAngle());
    return retval;
}

static PyObject *
View3DAttributes_SetParallelScale(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the parallelScale in the object.
    obj->data->SetParallelScale(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetParallelScale(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetParallelScale());
    return retval;
}

static PyObject *
View3DAttributes_SetNearPlane(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the nearPlane in the object.
    obj->data->SetNearPlane(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetNearPlane(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetNearPlane());
    return retval;
}

static PyObject *
View3DAttributes_SetFarPlane(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the farPlane in the object.
    obj->data->SetFarPlane(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetFarPlane(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetFarPlane());
    return retval;
}

static PyObject *
View3DAttributes_SetImagePan(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double *dvals = obj->data->GetImagePan();
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the imagePan in the object as modified.
    obj->data->SelectImagePan();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetImagePan(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the imagePan.
    PyObject *retval = PyTuple_New(2);
    const double *imagePan = obj->data->GetImagePan();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(imagePan[i]));
    return retval;
}

static PyObject *
View3DAttributes_SetImageZoom(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the imageZoom in the object.
    obj->data->SetImageZoom(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetImageZoom(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetImageZoom());
    return retval;
}

static PyObject *
View3DAttributes_SetPerspective(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the perspective in the object.
    obj->data->SetPerspective(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetPerspective(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPerspective()?1L:0L);
    return retval;
}

static PyObject *
View3DAttributes_SetEyeAngle(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the eyeAngle in the object.
    obj->data->SetEyeAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetEyeAngle(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEyeAngle());
    return retval;
}

static PyObject *
View3DAttributes_SetCenterOfRotationSet(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the centerOfRotationSet in the object.
    obj->data->SetCenterOfRotationSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetCenterOfRotationSet(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCenterOfRotationSet()?1L:0L);
    return retval;
}

static PyObject *
View3DAttributes_SetCenterOfRotation(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double *dvals = obj->data->GetCenterOfRotation();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the centerOfRotation in the object as modified.
    obj->data->SelectCenterOfRotation();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View3DAttributes_GetCenterOfRotation(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the centerOfRotation.
    PyObject *retval = PyTuple_New(3);
    const double *centerOfRotation = obj->data->GetCenterOfRotation();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(centerOfRotation[i]));
    return retval;
}



static struct PyMethodDef View3DAttributes_methods[] = {
    {"Notify", View3DAttributes_Notify, METH_VARARGS},
    {"SetViewNormal", View3DAttributes_SetViewNormal, METH_VARARGS},
    {"GetViewNormal", View3DAttributes_GetViewNormal, METH_VARARGS},
    {"SetFocus", View3DAttributes_SetFocus, METH_VARARGS},
    {"GetFocus", View3DAttributes_GetFocus, METH_VARARGS},
    {"SetViewUp", View3DAttributes_SetViewUp, METH_VARARGS},
    {"GetViewUp", View3DAttributes_GetViewUp, METH_VARARGS},
    {"SetViewAngle", View3DAttributes_SetViewAngle, METH_VARARGS},
    {"GetViewAngle", View3DAttributes_GetViewAngle, METH_VARARGS},
    {"SetParallelScale", View3DAttributes_SetParallelScale, METH_VARARGS},
    {"GetParallelScale", View3DAttributes_GetParallelScale, METH_VARARGS},
    {"SetNearPlane", View3DAttributes_SetNearPlane, METH_VARARGS},
    {"GetNearPlane", View3DAttributes_GetNearPlane, METH_VARARGS},
    {"SetFarPlane", View3DAttributes_SetFarPlane, METH_VARARGS},
    {"GetFarPlane", View3DAttributes_GetFarPlane, METH_VARARGS},
    {"SetImagePan", View3DAttributes_SetImagePan, METH_VARARGS},
    {"GetImagePan", View3DAttributes_GetImagePan, METH_VARARGS},
    {"SetImageZoom", View3DAttributes_SetImageZoom, METH_VARARGS},
    {"GetImageZoom", View3DAttributes_GetImageZoom, METH_VARARGS},
    {"SetPerspective", View3DAttributes_SetPerspective, METH_VARARGS},
    {"GetPerspective", View3DAttributes_GetPerspective, METH_VARARGS},
    {"SetEyeAngle", View3DAttributes_SetEyeAngle, METH_VARARGS},
    {"GetEyeAngle", View3DAttributes_GetEyeAngle, METH_VARARGS},
    {"SetCenterOfRotationSet", View3DAttributes_SetCenterOfRotationSet, METH_VARARGS},
    {"GetCenterOfRotationSet", View3DAttributes_GetCenterOfRotationSet, METH_VARARGS},
    {"SetCenterOfRotation", View3DAttributes_SetCenterOfRotation, METH_VARARGS},
    {"GetCenterOfRotation", View3DAttributes_GetCenterOfRotation, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
View3DAttributes_dealloc(PyObject *v)
{
   View3DAttributesObject *obj = (View3DAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
View3DAttributes_compare(PyObject *v, PyObject *w)
{
    View3DAttributes *a = ((View3DAttributesObject *)v)->data;
    View3DAttributes *b = ((View3DAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
View3DAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "viewNormal") == 0)
        return View3DAttributes_GetViewNormal(self, NULL);
    if(strcmp(name, "focus") == 0)
        return View3DAttributes_GetFocus(self, NULL);
    if(strcmp(name, "viewUp") == 0)
        return View3DAttributes_GetViewUp(self, NULL);
    if(strcmp(name, "viewAngle") == 0)
        return View3DAttributes_GetViewAngle(self, NULL);
    if(strcmp(name, "parallelScale") == 0)
        return View3DAttributes_GetParallelScale(self, NULL);
    if(strcmp(name, "nearPlane") == 0)
        return View3DAttributes_GetNearPlane(self, NULL);
    if(strcmp(name, "farPlane") == 0)
        return View3DAttributes_GetFarPlane(self, NULL);
    if(strcmp(name, "imagePan") == 0)
        return View3DAttributes_GetImagePan(self, NULL);
    if(strcmp(name, "imageZoom") == 0)
        return View3DAttributes_GetImageZoom(self, NULL);
    if(strcmp(name, "perspective") == 0)
        return View3DAttributes_GetPerspective(self, NULL);
    if(strcmp(name, "eyeAngle") == 0)
        return View3DAttributes_GetEyeAngle(self, NULL);
    if(strcmp(name, "centerOfRotationSet") == 0)
        return View3DAttributes_GetCenterOfRotationSet(self, NULL);
    if(strcmp(name, "centerOfRotation") == 0)
        return View3DAttributes_GetCenterOfRotation(self, NULL);

    return Py_FindMethod(View3DAttributes_methods, self, name);
}

static int
View3DAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "viewNormal") == 0)
        retval = (View3DAttributes_SetViewNormal(self, tuple) != NULL);
    else if(strcmp(name, "focus") == 0)
        retval = (View3DAttributes_SetFocus(self, tuple) != NULL);
    else if(strcmp(name, "viewUp") == 0)
        retval = (View3DAttributes_SetViewUp(self, tuple) != NULL);
    else if(strcmp(name, "viewAngle") == 0)
        retval = (View3DAttributes_SetViewAngle(self, tuple) != NULL);
    else if(strcmp(name, "parallelScale") == 0)
        retval = (View3DAttributes_SetParallelScale(self, tuple) != NULL);
    else if(strcmp(name, "nearPlane") == 0)
        retval = (View3DAttributes_SetNearPlane(self, tuple) != NULL);
    else if(strcmp(name, "farPlane") == 0)
        retval = (View3DAttributes_SetFarPlane(self, tuple) != NULL);
    else if(strcmp(name, "imagePan") == 0)
        retval = (View3DAttributes_SetImagePan(self, tuple) != NULL);
    else if(strcmp(name, "imageZoom") == 0)
        retval = (View3DAttributes_SetImageZoom(self, tuple) != NULL);
    else if(strcmp(name, "perspective") == 0)
        retval = (View3DAttributes_SetPerspective(self, tuple) != NULL);
    else if(strcmp(name, "eyeAngle") == 0)
        retval = (View3DAttributes_SetEyeAngle(self, tuple) != NULL);
    else if(strcmp(name, "centerOfRotationSet") == 0)
        retval = (View3DAttributes_SetCenterOfRotationSet(self, tuple) != NULL);
    else if(strcmp(name, "centerOfRotation") == 0)
        retval = (View3DAttributes_SetCenterOfRotation(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
View3DAttributes_print(PyObject *v, FILE *fp, int flags)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)v;

    {   const double *viewNormal = obj->data->GetViewNormal();
        fprintf(fp, "viewNormal = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", viewNormal[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *focus = obj->data->GetFocus();
        fprintf(fp, "focus = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", focus[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *viewUp = obj->data->GetViewUp();
        fprintf(fp, "viewUp = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", viewUp[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "viewAngle = %g\n", obj->data->GetViewAngle());
    fprintf(fp, "parallelScale = %g\n", obj->data->GetParallelScale());
    fprintf(fp, "nearPlane = %g\n", obj->data->GetNearPlane());
    fprintf(fp, "farPlane = %g\n", obj->data->GetFarPlane());
    {   const double *imagePan = obj->data->GetImagePan();
        fprintf(fp, "imagePan = (");
        for(int i = 0; i < 2; ++i)
        {
            fprintf(fp, "%g", imagePan[i]);
            if(i < 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "imageZoom = %g\n", obj->data->GetImageZoom());
    if(obj->data->GetPerspective())
        fprintf(fp, "perspective = 1\n");
    else
        fprintf(fp, "perspective = 0\n");
    fprintf(fp, "eyeAngle = %g\n", obj->data->GetEyeAngle());
    if(obj->data->GetCenterOfRotationSet())
        fprintf(fp, "centerOfRotationSet = 1\n");
    else
        fprintf(fp, "centerOfRotationSet = 0\n");
    {   const double *centerOfRotation = obj->data->GetCenterOfRotation();
        fprintf(fp, "centerOfRotation = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", centerOfRotation[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }

    return 0;
}

#include <snprintf.h>
PyObject *
View3DAttributes_str(PyObject *v)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)v;
    View3DAttributes *atts = obj->data;

    std::string str("");
    char tmpStr[1000];


    {   const double *viewNormal = atts->GetViewNormal();
        SNPRINTF(tmpStr, 1000,"viewNormal = ("); str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000,"%g", viewNormal[i]); str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000,", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000,"), ");
        str += tmpStr;
    }
    {   const double *focus = atts->GetFocus();
        SNPRINTF(tmpStr, 1000,"focus = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000,"%g", focus[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000,", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000,"), ");
        str += tmpStr;
    }
    {   const double *viewUp = atts->GetViewUp();
        SNPRINTF(tmpStr, 1000,"viewUp = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000,"%g", viewUp[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000,", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000,"), ");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000,"viewAngle = %g, ", atts->GetViewAngle()); str += tmpStr;
    SNPRINTF(tmpStr, 1000,"parallelScale = %g, ", atts->GetParallelScale()); str += tmpStr;
    SNPRINTF(tmpStr, 1000,"nearPlane = %g, ", atts->GetNearPlane()); str += tmpStr;
    SNPRINTF(tmpStr, 1000,"farPlane = %g, ", atts->GetFarPlane()); str += tmpStr;
    {   const double *imagePan = atts->GetImagePan();
        SNPRINTF(tmpStr, 1000,"imagePan = ("); str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            SNPRINTF(tmpStr, 1000,"%g", imagePan[i]); str += tmpStr;
            if(i < 1)
            {
                SNPRINTF(tmpStr, 1000,", "); str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000,"), "); str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000,"imageZoom = %g, ", atts->GetImageZoom()); str += tmpStr;
    if(atts->GetPerspective())
        SNPRINTF(tmpStr, 1000,"perspective = 1, ");
    else
        SNPRINTF(tmpStr, 1000,"perspective = 0, ");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000,"eyeAngle = %g,", atts->GetEyeAngle()), str += tmpStr;

    if(atts->GetCenterOfRotationSet())
    {
        SNPRINTF(tmpStr, 1000,"centerOfRotationSet = 1,");
        str += tmpStr;
    }
    else
    {
        SNPRINTF(tmpStr, 1000,"centerOfRotationSet = 0,");
        str += tmpStr;
    }

    {   const double *centerOfRotation = atts->GetCenterOfRotation();
        SNPRINTF(tmpStr, 1000,"centerOfRotation = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000,"%g", centerOfRotation[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000,", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000,")");
        str += tmpStr;
    }

    return PyString_FromString(str.c_str());
}

static PyObject *
View3DAttributes_add(PyObject *v, PyObject *w)
{
    bool arg1isObject = PyView3DAttributes_Check(v);
    bool arg2isObject = PyView3DAttributes_Check(w);
    if(!arg1isObject || !arg2isObject)
    {
        cerr << "View3DAttributes_add: One or more arguments are not View3DAttributes!" << endl;
        return NULL;
    }

    PyObject *retval = NewView3DAttributes();
    View3DAttributes *c = PyView3DAttributes_FromPyObject(retval);
    View3DAttributes *a = ((View3DAttributesObject *)v)->data;
    View3DAttributes *b = ((View3DAttributesObject *)w)->data;

    c->GetViewNormal()[0] = a->GetViewNormal()[0] + b->GetViewNormal()[0];
    c->GetViewNormal()[1] = a->GetViewNormal()[1] + b->GetViewNormal()[1];
    c->GetViewNormal()[2] = a->GetViewNormal()[2] + b->GetViewNormal()[2];

    c->GetFocus()[0] = a->GetFocus()[0] + b->GetFocus()[0];
    c->GetFocus()[1] = a->GetFocus()[1] + b->GetFocus()[1];
    c->GetFocus()[2] = a->GetFocus()[2] + b->GetFocus()[2];

    c->GetViewUp()[0] = a->GetViewUp()[0] + b->GetViewUp()[0];
    c->GetViewUp()[1] = a->GetViewUp()[1] + b->GetViewUp()[1];
    c->GetViewUp()[2] = a->GetViewUp()[2] + b->GetViewUp()[2];

    c->SetViewAngle(a->GetViewAngle() + b->GetViewAngle());
    c->SetParallelScale(a->GetParallelScale() + b->GetParallelScale());
    c->SetNearPlane(a->GetNearPlane() + b->GetNearPlane());
    c->SetFarPlane(a->GetFarPlane() + b->GetFarPlane());
    c->SetPerspective(a->GetPerspective() + b->GetPerspective());

    c->GetImagePan()[0] = a->GetImagePan()[0] + b->GetImagePan()[0];
    c->GetImagePan()[1] = a->GetImagePan()[1] + b->GetImagePan()[1];
    c->SetImageZoom(a->GetImageZoom() + b->GetImageZoom());

    c->SetEyeAngle(a->GetEyeAngle() + b->GetEyeAngle());

    c->SetCenterOfRotationSet(a->GetCenterOfRotationSet() +
                              b->GetCenterOfRotationSet());
    c->GetCenterOfRotation()[0] = a->GetCenterOfRotation()[0] +
                                  b->GetCenterOfRotation()[0];
    c->GetCenterOfRotation()[1] = a->GetCenterOfRotation()[1] +
                                  b->GetCenterOfRotation()[1];
    c->GetCenterOfRotation()[2] = a->GetCenterOfRotation()[2] +
                                  b->GetCenterOfRotation()[2];
    return retval;
}

static PyObject *
View3DAttributes_mul(PyObject *v, PyObject *w)
{
    PyObject *retval = NewView3DAttributes();
    View3DAttributes *c = PyView3DAttributes_FromPyObject(retval);

    View3DAttributes *a;
    double val = 1.;
    bool arg1isObject = PyView3DAttributes_Check(v);
    bool arg2isObject = PyView3DAttributes_Check(w);

    if(arg1isObject && arg2isObject)
    {
        return NULL;
    }
    else
    {
        PyObject *num;

        if(arg1isObject)
        {
            a = ((View3DAttributesObject *)v)->data;
            num = w;
        }
        else
        {
            a = ((View3DAttributesObject *)w)->data;
            num = v;
        }

        if(PyFloat_Check(num))
            val = PyFloat_AS_DOUBLE(num);
        else if(PyInt_Check(num))
            val = double(PyInt_AS_LONG(num));
        else if(PyLong_Check(num))
            val = PyLong_AsDouble(num);
        else
        {
            cerr << "MUL: Expected numeric argument is not a number!" << endl;
        }

        c->GetViewNormal()[0] = a->GetViewNormal()[0] * val;
        c->GetViewNormal()[1] = a->GetViewNormal()[1] * val;
        c->GetViewNormal()[2] = a->GetViewNormal()[2] * val;

        c->GetFocus()[0] = a->GetFocus()[0] * val;
        c->GetFocus()[1] = a->GetFocus()[1] * val;
        c->GetFocus()[2] = a->GetFocus()[2] * val;

        c->GetViewUp()[0] = a->GetViewUp()[0] * val;
        c->GetViewUp()[1] = a->GetViewUp()[1] * val;
        c->GetViewUp()[2] = a->GetViewUp()[2] * val;

        c->SetViewAngle(a->GetViewAngle() * val);
        c->SetParallelScale(a->GetParallelScale() * val);
        c->SetNearPlane(a->GetNearPlane() * val);
        c->SetFarPlane(a->GetFarPlane() * val);
        c->SetPerspective(a->GetPerspective() * val);

        c->GetImagePan()[0] = a->GetImagePan()[0] * val;
        c->GetImagePan()[1] = a->GetImagePan()[1] * val;
        c->SetImageZoom(a->GetImageZoom() * val);

        c->SetEyeAngle(a->GetEyeAngle() * val);

        c->SetCenterOfRotationSet(a->GetCenterOfRotationSet() * val);
        c->GetCenterOfRotation()[0] = a->GetCenterOfRotation()[0] * val;
        c->GetCenterOfRotation()[1] = a->GetCenterOfRotation()[1] * val;
        c->GetCenterOfRotation()[2] = a->GetCenterOfRotation()[2] * val;
    }

    return retval;
}

//
// The type description structure
//
static PyNumberMethods View3DAttributes_as_number = {
    (binaryfunc)View3DAttributes_add, /*nb_add*/
    (binaryfunc)0, /*nb_subtract*/
    (binaryfunc)View3DAttributes_mul, /*nb_multiply*/
    (binaryfunc)0, /*nb_divide*/
    (binaryfunc)0,    /*nb_remainder*/
    (binaryfunc)0,    /*nb_divmod*/
    (ternaryfunc)0,    /*nb_power*/
    (unaryfunc)0,    /*nb_negative*/
    (unaryfunc)0,    /*nb_positive*/
    (unaryfunc)0,    /*nb_absolute*/
    (inquiry)0,    /*nb_nonzero*/
    (unaryfunc)0,    /*nb_invert*/
    (binaryfunc)0,    /*nb_lshift*/
    (binaryfunc)0,    /*nb_rshift*/
    (binaryfunc)0,    /*nb_and*/
    (binaryfunc)0,    /*nb_xor*/
    (binaryfunc)0,    /*nb_or*/
    0,            /*nb_coerce*/
    (unaryfunc)0,    /*nb_int*/
    (unaryfunc)0,    /*nb_long*/
    (unaryfunc)0,    /*nb_float*/
    (unaryfunc)0,    /*nb_oct*/
    (unaryfunc)0,     /*nb_hex*/
    0,            /*nb_inplace_add*/
    0,            /*nb_inplace_subtract*/
    0,            /*nb_inplace_multiply*/
    0,            /*nb_inplace_divide*/
    0,            /*nb_inplace_remainder*/
    0,            /*nb_inplace_power*/
    0,            /*nb_inplace_lshift*/
    0,            /*nb_inplace_rshift*/
    0,            /*nb_inplace_and*/
    0,            /*nb_inplace_xor*/
    0,            /*nb_inplace_or*/
};

//
// The doc string for the class.
//
static char *View3DAttributes_Purpose = "This class contains the 3d view attributes.";

//
// The type description structure
//
static PyTypeObject View3DAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "View3DAttributes",                    // tp_name
    sizeof(View3DAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)View3DAttributes_dealloc,  // tp_dealloc
    (printfunc)View3DAttributes_print,     // tp_print
    (getattrfunc)View3DAttributes_getattr, // tp_getattr
    (setattrfunc)View3DAttributes_setattr, // tp_setattr
    (cmpfunc)View3DAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    &View3DAttributes_as_number,         // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)View3DAttributes_str,      // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    View3DAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static View3DAttributes *defaultAtts = 0;

static PyObject *
NewView3DAttributes()
{
    View3DAttributesObject *newObject;
    newObject = PyObject_NEW(View3DAttributesObject, &View3DAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new View3DAttributes(*defaultAtts);
    else
        newObject->data = new View3DAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapView3DAttributes(const View3DAttributes *attr)
{
    View3DAttributesObject *newObject;
    newObject = PyObject_NEW(View3DAttributesObject, &View3DAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (View3DAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
View3DAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewView3DAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef View3DAttributesMethods[] = {
    {"View3DAttributes", View3DAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *View3DAttributesObserver = 0;
static bool View3DAttributesEnableLogging = true;

static void
PyView3DAttributes_WriteLog(Subject *subj, void *data)
{
    View3DAttributes *atts = (View3DAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!View3DAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# View3DAttributes_WriteLog()\n");
}

void
PyView3DAttributes_StartUp(View3DAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyView3DAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(View3DAttributesObserver == 0)
    {
        View3DAttributesObserver = new ObserverToCallback(subj,
            PyView3DAttributes_WriteLog, (void *)logFile);
    }

    View3DAttributesEnableLogging = true;
}

void
PyView3DAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete View3DAttributesObserver;
    View3DAttributesObserver = 0;
}

PyMethodDef *
PyView3DAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return View3DAttributesMethods;
}

bool
PyView3DAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &View3DAttributesType);
}

View3DAttributes *
PyView3DAttributes_FromPyObject(PyObject *obj)
{
    View3DAttributesObject *obj2 = (View3DAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyView3DAttributes_NewPyObject()
{
    return NewView3DAttributes();
}

PyObject *
PyView3DAttributes_WrapPyObject(const View3DAttributes *attr)
{
    return WrapView3DAttributes(attr);
}

void
PyView3DAttributes_SetLogging(bool val)
{
    View3DAttributesEnableLogging = val;
}

void
PyView3DAttributes_SetDefaults(const View3DAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new View3DAttributes(*atts);
}

