#include <PyView2DAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyView2DAttributes
//
// Purpose: 
//   This class contains the 2d view attributes.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Oct 16 15:08:27 PST 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a View2DAttributes.
//
struct View2DAttributesObject
{
    PyObject_HEAD
    View2DAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewView2DAttributes();

static PyObject *
View2DAttributes_Notify(PyObject *self, PyObject *args)
{
    View2DAttributesObject *obj = (View2DAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View2DAttributes_SetWindowCoords(PyObject *self, PyObject *args)
{
    View2DAttributesObject *obj = (View2DAttributesObject *)self;

    double *dvals = obj->data->GetWindowCoords();
    if(!PyArg_ParseTuple(args, "dddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 4)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the windowCoords in the object as modified.
    obj->data->SelectWindowCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View2DAttributes_GetWindowCoords(PyObject *self, PyObject *args)
{
    View2DAttributesObject *obj = (View2DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the windowCoords.
    PyObject *retval = PyTuple_New(4);
    const double *windowCoords = obj->data->GetWindowCoords();
    for(int i = 0; i < 4; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(windowCoords[i]));
    return retval;
}

static PyObject *
View2DAttributes_SetViewportCoords(PyObject *self, PyObject *args)
{
    View2DAttributesObject *obj = (View2DAttributesObject *)self;

    double *dvals = obj->data->GetViewportCoords();
    if(!PyArg_ParseTuple(args, "dddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 4)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the viewportCoords in the object as modified.
    obj->data->SelectViewportCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View2DAttributes_GetViewportCoords(PyObject *self, PyObject *args)
{
    View2DAttributesObject *obj = (View2DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the viewportCoords.
    PyObject *retval = PyTuple_New(4);
    const double *viewportCoords = obj->data->GetViewportCoords();
    for(int i = 0; i < 4; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(viewportCoords[i]));
    return retval;
}

static PyObject *
View2DAttributes_SetFullFrame(PyObject *self, PyObject *args)
{
    View2DAttributesObject *obj = (View2DAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fullFrame in the object.
    obj->data->SetFullFrame(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
View2DAttributes_GetFullFrame(PyObject *self, PyObject *args)
{
    View2DAttributesObject *obj = (View2DAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFullFrame()?1L:0L);
    return retval;
}



static struct PyMethodDef View2DAttributes_methods[] = {
    {"Notify", View2DAttributes_Notify, METH_VARARGS},
    {"SetWindowCoords", View2DAttributes_SetWindowCoords, METH_VARARGS},
    {"GetWindowCoords", View2DAttributes_GetWindowCoords, METH_VARARGS},
    {"SetViewportCoords", View2DAttributes_SetViewportCoords, METH_VARARGS},
    {"GetViewportCoords", View2DAttributes_GetViewportCoords, METH_VARARGS},
    {"SetFullFrame", View2DAttributes_SetFullFrame, METH_VARARGS},
    {"GetFullFrame", View2DAttributes_GetFullFrame, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
View2DAttributes_dealloc(PyObject *v)
{
   View2DAttributesObject *obj = (View2DAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
View2DAttributes_compare(PyObject *v, PyObject *w)
{
    View2DAttributes *a = ((View2DAttributesObject *)v)->data;
    View2DAttributes *b = ((View2DAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
View2DAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "windowCoords") == 0)
        return View2DAttributes_GetWindowCoords(self, NULL);
    if(strcmp(name, "viewportCoords") == 0)
        return View2DAttributes_GetViewportCoords(self, NULL);
    if(strcmp(name, "fullFrame") == 0)
        return View2DAttributes_GetFullFrame(self, NULL);

    return Py_FindMethod(View2DAttributes_methods, self, name);
}

static int
View2DAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "windowCoords") == 0)
        retval = (View2DAttributes_SetWindowCoords(self, tuple) != NULL);
    else if(strcmp(name, "viewportCoords") == 0)
        retval = (View2DAttributes_SetViewportCoords(self, tuple) != NULL);
    else if(strcmp(name, "fullFrame") == 0)
        retval = (View2DAttributes_SetFullFrame(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
View2DAttributes_print(PyObject *v, FILE *fp, int flags)
{
    View2DAttributesObject *obj = (View2DAttributesObject *)v;

    {   const double *windowCoords = obj->data->GetWindowCoords();
        fprintf(fp, "windowCoords = (");
        for(int i = 0; i < 4; ++i)
        {
            fprintf(fp, "%g", windowCoords[i]);
            if(i < 3)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *viewportCoords = obj->data->GetViewportCoords();
        fprintf(fp, "viewportCoords = (");
        for(int i = 0; i < 4; ++i)
        {
            fprintf(fp, "%g", viewportCoords[i]);
            if(i < 3)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    if(obj->data->GetFullFrame())
        fprintf(fp, "fullFrame = 1\n");
    else
        fprintf(fp, "fullFrame = 0\n");

    return 0;
}

static PyObject *
View2DAttributes_add(PyObject *v, PyObject *w)
{
    bool arg1isObject = PyView2DAttributes_Check(v);
    bool arg2isObject = PyView2DAttributes_Check(w);
    if(!arg1isObject || !arg2isObject)
    {
        cerr << "View2DAttributes_add: One or more arguments are not View2DAttributes!" << endl;
        return NULL;
    }

    PyObject *retval = NewView2DAttributes();
    View2DAttributes *c = PyView2DAttributes_FromPyObject(retval);
    View2DAttributes *a = ((View2DAttributesObject *)v)->data;
    View2DAttributes *b = ((View2DAttributesObject *)w)->data;

    c->GetWindowCoords()[0] = a->GetWindowCoords()[0] + b->GetWindowCoords()[0];
    c->GetWindowCoords()[1] = a->GetWindowCoords()[1] + b->GetWindowCoords()[1];
    c->GetWindowCoords()[2] = a->GetWindowCoords()[2] + b->GetWindowCoords()[2];
    c->GetWindowCoords()[3] = a->GetWindowCoords()[3] + b->GetWindowCoords()[3];

    c->GetViewportCoords()[0] = a->GetViewportCoords()[0] + b->GetViewportCoords()[0];
    c->GetViewportCoords()[1] = a->GetViewportCoords()[1] + b->GetViewportCoords()[1];
    c->GetViewportCoords()[2] = a->GetViewportCoords()[2] + b->GetViewportCoords()[2];
    c->GetViewportCoords()[3] = a->GetViewportCoords()[3] + b->GetViewportCoords()[3];

    c->SetFullFrame(a->GetFullFrame() + b->GetFullFrame());

    return retval;
}

static PyObject *
View2DAttributes_mul(PyObject *v, PyObject *w)
{
    PyObject *retval = NewView2DAttributes();
    View2DAttributes *c = PyView2DAttributes_FromPyObject(retval);

    View2DAttributes *a;
    double val = 1.;
    bool arg1isObject = PyView2DAttributes_Check(v);
    bool arg2isObject = PyView2DAttributes_Check(w);

    if(arg1isObject && arg2isObject)
    {
        return NULL;
    }
    else
    {
        PyObject *num;

        if(arg1isObject)
        {
            a = ((View2DAttributesObject *)v)->data;
            num = w;
        }
        else
        {
            a = ((View2DAttributesObject *)w)->data;
            num = v;
        }

        if(PyFloat_Check(num))
            val = PyFloat_AS_DOUBLE(num);
        else if(PyInt_Check(num))
            val = double(PyInt_AS_LONG(num));
        else if(PyLong_Check(num))
            val = PyLong_AsDouble(num);
        else
        {
            cerr << "MUL: Expected numeric argument is not a number!" << endl;
        }

        c->GetWindowCoords()[0] = a->GetWindowCoords()[0] * val;
        c->GetWindowCoords()[1] = a->GetWindowCoords()[1] * val;
        c->GetWindowCoords()[2] = a->GetWindowCoords()[2] * val;
        c->GetWindowCoords()[3] = a->GetWindowCoords()[3] * val;

        c->GetViewportCoords()[0] = a->GetViewportCoords()[0] * val;
        c->GetViewportCoords()[1] = a->GetViewportCoords()[1] * val;
        c->GetViewportCoords()[2] = a->GetViewportCoords()[2] * val;
        c->GetViewportCoords()[3] = a->GetViewportCoords()[3] * val;

        c->SetFullFrame(a->GetFullFrame() * val);
    }

    return retval;
}

//
// The type description structure
//
static PyNumberMethods View2DAttributes_as_number = {
    (binaryfunc)View2DAttributes_add, /*nb_add*/
    (binaryfunc)0, /*nb_subtract*/
    (binaryfunc)View2DAttributes_mul, /*nb_multiply*/
    (binaryfunc)0, /*nb_divide*/
    (binaryfunc)0,    /*nb_remainder*/
    (binaryfunc)0,    /*nb_divmod*/
    (ternaryfunc)0,    /*nb_power*/
    (unaryfunc)0,    /*nb_negative*/
    (unaryfunc)0,    /*nb_positive*/
    (unaryfunc)0,    /*nb_absolute*/
    (inquiry)0,    /*nb_nonzero*/
    (unaryfunc)0,    /*nb_invert*/
    (binaryfunc)0,    /*nb_lshift*/
    (binaryfunc)0,    /*nb_rshift*/
    (binaryfunc)0,    /*nb_and*/
    (binaryfunc)0,    /*nb_xor*/
    (binaryfunc)0,    /*nb_or*/
    0,            /*nb_coerce*/
    (unaryfunc)0,    /*nb_int*/
    (unaryfunc)0,    /*nb_long*/
    (unaryfunc)0,    /*nb_float*/
    (unaryfunc)0,    /*nb_oct*/
    (unaryfunc)0,     /*nb_hex*/
    0,            /*nb_inplace_add*/
    0,            /*nb_inplace_subtract*/
    0,            /*nb_inplace_multiply*/
    0,            /*nb_inplace_divide*/
    0,            /*nb_inplace_remainder*/
    0,            /*nb_inplace_power*/
    0,            /*nb_inplace_lshift*/
    0,            /*nb_inplace_rshift*/
    0,            /*nb_inplace_and*/
    0,            /*nb_inplace_xor*/
    0,            /*nb_inplace_or*/
};

//
// The doc string for the class.
//
static char *View2DAttributes_Purpose = "This class contains the 2d view attributes.";

//
// The type description structure
//
static PyTypeObject View2DAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "View2DAttributes",                    // tp_name
    sizeof(View2DAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)View2DAttributes_dealloc,  // tp_dealloc
    (printfunc)View2DAttributes_print,     // tp_print
    (getattrfunc)View2DAttributes_getattr, // tp_getattr
    (setattrfunc)View2DAttributes_setattr, // tp_setattr
    (cmpfunc)View2DAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    &View2DAttributes_as_number,         // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    View2DAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static View2DAttributes *defaultAtts = 0;

static PyObject *
NewView2DAttributes()
{
    View2DAttributesObject *newObject;
    newObject = PyObject_NEW(View2DAttributesObject, &View2DAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new View2DAttributes(*defaultAtts);
    else
        newObject->data = new View2DAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapView2DAttributes(const View2DAttributes *attr)
{
    View2DAttributesObject *newObject;
    newObject = PyObject_NEW(View2DAttributesObject, &View2DAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (View2DAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
View2DAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewView2DAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef View2DAttributesMethods[] = {
    {"View2DAttributes", View2DAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *View2DAttributesObserver = 0;
static bool View2DAttributesEnableLogging = true;

static void
PyView2DAttributes_WriteLog(Subject *subj, void *data)
{
    View2DAttributes *atts = (View2DAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!View2DAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# View2DAttributes_WriteLog()\n");
}

void
PyView2DAttributes_StartUp(View2DAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyView2DAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(View2DAttributesObserver == 0)
    {
        View2DAttributesObserver = new ObserverToCallback(subj,
            PyView2DAttributes_WriteLog, (void *)logFile);
    }

    View2DAttributesEnableLogging = true;
}

void
PyView2DAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete View2DAttributesObserver;
    View2DAttributesObserver = 0;
}

PyMethodDef *
PyView2DAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return View2DAttributesMethods;
}

bool
PyView2DAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &View2DAttributesType);
}

View2DAttributes *
PyView2DAttributes_FromPyObject(PyObject *obj)
{
    View2DAttributesObject *obj2 = (View2DAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyView2DAttributes_NewPyObject()
{
    return NewView2DAttributes();
}

PyObject *
PyView2DAttributes_WrapPyObject(const View2DAttributes *attr)
{
    return WrapView2DAttributes(attr);
}

void
PyView2DAttributes_SetLogging(bool val)
{
    View2DAttributesEnableLogging = val;
}

void
PyView2DAttributes_SetDefaults(const View2DAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new View2DAttributes(*atts);
}

