#include <PySaveWindowAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PySaveWindowAttributes
//
// Purpose: 
//   This class contains the attributes used for saving windows.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Jul 30 16:33:03 PST 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a SaveWindowAttributes.
//
struct SaveWindowAttributesObject
{
    PyObject_HEAD
    SaveWindowAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewSaveWindowAttributes();

static PyObject *
SaveWindowAttributes_Notify(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_SetOutputToCurrentDirectory(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outputToCurrentDirectory in the object.
    obj->data->SetOutputToCurrentDirectory(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetOutputToCurrentDirectory(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOutputToCurrentDirectory()?1L:0L);
    return retval;
}

static PyObject *
SaveWindowAttributes_SetOutputDirectory(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the outputDirectory in the object.
    obj->data->SetOutputDirectory(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetOutputDirectory(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOutputDirectory().c_str());
    return retval;
}

static PyObject *
SaveWindowAttributes_SetFileName(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the fileName in the object.
    obj->data->SetFileName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetFileName(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetFileName().c_str());
    return retval;
}

static PyObject *
SaveWindowAttributes_SetFamily(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the family in the object.
    obj->data->SetFamily(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetFamily(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFamily()?1L:0L);
    return retval;
}

static PyObject *
SaveWindowAttributes_SetFormat(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the format in the object.
    if(ival >= 0 && ival < 12)
        obj->data->SetFormat(SaveWindowAttributes::FileFormat(ival));
    else
    {
        fprintf(stderr, "An invalid format value was given. "
                        "Valid values are in the range of [0,11]. "
                        "You can also use the following names: "
                        "BMP, CURVE, JPEG, OBJ, PNG, POSTSCRIPT, PPM, RGB, STL, TIFF, ULTRA, VTK.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetFormat(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFormat()));
    return retval;
}

static PyObject *
SaveWindowAttributes_SetMaintainAspect(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maintainAspect in the object.
    obj->data->SetMaintainAspect(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetMaintainAspect(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaintainAspect()?1L:0L);
    return retval;
}

static PyObject *
SaveWindowAttributes_SetWidth(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the width in the object.
    obj->data->SetWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetWidth(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWidth()));
    return retval;
}

static PyObject *
SaveWindowAttributes_SetHeight(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the height in the object.
    obj->data->SetHeight(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetHeight(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetHeight()));
    return retval;
}

static PyObject *
SaveWindowAttributes_SetScreenCapture(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the screenCapture in the object.
    obj->data->SetScreenCapture(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetScreenCapture(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetScreenCapture()?1L:0L);
    return retval;
}

static PyObject *
SaveWindowAttributes_SetSaveTiled(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the saveTiled in the object.
    obj->data->SetSaveTiled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetSaveTiled(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSaveTiled()?1L:0L);
    return retval;
}

static PyObject *
SaveWindowAttributes_SetQuality(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the quality in the object.
    obj->data->SetQuality(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetQuality(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetQuality()));
    return retval;
}

static PyObject *
SaveWindowAttributes_SetProgressive(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the progressive in the object.
    obj->data->SetProgressive(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetProgressive(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetProgressive()?1L:0L);
    return retval;
}

static PyObject *
SaveWindowAttributes_SetBinary(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the binary in the object.
    obj->data->SetBinary(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetBinary(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetBinary()?1L:0L);
    return retval;
}

static PyObject *
SaveWindowAttributes_SetStereo(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stereo in the object.
    obj->data->SetStereo(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetStereo(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetStereo()?1L:0L);
    return retval;
}

static PyObject *
SaveWindowAttributes_SetCompression(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the compression in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetCompression(SaveWindowAttributes::CompressionType(ival));
    else
    {
        fprintf(stderr, "An invalid compression value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "None, PackBits, Jpeg, Deflate.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SaveWindowAttributes_GetCompression(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCompression()));
    return retval;
}



static struct PyMethodDef SaveWindowAttributes_methods[] = {
    {"Notify", SaveWindowAttributes_Notify, METH_VARARGS},
    {"SetOutputToCurrentDirectory", SaveWindowAttributes_SetOutputToCurrentDirectory, METH_VARARGS},
    {"GetOutputToCurrentDirectory", SaveWindowAttributes_GetOutputToCurrentDirectory, METH_VARARGS},
    {"SetOutputDirectory", SaveWindowAttributes_SetOutputDirectory, METH_VARARGS},
    {"GetOutputDirectory", SaveWindowAttributes_GetOutputDirectory, METH_VARARGS},
    {"SetFileName", SaveWindowAttributes_SetFileName, METH_VARARGS},
    {"GetFileName", SaveWindowAttributes_GetFileName, METH_VARARGS},
    {"SetFamily", SaveWindowAttributes_SetFamily, METH_VARARGS},
    {"GetFamily", SaveWindowAttributes_GetFamily, METH_VARARGS},
    {"SetFormat", SaveWindowAttributes_SetFormat, METH_VARARGS},
    {"GetFormat", SaveWindowAttributes_GetFormat, METH_VARARGS},
    {"SetMaintainAspect", SaveWindowAttributes_SetMaintainAspect, METH_VARARGS},
    {"GetMaintainAspect", SaveWindowAttributes_GetMaintainAspect, METH_VARARGS},
    {"SetWidth", SaveWindowAttributes_SetWidth, METH_VARARGS},
    {"GetWidth", SaveWindowAttributes_GetWidth, METH_VARARGS},
    {"SetHeight", SaveWindowAttributes_SetHeight, METH_VARARGS},
    {"GetHeight", SaveWindowAttributes_GetHeight, METH_VARARGS},
    {"SetScreenCapture", SaveWindowAttributes_SetScreenCapture, METH_VARARGS},
    {"GetScreenCapture", SaveWindowAttributes_GetScreenCapture, METH_VARARGS},
    {"SetSaveTiled", SaveWindowAttributes_SetSaveTiled, METH_VARARGS},
    {"GetSaveTiled", SaveWindowAttributes_GetSaveTiled, METH_VARARGS},
    {"SetQuality", SaveWindowAttributes_SetQuality, METH_VARARGS},
    {"GetQuality", SaveWindowAttributes_GetQuality, METH_VARARGS},
    {"SetProgressive", SaveWindowAttributes_SetProgressive, METH_VARARGS},
    {"GetProgressive", SaveWindowAttributes_GetProgressive, METH_VARARGS},
    {"SetBinary", SaveWindowAttributes_SetBinary, METH_VARARGS},
    {"GetBinary", SaveWindowAttributes_GetBinary, METH_VARARGS},
    {"SetStereo", SaveWindowAttributes_SetStereo, METH_VARARGS},
    {"GetStereo", SaveWindowAttributes_GetStereo, METH_VARARGS},
    {"SetCompression", SaveWindowAttributes_SetCompression, METH_VARARGS},
    {"GetCompression", SaveWindowAttributes_GetCompression, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SaveWindowAttributes_dealloc(PyObject *v)
{
   SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
SaveWindowAttributes_compare(PyObject *v, PyObject *w)
{
    SaveWindowAttributes *a = ((SaveWindowAttributesObject *)v)->data;
    SaveWindowAttributes *b = ((SaveWindowAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
SaveWindowAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "outputToCurrentDirectory") == 0)
        return SaveWindowAttributes_GetOutputToCurrentDirectory(self, NULL);
    if(strcmp(name, "outputDirectory") == 0)
        return SaveWindowAttributes_GetOutputDirectory(self, NULL);
    if(strcmp(name, "fileName") == 0)
        return SaveWindowAttributes_GetFileName(self, NULL);
    if(strcmp(name, "family") == 0)
        return SaveWindowAttributes_GetFamily(self, NULL);
    if(strcmp(name, "format") == 0)
        return SaveWindowAttributes_GetFormat(self, NULL);
    if(strcmp(name, "BMP") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::BMP));
    else if(strcmp(name, "CURVE") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::CURVE));
    else if(strcmp(name, "JPEG") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::JPEG));
    else if(strcmp(name, "OBJ") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::OBJ));
    else if(strcmp(name, "PNG") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::PNG));
    else if(strcmp(name, "POSTSCRIPT") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::POSTSCRIPT));
    else if(strcmp(name, "PPM") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::PPM));
    else if(strcmp(name, "RGB") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::RGB));
    else if(strcmp(name, "STL") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::STL));
    else if(strcmp(name, "TIFF") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::TIFF));
    else if(strcmp(name, "ULTRA") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::ULTRA));
    else if(strcmp(name, "VTK") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::VTK));

    if(strcmp(name, "maintainAspect") == 0)
        return SaveWindowAttributes_GetMaintainAspect(self, NULL);
    if(strcmp(name, "width") == 0)
        return SaveWindowAttributes_GetWidth(self, NULL);
    if(strcmp(name, "height") == 0)
        return SaveWindowAttributes_GetHeight(self, NULL);
    if(strcmp(name, "screenCapture") == 0)
        return SaveWindowAttributes_GetScreenCapture(self, NULL);
    if(strcmp(name, "saveTiled") == 0)
        return SaveWindowAttributes_GetSaveTiled(self, NULL);
    if(strcmp(name, "quality") == 0)
        return SaveWindowAttributes_GetQuality(self, NULL);
    if(strcmp(name, "progressive") == 0)
        return SaveWindowAttributes_GetProgressive(self, NULL);
    if(strcmp(name, "binary") == 0)
        return SaveWindowAttributes_GetBinary(self, NULL);
    if(strcmp(name, "stereo") == 0)
        return SaveWindowAttributes_GetStereo(self, NULL);
    if(strcmp(name, "compression") == 0)
        return SaveWindowAttributes_GetCompression(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::None));
    else if(strcmp(name, "PackBits") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::PackBits));
    else if(strcmp(name, "Jpeg") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::Jpeg));
    else if(strcmp(name, "Deflate") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::Deflate));


    return Py_FindMethod(SaveWindowAttributes_methods, self, name);
}

static int
SaveWindowAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "outputToCurrentDirectory") == 0)
        retval = (SaveWindowAttributes_SetOutputToCurrentDirectory(self, tuple) != NULL);
    else if(strcmp(name, "outputDirectory") == 0)
        retval = (SaveWindowAttributes_SetOutputDirectory(self, tuple) != NULL);
    else if(strcmp(name, "fileName") == 0)
        retval = (SaveWindowAttributes_SetFileName(self, tuple) != NULL);
    else if(strcmp(name, "family") == 0)
        retval = (SaveWindowAttributes_SetFamily(self, tuple) != NULL);
    else if(strcmp(name, "format") == 0)
        retval = (SaveWindowAttributes_SetFormat(self, tuple) != NULL);
    else if(strcmp(name, "maintainAspect") == 0)
        retval = (SaveWindowAttributes_SetMaintainAspect(self, tuple) != NULL);
    else if(strcmp(name, "width") == 0)
        retval = (SaveWindowAttributes_SetWidth(self, tuple) != NULL);
    else if(strcmp(name, "height") == 0)
        retval = (SaveWindowAttributes_SetHeight(self, tuple) != NULL);
    else if(strcmp(name, "screenCapture") == 0)
        retval = (SaveWindowAttributes_SetScreenCapture(self, tuple) != NULL);
    else if(strcmp(name, "saveTiled") == 0)
        retval = (SaveWindowAttributes_SetSaveTiled(self, tuple) != NULL);
    else if(strcmp(name, "quality") == 0)
        retval = (SaveWindowAttributes_SetQuality(self, tuple) != NULL);
    else if(strcmp(name, "progressive") == 0)
        retval = (SaveWindowAttributes_SetProgressive(self, tuple) != NULL);
    else if(strcmp(name, "binary") == 0)
        retval = (SaveWindowAttributes_SetBinary(self, tuple) != NULL);
    else if(strcmp(name, "stereo") == 0)
        retval = (SaveWindowAttributes_SetStereo(self, tuple) != NULL);
    else if(strcmp(name, "compression") == 0)
        retval = (SaveWindowAttributes_SetCompression(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
SaveWindowAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)v;

    if(obj->data->GetOutputToCurrentDirectory())
        fprintf(fp, "outputToCurrentDirectory = 1\n");
    else
        fprintf(fp, "outputToCurrentDirectory = 0\n");
    fprintf(fp, "outputDirectory = \"%s\"\n", obj->data->GetOutputDirectory().c_str());
    fprintf(fp, "fileName = \"%s\"\n", obj->data->GetFileName().c_str());
    if(obj->data->GetFamily())
        fprintf(fp, "family = 1\n");
    else
        fprintf(fp, "family = 0\n");
    const char *format_names = "BMP, CURVE, JPEG, OBJ, PNG, POSTSCRIPT, PPM, RGB, STL, TIFF, ULTRA, VTK";
    if(obj->data->GetFormat() == SaveWindowAttributes::BMP)
        fprintf(fp, "format = BMP  # %s\n", format_names);
    else if(obj->data->GetFormat() == SaveWindowAttributes::CURVE)
        fprintf(fp, "format = CURVE  # %s\n", format_names);
    else if(obj->data->GetFormat() == SaveWindowAttributes::JPEG)
        fprintf(fp, "format = JPEG  # %s\n", format_names);
    else if(obj->data->GetFormat() == SaveWindowAttributes::OBJ)
        fprintf(fp, "format = OBJ  # %s\n", format_names);
    else if(obj->data->GetFormat() == SaveWindowAttributes::PNG)
        fprintf(fp, "format = PNG  # %s\n", format_names);
    else if(obj->data->GetFormat() == SaveWindowAttributes::POSTSCRIPT)
        fprintf(fp, "format = POSTSCRIPT  # %s\n", format_names);
    else if(obj->data->GetFormat() == SaveWindowAttributes::PPM)
        fprintf(fp, "format = PPM  # %s\n", format_names);
    else if(obj->data->GetFormat() == SaveWindowAttributes::RGB)
        fprintf(fp, "format = RGB  # %s\n", format_names);
    else if(obj->data->GetFormat() == SaveWindowAttributes::STL)
        fprintf(fp, "format = STL  # %s\n", format_names);
    else if(obj->data->GetFormat() == SaveWindowAttributes::TIFF)
        fprintf(fp, "format = TIFF  # %s\n", format_names);
    else if(obj->data->GetFormat() == SaveWindowAttributes::ULTRA)
        fprintf(fp, "format = ULTRA  # %s\n", format_names);
    else
        fprintf(fp, "format = VTK  # %s\n", format_names);

    if(obj->data->GetMaintainAspect())
        fprintf(fp, "maintainAspect = 1\n");
    else
        fprintf(fp, "maintainAspect = 0\n");
    fprintf(fp, "width = %d\n", obj->data->GetWidth());
    fprintf(fp, "height = %d\n", obj->data->GetHeight());
    if(obj->data->GetScreenCapture())
        fprintf(fp, "screenCapture = 1\n");
    else
        fprintf(fp, "screenCapture = 0\n");
    if(obj->data->GetSaveTiled())
        fprintf(fp, "saveTiled = 1\n");
    else
        fprintf(fp, "saveTiled = 0\n");
    fprintf(fp, "quality = %d\n", obj->data->GetQuality());
    if(obj->data->GetProgressive())
        fprintf(fp, "progressive = 1\n");
    else
        fprintf(fp, "progressive = 0\n");
    if(obj->data->GetBinary())
        fprintf(fp, "binary = 1\n");
    else
        fprintf(fp, "binary = 0\n");
    if(obj->data->GetStereo())
        fprintf(fp, "stereo = 1\n");
    else
        fprintf(fp, "stereo = 0\n");
    const char *compression_names = "None, PackBits, Jpeg, Deflate";
    if(obj->data->GetCompression() == SaveWindowAttributes::None)
        fprintf(fp, "compression = None  # %s\n", compression_names);
    else if(obj->data->GetCompression() == SaveWindowAttributes::PackBits)
        fprintf(fp, "compression = PackBits  # %s\n", compression_names);
    else if(obj->data->GetCompression() == SaveWindowAttributes::Jpeg)
        fprintf(fp, "compression = Jpeg  # %s\n", compression_names);
    else
        fprintf(fp, "compression = Deflate  # %s\n", compression_names);


    return 0;
}

#include <snprintf.h>
PyObject *
PySaveWindowAttributes_StringRepresentation(const SaveWindowAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetOutputToCurrentDirectory())
        SNPRINTF(tmpStr, 1000, "outputToCurrentDirectory = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "outputToCurrentDirectory = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "outputDirectory = \"%s\"\n", atts->GetOutputDirectory().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "fileName = \"%s\"\n", atts->GetFileName().c_str());
    str += tmpStr;
    if(atts->GetFamily())
        SNPRINTF(tmpStr, 1000, "family = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "family = 0\n");
    str += tmpStr;
    const char *format_names = "BMP, CURVE, JPEG, OBJ, PNG, POSTSCRIPT, PPM, RGB, STL, TIFF, ULTRA, VTK";
    if(atts->GetFormat() == SaveWindowAttributes::BMP)
        {
             SNPRINTF(tmpStr, 1000, "format = BMP  # %s\n", format_names);
             str += tmpStr;
        }
    else if(atts->GetFormat() == SaveWindowAttributes::CURVE)
        {
             SNPRINTF(tmpStr, 1000, "format = CURVE  # %s\n", format_names);
             str += tmpStr;
        }
    else if(atts->GetFormat() == SaveWindowAttributes::JPEG)
        {
             SNPRINTF(tmpStr, 1000, "format = JPEG  # %s\n", format_names);
             str += tmpStr;
        }
    else if(atts->GetFormat() == SaveWindowAttributes::OBJ)
        {
             SNPRINTF(tmpStr, 1000, "format = OBJ  # %s\n", format_names);
             str += tmpStr;
        }
    else if(atts->GetFormat() == SaveWindowAttributes::PNG)
        {
             SNPRINTF(tmpStr, 1000, "format = PNG  # %s\n", format_names);
             str += tmpStr;
        }
    else if(atts->GetFormat() == SaveWindowAttributes::POSTSCRIPT)
        {
             SNPRINTF(tmpStr, 1000, "format = POSTSCRIPT  # %s\n", format_names);
             str += tmpStr;
        }
    else if(atts->GetFormat() == SaveWindowAttributes::PPM)
        {
             SNPRINTF(tmpStr, 1000, "format = PPM  # %s\n", format_names);
             str += tmpStr;
        }
    else if(atts->GetFormat() == SaveWindowAttributes::RGB)
        {
             SNPRINTF(tmpStr, 1000, "format = RGB  # %s\n", format_names);
             str += tmpStr;
        }
    else if(atts->GetFormat() == SaveWindowAttributes::STL)
        {
             SNPRINTF(tmpStr, 1000, "format = STL  # %s\n", format_names);
             str += tmpStr;
        }
    else if(atts->GetFormat() == SaveWindowAttributes::TIFF)
        {
             SNPRINTF(tmpStr, 1000, "format = TIFF  # %s\n", format_names);
             str += tmpStr;
        }
    else if(atts->GetFormat() == SaveWindowAttributes::ULTRA)
        {
             SNPRINTF(tmpStr, 1000, "format = ULTRA  # %s\n", format_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "format = VTK  # %s\n", format_names);
             str += tmpStr;
        }

    if(atts->GetMaintainAspect())
        SNPRINTF(tmpStr, 1000, "maintainAspect = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "maintainAspect = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "width = %d\n", atts->GetWidth());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "height = %d\n", atts->GetHeight());
    str += tmpStr;
    if(atts->GetScreenCapture())
        SNPRINTF(tmpStr, 1000, "screenCapture = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "screenCapture = 0\n");
    str += tmpStr;
    if(atts->GetSaveTiled())
        SNPRINTF(tmpStr, 1000, "saveTiled = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "saveTiled = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "quality = %d\n", atts->GetQuality());
    str += tmpStr;
    if(atts->GetProgressive())
        SNPRINTF(tmpStr, 1000, "progressive = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "progressive = 0\n");
    str += tmpStr;
    if(atts->GetBinary())
        SNPRINTF(tmpStr, 1000, "binary = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "binary = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lastRealFilename = \"%s\"\n", atts->GetLastRealFilename().c_str());
    str += tmpStr;
    if(atts->GetStereo())
        SNPRINTF(tmpStr, 1000, "stereo = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "stereo = 0\n");
    str += tmpStr;
    const char *compression_names = "None, PackBits, Jpeg, Deflate";
    if(atts->GetCompression() == SaveWindowAttributes::None)
        {
             SNPRINTF(tmpStr, 1000, "compression = None  # %s\n", compression_names);
             str += tmpStr;
        }
    else if(atts->GetCompression() == SaveWindowAttributes::PackBits)
        {
             SNPRINTF(tmpStr, 1000, "compression = PackBits  # %s\n", compression_names);
             str += tmpStr;
        }
    else if(atts->GetCompression() == SaveWindowAttributes::Jpeg)
        {
             SNPRINTF(tmpStr, 1000, "compression = Jpeg  # %s\n", compression_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "compression = Deflate  # %s\n", compression_names);
             str += tmpStr;
        }

    return PyString_FromString(str.c_str());
}

static PyObject *
SaveWindowAttributes_str(PyObject *v)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)v;
    return PySaveWindowAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *SaveWindowAttributes_Purpose = "This class contains the attributes used for saving windows.";

//
// The type description structure
//
static PyTypeObject SaveWindowAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SaveWindowAttributes",                    // tp_name
    sizeof(SaveWindowAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SaveWindowAttributes_dealloc,  // tp_dealloc
    (printfunc)SaveWindowAttributes_print,     // tp_print
    (getattrfunc)SaveWindowAttributes_getattr, // tp_getattr
    (setattrfunc)SaveWindowAttributes_setattr, // tp_setattr
    (cmpfunc)SaveWindowAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SaveWindowAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SaveWindowAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SaveWindowAttributes *defaultAtts = 0;

static PyObject *
NewSaveWindowAttributes()
{
    SaveWindowAttributesObject *newObject;
    newObject = PyObject_NEW(SaveWindowAttributesObject, &SaveWindowAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new SaveWindowAttributes(*defaultAtts);
    else
        newObject->data = new SaveWindowAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapSaveWindowAttributes(const SaveWindowAttributes *attr)
{
    SaveWindowAttributesObject *newObject;
    newObject = PyObject_NEW(SaveWindowAttributesObject, &SaveWindowAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SaveWindowAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SaveWindowAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewSaveWindowAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SaveWindowAttributesMethods[] = {
    {"SaveWindowAttributes", SaveWindowAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SaveWindowAttributesObserver = 0;
static bool SaveWindowAttributesEnableLogging = true;

static void
PySaveWindowAttributes_WriteLog(Subject *subj, void *data)
{
    SaveWindowAttributes *atts = (SaveWindowAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!SaveWindowAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# SaveWindowAttributes_WriteLog()\n");
}

void
PySaveWindowAttributes_StartUp(SaveWindowAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PySaveWindowAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SaveWindowAttributesObserver == 0)
    {
        SaveWindowAttributesObserver = new ObserverToCallback(subj,
            PySaveWindowAttributes_WriteLog, (void *)logFile);
    }

    SaveWindowAttributesEnableLogging = true;
}

void
PySaveWindowAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SaveWindowAttributesObserver;
    SaveWindowAttributesObserver = 0;
}

PyMethodDef *
PySaveWindowAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SaveWindowAttributesMethods;
}

bool
PySaveWindowAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SaveWindowAttributesType);
}

SaveWindowAttributes *
PySaveWindowAttributes_FromPyObject(PyObject *obj)
{
    SaveWindowAttributesObject *obj2 = (SaveWindowAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySaveWindowAttributes_NewPyObject()
{
    return NewSaveWindowAttributes();
}

PyObject *
PySaveWindowAttributes_WrapPyObject(const SaveWindowAttributes *attr)
{
    return WrapSaveWindowAttributes(attr);
}

void
PySaveWindowAttributes_SetLogging(bool val)
{
    SaveWindowAttributesEnableLogging = val;
}

void
PySaveWindowAttributes_SetDefaults(const SaveWindowAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SaveWindowAttributes(*atts);
}

