#include <PyRenderingAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyRenderingAttributes
//
// Purpose: 
//   This class contains special rendering attributes like antialiasing and stero settings.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Sun Oct 24 07:31:09 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a RenderingAttributes.
//
struct RenderingAttributesObject
{
    PyObject_HEAD
    RenderingAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewRenderingAttributes();

static PyObject *
RenderingAttributes_Notify(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_SetAntialiasing(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the antialiasing in the object.
    obj->data->SetAntialiasing(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetAntialiasing(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAntialiasing()?1L:0L);
    return retval;
}

static PyObject *
RenderingAttributes_SetGeometryRepresentation(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the geometryRepresentation in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetGeometryRepresentation(RenderingAttributes::GeometryRepresentation(ival));
    else
    {
        fprintf(stderr, "An invalid geometryRepresentation value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Surfaces, Wireframe, Points.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetGeometryRepresentation(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGeometryRepresentation()));
    return retval;
}

static PyObject *
RenderingAttributes_SetDisplayListMode(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayListMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDisplayListMode(RenderingAttributes::TriStateMode(ival));
    else
    {
        fprintf(stderr, "An invalid displayListMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Never, Always, Auto.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetDisplayListMode(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDisplayListMode()));
    return retval;
}

static PyObject *
RenderingAttributes_SetStereoRendering(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stereoRendering in the object.
    obj->data->SetStereoRendering(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetStereoRendering(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetStereoRendering()?1L:0L);
    return retval;
}

static PyObject *
RenderingAttributes_SetStereoType(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stereoType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetStereoType(RenderingAttributes::StereoTypes(ival));
    else
    {
        fprintf(stderr, "An invalid stereoType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "RedBlue, Interlaced, CrystalEyes.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetStereoType(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStereoType()));
    return retval;
}

static PyObject *
RenderingAttributes_SetNotifyForEachRender(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the notifyForEachRender in the object.
    obj->data->SetNotifyForEachRender(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetNotifyForEachRender(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetNotifyForEachRender()?1L:0L);
    return retval;
}

static PyObject *
RenderingAttributes_SetScalableActivationMode(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scalableActivationMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetScalableActivationMode(RenderingAttributes::TriStateMode(ival));
    else
    {
        fprintf(stderr, "An invalid scalableActivationMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Never, Always, Auto.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetScalableActivationMode(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScalableActivationMode()));
    return retval;
}

static PyObject *
RenderingAttributes_SetScalableAutoThreshold(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scalableAutoThreshold in the object.
    obj->data->SetScalableAutoThreshold(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetScalableAutoThreshold(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScalableAutoThreshold()));
    return retval;
}

static PyObject *
RenderingAttributes_SetSpecularFlag(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the specularFlag in the object.
    obj->data->SetSpecularFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetSpecularFlag(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSpecularFlag()?1L:0L);
    return retval;
}

static PyObject *
RenderingAttributes_SetSpecularCoeff(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the specularCoeff in the object.
    obj->data->SetSpecularCoeff(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetSpecularCoeff(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetSpecularCoeff()));
    return retval;
}

static PyObject *
RenderingAttributes_SetSpecularPower(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the specularPower in the object.
    obj->data->SetSpecularPower(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetSpecularPower(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetSpecularPower()));
    return retval;
}

static PyObject *
RenderingAttributes_SetSpecularColor(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the specularColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSpecularColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetSpecularColor(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the specularColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *specularColor = obj->data->GetSpecularColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(specularColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(specularColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(specularColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(specularColor[3])));
    return retval;
}

static PyObject *
RenderingAttributes_SetDoShadowing(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doShadowing in the object.
    obj->data->SetDoShadowing(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetDoShadowing(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoShadowing()?1L:0L);
    return retval;
}

static PyObject *
RenderingAttributes_SetShadowStrength(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the shadowStrength in the object.
    obj->data->SetShadowStrength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
RenderingAttributes_GetShadowStrength(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetShadowStrength());
    return retval;
}



static struct PyMethodDef RenderingAttributes_methods[] = {
    {"Notify", RenderingAttributes_Notify, METH_VARARGS},
    {"SetAntialiasing", RenderingAttributes_SetAntialiasing, METH_VARARGS},
    {"GetAntialiasing", RenderingAttributes_GetAntialiasing, METH_VARARGS},
    {"SetGeometryRepresentation", RenderingAttributes_SetGeometryRepresentation, METH_VARARGS},
    {"GetGeometryRepresentation", RenderingAttributes_GetGeometryRepresentation, METH_VARARGS},
    {"SetDisplayListMode", RenderingAttributes_SetDisplayListMode, METH_VARARGS},
    {"GetDisplayListMode", RenderingAttributes_GetDisplayListMode, METH_VARARGS},
    {"SetStereoRendering", RenderingAttributes_SetStereoRendering, METH_VARARGS},
    {"GetStereoRendering", RenderingAttributes_GetStereoRendering, METH_VARARGS},
    {"SetStereoType", RenderingAttributes_SetStereoType, METH_VARARGS},
    {"GetStereoType", RenderingAttributes_GetStereoType, METH_VARARGS},
    {"SetNotifyForEachRender", RenderingAttributes_SetNotifyForEachRender, METH_VARARGS},
    {"GetNotifyForEachRender", RenderingAttributes_GetNotifyForEachRender, METH_VARARGS},
    {"SetScalableActivationMode", RenderingAttributes_SetScalableActivationMode, METH_VARARGS},
    {"GetScalableActivationMode", RenderingAttributes_GetScalableActivationMode, METH_VARARGS},
    {"SetScalableAutoThreshold", RenderingAttributes_SetScalableAutoThreshold, METH_VARARGS},
    {"GetScalableAutoThreshold", RenderingAttributes_GetScalableAutoThreshold, METH_VARARGS},
    {"SetSpecularFlag", RenderingAttributes_SetSpecularFlag, METH_VARARGS},
    {"GetSpecularFlag", RenderingAttributes_GetSpecularFlag, METH_VARARGS},
    {"SetSpecularCoeff", RenderingAttributes_SetSpecularCoeff, METH_VARARGS},
    {"GetSpecularCoeff", RenderingAttributes_GetSpecularCoeff, METH_VARARGS},
    {"SetSpecularPower", RenderingAttributes_SetSpecularPower, METH_VARARGS},
    {"GetSpecularPower", RenderingAttributes_GetSpecularPower, METH_VARARGS},
    {"SetSpecularColor", RenderingAttributes_SetSpecularColor, METH_VARARGS},
    {"GetSpecularColor", RenderingAttributes_GetSpecularColor, METH_VARARGS},
    {"SetDoShadowing", RenderingAttributes_SetDoShadowing, METH_VARARGS},
    {"GetDoShadowing", RenderingAttributes_GetDoShadowing, METH_VARARGS},
    {"SetShadowStrength", RenderingAttributes_SetShadowStrength, METH_VARARGS},
    {"GetShadowStrength", RenderingAttributes_GetShadowStrength, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
RenderingAttributes_dealloc(PyObject *v)
{
   RenderingAttributesObject *obj = (RenderingAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
RenderingAttributes_compare(PyObject *v, PyObject *w)
{
    RenderingAttributes *a = ((RenderingAttributesObject *)v)->data;
    RenderingAttributes *b = ((RenderingAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
RenderingAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "antialiasing") == 0)
        return RenderingAttributes_GetAntialiasing(self, NULL);
    if(strcmp(name, "geometryRepresentation") == 0)
        return RenderingAttributes_GetGeometryRepresentation(self, NULL);
    if(strcmp(name, "Surfaces") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Surfaces));
    else if(strcmp(name, "Wireframe") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Wireframe));
    else if(strcmp(name, "Points") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Points));

    if(strcmp(name, "displayListMode") == 0)
        return RenderingAttributes_GetDisplayListMode(self, NULL);
    if(strcmp(name, "Never") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Never));
    else if(strcmp(name, "Always") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Always));
    else if(strcmp(name, "Auto") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Auto));

    if(strcmp(name, "stereoRendering") == 0)
        return RenderingAttributes_GetStereoRendering(self, NULL);
    if(strcmp(name, "stereoType") == 0)
        return RenderingAttributes_GetStereoType(self, NULL);
    if(strcmp(name, "RedBlue") == 0)
        return PyInt_FromLong(long(RenderingAttributes::RedBlue));
    else if(strcmp(name, "Interlaced") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Interlaced));
    else if(strcmp(name, "CrystalEyes") == 0)
        return PyInt_FromLong(long(RenderingAttributes::CrystalEyes));

    if(strcmp(name, "notifyForEachRender") == 0)
        return RenderingAttributes_GetNotifyForEachRender(self, NULL);
    if(strcmp(name, "scalableActivationMode") == 0)
        return RenderingAttributes_GetScalableActivationMode(self, NULL);
    if(strcmp(name, "Never") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Never));
    else if(strcmp(name, "Always") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Always));
    else if(strcmp(name, "Auto") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Auto));

    if(strcmp(name, "scalableAutoThreshold") == 0)
        return RenderingAttributes_GetScalableAutoThreshold(self, NULL);
    if(strcmp(name, "specularFlag") == 0)
        return RenderingAttributes_GetSpecularFlag(self, NULL);
    if(strcmp(name, "specularCoeff") == 0)
        return RenderingAttributes_GetSpecularCoeff(self, NULL);
    if(strcmp(name, "specularPower") == 0)
        return RenderingAttributes_GetSpecularPower(self, NULL);
    if(strcmp(name, "specularColor") == 0)
        return RenderingAttributes_GetSpecularColor(self, NULL);
    if(strcmp(name, "doShadowing") == 0)
        return RenderingAttributes_GetDoShadowing(self, NULL);
    if(strcmp(name, "shadowStrength") == 0)
        return RenderingAttributes_GetShadowStrength(self, NULL);

    return Py_FindMethod(RenderingAttributes_methods, self, name);
}

static int
RenderingAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "antialiasing") == 0)
        retval = (RenderingAttributes_SetAntialiasing(self, tuple) != NULL);
    else if(strcmp(name, "geometryRepresentation") == 0)
        retval = (RenderingAttributes_SetGeometryRepresentation(self, tuple) != NULL);
    else if(strcmp(name, "displayListMode") == 0)
        retval = (RenderingAttributes_SetDisplayListMode(self, tuple) != NULL);
    else if(strcmp(name, "stereoRendering") == 0)
        retval = (RenderingAttributes_SetStereoRendering(self, tuple) != NULL);
    else if(strcmp(name, "stereoType") == 0)
        retval = (RenderingAttributes_SetStereoType(self, tuple) != NULL);
    else if(strcmp(name, "notifyForEachRender") == 0)
        retval = (RenderingAttributes_SetNotifyForEachRender(self, tuple) != NULL);
    else if(strcmp(name, "scalableActivationMode") == 0)
        retval = (RenderingAttributes_SetScalableActivationMode(self, tuple) != NULL);
    else if(strcmp(name, "scalableAutoThreshold") == 0)
        retval = (RenderingAttributes_SetScalableAutoThreshold(self, tuple) != NULL);
    else if(strcmp(name, "specularFlag") == 0)
        retval = (RenderingAttributes_SetSpecularFlag(self, tuple) != NULL);
    else if(strcmp(name, "specularCoeff") == 0)
        retval = (RenderingAttributes_SetSpecularCoeff(self, tuple) != NULL);
    else if(strcmp(name, "specularPower") == 0)
        retval = (RenderingAttributes_SetSpecularPower(self, tuple) != NULL);
    else if(strcmp(name, "specularColor") == 0)
        retval = (RenderingAttributes_SetSpecularColor(self, tuple) != NULL);
    else if(strcmp(name, "doShadowing") == 0)
        retval = (RenderingAttributes_SetDoShadowing(self, tuple) != NULL);
    else if(strcmp(name, "shadowStrength") == 0)
        retval = (RenderingAttributes_SetShadowStrength(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
RenderingAttributes_print(PyObject *v, FILE *fp, int flags)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)v;

    if(obj->data->GetAntialiasing())
        fprintf(fp, "antialiasing = 1\n");
    else
        fprintf(fp, "antialiasing = 0\n");
    const char *geometryRepresentation_names = "Surfaces, Wireframe, Points";
    if(obj->data->GetGeometryRepresentation() == RenderingAttributes::Surfaces)
        fprintf(fp, "geometryRepresentation = Surfaces  # %s\n", geometryRepresentation_names);
    else if(obj->data->GetGeometryRepresentation() == RenderingAttributes::Wireframe)
        fprintf(fp, "geometryRepresentation = Wireframe  # %s\n", geometryRepresentation_names);
    else
        fprintf(fp, "geometryRepresentation = Points  # %s\n", geometryRepresentation_names);

    const char *displayListMode_names = "Never, Always, Auto";
    if(obj->data->GetDisplayListMode() == RenderingAttributes::Never)
        fprintf(fp, "displayListMode = Never  # %s\n", displayListMode_names);
    else if(obj->data->GetDisplayListMode() == RenderingAttributes::Always)
        fprintf(fp, "displayListMode = Always  # %s\n", displayListMode_names);
    else
        fprintf(fp, "displayListMode = Auto  # %s\n", displayListMode_names);

    if(obj->data->GetStereoRendering())
        fprintf(fp, "stereoRendering = 1\n");
    else
        fprintf(fp, "stereoRendering = 0\n");
    const char *stereoType_names = "RedBlue, Interlaced, CrystalEyes";
    if(obj->data->GetStereoType() == RenderingAttributes::RedBlue)
        fprintf(fp, "stereoType = RedBlue  # %s\n", stereoType_names);
    else if(obj->data->GetStereoType() == RenderingAttributes::Interlaced)
        fprintf(fp, "stereoType = Interlaced  # %s\n", stereoType_names);
    else
        fprintf(fp, "stereoType = CrystalEyes  # %s\n", stereoType_names);

    if(obj->data->GetNotifyForEachRender())
        fprintf(fp, "notifyForEachRender = 1\n");
    else
        fprintf(fp, "notifyForEachRender = 0\n");
    const char *scalableActivationMode_names = "Never, Always, Auto";
    if(obj->data->GetScalableActivationMode() == RenderingAttributes::Never)
        fprintf(fp, "scalableActivationMode = Never  # %s\n", scalableActivationMode_names);
    else if(obj->data->GetScalableActivationMode() == RenderingAttributes::Always)
        fprintf(fp, "scalableActivationMode = Always  # %s\n", scalableActivationMode_names);
    else
        fprintf(fp, "scalableActivationMode = Auto  # %s\n", scalableActivationMode_names);

    fprintf(fp, "scalableAutoThreshold = %d\n", obj->data->GetScalableAutoThreshold());
    if(obj->data->GetSpecularFlag())
        fprintf(fp, "specularFlag = 1\n");
    else
        fprintf(fp, "specularFlag = 0\n");
    fprintf(fp, "specularCoeff = %g\n", obj->data->GetSpecularCoeff());
    fprintf(fp, "specularPower = %g\n", obj->data->GetSpecularPower());
    const unsigned char *specularColor = obj->data->GetSpecularColor().GetColor();
    fprintf(fp, "specularColor = (%d, %d, %d, %d)\n", int(specularColor[0]), int(specularColor[1]), int(specularColor[2]), int(specularColor[3]));
    if(obj->data->GetDoShadowing())
        fprintf(fp, "doShadowing = 1\n");
    else
        fprintf(fp, "doShadowing = 0\n");
    fprintf(fp, "shadowStrength = %g\n", obj->data->GetShadowStrength());

    return 0;
}

#include <snprintf.h>
PyObject *
PyRenderingAttributes_StringRepresentation(const RenderingAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetAntialiasing())
        SNPRINTF(tmpStr, 1000, "antialiasing = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "antialiasing = 0\n");
    str += tmpStr;
    const char *geometryRepresentation_names = "Surfaces, Wireframe, Points";
    if(atts->GetGeometryRepresentation() == RenderingAttributes::Surfaces)
        {
             SNPRINTF(tmpStr, 1000, "geometryRepresentation = Surfaces  # %s\n", geometryRepresentation_names);
             str += tmpStr;
        }
    else if(atts->GetGeometryRepresentation() == RenderingAttributes::Wireframe)
        {
             SNPRINTF(tmpStr, 1000, "geometryRepresentation = Wireframe  # %s\n", geometryRepresentation_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "geometryRepresentation = Points  # %s\n", geometryRepresentation_names);
             str += tmpStr;
        }

    const char *displayListMode_names = "Never, Always, Auto";
    if(atts->GetDisplayListMode() == RenderingAttributes::Never)
        {
             SNPRINTF(tmpStr, 1000, "displayListMode = Never  # %s\n", displayListMode_names);
             str += tmpStr;
        }
    else if(atts->GetDisplayListMode() == RenderingAttributes::Always)
        {
             SNPRINTF(tmpStr, 1000, "displayListMode = Always  # %s\n", displayListMode_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "displayListMode = Auto  # %s\n", displayListMode_names);
             str += tmpStr;
        }

    if(atts->GetStereoRendering())
        SNPRINTF(tmpStr, 1000, "stereoRendering = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "stereoRendering = 0\n");
    str += tmpStr;
    const char *stereoType_names = "RedBlue, Interlaced, CrystalEyes";
    if(atts->GetStereoType() == RenderingAttributes::RedBlue)
        {
             SNPRINTF(tmpStr, 1000, "stereoType = RedBlue  # %s\n", stereoType_names);
             str += tmpStr;
        }
    else if(atts->GetStereoType() == RenderingAttributes::Interlaced)
        {
             SNPRINTF(tmpStr, 1000, "stereoType = Interlaced  # %s\n", stereoType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "stereoType = CrystalEyes  # %s\n", stereoType_names);
             str += tmpStr;
        }

    if(atts->GetNotifyForEachRender())
        SNPRINTF(tmpStr, 1000, "notifyForEachRender = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "notifyForEachRender = 0\n");
    str += tmpStr;
    const char *scalableActivationMode_names = "Never, Always, Auto";
    if(atts->GetScalableActivationMode() == RenderingAttributes::Never)
        {
             SNPRINTF(tmpStr, 1000, "scalableActivationMode = Never  # %s\n", scalableActivationMode_names);
             str += tmpStr;
        }
    else if(atts->GetScalableActivationMode() == RenderingAttributes::Always)
        {
             SNPRINTF(tmpStr, 1000, "scalableActivationMode = Always  # %s\n", scalableActivationMode_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "scalableActivationMode = Auto  # %s\n", scalableActivationMode_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "scalableAutoThreshold = %d\n", atts->GetScalableAutoThreshold());
    str += tmpStr;
    if(atts->GetSpecularFlag())
        SNPRINTF(tmpStr, 1000, "specularFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "specularFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "specularCoeff = %g\n", atts->GetSpecularCoeff());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "specularPower = %g\n", atts->GetSpecularPower());
    str += tmpStr;
    const unsigned char *specularColor = atts->GetSpecularColor().GetColor();
    SNPRINTF(tmpStr, 1000, "specularColor = (%d, %d, %d, %d)\n", int(specularColor[0]), int(specularColor[1]), int(specularColor[2]), int(specularColor[3]));
    str += tmpStr;
    if(atts->GetDoShadowing())
        SNPRINTF(tmpStr, 1000, "doShadowing = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "doShadowing = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "shadowStrength = %g\n", atts->GetShadowStrength());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
RenderingAttributes_str(PyObject *v)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)v;
    return PyRenderingAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *RenderingAttributes_Purpose = "This class contains special rendering attributes like antialiasing and stero settings.";

//
// The type description structure
//
static PyTypeObject RenderingAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "RenderingAttributes",                    // tp_name
    sizeof(RenderingAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)RenderingAttributes_dealloc,  // tp_dealloc
    (printfunc)RenderingAttributes_print,     // tp_print
    (getattrfunc)RenderingAttributes_getattr, // tp_getattr
    (setattrfunc)RenderingAttributes_setattr, // tp_setattr
    (cmpfunc)RenderingAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)RenderingAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    RenderingAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static RenderingAttributes *defaultAtts = 0;

static PyObject *
NewRenderingAttributes()
{
    RenderingAttributesObject *newObject;
    newObject = PyObject_NEW(RenderingAttributesObject, &RenderingAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new RenderingAttributes(*defaultAtts);
    else
        newObject->data = new RenderingAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapRenderingAttributes(const RenderingAttributes *attr)
{
    RenderingAttributesObject *newObject;
    newObject = PyObject_NEW(RenderingAttributesObject, &RenderingAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (RenderingAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
RenderingAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewRenderingAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef RenderingAttributesMethods[] = {
    {"RenderingAttributes", RenderingAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *RenderingAttributesObserver = 0;
static bool RenderingAttributesEnableLogging = true;

static void
PyRenderingAttributes_WriteLog(Subject *subj, void *data)
{
    RenderingAttributes *atts = (RenderingAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!RenderingAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# RenderingAttributes_WriteLog()\n");
}

void
PyRenderingAttributes_StartUp(RenderingAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyRenderingAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(RenderingAttributesObserver == 0)
    {
        RenderingAttributesObserver = new ObserverToCallback(subj,
            PyRenderingAttributes_WriteLog, (void *)logFile);
    }

    RenderingAttributesEnableLogging = true;
}

void
PyRenderingAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete RenderingAttributesObserver;
    RenderingAttributesObserver = 0;
}

PyMethodDef *
PyRenderingAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return RenderingAttributesMethods;
}

bool
PyRenderingAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &RenderingAttributesType);
}

RenderingAttributes *
PyRenderingAttributes_FromPyObject(PyObject *obj)
{
    RenderingAttributesObject *obj2 = (RenderingAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyRenderingAttributes_NewPyObject()
{
    return NewRenderingAttributes();
}

PyObject *
PyRenderingAttributes_WrapPyObject(const RenderingAttributes *attr)
{
    return WrapRenderingAttributes(attr);
}

void
PyRenderingAttributes_SetLogging(bool val)
{
    RenderingAttributesEnableLogging = val;
}

void
PyRenderingAttributes_SetDefaults(const RenderingAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new RenderingAttributes(*atts);
}

